Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.
Require Import Coq.Setoids.Setoid.

Section NatMaxPlus.

   Open Scope Bisemigroup_scope.

   Definition natMaxPlusBisemigroup : Bisemigroup :=
      glueBSmg natMaxSemigroup natPlusSemigroup (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma isLeftDistributive : IsLeftDistributive natMaxPlusBisemigroup.
   Proof. intros x y z; dseq_u; simpl; rewrite beq_nat_eq; induction z; simpl; auto. Defined.

   Lemma isRightDistributive : IsRightDistributive natMaxPlusBisemigroup.
   Proof. intros x y z; dseq_u; simpl; rewrite beq_nat_eq; 
      rewrite plus_comm, (plus_comm x), (plus_comm y); induction z; simpl; auto.
   Defined.
   
(*
   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp natMaxPlusBisemigroup.
   Proof.
      red. exists 0; exists 0; exists 1. trivial.
   Defined.
   
   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp natMaxPlusBisemigroup.
   Proof.
      red. exists 0; exists 0; exists 1. trivial.
   Defined.
*)

   (* always irrelevant : plusIdentityIsTimesAnnihilator, plusAnnihilatorIsTimesIdentity *)

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp natMaxPlusBisemigroup.
   Proof. intros q [an p]; (assert (False); [|tauto]); clear q;
      destruct (p 1); dseq_u; simpl in *.
      rewrite beq_nat_eq in H.
      apply (lt_irrefl an).
      rewrite <- H at 2.
      rewrite plus_comm.
      apply lt_n_Sn.
   Defined.

      
   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp natMaxPlusBisemigroup.
   Proof. intros [an p] q; (assert (False); [|tauto]); clear q;
      destruct (p (S an)); dseq_u; simpl in *.
      rewrite beq_nat_eq in H.
      apply (lt_irrefl an).
      rewrite <- H at 2.
      rewrite max_r.
      apply lt_n_Sn.
      apply le_n_Sn.
   Defined.


   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).
 
   Lemma isRightStrictStable : IsRightStrictStable natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      assert (p1 := plus_le_compat_r x y z).
      assert (p2 := plus_le_compat_r y x z).
      destruct (le_ge_dec x y); destruct (le_ge_dec (x + z) (y + z)); min_max_rewrite; intuition; auto.
      assert (q := (le_antisym _ _ l H)); rewrite (plus_comm x z), (plus_comm y z) in q;
      assert (q' := plus_reg_l _ _ _ q); auto.
      repeat rewrite plus_cancel_r.
      copy_destruct (beq_nat x y). 
         dseq_f; rewrite beq_nat_eq in ew; rewrite ew; auto.
         bool_p;  rewrite beq_nat_eq in ew; auto.
   Defined.

   Lemma isLeftStrictStable : IsLeftStrictStable natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      assert (p1 := plus_le_compat_l x y z).
      assert (p2 := plus_le_compat_l y x z).
      destruct (le_ge_dec x y); destruct (le_ge_dec (z + x) (z + y)); min_max_rewrite; intuition; auto.
      assert (q := (le_antisym _ _ l H)); 
      assert (q' := plus_reg_l _ _ _ q); auto.
      repeat rewrite plus_cancel_l.
      copy_destruct (beq_nat x y). 
         dseq_f; rewrite beq_nat_eq in ew; rewrite ew; auto.
         bool_p;  rewrite beq_nat_eq in ew; auto.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     rewrite plus_cancel_r; intros h; rewrite h, max_idemp; auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     rewrite plus_cancel_l; intros h; rewrite h, max_idemp; auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natMaxPlusBisemigroup.
   Proof. intros comm idem.
      exists 1; exists 0; exists 2; compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natMaxPlusBisemigroup.
   Proof. intros comm idem.
      exists 1; exists 0; exists 2; compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     destruct (le_ge_dec (z + x) (z + y)); min_max_rewrite; auto.
   Defined.

   Lemma rightComparable : RightComparable natMaxPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     destruct (le_ge_dec (x + z) (y + z)); min_max_rewrite; auto.
   Defined.
   
   Lemma leftIncreasing_comp : LeftIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem; exists 0; exists 1; simpl; auto. Defined.

   Lemma rightIncreasing_comp : RightIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem; exists 0; exists 1; simpl; auto. Defined.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem; exists 0; exists 0; simpl; auto. Defined.
   
   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem; exists 0; exists 0; simpl; auto. Defined.

(*
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem hid.
      exists 1; exists 1.
      rewrite (uniqueId _ hid (NatMax.hasIdentity)).
      auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp natMaxPlusBisemigroup.
   Proof. intros comm idem hid.
      exists 1; exists 1.
      rewrite (uniqueId _ hid (NatMax.hasIdentity)).
      auto.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp natMaxPlusBisemigroup.
   Proof. intros hasId.
      exists 1; exists 1; exists 0;
      assert (p := uniqueId _ hasId NatMax.hasIdentity); rewrite p;
      compute; intuition.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp natMaxPlusBisemigroup.
   Proof. intros hasId.
      exists 1; exists 1; exists 0;
      assert (p := uniqueId _ hasId NatMax.hasIdentity); rewrite p;
      compute; intuition.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp : PlusIdentityIsTimesLeftAnnihilator_comp natMaxPlusBisemigroup.
   Proof. intros hasId; exists 1.
      assert (p := uniqueId _ hasId NatMax.hasIdentity); 
      rewrite p; simpl; auto.
   Defined.
      
   Lemma plusIdentityIsTimesRightAnnihilator_comp : PlusIdentityIsTimesRightAnnihilator_comp natMaxPlusBisemigroup.
   Proof. intros hasId; exists 1.
      assert (p := uniqueId _ hasId NatMax.hasIdentity); 
      rewrite p; simpl; auto.
   Defined.

   Close Scope Bisemigroup_scope.

End NatMaxPlus.
