Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.
Require Import Coq.Arith.Min.
Require Import Coq.Setoids.Setoid.

Section NatMaxMin.

   Open Scope Bisemigroup_scope.

   Definition natMaxMinBisemigroup : Bisemigroup :=
      glueBSmg natMaxSemigroup natMinSemigroup (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
   
   Lemma le_max : forall x y z : nat, (max x y <= z)%nat <-> (x <= z)%nat /\ (y <= z)%nat.
   Proof. intros x y z; split; intros h. split.
      apply (le_trans _ (max x y)); auto; apply le_max_l.
      apply (le_trans _ (max x y)); auto; apply le_max_r.
      destruct (le_ge_dec x y).
      rewrite (max_r x y); intuition.
      rewrite (max_l x y); intuition.
   Defined.

   Lemma isLeftDistributive : IsLeftDistributive natMaxMinBisemigroup.
   Proof. intros x y z. dseq_u; simpl. repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto;
      apply le_antisym; auto.
      apply (le_trans _ x); auto.
      apply (le_trans _ y); auto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive natMaxMinBisemigroup.
   Proof. intros x y z. dseq_u; simpl. repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto;
      apply le_antisym; auto.
      apply (le_trans _ x); auto.
      apply (le_trans _ y); auto.
   Defined.
   
(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive natMaxMinBisemigroup.
   Proof.
      intros x y z. dseq_u; simpl. repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto;
      apply le_antisym; auto.
      apply (le_trans _ y); auto.
      apply (le_trans _ x); auto.
   Defined.
   
   Lemma isRightCoDistributive : IsRightCoDistributive natMaxMinBisemigroup.
   Proof.
      intros x y z. dseq_u; simpl. repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto;
      apply le_antisym; auto.
      apply (le_trans _ y); auto.
      apply (le_trans _ x); auto.
   Defined.
*)
   
   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator natMaxMinBisemigroup.
   Proof. intros pid tann.
      destruct pid as [[|n] p]; simpl in *; [ | destruct (p 0); discriminate H ].
      destruct tann as [[|n] q]; simpl in *; [ | destruct (q 0); discriminate H ].
      auto.
   Defined.

   (* always irrelevant : plusAnnihilatorIsTimesIdentity *)
      
   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp natMaxMinBisemigroup.
   Proof. intros [an p] q; (assert (False); [|tauto]); clear q;
      destruct (p (S an)); dseq_u; simpl in *.
      rewrite beq_nat_eq in H.
      apply (lt_irrefl an).
      rewrite <- H at 2.
      rewrite max_r.
      apply lt_n_Sn.
      apply le_n_Sn.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp natMaxMinBisemigroup.
   Proof. intros comm idem; exists 1; exists 0; exists 0; simpl; toBool; auto. Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp natMaxMinBisemigroup.
   Proof. intros comm idem; exists 1; exists 0; exists 0; simpl; toBool; auto. Defined.
 
   Lemma isRightCompEqCancel : IsRightCompEqCancel natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      intros _; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natMaxMinBisemigroup.
   Proof. intros comm idem.
      exists 1; exists 0; exists 2; compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natMaxMinBisemigroup.
   Proof. intros comm idem.
      exists 1; exists 0; exists 2; compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      destruct (le_ge_dec (min z x) (min z y)); min_max_rewrite; auto.
   Defined.

   Lemma rightComparable : RightComparable natMaxMinBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      destruct (le_ge_dec (min x z) (min y z)); min_max_rewrite; auto.
   Defined.

   Lemma leftIncreasing : LeftIncreasing natMaxMinBisemigroup.
   Proof. intros comm idem x y; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma rightIncreasing : RightIncreasing natMaxMinBisemigroup.
   Proof. intros comm idem x y; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.
      
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natMaxMinBisemigroup.
   Proof. intros comm idem; exists 0; exists 0; simpl; auto. Defined.
   
   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natMaxMinBisemigroup.
   Proof. intros comm idem; exists 0; exists 0; simpl; auto. Defined.
   
(*
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp natMaxMinBisemigroup.
   Proof. intros comm idem hid.
      exists 1; exists 1.
      rewrite (uniqueId _ hid (NatMax.hasIdentity)).
      auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp natMaxMinBisemigroup.
   Proof. intros comm idem hid.
      exists 1; exists 1.
      rewrite (uniqueId _ hid (NatMax.hasIdentity)).
      auto.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp natMaxMinBisemigroup.
   Proof. intros hasId.
      assert (p := uniqueId _ hasId NatMax.hasIdentity). 
      exists 1; exists 1; exists 1. rewrite p. simpl. auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp natMaxMinBisemigroup.
   Proof. intros hasId.
      assert (p := uniqueId _ hasId NatMax.hasIdentity). 
      exists 1; exists 1; exists 1. rewrite p. simpl. auto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator natMaxMinBisemigroup.
   Proof. intros hasId x.
      assert (p := uniqueId _ hasId NatMax.hasIdentity); 
      rewrite p; simpl; auto.
   Defined.
      
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator natMaxMinBisemigroup.
   Proof. intros hasId x.
      assert (p := uniqueId _ hasId NatMax.hasIdentity); 
      rewrite p, min_comm; simpl; auto.
   Defined.

   Close Scope Bisemigroup_scope.

End NatMaxMin.
