(*
 * Isomorphic: AddOne NatMaxMin
 * Ignore: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.AddOne.
Require Import Metarouting.Constructions.Bisemigroups.NatMaxMin.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.
Require Import Coq.Arith.Min.

Section NatIMaxMin.

   Open Scope Bisemigroup_scope.

   Definition natIMaxMinBisemigroup : Bisemigroup :=
      let s1 := unionSemigroup unitSemigroup natMaxSemigroup in (* add infinity *)
      let s2 := unionSwapSemigroup natMinSemigroup unitSemigroup in (* add infinity *)
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   Lemma natIMaxMinDsIso : DsIso natIMaxMinBisemigroup (addOneBisemigroup natMaxMinBisemigroup).
   Proof.
      apply (@Build_DsIso natIMaxMinBisemigroup (addOneBisemigroup natMaxMinBisemigroup)
         (fun x => x) (fun x => x)).
      split; intros; auto.
   Defined.
   
   Lemma natIMaxMinBSmgIso : BSmgIso natIMaxMinBisemigroup (addOneBisemigroup natMaxMinBisemigroup).
   Proof. split with natIMaxMinDsIso. split; intros; auto. Defined.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
   
   (* No need to prove properties because of the above isomorphism *)

(*
   (* useful lemma for Max - move to NatMax.v !! *)
   Lemma max_idemp : forall n, Max.max n n = n.
   Proof. induction n. trivial.
      rewrite <- Max.max_SS, IHn; trivial.
   Qed.

   Lemma isLeftDistributive : IsLeftDistributive natIMaxMinBisemigroup.
   Proof.
      red. intros [[]|a] [[]|b] [[]|c]; dseq_u; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail); repeat rewrite beq_nat_eq; auto.
      rewrite max_idemp; auto.
      destruct (le_ge_dec c b);
      [ rewrite min_l; trivial; rewrite max_idemp; auto
      | rewrite min_r; trivial; rewrite max_l; auto ].
      destruct (le_ge_dec c a); 
      [ rewrite min_l; trivial; rewrite max_idemp; auto
      | rewrite min_r; trivial; rewrite Max.max_r; auto ].
      destruct (le_ge_dec a b);
      destruct (le_ge_dec a c);
      destruct (le_ge_dec b c);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto.
      rewrite (le_antisym _ _ l0 (le_trans _ _ _ g l)); auto.
      rewrite (le_antisym _ _ l (le_trans _ _ _ g0 g)); auto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive natIMaxMinBisemigroup.
   Proof. apply comm_distr.
      apply (Iso_IsCommutative (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup))).
      apply (Union.isCommutative natMinSemigroup unitSemigroup).
      split; [ apply (NatMin.isCommutative) | apply (Unit.isCommutative) ].
      apply isLeftDistributive.
   Defined.
   
(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive natIMaxMinBisemigroup.
   Proof. red. intros [[]|a] [[]|b] [[]|c]; dseq_u; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail); repeat rewrite beq_nat_eq; auto.
      destruct (le_ge_dec a b);
      destruct (le_ge_dec a c);
      destruct (le_ge_dec b c);
      progress repeat (
         try (rewrite max_l ; [|trivial; fail]);
         try (rewrite max_r ; [|trivial; fail]);
         try (rewrite min_l ; [|trivial; fail]);
         try (rewrite min_r ; [|trivial; fail])
      ); auto.
      rewrite (le_antisym _ _ g (le_trans _ _ _ l l0)); auto.
      rewrite (le_antisym _ _ g0 (le_trans _ _ _ g l)); auto.
   Defined.
   
   Lemma isRightCoDistributive : IsRightCoDistributive natIMaxMinBisemigroup.
   Proof. apply comm_codistr.
      apply (Union.isCommutative unitSemigroup natMaxSemigroup).
      split; [ apply (Unit.isCommutative) | apply (NatMax.isCommutative) ].
      apply isLeftCoDistributive.
   Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator natIMaxMinBisemigroup.
   Proof. intros pid tann.
      destruct pid as [[[]|[|n]] p]; simpl in *;
         [ destruct (p (inr _ 0)); discriminate H
         | | destruct (p (inr _ 0)); discriminate H ].
      destruct tann as [[[]|[|n]] q]; simpl in *;
         [ destruct (q (inr _ 0)); discriminate H
         | | destruct (q (inr _ 0)); discriminate H ].
      auto.
   Defined.
      
   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity natIMaxMinBisemigroup.
   Proof. intros pann tid.
      destruct pann as [[[]|[|n]] p]; simpl in *;
         [ | destruct (p (inl _ tt)); discriminate H
         | destruct (p (inl _ tt)); discriminate H ].
      destruct tid as [[[]|[|n]] q]; simpl in *;
         [ | destruct (q (inl _ tt)); discriminate H
         | destruct (q (inl _ tt)); discriminate H ].
      auto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail]);
         try (rewrite max_idemp)
      ).

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp natIMaxMinBisemigroup.
   Proof. intros comm idem.
     exists (inl _ tt); exists (inr _ 0); exists (inr _ 0); compute; intuition.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp natIMaxMinBisemigroup.
   Proof. intros comm idem.
     exists (inl _ tt); exists (inr _ 0); exists (inr _ 0); compute; intuition.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; auto;
     try (compute; auto; fail); toProp; repeat rewrite beq_nat_eq.
     intros h; rewrite h, max_idemp; auto.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec y z); min_max_rewrite; auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; auto;
     try (compute; auto; fail); toProp; repeat rewrite beq_nat_eq.
     intros h; rewrite h, max_idemp; auto.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec y z); min_max_rewrite; auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; try (compute; auto; fail);
     toProp; repeat rewrite beq_nat_eq; destruct (le_ge_dec x y); intros _; min_max_rewrite; auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; try (compute; auto; fail);
     toProp; repeat rewrite beq_nat_eq; destruct (le_ge_dec x y); intros _; min_max_rewrite; auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natIMaxMinBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 0); exists (inr _ 2); compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natIMaxMinBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 0); exists (inr _ 2); compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; 
     dseq_u; simpl; toProp; repeat rewrite beq_nat_eq;
     try (compute; auto; fail).
     min_max_rewrite; auto.
     destruct (le_ge_dec y z); min_max_rewrite; auto.
     destruct (le_ge_dec x z); min_max_rewrite; auto.
     destruct (le_ge_dec x y); min_max_rewrite; auto.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec z y); min_max_rewrite; auto.
   Defined.

   Lemma rightComparable : RightComparable natIMaxMinBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; 
     dseq_u; simpl; toProp; repeat rewrite beq_nat_eq;
     try (compute; auto; fail).
     min_max_rewrite; auto.
     destruct (le_ge_dec y z); min_max_rewrite; auto.
     destruct (le_ge_dec x z); min_max_rewrite; auto.
     destruct (le_ge_dec x y); min_max_rewrite; auto.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec z y); min_max_rewrite; auto.
   Defined.
      
   Lemma rightIncreasing : RightIncreasing natIMaxMinBisemigroup.
   Proof. intros _ _ [[]|x] [[]|y]; auto. simpl. rewrite max_idemp; auto.
      simpl; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma leftIncreasing : LeftIncreasing natIMaxMinBisemigroup.
   Proof. intros _ _ [[]|x] [[]|y]; auto. simpl. rewrite max_idemp; auto.
      simpl; destruct (le_ge_dec x y); min_max_rewrite; auto.
   Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natIMaxMinBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natIMaxMinBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp natIMaxMinBisemigroup.
   Proof. intros hasId;
      exists (inl _ tt); exists (inl _ tt); exists (inl _ tt);
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); rewrite p;
      compute; intuition.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp natIMaxMinBisemigroup.
   Proof. intros hasId;
      exists (inl _ tt); exists (inl _ tt); exists (inl _ tt);
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); rewrite p;
      compute; intuition.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator natIMaxMinBisemigroup.
   Proof. intros hasId [[]|x];
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); rewrite p; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator natIMaxMinBisemigroup.
   Proof. intros hasId [[]|x];
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); 
      rewrite p; auto; simpl; rewrite min_0_r; auto.
   Defined.
*)

   Close Scope Bisemigroup_scope.

End NatIMaxMin.
