Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.Semigroups.Left. 
Require Import Metarouting.Constructions.Bisemigroups.Unit.

Section Left.

   Variable A : Semigroup.
   
   Definition leftBisemigroup : Bisemigroup :=
      glueBSmg A (leftSemigroup A) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
      
   Lemma isLeftDistributive : IsIdempotent A -> IsLeftDistributive leftBisemigroup.
   Proof. intros idem x y z; simpl; unfold left_op. rewrite (idem z); auto. Defined.
   
   Lemma isLeftDistributive_comp : IsIdempotent_comp A -> IsLeftDistributive_comp leftBisemigroup.
   Proof. intros [x idem]; exists x; exists x; exists x; simpl; unfold left_op; toProp; 
      intros h; elim idem; dseq_f; rewrite <- h; auto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive leftBisemigroup.
   Proof. intros x y z; simpl; unfold left_op. auto. Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive leftBisemigroup.
   Proof. intros x y z. simpl. unfold left_op. auto. Defined.
      
   Lemma isRightCoDistributive : IsRightCoDistributive leftBisemigroup.
   Proof. intros x y z. simpl. unfold left_op. auto. Defined.
*)
   
   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator leftBisemigroup.
   Proof. intros [id p] [ann q]. simpl.
      destruct (q id) as [h1 h2]. simpl in *. unfold left_op in *. auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity leftBisemigroup.
   Proof. intros [id p] [ann q]. simpl.
      destruct (q id) as [h1 h2]. simpl in *. unfold left_op in *. auto.
      rewrite h1; auto.
   Defined.

   (**************************************************************************)
   (*               A - Commutative & Idempotent properties                  *)
   (**************************************************************************)

   Lemma comm_back : IsCommutative (plusSmg leftBisemigroup) -> IsCommutative A.
   Proof. intros comm.
      apply (Iso_IsCommutative (SmgIso_sym (plusBSmgIso A (leftSemigroup A) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*))) comm).
   Defined.

   Lemma idem_back : IsIdempotent (plusSmg leftBisemigroup) -> IsIdempotent A.
   Proof. intros idem.
      apply (Iso_IsIdempotent (SmgIso_sym (plusBSmgIso A (leftSemigroup A) (dsEq_refl _)(*(ds_eq_refl _ _ _ _ _ _)*))) idem).
   Defined.
   
   Ltac comm_idem_back comm idem :=
      let comm' := fresh "comm" in
      let idem' := fresh "idem" in
      assert (comm' := comm_back comm);
      assert (idem' := idem_back idem);
      clear comm idem;
      rename comm' into comm;
      rename idem' into idem.
      
      
   
   Lemma isRightStrictStable : IsRightStrictStable leftBisemigroup.
   Proof. intros comm idem x y z; simpl; unfold left_op. negb_p.
      toProp; dseq_f. rewrite (comm y x). 
      copy_destruct (((op A x y) == x)%bool) as h; dseq_u; simpl in h; rewrite h; toBool; simpl; auto.
      copy_destruct (((op A x y) == y)%bool) as h'; rewrite h'; auto.
   Defined.

   Lemma isLeftStrictStable : IsSingleton A -> IsLeftStrictStable leftBisemigroup.
   Proof. intros sg; apply (Iso_IsLeftStrictStable (BSmgIso_sym (unitBSmgIso leftBisemigroup sg))); 
      apply Unit.isLeftStrictStable.
   Defined.
   
   Lemma isLeftStrictStable_comp : IsSingleton_comp A -> IsLeftStrictStable_comp leftBisemigroup.
   Proof. intros sg comm idem; destruct (sg (choose A)) as [b pb]; simpl; unfold left_op. comm_idem_back comm idem.
      copy_destruct ((b + choose A == b)%bool) as h.
      exists b; exists (choose A); exists b; simpl; negb_p. toProp; dseq_f; rewrite (idem b); intuition.
      apply or_introl; intuition; elim pb; dseq_f. rewrite (comm (choose A) b), h in H; auto.
      
      exists (choose A + b); exists b; exists b; simpl; negb_p; toProp; dseq_f; rewrite (idem b); intuition.
      apply or_introl; split.
      rewrite (assoc A (choose A) b b), (idem b); auto.
      intros p; bool_p; elim h; dseq_f; rewrite (comm (choose A) b), <- (assoc A b b (choose A)), (idem b) in p; auto.
   Defined.
   
   Lemma leftDiscrete : LeftDiscrete leftBisemigroup.
   Proof. intros comm idem x y z; comm_idem_back comm idem; simpl; unfold left_op.
      negb_p; toProp; dseq_f; rewrite (idem z); auto.
   Defined.

   Lemma rightDiscrete : IsSingleton A -> RightDiscrete leftBisemigroup.
   Proof. intros sg; apply (Iso_RightDiscrete (BSmgIso_sym (unitBSmgIso leftBisemigroup sg))); 
      apply Unit.rightDiscrete.
   Defined.
   
   Lemma rightDiscrete_comp : IsSingleton_comp A -> RightDiscrete_comp leftBisemigroup.
   Proof. intros sg comm idem; comm_idem_back comm idem; destruct (sg (choose A)) as [b pb].
      simpl; unfold left_op.
      copy_destruct ((b + choose A == b)%bool) as h.
      exists b; exists (choose A); exists b; simpl; negb_p. toProp.
      intuition; elim pb; dseq_f. rewrite (comm (choose A) b), h in H; auto.
      
      exists (choose A + b); exists b; exists b; simpl; negb_p; toProp; dseq_f; split.
      rewrite (assoc A (choose A) b b), (idem b); auto.
      intros p; bool_p; elim h; dseq_f; rewrite (comm (choose A) b), <- (assoc A b b (choose A)), (idem b) in p; auto.
   Defined.
   
   Lemma leftComparable : LeftComparable leftBisemigroup.
   Proof. intros comm idem x y z; comm_idem_back comm idem; simpl; unfold left_op. toProp; dseq_f; rewrite (idem z); auto.
   Defined.
   
   Lemma rightComparable : IsSelective A -> RightComparable leftBisemigroup.
   Proof. intros sel comm idem x y z; comm_idem_back comm idem; simpl; unfold left_op.
      toProp; dseq_f; destruct (sel x y); auto. rewrite (comm y x); auto.
   Defined.
   
   Lemma rightComparable_comp : IsSelective_comp A -> RightComparable_comp leftBisemigroup.
   Proof. intros [x [y sel]] comm idem; comm_idem_back comm idem; simpl; unfold left_op.
      exists x; exists y; exists x; toProp; dseq_f. rewrite (comm y x); auto.
   Defined.

   Lemma isLeftCompEqCancel : IsSelective A -> IsLeftCompEqCancel leftBisemigroup.
   Proof. intros sel comm idem x y z _; comm_idem_back comm idem; simpl; unfold left_op.
      toProp; dseq_f; destruct (sel x y); auto. rewrite (comm y x); auto.
   Defined.

   Lemma isLeftCompEqCancel_comp : IsSelective_comp A -> IsLeftCompEqCancel_comp leftBisemigroup.
   Proof. intros [x [y sel]] comm idem; comm_idem_back comm idem; simpl; unfold left_op.
      exists x; exists y; exists x; toProp; dseq_f. rewrite (comm y x); auto.
   Defined.
   
   Lemma isRightCompEqCancel : IsRightCompEqCancel leftBisemigroup.
   Proof. intros comm idem x y z h. comm_idem_back comm idem; simpl in *; unfold left_op in *.
      toProp; dseq_f; rewrite h, (idem y); auto.
   Defined.
   
   Lemma isLeftCompCancel : IsLeftCompCancel leftBisemigroup.
   Proof. intros comm idem x y z; comm_idem_back comm idem; simpl in *; unfold left_op in *.
      toProp; intros [p _]; elim p; rewrite (idem z); auto.
   Defined.
   
   Lemma isRightCompCancel : IsSelective A -> IsRightCompCancel leftBisemigroup.
   Proof. intros sel comm idem x y z _; comm_idem_back comm idem; simpl in *; unfold left_op in *.
      toProp; dseq_f; destruct (sel x y); auto. rewrite (comm y x); auto.
   Defined.

   Lemma isRightCompCancel_comp : IsSelective_comp A -> IsRightCompCancel_comp leftBisemigroup.
   Proof. intros [x [y sel]] comm idem; comm_idem_back comm idem; simpl; unfold left_op.
      exists x; exists y; exists x; toProp; dseq_f. rewrite (comm y x); auto.
   Defined.

   Lemma leftIncreasing : IsSingleton A -> LeftIncreasing leftBisemigroup.
   Proof. intros sg; apply (Iso_LeftIncreasing (BSmgIso_sym (unitBSmgIso leftBisemigroup sg))); 
      apply Unit.leftIncreasing.
   Defined.
   
   Lemma leftIncreasing_comp : IsSingleton_comp A -> LeftIncreasing_comp leftBisemigroup.
   Proof. intros sg comm idem; comm_idem_back comm idem; simpl; unfold left_op.
      destruct (sg (choose A)) as [b pb].
      copy_destruct ((b + choose A == b)%bool) as h.
      exists (choose A); exists b. toProp; dseq_f. rewrite (comm (choose A) b), h; auto.
      exists b; exists (choose A). rewrite h. auto.
   Defined.

   Lemma rightIncreasing : RightIncreasing leftBisemigroup.
   Proof. intros comm idem x y; simpl; unfold left_op; comm_idem_back comm idem. apply idem. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp leftBisemigroup.
   Proof. intros comm idem; simpl; unfold left_op; comm_idem_back comm idem.
      exists (choose A); exists (choose A); rewrite (idem (choose A)). auto.
   Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp leftBisemigroup.
   Proof. intros comm idem; simpl; unfold left_op; comm_idem_back comm idem.
      exists (choose A); exists (choose A); rewrite (idem (choose A)). auto.
   Defined.

   Lemma leftWStrictIncreasing_comp : IsSingleton_comp A -> LeftWStrictIncreasing_comp leftBisemigroup.
   Proof. intros sg comm idem [id hid].
      destruct (sg id) as [a pa].
      exists a; exists a. simpl. split; auto.
      unfold left_op; simpl. negb_p; toProp; dseq_f; rewrite (idem a); auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : IsSingleton_comp A -> RightWStrictIncreasing_comp leftBisemigroup.
   Proof. intros sg comm idem [id hid].
      destruct (sg id) as [a pa].
      exists a; exists a. simpl. split; auto.
      unfold left_op; simpl. negb_p; toProp; dseq_f; rewrite (idem a); auto.
   Defined.

   (**************************************************************************)
   (*                         Identity properties                            *)
   (**************************************************************************)
   
   Lemma hasId_back :  HasIdentity (plusSmg leftBisemigroup) -> HasIdentity A.
   Proof. intros hasId.
      apply (Iso_HasIdentity (SmgIso_sym (plusBSmgIso A (leftSemigroup A) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*))) hasId).
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus : IsIdempotent A -> IsLeftTimesMapToIdConstantPlus leftBisemigroup.
   Proof. intros idem hasId x y z; simpl; unfold left_op; rewrite (idem z); auto. Defined.
   
   Lemma isLeftTimesMapToIdConstantPlus_comp : IsIdempotent_comp A -> IsLeftTimesMapToIdConstantPlus_comp leftBisemigroup.
   Proof. intros [x idem] hasId ; simpl; unfold left_op; exists x; exists x; exists x. auto. Defined.
   
   Lemma isRightTimesMapToIdConstantPlus : IsSingleton A -> IsRightTimesMapToIdConstantPlus leftBisemigroup.
   Proof. intros sg; apply (Iso_IsRightTimesMapToIdConstantPlus (BSmgIso_sym (unitBSmgIso leftBisemigroup sg))); 
      apply Unit.isRightTimesMapToIdConstantPlus.
   Defined.
   
   Lemma isRightTimesMapToIdConstantPlus_comp : IsSingleton_comp A -> IsRightTimesMapToIdConstantPlus_comp leftBisemigroup.
   Proof. intros sg [id hasId]; simpl; unfold left_op; destruct (sg id) as [b pb].
      exists id; exists b; exists b. destruct (hasId b) as [p _]; toProp; dseq_f; rewrite p; auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator leftBisemigroup.
   Proof. intros hasId x. simpl; unfold left_op. auto. Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : IsSingleton A -> PlusIdentityIsTimesRightAnnihilator leftBisemigroup.
   Proof. intros sg; apply (Iso_PlusIdentityIsTimesRightAnnihilator (BSmgIso_sym (unitBSmgIso leftBisemigroup sg))); 
      apply Unit.plusIdentityIsTimesRightAnnihilator.
   Defined.
   
   Lemma plusIdentityIsTimesRightAnnihilator_comp : IsSingleton_comp A -> PlusIdentityIsTimesRightAnnihilator_comp leftBisemigroup.
   Proof. intros sg [id hasId]; destruct (sg id) as [b pb]; exists b; simpl; unfold left_op. auto. Defined.

End Left.