Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.


(*********************************************************************)
(*             Finite sets with intersection and union               *)
(*********************************************************************)

Section FSetsOp.

   Open Scope Bisemigroup_scope.
   Open Scope Semigroup_scope.
   
   Variable A : Semigroup.

   Definition fsetOpBisemigroup : Bisemigroup :=
      glueBSmg (fsetsUnionSemigroup A) (fsetOpSemigroup A) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)
   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma isLeftDistributive : IsLeftDistributive fsetOpBisemigroup.
   Proof. intros x y z. simpl. toSet_u. rewrite bool_eq; split; intros h.
      destruct (fset_op_elim A _ _ _ h) as [b [c [p1 [p2 p3]]]].
      rewrite union_mem in p3; toProp; destruct p3 as [p3 | p3].
      apply or_introl; apply (fset_op_intro A _ _ _ b c); auto.
      apply or_intror; apply (fset_op_intro A _ _ _ b c); auto.
      toProp; destruct h as [h|h]; destruct (fset_op_elim A _ _ _ h) as [b [c [p1 [p2 p3]]]];
      apply (fset_op_intro A _ _ _ b c); auto; rewrite union_mem; toProp; tauto.
   Defined.
   
   Lemma isRightDistributive : IsRightDistributive fsetOpBisemigroup.
   Proof. intros x y z. simpl. toSet_u. rewrite bool_eq; split; intros h.
      destruct (fset_op_elim A _ _ _ h) as [b [c [p1 [p2 p3]]]].
      rewrite union_mem in p2; toProp; destruct p2 as [p2 | p2].
      apply or_introl; apply (fset_op_intro A _ _ _ b c); auto.
      apply or_intror; apply (fset_op_intro A _ _ _ b c); auto.
      toProp; destruct h as [h|h]; destruct (fset_op_elim A _ _ _ h) as [b [c [p1 [p2 p3]]]];
      apply (fset_op_intro A _ _ _ b c); auto; rewrite union_mem; toProp; tauto.
   Defined.

   Lemma singl : IsSingleton A -> forall x : fsetOpBisemigroup, (x == nil) + Exists b, x == b :: nil.
   Proof. intros [a sg] [|x xs]. apply inl; auto.
      apply inr; exists a; unfold dseq; toSet; simpl; toProp;
      rewrite (sg a0). simpl; dseq_f; toProp; dseq_f. rewrite (sg x); auto.
   Defined.

(*

   Lemma isLeftCoDistributive_comp : IsSingleton_comp A -> IsLeftCoDistributive_comp fsetOpBisemigroup.
   Proof. intros sa; destruct (sa (choose A)) as [b pb].
      assert (b == choose A = false) as pb'.
         toProp; bool_p; auto.
      assert (choose A == b = false) as pb1.
         toProp; bool_p; intros h; elim pb; dseq_f; rewrite h; auto.
      copy_destruct ((choose A + choose A) == choose A);
      copy_destruct ((b + choose A) == choose A).
      exists nil; exists (choose A :: nil); exists (b :: nil); simpl.
         unfold fset_op, union, eq_fset, subset; simpl;
         rewrite pb'; simpl; toProp; dseq_f; bool_p; rewrite ew0; intuition.
      exists (b :: nil); exists nil; exists (choose A :: nil); simpl.
         unfold fset_op, union, eq_fset, subset; simpl.
         rewrite pb1; simpl; rewrite ew, ew0; simpl; toProp; dseq_f; rewrite ew; bool_p; intuition.
      exists nil; exists nil; exists (choose A :: nil); simpl.
         unfold fset_op, union, eq_fset, subset; simpl.
         rewrite ew; simpl; negb_p; toProp; bool_p; auto.
      exists nil; exists nil; exists (choose A :: nil); simpl.
         unfold fset_op, union, eq_fset, subset; simpl.
         rewrite ew; simpl; negb_p; toProp; bool_p; auto.
   Defined.



   Lemma isLeftCoDistributive : IsSingleton A -> IsLeftCoDistributive fsetOpBisemigroup.
   Proof. intros sa x y z; simpl.
      destruct (singl sa x) as [p1 | [b p1]];
      destruct (singl sa y) as [p2 | [c p2]];
      destruct (singl sa z) as [p3 | [d p3]];
      rewrite (union_pres_eq A _ _ _ _ p3 (fset_op_pres_eq A _ _ _ _ p1 p2));
      rewrite (fset_op_pres_eq A _ _ _ _ (union_pres_eq A _ _ _ _ p3 p1) (union_pres_eq A _ _ _ _ p3 p2));
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto;
      destruct sa as [a sa];
      (assert (forall w1 w2 : A, w1 == w2) as h;
         [intros w1 w2; rewrite (sa w1), (sa w2); auto|]);
      repeat progress (rewrite h; simpl; auto).
   Defined.

   Lemma isRightCoDistributive_comp : IsSingleton_comp A -> IsRightCoDistributive_comp fsetOpBisemigroup.
   Proof. intros sa; red.
      destruct (sa (choose A)) as [b pb].
      assert (choose A == b = false) as r1; [ bool_p; toProp; intros h; elim pb; dseq_f; rewrite h; auto |].
      assert (b == choose A = false) as r2; [bool_p; toProp; auto |].
      copy_destruct (choose A + choose A == choose A);
      copy_destruct (choose A + b == choose A).
      exists (choose A :: nil); exists (@nil A); exists (b :: nil); simpl.
         unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl.
         rewrite ?r1, ?r2; simpl; negb_p; toProp; dseq_f; rewrite ew0; dseq_u; rewrite r1; bool_p; tauto.
      exists (@nil A); exists (b :: nil); exists (choose A :: nil); simpl.
         unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl.
         rewrite ?r1, ?r2; simpl; rewrite ew0; simpl; negb_p; simpl; toProp; bool_p; intuition.
      exists (@nil A); exists (@nil A); exists (choose A :: nil); simpl.
         unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl.
         simpl; rewrite ew; simpl; negb_p; simpl; toProp; bool_p; intuition.
      exists (@nil A); exists (@nil A); exists (choose A :: nil); simpl.
         unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl.
         simpl; rewrite ew; simpl; negb_p; simpl; toProp; bool_p; intuition.
   Defined.

   Lemma isRightCoDistributive : IsSingleton A -> IsRightCoDistributive fsetOpBisemigroup.
   Proof. intros sa x y z; simpl.
      destruct (singl sa x) as [p1 | [b p1]];
      destruct (singl sa y) as [p2 | [c p2]];
      destruct (singl sa z) as [p3 | [d p3]];
      rewrite (union_pres_eq A _ _ _ _ (fset_op_pres_eq A _ _ _ _ p1 p2) p3);
      rewrite (fset_op_pres_eq A _ _ _ _ (union_pres_eq A _ _ _ _ p1 p3) (union_pres_eq A _ _ _ _ p2 p3));
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto;
      destruct sa as [a sa];
      (assert (forall w1 w2 : A, w1 == w2) as h;
         [intros w1 w2; rewrite (sa w1), (sa w2); auto|]);
      repeat progress (rewrite h; simpl; auto).
   Defined.

*)

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator fsetOpBisemigroup.
   Proof. intros pid tann.
      set (pid2 := FSetsUnion.hasIdentity A).
      set (iso := Iso_PresId (@SmgIso_sym (fsetsUnionSemigroup A) (plusSmg fsetOpBisemigroup) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresAnn (@SmgIso_sym (fsetOpSemigroup A) (timesSmg fsetOpBisemigroup) (timesBSmgIso _ _ _))).
      set (tann2 := FSetOp.hasAnnihilator A).
      rewrite <- (iso2 tann tann2).
      simpl. auto.
   Defined.

(*
   Lemma hasTimesId_back_helper : HasIdentity (timesSmg fsetOpBisemigroup) -> HasIdentity (timesSmg fsetOpBisemigroup).
   Proof. intros [[|x m] p].
      destruct (p (choose A :: nil)) as [h _]; toSet_u; 
      assert (q := h (choose A)); simpl in q; rewrite refl in q; discriminate q.
      
      exists (x :: nil). intros y. simpl in *; split.
      toSet_u. rewrite bool_eq; split; intros h.
      destruct (fset_op_elim A _ _ _ h) as [b [c [w1 [w2 w3]]]].
      destruct (p y) as [p1 p2].
*)

   Lemma hasTimesId_back : HasIdentity (timesSmg fsetOpBisemigroup) -> HasIdentity A.
   Proof. 
      intros [[|ida m] p].
      destruct (p (choose A :: nil)) as [h _].
      toSet_u. assert (q := h (choose A)). simpl in q. rewrite refl in q; discriminate q.
      
      exists ida. intros a. split.
      assert (forall x, (@op (timesSmg fsetOpBisemigroup) (ida :: m) x) == x) as h.
         intros x; destruct (p x); auto.
      assert (q := h (a :: nil)); clear -q.
      toSet_u. dseq_f. assert (p := q (ida + a)). 
      simpl in p. rewrite refl in p; simpl in p. rewrite orb_false_r in p. dseq_u; simpl in *. rewrite <- p; auto.

      assert (forall x, (@op (timesSmg fsetOpBisemigroup) x (ida :: m)) == x) as h.
         intros x; destruct (p x); auto.
      assert (q := h (a :: nil)); clear -q.
      toSet_u. dseq_f. assert (p := q (a + ida)). 
      simpl in p. rewrite refl in p; simpl in p. rewrite orb_false_r in p. dseq_u; simpl in *. rewrite <- p; auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : IsSingleton A -> PlusAnnihilatorIsTimesIdentity fsetOpBisemigroup.
   Proof. intros [y sg] pann tid.
      set (ida := hasTimesId_back tid).
      set (w1 := FSetOp.hasIdentity A ida).
      set (iso := Iso_PresId (@SmgIso_sym (fsetOpSemigroup A) (timesSmg fsetOpBisemigroup) (timesBSmgIso _ _ _)) tid w1).
      simpl in *.
      rewrite <- iso.
      destruct pann as [an p];
      destruct tid as [[|id m] q]; simpl in *.
      
      set (a := choose A).
      destruct (q (a :: nil)). toSet_u; simpl in *. assert (w2 := H a); rewrite refl in w2; discriminate w2.
      
      clear - p q sg.
      toSet_u. simpl.
      assert (a == id).
         assert (w1 := sg a); assert (w2 := sg id); dseq_f;
         rewrite w1, w2; auto.
      rewrite H; simpl.
      destruct (p (a :: nil)) as [p1 _].
      toSet. assert (r := p1 a); toSet. simpl in r. rewrite refl in r; simpl in r; rewrite orb_true_r in r; rewrite r; auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity_comp : IsSingleton_comp A -> PlusAnnihilatorIsTimesIdentity_comp fsetOpBisemigroup.
   Proof. intros sg pann tid.
      set (ida := hasTimesId_back tid).
      set (w1 := FSetOp.hasIdentity A ida).
      set (iso := Iso_PresId (@SmgIso_sym (fsetOpSemigroup A) (timesSmg fsetOpBisemigroup) (timesBSmgIso _ _ _)) tid w1).
      simpl in iso.
      toProp; intros h. dseq_f.
      rewrite <- iso in h.
      destruct pann as [an p];
      destruct tid as [[|id m] q]; simpl in *.
      
      set (a := choose A).
      destruct (q (a :: nil)). toSet_u; simpl in *. assert (w2 := H a); rewrite refl in w2; discriminate w2.
      
      destruct (sg id) as [b be].
      assert (mem b an).
         clear -p.
         destruct (p (b :: nil)) as [h _]. toSet_u.
         assert (w := h b); toSet. simpl in w; rewrite refl in w. simpl in w.
         rewrite orb_true_r in w; rewrite <- w; auto.
      clear -H h be.
      toSet_u. rewrite h in H. simpl in H; toProp; bool_p; tauto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)      
   
   Lemma isRightStrictStable_comp : IsRightStrictStable_comp fsetOpBisemigroup.
   Proof. intros comm idem.
      exists (choose A :: nil); exists nil; exists nil. simpl.
      negb_p; toProp; toSet; simpl; bool_p; tauto.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp fsetOpBisemigroup.
   Proof. intros comm idem.
      exists (choose A :: nil); exists nil; exists nil. simpl.
      negb_p; toProp; toSet; simpl; bool_p; tauto.
   Defined.
   
   Lemma isRightCompEqCancel : IsSingleton A -> IsRightCompEqCancel fsetOpBisemigroup.
   Proof. intros sa comm idem x y z.
      assert (forall w1 w2 : A, w1 == w2) as p.
        intros w1 w2; destruct sa as [a sa]; rewrite (sa w1), (sa w2); auto.
      destruct (singl sa x) as [p1 | [b p1]];
      destruct (singl sa y) as [p2 | [c p2]];
      destruct (singl sa z) as [p3 | [d p3]];
      toProp; dseq_f; rewrite p1, p2, p3; simpl;
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto;
      repeat progress (rewrite p; simpl; auto).
   Defined.

   Lemma isRightCompEqCancel_comp : IsSingleton_comp A -> IsRightCompEqCancel_comp fsetOpBisemigroup.
   Proof. intros sg comm idem.
      destruct (sg (choose A)) as [b p].
      assert (b == choose A = false) as r1; [toProp; bool_p; auto|].
      assert (choose A == b = false) as r2; [toProp; bool_p; intros h; elim p; dseq_f; rewrite h; auto|].
      exists (choose A :: nil); exists (b :: nil); exists nil; simpl.
      do 2 rewrite fset_op_nil.
      unfold eq_fset, subset, union; simpl.
      repeat progress (rewrite ?r1, ?r2, ?refl; simpl).
      intuition.
   Defined.

   Lemma isLeftCompEqCancel : IsSingleton A -> IsLeftCompEqCancel fsetOpBisemigroup.
   Proof. intros sa comm idem x y z.
      assert (forall w1 w2 : A, w1 == w2) as p.
        intros w1 w2; destruct sa as [a sa]; rewrite (sa w1), (sa w2); auto.
      destruct (singl sa x) as [p1 | [b p1]];
      destruct (singl sa y) as [p2 | [c p2]];
      destruct (singl sa z) as [p3 | [d p3]];
      toProp; dseq_f; rewrite p1, p2, p3; simpl;
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto;
      repeat progress (rewrite p; simpl; auto).
   Defined.

   Lemma isLeftCompEqCancel_comp : IsSingleton_comp A -> IsLeftCompEqCancel_comp fsetOpBisemigroup.
   Proof. intros sg comm idem.
      destruct (sg (choose A)) as [b p].
      assert (b == choose A = false) as r1; [toProp; bool_p; auto|].
      assert (choose A == b = false) as r2; [toProp; bool_p; intros h; elim p; dseq_f; rewrite h; auto|].
      exists (choose A :: nil); exists (b :: nil); exists nil; simpl.
      unfold eq_fset, subset, union; simpl.
      repeat progress (rewrite ?r1, ?r2, ?refl; simpl).
      intuition.
   Defined.

   Lemma isRightCompCancel : RightCondensed A -> IsRightCompCancel fsetOpBisemigroup.
   Proof. intros rc comm idem. intros [|x xs] y z; toProp; dseq_f; simpl.
      intros _; apply or_intror; toSet_u; simpl; rewrite orb_false_r; auto.
      intros [h _]; elim h; clear h. toSet_u. rewrite bool_eq; split; intros h; toProp; intuition.
      destruct (fset_op_elim A _ _ _ H) as [b [c [p1 [p2 p3]]]].
      apply (fset_op_intro A _ _ _ x c).
         rewrite (rc c x b); auto.
         simpl; rewrite refl; auto.
         auto.
   Defined.

   Lemma isRightCompCancel_comp : RightCondensed_comp A -> IsRightCompCancel_comp fsetOpBisemigroup.
   Proof. intros [a [b [c rc]]] comm idem.
      exists (b :: nil); exists (c :: nil); exists (a :: nil). simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      assert (b + a == c + a = false) as p1; [bool_p; toProp; auto|].
      assert (c + a == b + a = false) as p2; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      assert (b == c = false) as p3; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      assert (c == b = false) as p4; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      repeat progress (rewrite ?p1, ?p2, ?p3, ?p4, ?refl; simpl; auto).
   Defined.

   Lemma isLeftCompCancel : LeftCondensed A -> IsLeftCompCancel fsetOpBisemigroup.
   Proof. intros rc comm idem. intros [|x xs] y z; toProp; dseq_f; simpl.
      intros _; apply or_intror; toSet_u; simpl; rewrite orb_false_r; auto.
      intros [h _]; elim h; clear h. toSet_u. rewrite bool_eq; split; intros h; toProp; intuition.
      destruct (fset_op_elim A _ _ _ H) as [b [c [p1 [p2 p3]]]].
      apply (fset_op_intro A _ _ _ b x).
         rewrite (rc b x c); auto.
         auto.
         simpl; rewrite refl; auto.
   Defined.

   Lemma isLeftCompCancel_comp : LeftCondensed_comp A -> IsLeftCompCancel_comp fsetOpBisemigroup.
   Proof. intros [a [b [c rc]]] comm idem.
      exists (b :: nil); exists (c :: nil); exists (a :: nil). simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      assert (a + b == a + c = false) as p1; [bool_p; toProp; auto|].
      assert (a + c == a + b = false) as p2; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      assert (b == c = false) as p3; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      assert (c == b = false) as p4; [bool_p; toProp; intros h; elim rc; dseq_f; rewrite h; auto|].
      repeat progress (rewrite ?p1, ?p2, ?p3, ?p4, ?refl; simpl; auto).
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp fsetOpBisemigroup.
   Proof. intros comm idem.
      exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      rewrite refl; auto.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp fsetOpBisemigroup.
   Proof. intros comm idem.
      exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      rewrite refl; auto.
   Defined.

   Lemma leftComparable : LeftCondensed A -> LeftComparable fsetOpBisemigroup.
   Proof. intros lc comm idem [|b x] y z; toProp; dseq_f.
      apply or_intror; simpl; toSet_u; rewrite fset_op_nil; simpl; rewrite orb_false_r; auto.
      apply or_introl. toSet_u.
      rewrite bool_eq; split; intros h; toProp; intuition.
      destruct (fset_op_elim A _ _ _ H) as [c [d [p1 [p2 p3]]]].
      apply (fset_op_intro A _ _ _ c b).
         rewrite (lc c b d); auto.
         auto.
         simpl; rewrite refl; auto.
   Defined.

   Lemma leftComparable_comp : LeftCondensed_comp A -> LeftComparable_comp fsetOpBisemigroup.
   Proof. intros [a [b [c lc]]] comm idem.
      exists (b :: nil); exists (c :: nil); exists (a :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      assert (a + b == a + c = false) as p1; [bool_p; toProp; intros h; elim lc; dseq_f; rewrite h; auto|].
      assert (a + c == a + b = false) as p2; [bool_p; toProp; intros h; elim lc; dseq_f; rewrite h; auto|].
      repeat progress (rewrite ?p1, ?p2, ?refl; simpl; auto).
   Defined.

   Lemma rightComparable : RightCondensed A -> RightComparable fsetOpBisemigroup.
   Proof. intros lc comm idem [|b x] y z; toProp; dseq_f.
      apply or_intror; simpl; toSet_u; simpl; rewrite orb_false_r; auto.
      apply or_introl. toSet_u.
      rewrite bool_eq; split; intros h; toProp; intuition.
      destruct (fset_op_elim A _ _ _ H) as [c [d [p1 [p2 p3]]]].
      apply (fset_op_intro A _ _ _ b d).
         rewrite (lc d b c); auto.
         simpl; rewrite refl; auto.
         auto.
   Defined.

   Lemma rightComparable_comp : RightCondensed_comp A -> RightComparable_comp fsetOpBisemigroup.
   Proof. intros [a [b [c lc]]] comm idem.
      exists (b :: nil); exists (c :: nil); exists (a :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      assert (b + a == c + a = false) as p1; [bool_p; toProp; intros h; elim lc; dseq_f; rewrite h; auto|].
      assert (c + a == b + a = false) as p2; [bool_p; toProp; intros h; elim lc; dseq_f; rewrite h; auto|].
      repeat progress (rewrite ?p1, ?p2, ?refl; simpl; auto).
   Defined.
   
   Lemma leftIncreasing : IsRight A -> LeftIncreasing fsetOpBisemigroup.
   Proof. intros rt comm idem x y. simpl. toSet_u. rewrite bool_eq; split; intros h.
      toProp; destruct h as [h|h]; auto.
      destruct (fset_op_elim _ _ _ _ h) as [b [c [p1 [p2 p3]]]];
      rewrite (rt b c) in p1; rewrite (mem_pres_eq _ p1); auto.
      rewrite h; auto.
   Defined.
   
   Lemma leftIncreasing_comp : IsRight_comp A -> LeftIncreasing_comp fsetOpBisemigroup.
   Proof. intros [x [y]] comm idem. exists (y :: nil); exists (x :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto. 
      assert (y == x + y = false) as q1.
         bool_p; toProp; intros h; elim b; dseq_f; rewrite <- h; auto.
      rewrite q1. simpl. rewrite refl; simpl. negb_p. rewrite b; auto.
   Defined.

   Lemma rightIncreasing : IsLeft A -> RightIncreasing fsetOpBisemigroup.
   Proof. intros rt comm idem x y. simpl. toSet_u. rewrite bool_eq; split; intros h.
      toProp; destruct h as [h|h]; auto.
      destruct (fset_op_elim _ _ _ _ h) as [b [c [p1 [p2 p3]]]];
      rewrite (rt b c) in p1; rewrite (mem_pres_eq _ p1); auto.
      rewrite h; auto.
   Defined.
   
   Lemma rightIncreasing_comp : IsLeft_comp A -> RightIncreasing_comp fsetOpBisemigroup.
   Proof. intros [x [y]] comm idem. exists (x :: nil); exists (y :: nil); simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto. 
      assert (x == x + y = false) as q1.
         bool_p; toProp; intros h; elim b; dseq_f; rewrite <- h; auto.
      rewrite q1. simpl. rewrite refl; simpl. negb_p. rewrite b; auto.
   Defined.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp fsetOpBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp fsetOpBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

(*
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp fsetOpBisemigroup.
   Proof. intros comm idem hid.
      set (a := choose A);
      exists (a :: nil); exists (a :: nil).
      rewrite (uniqueId _ hid (FSetsUnion.hasIdentity A)).
      split; simpl; auto.
      negb_p. toProp.
      copy_destruct (a + a == a).
      apply or_intror. toSet.
      simpl.
      repeat rewrite orb_false_r. dseq_f. rewrite ew.
      destruct (a0 == a); auto.
      apply or_introl. toSet.
      assert (p := a0 (a + a)); simpl in p.
      toSet. simpl in p.
      rewrite ew in p; simpl in p. rewrite refl in p; discriminate p.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp fsetOpBisemigroup.
   Proof. intros comm idem hid.
      set (a := choose A);
      exists (a :: nil); exists (a :: nil).
      rewrite (uniqueId _ hid (FSetsUnion.hasIdentity A)).
      split; simpl; auto.
      negb_p. toProp.
      copy_destruct (a + a == a).
      apply or_intror. toSet.
      simpl.
      repeat rewrite orb_false_r. dseq_f. rewrite ew.
      destruct (a0 == a); auto.
      apply or_introl. toSet.
      assert (p := a0 (a + a)); simpl in p.
      toSet. simpl in p.
      rewrite ew in p; simpl in p. rewrite refl in p; discriminate p.
   Defined.
*)
   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp fsetOpBisemigroup.
   Proof. intros hasId.
      exists (choose A :: nil); exists (choose A :: nil); exists (choose A :: nil).
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      rewrite refl; simpl. auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp fsetOpBisemigroup.
   Proof. intros hasId.
      exists (choose A :: nil); exists (choose A :: nil); exists (choose A :: nil).
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      unfold dseq, fset_op, union; simpl; unfold eq_fset, subset; simpl; auto.
      rewrite refl; simpl. auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator fsetOpBisemigroup.
   Proof. intros hasId. intros x.
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      compute; auto.
   Defined.
   
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator fsetOpBisemigroup.
   Proof. intros hasId. intros x.
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      rewrite fset_op_nil; auto.
   Defined.


End FSetsOp.
