Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetsIntersect.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.



(*********************************************************************)
(*             Finite sets with intersection and union               *)
(*********************************************************************)

Section FSets.

   Open Scope Bisemigroup_scope.
   
   Variable A : DecSetoid.

   Definition fsetBisemigroup : Bisemigroup :=
      glueBSmg (fsetsUnionSemigroup A) (fsetsIntersectionSemigroup A) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma isLeftDistributive : IsLeftDistributive fsetBisemigroup.
   Proof. intros x y z; toSet_u; destruct (mem a z); destruct (mem a x); destruct (mem a y); auto. Defined.

   Lemma isRightDistributive : IsRightDistributive fsetBisemigroup.
   Proof. intros x y z; toSet_u; destruct (mem a z); destruct (mem a x); destruct (mem a y); auto. Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive fsetBisemigroup.
   Proof. intros x y z; toSet_u; destruct (mem a z); destruct (mem a x); destruct (mem a y); auto. Defined.

   Lemma isRightCoDistributive : IsRightCoDistributive fsetBisemigroup.
   Proof. intros x y z; toSet_u; destruct (mem a z); destruct (mem a x); destruct (mem a y); auto. Defined.
*)

   (*********************************************************************)
   (*                        Special elements                           *)
   (*********************************************************************)
   
   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator fsetBisemigroup.
   Proof. intros pid tann.
      set (pid2 := FSetsUnion.hasIdentity A).
      set (iso := Iso_PresId (@SmgIso_sym (fsetsUnionSemigroup A) (plusSmg fsetBisemigroup) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresAnn (@SmgIso_sym (fsetsIntersectionSemigroup A) (timesSmg fsetBisemigroup) (timesBSmgIso _ _ _))).
      set (tann2 := FSetsIntersect.hasAnnihilator A).
      rewrite <- (iso2 tann tann2).
      simpl. auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity fsetBisemigroup.
   Proof. intros pann tid.
      destruct pann as [an p];
      destruct tid as [id q]; simpl in *.
      toSet_u.
      destruct (p id) as [p1 p2];
      destruct (q an) as [q1 q2]; simpl in *.
      toSet.
      assert (w1 := p1 a);
      assert (w2 := p2 a);
      assert (w3 := q1 a);
      assert (w4 := q2 a); toSet.
      destruct (mem a an); destruct (mem a id); auto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp fsetBisemigroup.
   Proof. intros _ _.
      exists (choose A :: nil); exists nil; exists nil.
      negb_p. intuition. apply or_introl. simpl; rewrite andb_true_r.
      toSet; simpl; rewrite orb_false_r; auto.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp fsetBisemigroup.
   Proof. intros _ _.
      exists (choose A :: nil); exists nil; exists nil.
      negb_p. intuition. apply or_introl. simpl; rewrite andb_true_r.
      toSet; simpl; rewrite orb_false_r; auto.
   Defined.
   
   Lemma isRightCompEqCancel : IsSingleton A -> IsRightCompEqCancel fsetBisemigroup.
   Proof. intros [a sg] _ _ [|x xs] [|y ys] _ _; unfold dseq; toSet; toProp;
      [ auto
      | apply or_intror; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; assert (a0 == x) as h; [rewrite (sg a0), (sg x); auto | rewrite h; auto]
      ].
   Defined.

   Lemma isRightCompEqCancel_comp : IsSingleton_comp A -> IsRightCompEqCancel_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p];
      exists (choose A :: nil); exists (b :: nil); exists nil; simpl.
      negb_p; toProp; split;
      [ auto
      | split; toSet; apply p; clear p;
         [ assert (q := a b); clear a; toSet; simpl in q; rewrite refl in q; simpl in q;
           rewrite orb_true_r, orb_false_r in q; rewrite <- q; auto
         | assert (q := a (choose A)); clear a; toSet; simpl in q; rewrite refl in q; simpl in q;
           rewrite orb_true_r, orb_false_r in q; rewrite (equal_sym_b b (choose A)), <- q; auto
         ]
      ].
   Defined.

   Lemma isLeftCompEqCancel : IsSingleton A -> IsLeftCompEqCancel fsetBisemigroup.
   Proof. intros [a sg] _ _ [|x xs] [|y ys] _ _; unfold dseq; toSet; toProp;
      [ auto
      | apply or_intror; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; assert (a0 == x) as h; [rewrite (sg a0), (sg x); auto | rewrite h; auto]
      ].
   Defined.

   Lemma isLeftCompEqCancel_comp : IsSingleton_comp A -> IsLeftCompEqCancel_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p];
      exists (choose A :: nil); exists (b :: nil); exists nil; simpl.
      negb_p; toProp; split;
      [ auto
      | split; toSet; apply p; clear p;
         [ assert (q := a b); clear a; toSet; simpl in q; rewrite refl in q; simpl in q;
           rewrite orb_true_r, orb_false_r in q; rewrite <- q; auto
         | assert (q := a (choose A)); clear a; toSet; simpl in q; rewrite refl in q; simpl in q;
           rewrite orb_true_r, orb_false_r in q; rewrite (equal_sym_b b (choose A)), <- q; auto
         ]
      ].
   Defined.

   Lemma isRightCompCancel : IsSingleton A -> IsRightCompCancel fsetBisemigroup.
   Proof. intros [a sg] _ _ [|x xs] [|y ys] _ _; unfold dseq; toSet; toProp;
      [ auto
      | apply or_intror; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; assert (a0 == x) as h; [rewrite (sg a0), (sg x); auto | rewrite h; auto]
      ].
   Defined.

   Lemma isRightCompCancel_comp : IsSingleton_comp A -> IsRightCompCancel_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p];
      exists (choose A :: nil); exists (b :: nil); exists (choose A :: b :: nil); simpl.
      rewrite refl, refl; 
      assert (b == choose A = false) as h1; [bool_p; toProp; auto | rewrite h1];
      assert (choose A == b = false) as h2; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto | rewrite h2]; simpl.
      unfold eq_fset, subset, union; simpl; rewrite h1, h2; simpl; rewrite h1, h2, refl, refl; auto.
   Defined.

   Lemma isLeftCompCancel : IsSingleton A -> IsLeftCompCancel fsetBisemigroup.
   Proof. intros [a sg] _ _ [|x xs] [|y ys] _ _; unfold dseq; toSet; toProp;
      [ auto
      | apply or_intror; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; rewrite orb_false_r; auto
      | apply or_introl; toSet; simpl; assert (a0 == x) as h; [rewrite (sg a0), (sg x); auto | rewrite h; auto]
      ].
   Defined.

   Lemma isLeftCompCancel_comp : IsSingleton_comp A -> IsLeftCompCancel_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p];
      exists (choose A :: nil); exists (b :: nil); exists (choose A :: b :: nil); simpl.
      rewrite refl, refl; 
      assert (b == choose A = false) as h1; [bool_p; toProp; auto | rewrite h1];
      assert (choose A == b = false) as h2; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto | rewrite h2]; simpl.
      unfold eq_fset, subset, union; simpl; rewrite h1, h2; simpl; rewrite h1, h2, refl, refl; auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp fsetBisemigroup.
   Proof. intros _ _.
      exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl;
      rewrite refl; simpl; rewrite andb_true_r; toSet; simpl; rewrite orb_false_r; auto.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp fsetBisemigroup.
   Proof. intros _ _.
      exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl;
      rewrite refl; simpl; rewrite andb_true_r; toSet; simpl; rewrite orb_false_r; auto.
   Defined.

   Lemma leftComparable : IsSingleton A -> LeftComparable fsetBisemigroup.
   Proof. intros [a sg] _ _ [|x xs] [|y ys] [|z zs]; unfold dseq; toSet; toProp; auto;
      [ apply or_introl; toSet; simpl; rewrite andb_false_r; auto
      | apply or_intror; toSet; simpl; rewrite andb_false_r, orb_false_r; auto
      | apply or_introl; toSet; simpl; rewrite andb_false_r, orb_false_r; auto
      | apply or_introl; toSet; simpl; assert (forall (w1 w2 : A), w1 == w2) as h; 
         [intros; rewrite (sg w1), (sg w2); auto | repeat (rewrite h; simpl); auto]
      ].
   Defined.

   Lemma leftComparable_comp : IsSingleton_comp A -> LeftComparable_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p].
      assert ((choose A == b) = false) as h1; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto|].
      assert ((b == choose A) = false) as h2; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto|].
      exists (choose A :: nil); exists (b :: nil); exists (choose A :: b :: nil); simpl.
      unfold eq_fset, subset, union.
      repeat (progress (simpl; rewrite ?h1, ?h2, ?refl; simpl)); auto.
   Defined.

   Lemma rightComparable : IsSingleton A -> RightComparable fsetBisemigroup.
   Proof. intros sg comm idem x y z. 
      assert (x * z == z * x) as h1; [ apply (FSetsIntersect.isCommutative A x z) |  rewrite h1].
      assert (y * z == z * y) as h2; [ apply (FSetsIntersect.isCommutative A y z) |  rewrite h2].
      apply leftComparable; auto.
   Defined.

   Lemma rightComparable_comp : IsSingleton_comp A -> RightComparable_comp fsetBisemigroup.
   Proof. intros sg _ _. destruct (sg (choose A)) as [b p].
      assert ((choose A == b) = false) as h1; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto|].
      assert ((b == choose A) = false) as h2; [bool_p; toProp; intros h; elim p; dseq_f; rewrite h; auto|].
      exists (choose A :: nil); exists (b :: nil); exists (choose A :: b :: nil); simpl.
      unfold eq_fset, subset, union.
      repeat (progress (simpl; rewrite ?h1, ?h2, ?refl; simpl)); auto.
   Defined.

   Lemma leftIncreasing : LeftIncreasing fsetBisemigroup.
   Proof. intros comm idem x y; simpl. toSet_u. destruct (mem a x); destruct (mem a y); auto. Defined.

   Lemma rightIncreasing : RightIncreasing fsetBisemigroup.
   Proof. intros comm idem x y; simpl. toSet_u. destruct (mem a x); destruct (mem a y); auto. Defined.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp fsetBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp fsetBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

(*
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp fsetBisemigroup.
   Proof. intros comm idem hid.
      set (a := choose A);
      exists (a :: nil); exists (a :: nil);
      rewrite (uniqueId _ hid (FSetsUnion.hasIdentity A)).
      simpl. split; auto.
      rewrite refl; simpl. negb_p. toProp.
      apply or_intror.
      toSet_u. destruct (mem a0 (a :: nil)); auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp fsetBisemigroup.
   Proof. intros comm idem hid.
      set (a := choose A);
      exists (a :: nil); exists (a :: nil);
      rewrite (uniqueId _ hid (FSetsUnion.hasIdentity A)).
      simpl. split; auto.
      rewrite refl; simpl. negb_p. toProp.
      apply or_intror.
      toSet_u. destruct (mem a0 (a :: nil)); auto.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)
   
   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp fsetBisemigroup.
   Proof. intros hasId.
      exists (choose A :: nil); exists (choose A :: nil); exists (choose A :: nil).
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      unfold eq_fset, subset, union; simpl.
      repeat (progress (rewrite refl; simpl)); auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp fsetBisemigroup.
   Proof. intros hasId.
      exists (choose A :: nil); exists (choose A :: nil); exists (choose A :: nil).
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl.
      unfold eq_fset, subset, union; simpl.
      repeat (progress (rewrite refl; simpl)); auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator fsetBisemigroup.
   Proof. intros hasId. intros x.
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl; auto.
   Defined.
   
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator fsetBisemigroup.
   Proof. intros hasId. intros x;
      assert (p := uniqueId _ hasId (FSetsUnion.hasIdentity A)); rewrite p; simpl;
      toSet_u; simpl; rewrite andb_false_r; auto.
   Defined.

End FSets.
