Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Semigroups.FMinSetsOp.
Require Import Metarouting.Constructions.Semigroups.FMinSetsUnion.
Require Import Metarouting.Constructions.Bisemigroups.FSetsOp.


Section FMinSets.

   Variable A : OrderSemigroup.
   Variable lmon : LeftMonotonic A.
   Variable rmon : RightMonotonic A.
   Variable antisym : Antisym A.

   Definition minsetOpUnionBisemigroup : Bisemigroup :=
      glueBSmg (msetOpSemigroup A lmon rmon antisym) (msetUnionSemigroup A) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)
   
   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

    Open Scope Bisemigroup_scope.
    Open Scope Semigroup_scope.
    Open Scope OrderSemigroup_scope.

   Ltac toMSet :=
      unfold eq_mset in *;
      unfold mset_union in *;
      unfold mset_op in *.
      
   Ltac toMSet_u :=
      dseq_u; simpl in *;
      toMSet.

   Ltac mred :=
      repeat rewrite (min_min A);
      repeat rewrite <- min_union_l;
      repeat rewrite <- min_union_r;
      repeat rewrite <- (min_fset_op_l A lmon rmon antisym);
      repeat rewrite <- (min_fset_op_r A lmon rmon antisym).

   Ltac mred_at h :=
      repeat rewrite (min_min A) in h;
      repeat rewrite <- min_union_l in h;
      repeat rewrite <- min_union_r in h;
      repeat rewrite <- (min_fset_op_l A lmon rmon antisym) in h;
      repeat rewrite <- (min_fset_op_r A lmon rmon antisym) in h.

   Lemma upper_mem_pres_le : forall (a b : A) x, upper_mem A a x -> le A a b -> upper_mem A b x.
   Proof. intros a b x p q.
      destruct (upper_mem_elim A _ _ p) as [a0 [p1 p2]].
      apply (upper_mem_intro antisym _ _ _ p1).
      apply (@le_trans A _ a); auto.
   Qed.

    Lemma isLeftDistributive : IsIdempotent A * LeftOpNonDecreasing A * RightOpNonDecreasing A -> IsLeftDistributive minsetOpUnionBisemigroup.
    Proof. intros [[idem lnd] rnd] x y z; toMSet_u; mred.
       dseq_f; rewrite <- upper_eq; auto; intros a.
       rewrite upper_union; auto.
       rewrite bool_eq; split; intros h.
       toProp; destruct h as [h|h].
       apply upper_op_intro with a a; auto.
       rewrite (idem a); auto.
       rewrite upper_union; toProp; auto.
       rewrite upper_union; toProp; auto.
       destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [x0 [y0 [p1 [p2 p3]]]].
       apply upper_op_intro with x0 y0; auto.
       rewrite upper_union; toProp; auto.
       rewrite upper_union; toProp; auto.
       destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [x0 [y0 [p1 [p2 p3]]]].
       rewrite upper_union in *; toProp; auto.
       destruct p3 as [p3 | p3]; destruct p2 as [p2 | p2]; auto.
       apply or_introl; apply (upper_mem_pres_le _ _ _ p2); apply (@le_trans A _ (x0 + y0)); auto.
       apply or_introl; apply (upper_mem_pres_le _ _ _ p3); apply (@le_trans A _ (x0 + y0)); auto.
       apply or_introl; apply (upper_mem_pres_le _ _ _ p2); apply (@le_trans A _ (x0 + y0)); auto.
       apply or_intror; apply upper_op_intro with x0 y0; auto.
    Defined.
    
    Lemma isLeftDistributive_comp : IsIdempotent_comp A + LeftOpNonDecreasing_comp A + RightOpNonDecreasing_comp A -> IsLeftDistributive_comp minsetOpUnionBisemigroup.
    Proof. intros [[[x idem]|[x [y lnd]]]|[x [y rnd]]]. simpl in *.
       exists nil; exists nil; exists (x :: nil). simpl in *. toMSet. mred.
       rewrite fset_op_nil. mred. toProp; intros h; toSet.
       assert (p := h x); clear h; simpl in p.
       unfold min, union, fset_op in p; simpl in p.
       do 2 rewrite le_refl in p; simpl in p.
       rewrite refl, orb_false_r, orb_false_r in p. apply idem; apply sym; rewrite <- p; auto.
       
       exists nil; exists (y :: nil); exists (x :: nil); simpl in *. toMSet; mred. simpl.
       unfold fset_op at 1; simpl; toProp; intros h; toSet.
       unfold min, union, fset_op in h; simpl in h.
       rewrite le_refl in h; simpl in h. repeat rewrite orb_false_r in h.
       copy_destruct (x == y); rewrite ew in h; simpl in h.
          rewrite andb_true_r in h.
          rewrite le_refl in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          
          repeat rewrite le_refl in h; simpl in h.
          copy_destruct ((le A (x + x) (x + y))%bool); rewrite ew0 in h; simpl in h;
          copy_destruct ((le A (x + y) (x + x))%bool); rewrite ew1 in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          copy_destruct (x == x + x).
             apply lnd; apply (@le_trans A _ (x + x)); auto; dseq_f; rewrite <- ew2; auto.
             rewrite ew2 in p; simpl in p.
             apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply lnd; apply (@le_trans A _ (x + x)); auto; dseq_f;
          assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p;
          apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          copy_destruct (x == x + x).
             assert (p := h (x + y)); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite orb_true_r in p; dseq_f.
             apply lnd; rewrite p; auto.
             assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite ew2 in p. simpl in p.
             apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.

       exists (y :: nil); exists nil; exists (x :: nil); simpl in *. toMSet; mred. simpl.
       unfold fset_op at 1; simpl; toProp; intros h; toSet.
       unfold min, union, fset_op in h; simpl in h.
       rewrite le_refl in h; simpl in h. repeat rewrite orb_false_r in h.
       copy_destruct (x == y); rewrite ew in h; simpl in h.
          rewrite andb_true_r in h.
          rewrite le_refl in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          
          repeat rewrite le_refl in h; simpl in h.
          copy_destruct ((le A (x + x) (y + x))%bool); rewrite ew0 in h; simpl in h;
          copy_destruct ((le A (y + x) (x + x))%bool); rewrite ew1 in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          copy_destruct (x == x + x).
             apply rnd; apply (@le_trans A _ (x + x)); auto; dseq_f; rewrite <- ew2; auto.
             rewrite ew2 in p; simpl in p.
             apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply rnd; apply (@le_trans A _ (x + x)); auto; dseq_f;
          assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p;
          apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          copy_destruct (x == x + x).
             assert (p := h (y + x)); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite orb_true_r in p; dseq_f.
             apply rnd; rewrite p; auto.
             assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite ew2 in p. simpl in p.
             apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
    Defined.

    Lemma isRightDistributive : IsIdempotent A * LeftOpNonDecreasing A * RightOpNonDecreasing A -> IsRightDistributive minsetOpUnionBisemigroup.
    Proof. intros [[idem lnd] rnd] x y z; toMSet_u; mred.
       dseq_f; rewrite <- upper_eq; auto; intros a.
       rewrite upper_union; auto.
       rewrite bool_eq; split; intros h.
       toProp; destruct h as [h|h].
       destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [x0 [y0 [p1 [p2 p3]]]].
       apply upper_op_intro with x0 y0; auto.
       rewrite upper_union; toProp; auto.
       rewrite upper_union; toProp; auto.
       apply upper_op_intro with a a; auto.
       rewrite (idem a); auto.
       rewrite upper_union; toProp; auto.
       rewrite upper_union; toProp; auto.
       destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [x0 [y0 [p1 [p2 p3]]]].
       rewrite upper_union in *; toProp; auto.
       destruct p3 as [p3 | p3]; destruct p2 as [p2 | p2]; auto.
       apply or_introl; apply upper_op_intro with x0 y0; auto.
       apply or_intror; apply (upper_mem_pres_le _ _ _ p2); apply (@le_trans A _ (x0 + y0)); auto.
       apply or_intror; apply (upper_mem_pres_le _ _ _ p3); apply (@le_trans A _ (x0 + y0)); auto.
       apply or_intror; apply (upper_mem_pres_le _ _ _ p2); apply (@le_trans A _ (x0 + y0)); auto.
    Defined.
    
    Lemma isRightDistributive_comp : IsIdempotent_comp A + LeftOpNonDecreasing_comp A + RightOpNonDecreasing_comp A -> IsRightDistributive_comp minsetOpUnionBisemigroup.
    Proof. intros [[[x idem]|[x [y lnd]]]|[x [y rnd]]]. simpl in *.
       exists nil; exists nil; exists (x :: nil). simpl in *. toMSet. mred.
       rewrite fset_op_nil. mred. toProp; intros h; toSet.
       assert (p := h x); clear h; simpl in p.
       unfold min, union, fset_op in p; simpl in p.
       do 2 rewrite le_refl in p; simpl in p.
       rewrite refl, orb_false_r, orb_false_r in p. apply idem; apply sym; rewrite <- p; auto.
       
       exists nil; exists (y :: nil); exists (x :: nil); simpl in *. toMSet; mred. simpl.
       unfold fset_op at 1; simpl; toProp; intros h; toSet.
       unfold min, union, fset_op in h; simpl in h.
       rewrite le_refl in h; simpl in h. repeat rewrite orb_false_r in h.
       copy_destruct (y == x); rewrite ew in h; simpl in h.
          rewrite andb_true_r in h.
          rewrite le_refl in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          dseq_f; rewrite ew in lnd.
          apply lnd; assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          
          repeat rewrite le_refl in h; simpl in h.
          copy_destruct ((le A (x + x) (x + y))%bool); rewrite ew0 in h; simpl in h;
          copy_destruct ((le A (x + y) (x + x))%bool); rewrite ew1 in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          copy_destruct (x == x + x).
             apply lnd; apply (@le_trans A _ (x + x)); auto; dseq_f; rewrite <- ew2; auto.
             rewrite ew2 in p; simpl in p. rewrite orb_false_r in p;
             apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply lnd; apply (@le_trans A _ (x + x)); auto; dseq_f;
          assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p;
          apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          copy_destruct (x == x + x).
             assert (p := h (x + y)); rewrite refl in p; repeat rewrite orb_false_r in p.
             simpl in p; dseq_f.
             apply lnd; rewrite p; auto.
             assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite ew2, orb_false_r in p. simpl in p.
             apply lnd; assert (x == x + y) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.

       exists (y :: nil); exists nil; exists (x :: nil); simpl in *. toMSet; mred. simpl.
       unfold fset_op at 1; simpl; toProp; intros h; toSet.
       unfold min, union, fset_op in h; simpl in h.
       rewrite le_refl in h; simpl in h. repeat rewrite orb_false_r in h.
       copy_destruct (y == x); rewrite ew in h; simpl in h.
          rewrite andb_true_r in h.
          rewrite le_refl in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          dseq_f; rewrite ew in rnd;
          apply rnd; assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          
          repeat rewrite le_refl in h; simpl in h.
          copy_destruct ((le A (x + x) (y + x))%bool); rewrite ew0 in h; simpl in h;
          copy_destruct ((le A (y + x) (x + x))%bool); rewrite ew1 in h; simpl in h.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          copy_destruct (x == x + x).
             apply rnd; apply (@le_trans A _ (x + x)); auto; dseq_f; rewrite <- ew2; auto.
             rewrite ew2 in p; simpl in p. rewrite orb_false_r in p.
             apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
          apply rnd; apply (@le_trans A _ (x + x)); auto; dseq_f;
          assert (x == x + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p;
          apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
          copy_destruct (x == x + x).
             assert (p := h (y + x)); rewrite refl in p; repeat rewrite orb_false_r in p.
             simpl in p; dseq_f.
             apply rnd; rewrite p; auto.
             assert (p := h x); rewrite refl in p; repeat rewrite orb_false_r in p.
             rewrite ew2 in p. simpl in p. rewrite orb_false_r in p;
             apply rnd; assert (x == y + x) as q; [dseq_u; rewrite <- p | rewrite <- q]; auto.
    Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity minsetOpUnionBisemigroup.
   Proof. intros pid tann.
      set (pid2 := FMinSetsOp.hasAnnihilator A lmon rmon antisym).
      set (tann2 := FMinSetsUnion.hasIdentity A).
      set (iso := Iso_PresAnn (@SmgIso_sym (msetOpSemigroup A lmon rmon antisym) (plusSmg minsetOpUnionBisemigroup) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresId(@SmgIso_sym (msetUnionSemigroup A) (timesSmg minsetOpUnionBisemigroup) (timesBSmgIso _ _ _))).
      rewrite <- (iso2 tann tann2).
      simpl. auto.
   Defined.

(*
   Lemma plusAnnihilatorIsTimesIdentity : IsSingleton A -> PlusAnnihilatorIsTimesIdentity minsetOpUnionBisemigroup.
   Proof.
*)

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)
   
   Lemma comm_back : IsCommutative (plusSmg minsetOpUnionBisemigroup) -> IsCommutative A.
   Proof. intros comm x y. assert (p := comm (x :: nil) (y :: nil)); simpl in *.
      toMSet. unfold fset_op in p; simpl in p.
      toMSet_u. toSet_u.
      assert (h := p (y + x)); clear p; simpl in *.
      unfold min in h; simpl in h.
      repeat (rewrite le_refl in h; simpl in h).
      rewrite orb_false_r, refl in h; dseq_f; rewrite h; auto.
   Qed.
   
   Lemma idem_back : IsIdempotent (plusSmg minsetOpUnionBisemigroup) -> IsIdempotent A.
   Proof. intros idem x. assert (p := idem (x :: nil)); simpl in *.
      toMSet. unfold fset_op in p; simpl in p.
      toMSet_u. toSet_u.
      assert (h := p x); clear p; simpl in *.
      unfold min in h; simpl in h.
      repeat (rewrite le_refl in h; simpl in h).
      rewrite orb_false_r, refl in h; dseq_f. rewrite <- h; auto.
   Qed.

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem. assert (idemA := idem_back idem).
      set (a := choose A).
      exists nil; exists (a :: nil); exists (a :: nil).
      split. apply or_intror.
      negb_p; simpl; toMSet; toProp; dseq_f; mred.
      apply or_intror. apply min_pres_eq.
      toSet_u; unfold union, fset_op; simpl. 
      rewrite refl; simpl. rewrite (idemA a).
      destruct (a0 == a); auto.
      
      apply or_introl.
      negb_p; simpl; toMSet; toProp; dseq_f; mred.
      intros h. unfold fset_op, min in h; simpl in h.
      rewrite le_refl in h. simpl in h.
      toSet_u.
      assert (p := h a); simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem. assert (idemA := idem_back idem).
      set (a := choose A).
      exists nil; exists (a :: nil); exists (a :: nil).
      split. apply or_intror.
      negb_p; simpl; toMSet; toProp; dseq_f; mred.
      apply or_intror. apply min_pres_eq.
      toSet_u; unfold union, fset_op; simpl. 
      rewrite refl; simpl. rewrite (idemA a).
      destruct (a0 == a); auto.
      
      apply or_introl.
      negb_p; simpl; toMSet; toProp; dseq_f; mred.
      intros h. unfold fset_op, min in h; simpl in h.
      rewrite le_refl in h. simpl in h.
      toSet_u.
      assert (p := h a); simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma total_singleton : Total A -> forall x : minsetOpUnionBisemigroup, 
      (x == nil) + (Exists a, x == a :: nil).
   Proof. intros tot [|x xs].
      apply inl; auto.
      apply inr.
      assert (mem x (x :: xs)) as h; [simpl; rewrite refl; auto|].
      destruct (min_exists_mem A _ _ h) as [a [p1 p2]].
      exists a. simpl. unfold eq_mset; dseq_f.
      rewrite singleton_min. toSet_u. simpl.
      copy_destruct (a0 == a); dseq_f; rewrite ew; auto.
         assert (p := mem_pres_eq (min A (x :: xs)) ew). simpl in p.
         rewrite p; auto.
         simpl.
         rewrite (min_mem A) in p1. destruct p1 as [p1 p3].
         bool_p; intros q.
         rewrite (min_mem A) in q. destruct q as [q1 q2].
         apply ew. dseq_f.
         assert (r1 := p3 _ q1).
         assert (r2 := q2 _ p1).
         negb_p.
         apply antisym.
         destruct (tot a a0);
         toProp; tauto.
   Defined.

   Lemma isSelective__isRightCompEqCancel : IsSelective (plusSmg minsetOpUnionBisemigroup) -> IsRightCompEqCancel minsetOpUnionBisemigroup.
   Proof. intros sel comm idem x y z p.
      destruct (sel x y).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; rewrite (comm x y) in H; auto.
   Qed.
   
   Lemma isSelective_comp__isRightCompEqCancel_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> IsRightCompEqCancel_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      exists x; exists y; exists (mset_union A x y); split.
         toMSet_u. dseq_f. mred. apply min_pres_eq.
         toSet_u. destruct (mem a x); destruct (mem a y); auto.
      destruct sel as [s1 s2]; toProp; split; intros h.
         apply s1; auto.
         apply s2; dseq_f; rewrite (comm x y); auto.
   Defined.

   Lemma isRightCompEqCancel : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> IsRightCompEqCancel minsetOpUnionBisemigroup.
   Proof. intros X. 
      apply isSelective__isRightCompEqCancel.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.
   
   Lemma isRightCompEqCancel_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> IsRightCompEqCancel_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__isRightCompEqCancel_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.

   Lemma isSelective__isLeftCompEqCancel : IsSelective (plusSmg minsetOpUnionBisemigroup) -> IsLeftCompEqCancel minsetOpUnionBisemigroup.
   Proof. intros sel comm idem x y z p.
      destruct (sel x y).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; rewrite (comm x y) in H; auto.
   Qed.
   
   Lemma isSelective_comp__isLeftCompEqCancel_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> IsLeftCompEqCancel_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      exists x; exists y; exists (mset_union A x y); split.
         toMSet_u. dseq_f. mred. apply min_pres_eq.
         toSet_u. destruct (mem a x); destruct (mem a y); auto.
      destruct sel as [s1 s2]; toProp; split; intros h.
         apply s1; auto.
         apply s2; dseq_f; rewrite (comm x y); auto.
   Defined.

   Lemma isLeftCompEqCancel : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> IsLeftCompEqCancel minsetOpUnionBisemigroup.
   Proof. intros X. 
      apply isSelective__isLeftCompEqCancel.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.
   
   Lemma isLeftCompEqCancel_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> IsLeftCompEqCancel_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__isLeftCompEqCancel_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.

   Lemma isSelective__isRightCompCancel : IsSelective (plusSmg minsetOpUnionBisemigroup) -> IsRightCompCancel minsetOpUnionBisemigroup.
   Proof. intros sel comm idem x y z p.
      destruct (sel x y).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; rewrite (comm x y) in H; auto.
   Qed.

   Lemma isSelective_comp__isRightCompCancel_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> IsRightCompCancel_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      assert (((plus minsetOpUnionBisemigroup x y) != x) && ((plus minsetOpUnionBisemigroup y x) != y)) as e1.
         destruct sel as [s1 s2]; toProp; split; intros h.
            apply s1; auto.
            apply s2; dseq_f; rewrite (comm x y); auto.
      exists x; exists y; exists nil; split; auto.
         assert (forall w, (times minsetOpUnionBisemigroup w nil) == w) as e2.
            intros. simpl; toProp; toMSet_u. dseq_f. mred. apply min_pres_eq; toSet_u.
            destruct (mem a w); auto.
         rewrite (e2 x), (e2 y); auto.
   Defined.

   Lemma isRightCompCancel : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> IsRightCompCancel minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective__isRightCompCancel.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.

   Lemma isRightCompCancel_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> IsRightCompCancel_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__isRightCompCancel_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.

   Lemma isSelective__isLeftCompCancel : IsSelective (plusSmg minsetOpUnionBisemigroup) -> IsLeftCompCancel minsetOpUnionBisemigroup.
   Proof. intros sel comm idem x y z p.
      destruct (sel x y).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; rewrite (comm x y) in H; auto.
   Qed.

   Lemma isSelective_comp__isLeftCompCancel_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> IsLeftCompCancel_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      assert (((plus minsetOpUnionBisemigroup x y) != x) && ((plus minsetOpUnionBisemigroup y x) != y)) as e1.
         destruct sel as [s1 s2]; toProp; split; intros h.
            apply s1; auto.
            apply s2; dseq_f; rewrite (comm x y); auto.
      exists x; exists y; exists nil; split; auto.
         assert (forall w, (times minsetOpUnionBisemigroup nil w) == w) as e2.
            intros. simpl; toProp; toMSet_u. dseq_f. mred. apply min_pres_eq; toSet_u.
            destruct (mem a w); auto.
         rewrite (e2 x), (e2 y); auto.
   Defined.

   Lemma isLeftCompCancel : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> IsLeftCompCancel minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective__isLeftCompCancel.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.

   Lemma isLeftCompCancel_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> IsLeftCompCancel_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__isLeftCompCancel_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem.
      set (a := choose A).
      exists nil; exists (a :: nil); exists nil.
      negb_p. toProp. split.
      simpl. toMSet_u. mred. auto.
      intros h; toMSet_u; dseq_f; mred.
      unfold min, fset_op, union in h; simpl in h.
      repeat (rewrite le_refl in h; simpl in h).
      toSet_u; assert (p := h a); simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem.
      set (a := choose A).
      exists nil; exists (a :: nil); exists nil.
      negb_p. toProp. split.
      simpl. toMSet_u. mred. auto.
      intros h; toMSet_u; dseq_f; mred.
      unfold min, fset_op, union in h; simpl in h.
      repeat (rewrite le_refl in h; simpl in h).
      toSet_u; assert (p := h a); simpl in p; rewrite refl in p; discriminate p.
   Defined.

   Lemma isSelective__leftComparable : IsSelective (plusSmg minsetOpUnionBisemigroup) -> LeftComparable minsetOpUnionBisemigroup.
   Proof. intros sel comm idem. intros x y z.
      destruct (sel (times minsetOpUnionBisemigroup z x) (times minsetOpUnionBisemigroup z y)).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; 
      rewrite (comm (times minsetOpUnionBisemigroup z x) (times minsetOpUnionBisemigroup z y)) in H; auto.
   Qed.

   Lemma isSelective_comp__leftComparable_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> LeftComparable_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      exists x; exists y; exists nil.
      assert (forall w, (times minsetOpUnionBisemigroup nil w) == w) as e1.
         intros. simpl; toProp; toMSet_u. dseq_f. mred. apply min_pres_eq; toSet_u. auto.
      rewrite (e1 x), (e1 y).
         destruct sel as [s1 s2]; toProp; split; intros h.
            apply s1; auto.
            apply s2; dseq_f; rewrite (comm x y); auto.
   Defined.

   Lemma leftComparable : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> LeftComparable minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective__leftComparable.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.

   Lemma leftComparable_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> LeftComparable_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__leftComparable_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.

   Lemma isSelective__rightComparable : IsSelective (plusSmg minsetOpUnionBisemigroup) -> RightComparable minsetOpUnionBisemigroup.
   Proof. intros sel comm idem. intros x y z.
      destruct (sel (times minsetOpUnionBisemigroup x z) (times minsetOpUnionBisemigroup y z)).
      toProp. dseq_f. apply or_introl; auto.
      toProp. dseq_f. apply or_intror; 
      rewrite (comm (times minsetOpUnionBisemigroup x z) (times minsetOpUnionBisemigroup y z)) in H; auto.
   Qed.

   Lemma isSelective_comp__rightComparable_comp : IsSelective_comp (plusSmg minsetOpUnionBisemigroup) -> RightComparable_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y sel]] comm idem.
      exists x; exists y; exists nil.
      assert (forall w, (times minsetOpUnionBisemigroup w nil) == w) as e1.
         intros. simpl; toProp; toMSet_u. dseq_f. mred. apply min_pres_eq; toSet_u. destruct (mem a w); auto.
      rewrite (e1 x), (e1 y).
         destruct sel as [s1 s2]; toProp; split; intros h.
            apply s1; auto.
            apply s2; dseq_f; rewrite (comm x y); auto.
   Defined.

   Lemma rightComparable : IsSelective A * (IsSelective_comp A + IncompArrowUniqueSrc A * IncompArrowFactor A) -> RightComparable minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective__rightComparable.
      apply (FMinSetsOp.isSelective A lmon rmon antisym X).
   Qed.

   Lemma rightComparable_comp : IsSelective_comp A + IsSelective A * (IncompArrowUniqueSrc_comp A + IncompArrowFactor_comp A) -> RightComparable_comp minsetOpUnionBisemigroup.
   Proof. intros X.
      apply isSelective_comp__rightComparable_comp.
      apply (FMinSetsOp.isSelective_comp A lmon rmon antisym X).
   Defined.
   
   Lemma leftIncreasing : RightOpNonDecreasing A -> LeftIncreasing minsetOpUnionBisemigroup.
   Proof. intros rnd comm idem x y. simpl.
      assert (commA := comm_back comm).
      assert (idemA := idem_back idem).
      dseq_u; simpl. unfold eq_mset; dseq_f. toMSet. mred.
      rewrite <- upper_eq; auto. intros a.
      rewrite bool_eq; split; intros h.

      destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [b [c [p1 [p2 p3]]]].
      rewrite upper_union in p3; auto.
      rewrite (commA b c) in p1. simpl in p1.
      assert (le A b a) as q1; [apply (@le_trans A _ (c + b)); auto|].
      apply (upper_mem_pres_le _ _ _ p2 q1).
      
      apply upper_op_intro with a a; auto.
      rewrite (idemA a); auto.
      rewrite upper_union; toProp; auto.
   Defined.
   
   Lemma leftIncreasing_comp : RightOpNonDecreasing_comp A -> LeftIncreasing_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y rnd]] comm idem. simpl.
      assert (commA := comm_back comm).
      assert (idemA := idem_back idem).
      exists (x :: nil); exists (y :: nil); toMSet.
      mred. unfold min, fset_op, union, eq_fset; simpl.
      toProp; rewrite eq_fset_mem.
      assert (y == x = false);
         [bool_p; intros h; toProp; apply rnd; dseq_f; rewrite h, (idemA x); auto| rewrite H; simpl].
      repeat (rewrite le_refl; simpl).
      assert (le A (x + x) (x + y) = false).
         bool_p; intros h; apply rnd; dseq_f; rewrite (idemA x), (commA x y) in h; auto.
      rewrite H0; simpl.
      copy_destruct (le A (x + y) (x + x)); rewrite ew; simpl.
         intros p; assert (y + x == x).
         assert (h := p x); rewrite refl, orb_false_r in h; simpl in h.
         dseq_f; rewrite (commA y x), <- h; auto.
         apply rnd; rewrite H1; auto.
         
         intros p; assert (y + x == x).
         assert (h := p (x + y));rewrite refl in h; simpl in h; rewrite orb_false_r in h.
         rewrite (commA y x). simpl. dseq_u; rewrite <- h; auto.
         apply rnd; rewrite H1; auto.
   Defined.

   Lemma rightIncreasing : RightOpNonDecreasing A -> RightIncreasing minsetOpUnionBisemigroup.
   Proof. intros rnd comm idem x y. simpl.
      assert (commA := comm_back comm).
      assert (idemA := idem_back idem).
      dseq_u; simpl. unfold eq_mset; dseq_f. toMSet. mred.
      rewrite <- upper_eq; auto. intros a.
      rewrite bool_eq; split; intros h.

      destruct (upper_op_elim A lmon rmon antisym _ _ _ h) as [b [c [p1 [p2 p3]]]].
      rewrite upper_union in p3; auto.
      rewrite (commA b c) in p1. simpl in p1.
      assert (le A b a) as q1; [apply (@le_trans A _ (c + b)); auto|].
      apply (upper_mem_pres_le _ _ _ p2 q1).
      
      apply upper_op_intro with a a; auto.
      rewrite (idemA a); auto.
      rewrite upper_union; toProp; auto.
   Defined.
   
   Lemma rightIncreasing_comp : RightOpNonDecreasing_comp A -> RightIncreasing_comp minsetOpUnionBisemigroup.
   Proof. intros [x [y rnd]] comm idem. simpl.
      assert (commA := comm_back comm).
      assert (idemA := idem_back idem).
      exists (x :: nil); exists (y :: nil); toMSet.
      mred. unfold min, fset_op, union, eq_fset; simpl.
      toProp; rewrite eq_fset_mem.
      assert (x == y = false).
         bool_p; intros h; toProp; apply rnd; dseq_f. rewrite <- h, (idemA x); auto.
      rewrite H; simpl.
      repeat (rewrite le_refl; simpl).
      assert (le A (x + x) (x + y) = false).
         bool_p; intros h; apply rnd; dseq_f; rewrite (idemA x), (commA x y) in h; auto.
      rewrite H0; simpl.
      copy_destruct (le A (x + y) (x + x)); rewrite ew; simpl.
         intros p; assert (y + x == x).
         assert (h := p x); rewrite refl, orb_false_r in h; simpl in h.
         dseq_f; rewrite (commA y x), <- h; auto.
         apply rnd; rewrite H1; auto.
         
         intros p; assert (y + x == x).
         assert (h := p (x + y));rewrite refl in h; simpl in h; rewrite orb_false_r in h.
         rewrite (commA y x). simpl. dseq_u; rewrite <- h; auto.
         rewrite orb_true_r; auto.
         apply rnd; rewrite H1; auto.
   Defined.
 
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp minsetOpUnionBisemigroup.
   Proof. intros comm idem; simpl. exists nil; exists nil; compute; auto. Defined.

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)
   
   Lemma nilOrElement : forall x : minsetOpUnionBisemigroup, (x = nil) + (Exists y, (mem y (min A x))).
   Proof. intros [|a x]. apply inl; auto. apply inr.
      assert (mem a (a :: x)) as h.
         simpl; rewrite refl; auto.
      destruct (min_exists_mem A _ _ h) as [y p].
      exists y. tauto.
   Defined.

(*
   Lemma idNil : forall (i : HasIdentity (plusSmg minsetOpUnionBisemigroup)), projT1 i == nil.
   Proof. intros [i p]; simpl. destruct (nilOrElement i) as [|[y x]]; [rewrite e; auto|].
      destruct (p nil) as [h _]; simpl in h.
      unfold mset_union in h.
      assert (min A (union A i nil) == min A i) as w.
         apply min_pres_eq; toSet_u; simpl; rewrite orb_false_r; auto.
      assert (min A i == nil) as w1.
         unfold dseq in h; simpl in h; unfold eq_mset in h; dseq_f.
         rewrite min_min in h. rewrite w in h. apply h.
      unfold dseq; simpl; unfold eq_mset; dseq_f. apply w1.
   Qed.
*)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp minsetOpUnionBisemigroup.
   Proof. intros id.
      exists nil; exists nil; exists nil; simpl.
      toMSet. toProp. dseq_f; mred. intros h.
      dseq_u; simpl in h. rewrite eq_fset_mem in h. simpl.
      destruct id as [[|x m] p]; simpl in *.
         set (a := choose A). clear h.
         assert (h := p (a :: nil)).
         destruct h as [h _].
         toMSet. unfold fset_op in h; simpl in h.
         dseq_u; simpl in *. 
         unfold min in h; simpl in h. unfold eq_mset in h; simpl in h.
         rewrite eq_fset_mem in h.
         assert (q := h a); simpl in q. unfold min in q; simpl in q.
         rewrite le_refl in q; simpl in q. rewrite refl in q; discriminate q.
         
         assert (Exists b, mem b (min A (union A (x :: m) nil))).
            assert (mem x (x :: m)).
               simpl; rewrite refl; auto.
            destruct (min_exists_mem A _ _ H) as [b [p1 p2]].
            exists b; auto.
            assert (min A (x :: m) == min A (union A (x :: m) nil)).
               apply min_pres_eq. toSet_u. simpl. rewrite orb_false_r; auto.
            rewrite <- H0. apply p1.
         destruct X as [b q].
         assert (mem b (min A (min A (union A (x :: m) nil)))).
            rewrite min_min. auto.
         assert (r := h b).
         simpl in *.
         rewrite H in r; discriminate r.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp minsetOpUnionBisemigroup.
   Proof. intros id.
      exists nil; exists nil; exists nil; simpl.
      toMSet. toProp. dseq_f; mred. intros h.
      dseq_u; simpl in h. rewrite eq_fset_mem in h. simpl.
      destruct id as [[|x m] p]; simpl in *.
         set (a := choose A). clear h.
         assert (h := p (a :: nil)).
         destruct h as [h _].
         toMSet_u. unfold fset_op in h; simpl in h.
         dseq_u; simpl in *. unfold eq_mset in h. rewrite eq_fset_mem in h.
         assert (q := h a); simpl in q. unfold min in q; simpl in q.
         rewrite le_refl in q; simpl in q. rewrite refl in q; discriminate q.
         
         assert (Exists b, mem b (min A (union A nil (x :: m)))).
            assert (mem x (x :: m)).
               simpl; rewrite refl; auto.
            destruct (min_exists_mem A _ _ H) as [b [p1 p2]].
            exists b; auto.
            assert (min A (x :: m) == min A (union A nil (x :: m))).
               apply min_pres_eq. toSet_u. simpl. auto. 
            rewrite <- H0. apply p1.
         destruct X as [b q].
         assert (mem b (min A (min A (union A nil (x :: m))))).
            rewrite min_min. auto.
         assert (r := h b).
         simpl in *.
         rewrite H in r; discriminate r.
   Defined.

(*
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator minsetOpUnionBisemigroup.
   Proof. intros hasId. intros x.
      rewrite (idNil hasId).
      auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator minsetOpUnionBisemigroup.
   Proof. intros hasId. intros x. rewrite (idNil hasId).
      toMSet_u; toSet_u; rewrite fset_op_nil; auto.
   Defined.
*)

End FMinSets.
