(*
 * Skip: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.

Section Copy.

   Variable A : Semigroup.
   
   Definition copyBisemigroup : Bisemigroup :=
      glueBSmg A A (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma isLeftDistributive : IsLeftDistributive copyBisemigroup.
   Proof. intros x y z. simpl.

End Copy.

      bs_plus_sgprop                            : sgProp (plusSmg BS);
      bs_times_sgprop                           : sgProp (timesSmg BS);
      isLeftDistributive                        : option IsLeftDistributive;
      isLeftDistributive_comp                   : option IsLeftDistributive_comp;
      isRightDistributive                       : option IsRightDistributive;
      isRightDistributive_comp                  : option IsRightDistributive_comp;
      isLeftCoDistributive                      : option IsLeftCoDistributive;
      isLeftCoDistributive_comp                 : option IsLeftCoDistributive_comp;
      isRightCoDistributive                     : option IsRightCoDistributive;
      isRightCoDistributive_comp                : option IsRightCoDistributive_comp;
      plusIdentityIsTimesAnnihilator            : option PlusIdentityIsTimesAnnihilator;
      plusIdentityIsTimesAnnihilator_comp       : option PlusIdentityIsTimesAnnihilator_comp;
      plusAnnihilatorIsTimesIdentity            : option PlusAnnihilatorIsTimesIdentity;
      plusAnnihilatorIsTimesIdentity_comp       : option PlusAnnihilatorIsTimesIdentity_comp;
      (* LatticeProps *)
      isRightStrictStable                       : option IsRightStrictStable;
      isRightStrictStable_comp                  : option IsRightStrictStable_comp;
      isLeftStrictStable                        : option IsLeftStrictStable;
      isLeftStrictStable_comp                   : option IsLeftStrictStable_comp;
      isRightCompEqCancel                       : option IsRightCompEqCancel;
      isRightCompEqCancel_comp                  : option IsRightCompEqCancel_comp;
      isLeftCompEqCancel                        : option IsLeftCompEqCancel;
      isLeftCompEqCancel_comp                   : option IsLeftCompEqCancel_comp;
      isRightCompCancel                         : option IsRightCompCancel;
      isRightCompCancel_comp                    : option IsRightCompCancel_comp;
      isLeftCompCancel                          : option IsLeftCompCancel;
      isLeftCompCancel_comp                     : option IsLeftCompCancel_comp;
      leftDiscrete                              : option LeftDiscrete;
      leftDiscrete_comp                         : option LeftDiscrete_comp;
      rightDiscrete                             : option RightDiscrete;
      rightDiscrete_comp                        : option RightDiscrete_comp;
      leftComparable                            : option LeftComparable;
      leftComparable_comp                       : option LeftComparable_comp;
      rightComparable                           : option RightComparable;
      rightComparable_comp                      : option RightComparable_comp;
      (* IdProps *)
      isRightTimesMapToIdConstantPlus           : option IsRightTimesMapToIdConstantPlus;
      isRightTimesMapToIdConstantPlus_comp      : option IsRightTimesMapToIdConstantPlus_comp;
      isLeftTimesMapToIdConstantPlus            : option IsLeftTimesMapToIdConstantPlus;
      isLeftTimesMapToIdConstantPlus_comp       : option IsLeftTimesMapToIdConstantPlus_comp;
      plusIdentityIsTimesLeftAnnihilator        : option PlusIdentityIsTimesLeftAnnihilator;
      plusIdentityIsTimesLeftAnnihilator_comp   : option PlusIdentityIsTimesLeftAnnihilator_comp;
      plusIdentityIsTimesRightAnnihilator       : option PlusIdentityIsTimesRightAnnihilator;
      plusIdentityIsTimesRightAnnihilator_comp  : option PlusIdentityIsTimesRightAnnihilator_comp
