Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Unit.

Section AddZero.

   Open Scope Bisemigroup_scope.

   Variable A : Bisemigroup.

   Definition addZeroBisemigroup : Bisemigroup :=
      let s1 := unionSemigroup (plusSmg A) unitSemigroup in
      let s2 := unionSwapSemigroup unitSemigroup (timesSmg A) in
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******)

   Definition zero : addZeroBisemigroup := inr _ tt.

   Lemma test_zero_1 : forall x : addZeroBisemigroup, zero + x == x.
   Proof. intros [x|[]]; auto. Defined.

   Lemma test_zero_2 : forall x : addZeroBisemigroup, x + zero == x.
   Proof. intros [x|[]]; auto. Defined.

   Lemma test_zero_3 : forall x : addZeroBisemigroup, zero * x == zero.
   Proof. intros [x|[]]; auto. Defined.

   Lemma test_zero_4 : forall x : addZeroBisemigroup, x * zero == zero.
   Proof. intros [x|[]]; auto. Defined.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma isLeftDistributive : IsLeftDistributive A -> IsLeftDistributive addZeroBisemigroup.
   Proof. intros ld [x|[]] [y|[]] [z|[]]; dseq_u; simpl; dseq_f; auto. Defined. 
   
   Lemma isLeftDistributive_comp : IsLeftDistributive_comp A -> IsLeftDistributive_comp addZeroBisemigroup.
   Proof. intros [x [y [z ld]]]; exists (inl _ x); exists (inl _ y); exists (inl _ z); dseq_u; simpl; auto. Defined.

   Lemma isRightDistributive : IsRightDistributive A -> IsRightDistributive addZeroBisemigroup.
   Proof. intros ld [x|[]] [y|[]] [z|[]]; dseq_u; simpl; dseq_f; auto. Defined. 

   Lemma isRightDistributive_comp : IsRightDistributive_comp A -> IsRightDistributive_comp addZeroBisemigroup.
   Proof. intros [x [y [z ld]]]; exists (inl _ x); exists (inl _ y); exists (inl _ z); dseq_u; simpl; auto. Defined.

   (* skip: IsLeftCoDistributive *)

   (* skip: IsRightCoDistributive *)
   
   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator addZeroBisemigroup.
   Proof. intros [id p] [ann q]. simpl in *.
      destruct id as [id|[]]; [destruct (p (inr _ tt)) as [h _]; simpl in h; discriminate h |].
      destruct ann as [ann|[]]; [destruct (q (inr _ tt)) as [h _]; simpl in h; discriminate h |].
      auto.
   Defined.
   
   Lemma hasPlusAnn_back : HasAnnihilator (plusSmg addZeroBisemigroup) -> HasAnnihilator (plusSmg A).
   Proof. intros [[an|[]] p]; [| destruct (p (inl _ (choose A))) as [H _]; dseq_u; simpl in *; discriminate H].
      exists an. intros x; destruct (p (inl _ x)); dseq_u; simpl in *; dseq_f. tauto.
   Defined.

   Lemma hasTimesId_back : HasIdentity (timesSmg addZeroBisemigroup) -> HasIdentity (timesSmg A).
   Proof. intros [[an|[]] p]; [| destruct (p (inl _ (choose A))) as [H _]; dseq_u; simpl in *; discriminate H].
      exists an. intros x; destruct (p (inl _ x)); dseq_u; simpl in *; dseq_f. tauto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity A -> PlusAnnihilatorIsTimesIdentity addZeroBisemigroup.
   Proof. intros p pan tid.
      set (pa := p (hasPlusAnn_back pan) (hasTimesId_back tid)).
      destruct pan as [[an|[]] w1];
      destruct tid as [[id|[]] w2]; simpl in *; auto.
      
      destruct (w2 (inl _ (choose A))); dseq_u; simpl in *; discriminate.
      destruct (w1 (inl _ (choose A))); dseq_u; simpl in *; discriminate.
   Defined.
   
   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp A -> PlusAnnihilatorIsTimesIdentity_comp addZeroBisemigroup.
   Proof. intros p pan tid.
      set (pa := p (hasPlusAnn_back pan) (hasTimesId_back tid)).
      destruct pan as [[an|[]] w1];
      destruct tid as [[id|[]] w2]; simpl in *; auto.
      
      destruct (w2 (inl _ (choose A))); dseq_u; simpl in *; discriminate.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)
   
   Lemma comm_back : IsCommutative (plusSmg addZeroBisemigroup) -> IsCommutative (plusSmg A).
   Proof. intros comm.
      assert (p := Iso_IsCommutative (SmgIso_sym (plusBSmgIso _ _ _)) comm).
      intros x y; assert (q := p (inl _ x) (inl _ y)); dseq_u; simpl in *; auto.
   Defined.
   
   Lemma idem_back : IsIdempotent (plusSmg addZeroBisemigroup) -> IsIdempotent (plusSmg A).
   Proof. intros idem.
      assert (p := Iso_IsIdempotent (SmgIso_sym (plusBSmgIso _ _ _)) idem).
      intros x; assert (q := p (inl _ x)); dseq_u; simpl in *; auto.
   Defined.
   
   Ltac ci_back comm idem :=
      let comm' := fresh "comm" in
      let idem' := fresh "idem" in
      assert (comm' := comm_back comm);
      assert (idem' := idem_back idem);
      clear comm idem;
      rename comm' into comm;
      rename idem' into idem.

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp addZeroBisemigroup.
   Proof. intros comm idem; exists (inl _ (choose A)); exists zero; exists zero; simpl.
      rewrite refl; toBool; simpl; auto.
   Defined.
   
   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp addZeroBisemigroup.
   Proof. intros comm idem; exists (inl _ (choose A)); exists zero; exists zero; simpl.
      rewrite refl; toBool; simpl; auto.
   Defined.

   Lemma isRightCompEqCancel : IsSelective (plusSmg A) -> IsRightCompEqCancel addZeroBisemigroup.
   Proof. intros sel comm idem [x|[]] [y|[]] [z|[]] _; simpl; toProp; dseq_f; auto;
      ci_back comm idem; rewrite (comm y x); simpl; destruct (sel x y); auto.
   Defined.

   Lemma isRightCompEqCancel_comp : IsSelective_comp (plusSmg A) -> IsRightCompEqCancel_comp addZeroBisemigroup.
   Proof. intros [x [y sel]] comm idem. exists (inl _ x); exists (inl _ y); exists zero; simpl in *.
      ci_back comm idem; intuition; toProp; dseq_f; rewrite (comm y x); intuition.
   Defined.

   Lemma isLeftCompEqCancel : IsSelective (plusSmg A) -> IsLeftCompEqCancel addZeroBisemigroup.
   Proof. intros sel comm idem [x|[]] [y|[]] [z|[]] _; simpl; toProp; dseq_f; auto;
      ci_back comm idem; rewrite (comm y x); simpl; destruct (sel x y); auto.
   Defined.

   Lemma isLeftCompEqCancel_comp : IsSelective_comp (plusSmg A) -> IsLeftCompEqCancel_comp addZeroBisemigroup.
   Proof. intros [x [y sel]] comm idem. exists (inl _ x); exists (inl _ y); exists zero; simpl in *.
      ci_back comm idem; intuition; toProp; dseq_f; rewrite (comm y x); intuition.
   Defined.
   
   Lemma isLeftCompCancel : IsLeftCompCancel A -> IsLeftCompCancel addZeroBisemigroup.
   Proof. intros lcc comm idem [x|[]] [y|[]] [z|[]]; simpl; ci_back comm idem;
      try apply (lcc comm idem); bool_p; toProp; dseq_f; auto; try tauto.
   Defined.

   Lemma isLeftCompCancel_comp : IsLeftCompCancel_comp A -> IsLeftCompCancel_comp addZeroBisemigroup.
   Proof. intros lcc comm idem; ci_back comm idem; destruct (lcc comm idem) as [x [y [z p]]];
      exists (inl _ x); exists (inl _ y); exists (inl _ z); auto.
   Defined.
      
   Lemma isRightCompCancel : IsRightCompCancel A -> IsRightCompCancel addZeroBisemigroup.
   Proof. intros lcc comm idem [x|[]] [y|[]] [z|[]]; simpl; ci_back comm idem;
      try apply (lcc comm idem); bool_p; toProp; dseq_f; auto; try tauto.
   Defined.

   Lemma isRightCompCancel_comp : IsRightCompCancel_comp A -> IsRightCompCancel_comp addZeroBisemigroup.
   Proof. intros lcc comm idem; ci_back comm idem; destruct (lcc comm idem) as [x [y [z p]]];
      exists (inl _ x); exists (inl _ y); exists (inl _ z); auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp addZeroBisemigroup.
   Proof. intros comm idem. exists (inl _ (choose A)); exists zero; exists (inl _ (choose A)); simpl. rewrite refl; auto.
   Defined.
   
   Lemma rightDiscrete_comp : RightDiscrete_comp addZeroBisemigroup.
   Proof. intros comm idem. exists (inl _ (choose A)); exists zero; exists (inl _ (choose A)); simpl. rewrite refl; auto.
   Defined.
   
   Lemma leftComparable : LeftComparable A -> LeftComparable addZeroBisemigroup.
   Proof. intros lc comm idem [x|[]] [y|[]] [z|[]]; simpl; rewrite ?refl; auto.
      ci_back comm idem; assert (p := lc comm idem x y z); auto.
   Defined.

   Lemma leftComparable_comp : LeftComparable_comp A -> LeftComparable_comp addZeroBisemigroup.
   Proof. intros lc comm idem; ci_back comm idem; destruct (lc comm idem) as [x [y [z p]]].
      exists (inl _ x); exists (inl _ y); exists (inl _ z); auto.
   Defined.
      
   Lemma rightComparable : RightComparable A -> RightComparable addZeroBisemigroup.
   Proof. intros lc comm idem [x|[]] [y|[]] [z|[]]; simpl; rewrite ?refl; auto.
      ci_back comm idem; assert (p := lc comm idem x y z); auto.
   Defined.

   Lemma rightComparable_comp : RightComparable_comp A -> RightComparable_comp addZeroBisemigroup.
   Proof. intros lc comm idem; ci_back comm idem; destruct (lc comm idem) as [x [y [z p]]].
      exists (inl _ x); exists (inl _ y); exists (inl _ z); auto.
   Defined.
   
   Lemma leftIncreasing : LeftIncreasing A -> LeftIncreasing addZeroBisemigroup.
   Proof. intros li comm idem; ci_back comm idem; intros [x|[]] [y|[]]; dseq_u; simpl; dseq_f; auto. Defined.
   
   Lemma leftIncreasing_comp : LeftIncreasing_comp A -> LeftIncreasing_comp addZeroBisemigroup.
   Proof. intros li comm idem; ci_back comm idem; destruct (li comm idem) as [x [y l]];
      exists (inl _ x); exists (inl _ y); simpl; auto.
   Defined.

   Lemma rightIncreasing : RightIncreasing A -> RightIncreasing addZeroBisemigroup.
   Proof. intros li comm idem; ci_back comm idem; intros [x|[]] [y|[]]; dseq_u; simpl; dseq_f; auto. Defined.
   
   Lemma rightIncreasing_comp : RightIncreasing_comp A -> RightIncreasing_comp addZeroBisemigroup.
   Proof. intros li comm idem; ci_back comm idem; destruct (li comm idem) as [x [y l]];
      exists (inl _ x); exists (inl _ y); simpl; auto.
   Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp addZeroBisemigroup.
   Proof. intros _ _; exists zero; exists zero; simpl. auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp addZeroBisemigroup.
   Proof. intros _ _; exists zero; exists zero; simpl. auto. Defined.

(*   Lemma leftWStrictIncreasing : LeftStrictIncreasing A -> LeftWStrictIncreasing addZeroBisemigroup.
   Proof. intros lsi comm idem hid x y; ci_back comm idem.
      rewrite (uniqueId _ hid (Union.hasIdentity (plusSmg A) _ (Unit.hasIdentity))).
      destruct x as [x|[]]; simpl; intros h; bool_p; try tauto.
      destruct y as [y|[]]; simpl; auto.
      toProp; dseq_f; auto.
   Qed. *)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)
   
   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp addZeroBisemigroup.
   Proof. intros [[id|[]] hasId]; [destruct (hasId zero); dseq_u; simpl in *; bool_p; tauto|].
      exists (inl _ (choose A)); exists (inl _ (choose A)); exists (inl _ (choose A)); dseq_u; simpl; auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp addZeroBisemigroup.
   Proof. intros [[id|[]] hasId]; [destruct (hasId zero); dseq_u; simpl in *; bool_p; tauto|].
      exists (inl _ (choose A)); exists (inl _ (choose A)); exists (inl _ (choose A)); dseq_u; simpl; auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator addZeroBisemigroup.
   Proof. intros [[id|[]] hasId]; [destruct (hasId zero); dseq_u; simpl in *; bool_p; tauto|].
      intros [x|[]]; dseq_u; simpl; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator addZeroBisemigroup.
   Proof. intros [[id|[]] hasId]; [destruct (hasId zero); dseq_u; simpl in *; bool_p; tauto|].
      intros [x|[]]; dseq_u; simpl; auto.
   Defined.

End AddZero.