Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Coq.Bool.Bool.

Section AddOne.

   Open Scope Bisemigroup_scope.

   Variable A : Bisemigroup.
   Variable comm : IsCommutative (plusSmg A).

   Definition addOneBisemigroup : Bisemigroup :=
      let s1 := unionSemigroup unitSemigroup (plusSmg A) in
      let s2 := unionSwapSemigroup (timesSmg A) unitSemigroup in
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******)

   Definition one : addOneBisemigroup := inl _ tt. 

   Lemma test_one_1 : forall x : addOneBisemigroup, one + x == one.
   Proof. intros [[]|x]; auto. Defined.

   Lemma test_one_2 : forall x : addOneBisemigroup, x + one == one.
   Proof. intros [[]|x]; auto. Defined.

   Lemma test_one_3 : forall x : addOneBisemigroup, one * x == x.
   Proof. intros [[]|x]; auto. Defined.

   Lemma test_one_4 : forall x : addOneBisemigroup, x * one == x.
   Proof. intros [[]|x]; auto. Defined.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
  

   Lemma isLeftDistributive : IsLeftDistributive A * IsIdempotent (plusSmg A)
       * (RightIncreasing A + IsIdempotent_comp (plusSmg A)) -> IsLeftDistributive addOneBisemigroup.
   Proof. intros [[ld idem] [ri | [a idemc]]]. 
      intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto.
      rewrite (idem z); auto.
      rewrite (ri comm idem z y); auto.
      rewrite (comm (z * x) z), (ri comm idem z x); auto.
      simpl in *; dseq_f; rewrite (idem a) in idemc; toProp; elim idemc; dseq_f; auto.
   Defined. 
   
   Lemma isLeftDistributive_comp : IsLeftDistributive_comp A + IsIdempotent_comp (plusSmg A)
       + (RightIncreasing_comp A * IsIdempotent (plusSmg A)) -> IsLeftDistributive_comp addOneBisemigroup.
   Proof. intros [[[x [y [z ld]]] | [x idem]] | [ri idm]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto. 
      exists one; exists one; exists (inr _ x); dseq_u; simpl in *; toProp; intros h; elim idem; dseq_f; rewrite <- h; auto. 
      destruct (ri comm idm) as [x [y r]].
      exists one; exists (inr _ y); exists (inr _ x); dseq_u; simpl; toProp; intros h; elim r; dseq_f; rewrite <- h; auto. 
   Defined.

   Lemma isRightDistributive : IsRightDistributive A * IsIdempotent (plusSmg A)
       * (LeftIncreasing A + IsIdempotent_comp (plusSmg A)) -> IsRightDistributive addOneBisemigroup.
   Proof. intros [[ld idem] [ri | [a idemc]]]. 
      intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto.
      rewrite (idem z); auto.
      rewrite (ri comm idem z y); auto.
      rewrite (comm (x * z) z), (ri comm idem z x); auto.
      simpl in *; dseq_f; rewrite (idem a) in idemc; toProp; elim idemc; dseq_f; auto.
   Defined.

   Lemma isRightDistributive_comp : IsRightDistributive_comp A + IsIdempotent_comp (plusSmg A)
       + (LeftIncreasing_comp A * IsIdempotent (plusSmg A)) -> IsRightDistributive_comp addOneBisemigroup.
   Proof. intros [[[x [y [z ld]]] | [x idem]] | [ri idm]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto. 
      exists one; exists one; exists (inr _ x); dseq_u; simpl in *; toProp; intros h; elim idem; dseq_f; rewrite <- h; auto. 
      destruct (ri comm idm) as [x [y r]].
      exists one; exists (inr _ y); exists (inr _ x); dseq_u; simpl; toProp; intros h; elim r; dseq_f; rewrite <- h; auto. 
   Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive A -> IsLeftCoDistributive addOneBisemigroup.
   Proof. intros ld [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto. Defined.

   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp A -> IsLeftCoDistributive_comp addOneBisemigroup.
   Proof. intros [x [y [z ld]]]; exists (inr _ x); exists (inr _ y); exists (inr _ z); 
      simpl. auto.
   Defined.

   Lemma isRightCoDistributive : IsRightCoDistributive A -> IsRightCoDistributive addOneBisemigroup.
   Proof. intros ld [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto. Defined.

   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp A -> IsRightCoDistributive_comp addOneBisemigroup.
   Proof. intros [x [y [z ld]]]; exists (inr _ x); exists (inr _ y); exists (inr _ z); 
      simpl. auto.
   Defined.
*)

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity addOneBisemigroup.
   Proof. intros [id p] [ann q]. simpl in *.
      destruct id as [[]|id]; [|destruct (p (inl _ tt)) as [h _]; simpl in h; discriminate h].
      destruct ann as [[]|ann]; [|destruct (q (inl _ tt)) as [h _]; simpl in h; discriminate h].
      auto.
   Defined.
   
   Lemma hasTimesAnn_back : HasAnnihilator (timesSmg addOneBisemigroup) -> HasAnnihilator (timesSmg A).
   Proof. intros [[[]|an] p]; [destruct (p (inr _ (choose A))) as [H _]; dseq_u; simpl in *; discriminate H|].
      exists an. intros x; destruct (p (inr _ x)); dseq_u; simpl in *; dseq_f. tauto.
   Defined.

   Lemma hasPlusId_back : HasIdentity (plusSmg addOneBisemigroup) -> HasIdentity (plusSmg A).
   Proof. intros [[[]|an] p]; [destruct (p (inr _ (choose A))) as [H _]; dseq_u; simpl in *; discriminate H|].
      exists an. intros x; destruct (p (inr _ x)); dseq_u; simpl in *; dseq_f. tauto.
   Defined.

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator A -> PlusIdentityIsTimesAnnihilator addOneBisemigroup.
   Proof. intros p pan tid.
      set (pa := p (hasPlusId_back pan) (hasTimesAnn_back tid)).
      destruct pan as [[[]|an] w1];
      destruct tid as [[[]|id] w2]; simpl in *; auto.
      
      destruct (w1 (inr _ (choose A))); dseq_u; simpl in *; discriminate.
      destruct (w2 (inr _ (choose A))); dseq_u; simpl in *; discriminate.
   Defined.
   
   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp A -> PlusIdentityIsTimesAnnihilator_comp addOneBisemigroup.
   Proof. intros p pan tid.
      set (pa := p (hasPlusId_back pan) (hasTimesAnn_back tid)).
      destruct pan as [[[]|an] w1];
      destruct tid as [[[]|id] w2]; simpl in *; auto.
      
      destruct (w2 (inr _ (choose A))); dseq_u; simpl in *; discriminate.
   Defined.
   
   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)
   
   Lemma idem_back : IsIdempotent (plusSmg addOneBisemigroup) -> IsIdempotent (plusSmg A).
   Proof. intros idem.
      assert (p := Iso_IsIdempotent (SmgIso_sym (plusBSmgIso _ _ _)) idem).
      intros x; assert (q := p (inr _ x)); dseq_u; simpl in *; auto.
   Defined.
   
   Ltac ci_back idem :=
      let idem' := fresh "idem" in
      assert (idem' := idem_back idem);
      clear idem;
      rename idem' into idem.

   Lemma isRightStrictStable : 
      IsRightStrictStable A
      * LeftStrictIncreasing A
      -> IsRightStrictStable addOneBisemigroup.
   Proof. intros [rss rsi] _ idem [[]|x] [[]|y] [[]|z]; ci_back idem; dseq_u; simpl; auto; toBool; simpl.
      rewrite (idem z), refl; auto.
      assert (p := rsi comm idem z x); negb_p; toProp; tauto.
      destruct (x < y); auto.
   Defined.
      
   Lemma isRightStrictStable_comp : 
      IsRightStrictStable_comp A
      + LeftStrictIncreasing_comp A
      -> IsRightStrictStable_comp addOneBisemigroup.
   Proof. intros [rss | rsi] _ idem; ci_back idem.
      destruct (rss comm idem) as [x [y [z rssA]]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto.
      
      destruct (rsi comm idem) as [x [y rsiA]].
      exists (inl _ tt); exists (inr _ y); exists (inr _ x); dseq_u; simpl; auto.
   Defined.

   Lemma isLeftStrictStable : 
      IsLeftStrictStable A
      * RightStrictIncreasing A
      -> IsLeftStrictStable addOneBisemigroup.
   Proof. intros [rss rsi] _ idem [[]|x] [[]|y] [[]|z]; ci_back idem; dseq_u; simpl; auto; toBool; simpl.
      rewrite (idem z), refl; auto.
      assert (p := rsi comm idem z x); negb_p; toProp; tauto.
      destruct (x < y); auto.
   Defined.
      
   Lemma isLeftStrictStable_comp : 
      IsLeftStrictStable_comp A
      + RightStrictIncreasing_comp A
      -> IsLeftStrictStable_comp addOneBisemigroup.
   Proof. intros [rss | rsi] _ idem; ci_back idem.
      destruct (rss comm idem) as [x [y [z rssA]]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto.
      
      destruct (rsi comm idem) as [x [y rsiA]].
      exists (inl _ tt); exists (inr _ y); exists (inr _ x); dseq_u; simpl; auto.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel A -> IsRightCompEqCancel addOneBisemigroup.
   Proof. intros rcec _ idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; toProp; dseq_f; auto; ci_back idem.
      intros h; rewrite h; rewrite (idem y); auto.
      intros h; assert (p := rcec comm idem x y z). toProp. auto.
   Defined.
   
   Lemma isRightCompEqCancel_comp : IsRightCompEqCancel_comp A -> IsRightCompEqCancel_comp addOneBisemigroup.
   Proof. intros rcec _ idem; ci_back idem; destruct (rcec comm idem) as [x [y [z r]]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel A -> IsLeftCompEqCancel addOneBisemigroup.
   Proof. intros rcec _ idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; toProp; dseq_f; auto; ci_back idem.
      intros h; rewrite h; rewrite (idem y); auto.
      intros h; assert (p := rcec comm idem x y z). toProp. auto.
   Defined.
   
   Lemma isLeftCompEqCancel_comp : IsLeftCompEqCancel_comp A -> IsLeftCompEqCancel_comp addOneBisemigroup.
   Proof. intros rcec _ idem; ci_back idem; destruct (rcec comm idem) as [x [y [z r]]].
      exists (inr _ x); exists (inr _ y); exists (inr _ z); dseq_u; simpl; auto.
   Defined.
   
   Lemma isLeftCompCancel : IsSelective (plusSmg A) -> IsLeftCompCancel addOneBisemigroup.
   Proof. intros sel _ idem [[]|x] [[]|y] [[]|z] _; dseq_u; simpl; ci_back idem;
      bool_p; toProp; dseq_f; auto; try tauto;
      rewrite (comm y x); destruct (sel x y); auto.
   Defined.
   
   Lemma isLeftCompCancel_comp : IsSelective_comp (plusSmg A) -> IsLeftCompCancel_comp addOneBisemigroup.
   Proof. intros [x [y sel]] _ idem; ci_back idem. simpl in sel.
      exists (inr _ x); exists (inr _ y); exists one; dseq_u; simpl; toProp.
      rewrite (comm y x). simpl; auto.
   Defined.

   Lemma isRightCompCancel : IsSelective (plusSmg A) -> IsRightCompCancel addOneBisemigroup.
   Proof. intros sel _ idem [[]|x] [[]|y] [[]|z] _; dseq_u; simpl; ci_back idem;
      bool_p; toProp; dseq_f; auto; try tauto;
      rewrite (comm y x); destruct (sel x y); auto.
   Defined.
   
   Lemma isRightCompCancel_comp : IsSelective_comp (plusSmg A) -> IsRightCompCancel_comp addOneBisemigroup.
   Proof. intros [x [y sel]] _ idem; ci_back idem. simpl in sel.
      exists (inr _ x); exists (inr _ y); exists one; dseq_u; simpl; toProp.
      rewrite (comm y x). simpl; auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp addOneBisemigroup.
   Proof. intros _ idem. exists one; exists (inr _ (choose A)); exists one; simpl. auto. Defined.
   
   Lemma rightDiscrete_comp : RightDiscrete_comp addOneBisemigroup.
   Proof. intros _ idem. exists one; exists (inr _ (choose A)); exists one; simpl. auto. Defined.
   
   Lemma leftComparable : IsSelective (plusSmg A) -> LeftComparable addOneBisemigroup.
   Proof. intros sel _ idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; negb_p; ci_back idem;
      toProp; dseq_f; rewrite ?refl; auto.
      rewrite (idem z); auto.
      rewrite (comm (z * y) z); destruct (sel z (z * y)); auto.
      rewrite (comm (z * x) z); destruct (sel z (z * x)); auto.
      rewrite (comm y x); destruct (sel x y); auto.
      rewrite (comm (z * x) (z * y)); destruct (sel (z * y) (z * x)); auto.
   Defined.

   Lemma leftComparable_comp : IsSelective_comp (plusSmg A) -> LeftComparable_comp addOneBisemigroup.
   Proof. intros [x [y sel]] _ idem.
      exists (inr _ x); exists (inr _ y); exists one; dseq_u; simpl; negb_p; toProp; dseq_f.
      rewrite (comm y x); auto.
   Defined.

   Lemma rightComparable : IsSelective (plusSmg A) -> RightComparable addOneBisemigroup.
   Proof. intros sel _ idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl; negb_p; ci_back idem;
      toProp; dseq_f; rewrite ?refl; auto.
      rewrite (idem z); auto.
      rewrite (comm (y * z) z); destruct (sel z (y * z)); auto.
      rewrite (comm (x * z) z); destruct (sel z (x * z)); auto.
      rewrite (comm y x); destruct (sel x y); auto.
      rewrite (comm (x * z) (y * z)); destruct (sel (y * z) (x * z)); auto.
   Defined.

   Lemma rightComparable_comp : IsSelective_comp (plusSmg A) -> RightComparable_comp addOneBisemigroup.
   Proof. intros [x [y sel]] _ idem.
      exists (inr _ x); exists (inr _ y); exists one; dseq_u; simpl; negb_p; toProp; dseq_f.
      rewrite (comm y x); auto.
   Defined.
   
   Lemma leftIncreasing : LeftIncreasing A -> LeftIncreasing addOneBisemigroup.
   Proof. intros li _ idem [[]|x] [[]|y]; dseq_u; simpl; auto; ci_back idem.
      apply (idem x).
      apply (li comm idem).
   Defined.

   Lemma leftIncreasing_comp : LeftIncreasing_comp A -> LeftIncreasing_comp addOneBisemigroup.
   Proof. intros li _ idem; ci_back idem. destruct (li comm idem) as [x [y l]].
      exists (inr _ x); exists (inr _ y); simpl. auto.
   Defined.

   Lemma rightIncreasing : RightIncreasing A -> RightIncreasing addOneBisemigroup.
   Proof. intros li _ idem [[]|x] [[]|y]; dseq_u; simpl; auto; ci_back idem.
      apply (idem x).
      apply (li comm idem).
   Defined.

   Lemma rightIncreasing_comp : RightIncreasing_comp A -> RightIncreasing_comp addOneBisemigroup.
   Proof. intros li _ idem; ci_back idem. destruct (li comm idem) as [x [y l]].
      exists (inr _ x); exists (inr _ y); simpl. auto.
   Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp addOneBisemigroup.
   Proof. intros _ idem; exists one; exists one; simpl. auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp addOneBisemigroup.
   Proof. intros _ idem; exists one; exists one; simpl. auto. Defined.

   Lemma id_back : HasIdentity (plusSmg addOneBisemigroup) -> HasIdentity (plusSmg A).
   Proof. intros [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      exists id. intros x. destruct (hasId (inr _ x)); auto.
   Defined.
(*   
   Lemma leftWStrictIncreasing : LeftStrictIncreasing A -> LeftWStrictIncreasing addOneBisemigroup.
   Proof. intros sia _ idem pah x y.
      rewrite (uniqueAnnh _ pah (Union.hasAnnihilator _ (plusSmg A) Unit.hasAnnihilator)).
      toBool; negb_p; simpl.
      destruct x as [[]|x]; auto.
      destruct y as [[]|y]; simpl; auto.
   
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp addOneBisemigroup.
   Proof. intros _ idem pah.
      exists zero; exists zero. simpl. split; auto.
      simpl in *. destruct id as [[]|id].
      assert (h := pid (inr _ (choose A))); dseq_u; simpl in h. bool_p; tauto.
      trivial.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp addOneBisemigroup.
   Proof. intros _ idem [id pid].
      exists one; exists one. simpl. split; auto.
      simpl in *. destruct id as [[]|id].
      assert (h := pid (inr _ (choose A))); dseq_u; simpl in h. bool_p; tauto.
      trivial.
   Defined.
*)
   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)
   
   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp addOneBisemigroup.
   Proof. intros [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      exists one; exists one; exists one; simpl; auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp addOneBisemigroup.
   Proof. intros [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      exists one; exists one; exists one; simpl; auto.
   Defined.
   

   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator A -> PlusIdentityIsTimesLeftAnnihilator addOneBisemigroup.
   Proof. intros hid hasId; assert (p := hid (id_back hasId)). simpl in p.
      destruct hasId as [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      simpl in *.
      intros [[]|x]; dseq_u; simpl; dseq_f; auto. apply p.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp : PlusIdentityIsTimesLeftAnnihilator_comp A -> PlusIdentityIsTimesLeftAnnihilator_comp addOneBisemigroup.
   Proof. intros hid hasId; assert (p := hid (id_back hasId)). simpl in p.
      destruct hasId as [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      simpl in *. destruct p as [x p]; exists (inr _ x). simpl. auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator A -> PlusIdentityIsTimesRightAnnihilator addOneBisemigroup.
   Proof. intros hid hasId; assert (p := hid (id_back hasId)). simpl in p.
      destruct hasId as [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      simpl in *.
      intros [[]|x]; dseq_u; simpl; dseq_f; auto. apply p.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator_comp : PlusIdentityIsTimesRightAnnihilator_comp A -> PlusIdentityIsTimesRightAnnihilator_comp addOneBisemigroup.
   Proof. intros hid hasId; assert (p := hid (id_back hasId)). simpl in p.
      destruct hasId as [[[]|id] hasId]; [destruct (hasId (inr _ (choose A))); dseq_u; simpl in *; bool_p; elim H|].
      simpl in *. destruct p as [x p]; exists (inr _ x). simpl. auto.
   Defined.

End AddOne.