(*
 * Skip: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.DecSetoids.AddConstant.
Require Import Coq.Setoids.Setoid.

(*

Section AbsorbingProduct.

   Open Scope Bisemigroup_scope.

   Variable A B : Bisemigroup.

   (* conditions *)
   Variable A_hasTimesAnnih : HasAnnihilator (timesSemigroup A).
   Variable B_hasTimesAnnih : HasAnnihilator (timesSemigroup B).
   Variable A_notsingleton : IsSingleton_comp (setoid A).
   Variable B_notsingleton : IsSingleton_comp (setoid B).
   Variable A_comm : IsCommutative (plusSemigroup A).
   Variable B_comm : IsCommutative (plusSemigroup B).
   Variable A_idem : IsIdempotent (plusSemigroup A).
   Variable B_idem : IsIdempotent (plusSemigroup B).
   Variable A_sel : IsSelective (plusSemigroup A).
   Variable A_plusId_timesAnnh : PlusIdentityIsTimesAnnihilator A.
   Variable B_plusId_timesAnnh : PlusIdentityIsTimesAnnihilator B.

   (* annihilators *)
   Definition Aw := eproj1 _ _ A_hasTimesAnnih.
   Definition Bw := eproj1 _ _ B_hasTimesAnnih.

   (* setoid = (A - {Aw}) x (B - {Bw}) *)
   Definition restricted_setoid :=
      prodDecSetoid
         (restrictedDecSetoid 
            (setoid A) 
            (fun x => Not (x == Aw)) 
            (A_notsingleton Aw)
         )
         (restrictedDecSetoid 
            (setoid B)
            (fun x => Not (x == Bw))
            (B_notsingleton Bw)
         ).

   (* setoid = (A - {Aw}) x (B - {Bw}) u (w) *)
   Definition ab_setoid :=
      addConstDecSetoid restricted_setoid.

   (* times annihilator *)
   Definition w := 
      const restricted_setoid.

   (* give order for elements of A *)
   Definition le (x y : A) : Prop := x + y == x.
   Notation "A <= B" := (le A B) (at level 70, no associativity) : type_scope.

   Inductive Comp (x y : carrier A) : Type :=
      | equiv : x <= y -> y <= x -> Comp x y
      | less : x <= y -> Not (y <= x) -> Comp x y
      | more : Not (x <= y) -> y <= x -> Comp x y.

   Definition comp : forall x y, Comp x y.
   Proof.
      intros.      
      assert (X := isDec A (x+y) x); destruct X;
      assert (X := isDec A (y+x) y); destruct X;
      [ constructor 1; unfold le; assumption
      | constructor 2; unfold le; assumption
      | constructor 3; unfold le; assumption
      | idtac
      ].
      unfold Not in *;
      assert (xy := A_comm x y); simpl in xy;
      assert (X := A_sel x y); simpl in X; destruct X. tauto.
      setoid_reason A; tauto.
   Defined.

   Definition InfA (x : A) := Dec (x == Aw).
   Definition InfB (x : B) := Dec (x == Bw).

   Definition infA : forall x, InfA x.
   Proof.
      intro.
      assert (X := isDec A x Aw). destruct X.
      constructor 1. assumption.
      constructor 2. assumption.
   Defined.

   Definition infB : forall x, InfB x.
   Proof.
      intro.
      assert (X := isDec B x Bw). destruct X.
      constructor 1. assumption.
      constructor 2. assumption.
   Defined.

   Theorem A_non_infgen : forall x y, x != Aw -> y != Aw -> x + y != Aw.
   Proof.
      intros x y p q.
      unfold PlusIdentityIsTimesAnnihilator in A_plusId_timesAnnh.
      destruct A_plusId_timesAnnh as [Aid [Aid_id Aid_annh]].
      assert (Aw == Aid).
         clear p q x y.
         assert (Aw_annh := eproj2 _ _ A_hasTimesAnnih). simpl in *.
         unfold Aw; simpl in *.
         match goal with |- ?x == _ => set (Aw2 := x) in * end.
         unfold 
            annihilator,
            left_annihilator,
            right_annihilator
         in Aid_annh, Aw_annh. simpl in *.
         destruct Aid_annh as [Aid_annhl Aid_annhr].
         destruct Aw_annh as [Aw_annhl Aw_annhr].
         assert (a := Aid_annhl Aw2).
         assert (b := Aw_annhr Aid).
         setoid_reason A.
         assumption.
      assert (x != Aid) as p2. 
         intro. setoid_reason A. auto.
      assert (y != Aid) as q2.
         intro. setoid_reason A. auto.
      assert (x + y != Aid).
         intro. 
         unfold identity, left_identity, right_identity in Aid_id. simpl in Aid_id.
         destruct Aid_id as [Aid_idl Aid_idr].
         assert (xx := refl _ _ (isEquivalence A) x).
         assert (H1 := op_pres_eq _ _ (isSemigroup (plusSemigroup A)) _ _ _ _ xx H0); simpl in H1.
         assert (H2 := Aid_idr x); simpl in H2.
         assert (H3 := assoc _ _ (isSemigroup (plusSemigroup A)) x x y); simpl in H3.
         assert (H4 := A_idem x); simpl in H4.
         assert (yy := refl _ _ (isEquivalence A) y).
         assert (H5 := op_pres_eq _ _ (isSemigroup (plusSemigroup A)) _ _ _ _ H4 yy); simpl in H5.
         setoid_reason A.
         auto.
      intro. setoid_reason A. auto.
   Defined.

   Theorem B_non_infgen : forall x y, x != Bw -> y != Bw -> x + y != Bw.
   Proof.
      intros x y p q.
      unfold PlusIdentityIsTimesAnnihilator in B_plusId_timesAnnh.
      destruct B_plusId_timesAnnh as [Bid [Bid_id Bid_annh]].
      assert (Bw == Bid).
         clear p q x y.
         assert (Bw_annh := eproj2 _ _ B_hasTimesAnnih). simpl in *.
         unfold Bw; simpl in *.
         match goal with |- ?x == _ => set (Bw2 := x) in * end.
         unfold 
            annihilator,
            left_annihilator,
            right_annihilator
         in Bid_annh, Bw_annh. simpl in *.
         destruct Bid_annh as [Bid_annhl Bid_annhr].
         destruct Bw_annh as [Bw_annhl Bw_annhr].
         assert (a := Bid_annhl Bw2).
         assert (b := Bw_annhr Bid).
         setoid_reason B.
         assumption.
      assert (x != Bid) as p2. 
         intro. setoid_reason B. auto.
      assert (y != Bid) as q2.
         intro. setoid_reason B. auto.
      assert (x + y != Bid).
         intro. 
         unfold identity, left_identity, right_identity in Bid_id. simpl in Bid_id.
         destruct Bid_id as [Bid_idl Bid_idr].
         assert (xx := refl _ _ (isEquivalence B) x).
         assert (H1 := op_pres_eq _ _ (isSemigroup (plusSemigroup B)) _ _ _ _ xx H0); simpl in H1.
         assert (H2 := Bid_idr x); simpl in H2.
         assert (H3 := assoc _ _ (isSemigroup (plusSemigroup B)) x x y); simpl in H3.
         assert (H4 := B_idem x); simpl in H4.
         assert (yy := refl _ _ (isEquivalence B) y).
         assert (H5 := op_pres_eq _ _ (isSemigroup (plusSemigroup B)) _ _ _ _ H4 yy); simpl in H5.
         setoid_reason B.
         auto.
      intro. setoid_reason B. auto.
   Defined.

   Definition ab_plus (x y : ab_setoid) : ab_setoid :=
      match x, y with
         | inj2 _, y => y
         | x, inj2 _ => x
         | inj1 (and (sigma x1 px1) (sigma x2 px2))
         , inj1 (and (sigma y1 py1) (sigma y2 py2)) =>
            match comp x1 y1 with
               | equiv _ _ => 
                        inj1 _ _ (and _ _ 
                              (sigma _ _ (x1 + y1) (A_non_infgen _ _ px1 py1)) 
                              (sigma _ _ (x2 + y2) (B_non_infgen _ _ px2 py2))
                           )
               | less _ _ => x
               | more _ _ => y
            end
      end.

   Definition ab_times (x y : ab_setoid) : ab_setoid :=
      match x, y with
         | inj2 _, _ => w
         | _, inj2 _ => w
         | inj1 (and (sigma x1 px1) (sigma x2 px2))
         , inj1 (and (sigma y1 py1) (sigma y2 py2)) =>      
            match infA (x1 * y1), infB (x2 * y2) with
               | yes _, _ => w
               | _, yes _ => w
               | no px1y1, no px2y2 =>
                  inj1 _ _ (and _ _ (sigma _ _ (x1 * y1) px1y1) (sigma _ _ (x2 * y2) px2y2))
            end
      end.

   Theorem le_trans : forall x y z, x <= y -> y <= z -> x <= z.
   Proof.
      unfold le.
      intros x y z p q.
      assert (xx := (refl _ _ (isEquivalence A)) x); simpl in xx.
      assert (r := op_pres_eq _ _ (isSemigroup (plusSemigroup A)) _ _ _ _ xx q); simpl in r. 
      assert (e := assoc _ _ (isSemigroup (plusSemigroup A)) x y z); simpl in e.
      assert (zz := refl _ _ (isEquivalence A) z); simpl in zz.
      assert (f := op_pres_eq _ _ (isSemigroup (plusSemigroup A)) _ _ _ _ p zz); simpl in f.
      setoid_reason A.
      assumption.
   Defined.

   Ltac le_tactics :=
      repeat match goal with
         | h1 : ?x <= ?y, h2 : ?y <= ?z |- _ =>
	    have (le x z);
            let t := fresh "t" in
            assert (t := le_trans _ _ _ h1 h2);
            simpl in t
      end.

   Theorem equiv_eq : forall x y, x <= y -> y <= x -> x == y.
   Proof.
      unfold le.
      intros x y p q.
      assert (r := A_comm x y).
      setoid_reason A.
      assumption.
   Defined.

   Ltac le_equiv :=
      repeat match goal with
         | h1 : ?x <= ?y, h2 : ?y <= ?x |- _ =>
            have (x == y);
            let e := fresh "e" in
            assert (e := equiv_eq x y h1 h2)
      end.

   Add Relation (carrier A) (eq A)
     reflexivity  proved by (refl _ _ (isEquivalence A))
     symmetry     proved by (sym _ _ (isEquivalence A))
     transitivity proved by (trans _ _ (isEquivalence A))
   as eqA.

   Add Morphism (plus A) with signature (eq A) ==> (eq A) ==> (eq A) as plusA.
   Proof.
      intros x y p z k q;
      apply (op_pres_eq _ _ (isSemigroup (plusSemigroup A)));
      assumption.
   Defined.

   Add Morphism (times A) with signature (eq A) ==> (eq A) ==> (eq A) as timesA.
   Proof.
      intros x y p z k q;
      apply (op_pres_eq _ _ (isSemigroup (timesSemigroup A)));
      assumption.
   Defined.

   Add Morphism (le) with signature (eq A) ==> (eq A) ==> iff as leA.
   Proof.
      intros x y p z k q.
      unfold le.
      red. 
      intuition; rewrite p, q in *; assumption.
   Defined.

   Add Relation (carrier B) (eq B)
     reflexivity  proved by (refl _ _ (isEquivalence B))
     symmetry     proved by (sym _ _ (isEquivalence B))
     transitivity proved by (trans _ _ (isEquivalence B))
   as eqB.

   Add Morphism (plus B) with signature (eq B) ==> (eq B) ==> (eq B) as plusB.
   Proof.
      intros x y p z k q;
      apply (op_pres_eq _ _ (isSemigroup (plusSemigroup B)));
      assumption.
   Defined.

   Add Morphism (times B) with signature (eq B) ==> (eq B) ==> (eq B) as timesB.
   Proof.
      intros x y p z k q;
      apply (op_pres_eq _ _ (isSemigroup (timesSemigroup B)));
      assumption.
   Defined.


   Theorem ab_plus_assoc : Associative _ ab_plus.
   Proof.
      red. intros x y z.
      unfold ab_plus.
      destruct x as [[[xa pxa] [xb pxb]] | xw];
      destruct y as [[[ya pya] [yb pyb]] | yw]; 
      destruct z as [[[za pza] [zb pzb]] | zw].
      destruct (comp xa ya);
      destruct (comp ya za).
      le_equiv.
      destruct (comp (xa + ya) za);
      destruct (comp xa (ya + za));
      simpl;
      unfold r_eq; simpl;
      try (
         unfold le, Not in *; rewrite e0, e1 in *; tauto
      );
      try (
        unfold le, Not in *; rewrite e0, e1 in *;
        assert (yy := A_idem ya); simpl in yy; rewrite yy in *; tauto
      );
      intuition;
      [apply (assoc _ _ (isSemigroup (plusSemigroup A)))
      |apply (assoc _ _ (isSemigroup (plusSemigroup B)))].
      
      le_equiv;
      destruct (comp (xa + ya) za);
      destruct (comp xa ya);
      unfold Not in *; try tauto;
      simpl; unfold r_eq; simpl;
      try (
         unfold le, Not in *; rewrite e, e0 in *;
         assert (yy := A_idem ya); simpl in yy; rewrite yy in *; tauto
      );
      intuition; setoid_reflexivity.
      
      le_equiv;
      destruct (comp (xa + ya) za);
      destruct (comp xa za);
      unfold Not in *; try tauto;
      simpl; unfold r_eq; simpl; 
      assert (yy := A_idem ya); simpl in yy;
      rewrite e, yy in *; try tauto.
      intuition.
      
      le_equiv;
      destruct (comp xa za);
      destruct (comp xa (ya + za));
      unfold Not in *; try tauto;
      simpl; unfold r_eq; simpl;
      assert (yy := A_idem ya); simpl in yy;
      rewrite e0, yy in *; try tauto.
      intuition.
            
      destruct (comp xa za);
      destruct (comp xa ya);
      le_tactics;
      unfold Not in *; try tauto.
      simpl; unfold r_eq; simpl; intuition.

      destruct (comp xa za); 
      simpl; unfold r_eq; simpl;
      intuition.

      destruct (comp xa (ya + za)); 
      simpl; unfold r_eq; simpl;
      le_equiv;
      unfold Not in *;
      assert (yy := A_idem ya); simpl in yy.
      rewrite e2, yy, e in *; tauto.
      rewrite e0, yy in *; tauto.
      intuition.

      destruct (comp xa ya);
      simpl; unfold r_eq; simpl;
      le_equiv; unfold Not in *; try tauto.
      intuition.

      destruct (comp xa za);
      simpl; unfold r_eq; simpl;
      le_equiv; unfold Not in *; le_tactics; try tauto.
      intuition.

      destruct (comp xa ya);
      simpl; unfold r_eq; simpl; intuition.

      destruct (comp xa za);
      simpl; unfold r_eq; simpl; intuition. 

      simpl; unfold r_eq; simpl; intuition.

      destruct (comp ya za);
      simpl; unfold r_eq; simpl; intuition.
      
      simpl; unfold r_eq; simpl; intuition.
      simpl; unfold r_eq; simpl; intuition.
      simpl; unfold r_eq; simpl; intuition.
   Defined.

   Theorem ab_plus_pres_eq : Preserves _ ab_plus (eq ab_setoid).
   Proof.
      red.
      intros x y u v p q.
      unfold ab_plus.

      assert (A_pres_eq := op_pres_eq _ _ (isSemigroup (plusSemigroup A))).
      assert (B_pres_eq := op_pres_eq _ _ (isSemigroup (plusSemigroup B))).
      red in A_pres_eq, B_pres_eq.
      simpl in A_pres_eq, B_pres_eq.

      destruct x as [[[xa pxa] [xb pxb]] | xw];
      destruct y as [[[ya pya] [yb pyb]] | yw]; 
      destruct u as [[[ua pua] [ub pub]] | uw];
      destruct v as [[[va pva] [vb pvb]] | vw];
      simpl in *; unfold r_eq in *; simpl in *; 
      try tauto.

      destruct p as [pa pb];
      destruct q as [qa qb];      
      destruct (comp xa ya);
      destruct (comp ua va);
      unfold Not in *;
      simpl; unfold r_eq; simpl; intuition;
      rewrite ?pa, ?pb, ?qa, ?qb in *; intuition.
   Defined.

   Theorem ab_times_assoc : Associative _ ab_times.
   Proof.
      red; intros x y z; unfold ab_times.
      destruct x as [[[xa pxa] [xb pxb]] | xw];
      destruct y as [[[ya pya] [yb pyb]] | yw]; 
      destruct z as [[[za pza] [zb pzb]] | zw];
      unfold w; simpl; unfold Unit.eq_unit; intuition.

      destruct (infA (xa * ya));
      destruct (infB (xb * yb));
      destruct (infA (ya * za));
      destruct (infB (yb * zb));
      unfold w; simpl;
      unfold Unit.eq_unit;
      intuition.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n1.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za).
      simpl in xyz.
      rewrite <- xyz.
      rewrite e.
      assert (paw := eproj2 _ _ A_hasTimesAnnih).
      unfold Aw in *.
      set (Aw2 := eproj1 _ _ A_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.
      
      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n2.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za).
      simpl in xyz.
      rewrite <- xyz.
      rewrite e.
      assert (paw := eproj2 _ _ A_hasTimesAnnih).
      unfold Aw in *.
      set (Aw2 := eproj1 _ _ A_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n3.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz.
      rewrite <- xyz.
      rewrite e.
      assert (paw := eproj2 _ _ B_hasTimesAnnih).
      unfold Bw in *.
      set (Bw2 := eproj1 _ _ B_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.

      destruct (infA (xa * ya * za));
      destruct (infB (xb * yb * zb));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n1.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za).
      simpl in xyz.
      rewrite xyz.
      rewrite e.
      assert (paw := eproj2 _ _ A_hasTimesAnnih).
      unfold Aw in *.
      set (Aw2 := eproj1 _ _ A_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.

      destruct (infA (xa * ya * za));
      destruct (infB (xb * yb * zb));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n2.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za).
      simpl in xyz.
      rewrite xyz.
      rewrite e.
      assert (paw := eproj2 _ _ A_hasTimesAnnih).
      unfold Aw in *.
      set (Aw2 := eproj1 _ _ A_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.

      destruct (infA (xa * ya * za));
      destruct (infB (xb * yb * zb));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n3.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz.
      rewrite xyz.
      rewrite e.
      assert (paw := eproj2 _ _ B_hasTimesAnnih).
      unfold Bw in *.
      set (Bw2 := eproj1 _ _ B_hasTimesAnnih) in *.
      unfold
         annihilator,
         left_annihilator,
         right_annihilator in paw.
      simpl in paw. intuition.

      destruct (infA (xa * ya * za));
      destruct (infB (xb * yb * zb));
      unfold w; simpl; unfold Unit.eq_unit; intuition.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.
      
      apply n4.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz.
      rewrite <- xyz.
      assumption.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.

      apply n4.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za);
      simpl in xyz; rewrite <- xyz.
      assumption.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.

      apply n5.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz; rewrite <- xyz.
      assumption.

      destruct (infA (xa * (ya * za)));
      destruct (infB (xb * (yb * zb)));
      unfold w; simpl; unfold Unit.eq_unit; intuition.

      apply n4.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz; rewrite xyz.
      assumption.

      apply n3.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup A)) xa ya za).
      simpl in xyz; rewrite xyz.
      assumption.

      apply n4.
      assert (xyz := assoc _ _ (isSemigroup (timesSemigroup B)) xb yb zb).
      simpl in xyz; rewrite xyz.
      assumption.

      unfold r_eq; simpl. apply (assoc _ _ (isSemigroup (timesSemigroup A))).
      unfold r_eq; simpl. apply (assoc _ _ (isSemigroup (timesSemigroup B))).
      
      destruct (infA (xa * ya));
      destruct (infB (xb * yb));
      simpl; try tauto.
   Defined.
   
   Theorem ab_times_pres_eq : Preserves _ ab_times (eq ab_setoid).
   Proof.
      red. intros x y u v p q.
      unfold ab_times.
      destruct x as [[[xa pxa] [xb pxb]] | xw];
      destruct y as [[[ya pya] [yb pyb]] | yw]; 
      destruct u as [[[ua pua] [ub pub]] | uw];
      destruct v as [[[va pva] [vb pvb]] | vw];
      simpl in *; unfold r_eq in *; simpl in *; 
      try tauto.
      
      destruct p as [pa pb];
      destruct q as [qa qb].
      
      destruct (infA (xa * ya));
      destruct (infB (xb * yb));
      destruct (infA (ua * va));
      destruct (infB (ub * vb));
      simpl;
      try constructor;
      unfold Not in *;
      rewrite ?pa, ?pb, ?qa, ?qb in *; try tauto.
      unfold r_eq; simpl; apply (op_pres_eq _ _ (isSemigroup (timesSemigroup A))); assumption.
      unfold r_eq; simpl; apply (op_pres_eq _ _ (isSemigroup (timesSemigroup B))); assumption.
   Defined.

   Definition absorbProdBisemigroup : Bisemigroup :=
      Build_Bisemigroup
         ab_setoid (* setoid *)
         ab_plus   (* plus *)
         ab_times  (* times *)
         (Build_IsSemigroup _ _
            ab_plus_assoc   (* assoc *)
            ab_plus_pres_eq (* op_pres_eq *)
         )(* isSemigroup_plus *)
         (Build_IsSemigroup _ _
            ab_times_assoc   (* assoc *)
            ab_times_pres_eq (* op_pres_eq *)
         )(* isSemigroup_times *).

   Theorem isLeftDistributive :
      IsLeftDistributive A
      -> IsLeftDistributive B
      -> (* B has w support - for a fixed c multiplication on 
            left either always gives w or never *)
      (forall a b c : B, a != Bw -> b != Bw -> c != Bw -> c * a == Bw -> c * b == Bw)
      -> (* B is left w-condenced *)
      (forall a b c : B, a != Bw -> b != Bw -> c != Bw -> c * a != Bw -> c * b != Bw -> c * a = c * b)
      -> IsLeftDistributive absorbProdBisemigroup.
   Proof.
      intro A_is_left_distributive.
      intro B_is_left_distributive.
      intro B_has_w_support.
      intro B_is_w_condenced.

      (* Aid = Aw - useful later *)
      destruct A_plusId_timesAnnh as [Aid [[Aidl Aidr] [Aidwl Aidwr]]].
      assert (Aw == Aid) as Aidw.
      assert (Aidwle := Aidwl Aw).
      assert (Awe := eproj2 _ _ A_hasTimesAnnih).
      simpl in Awe.
      destruct Awe as [Awl Awr].
      assert (Awre := Awr Aid).
      unfold Aw in *.
      simpl in *.
      rewrite <- Awre.
      tauto.

      (* Bid = Bw - useful later *)
      destruct B_plusId_timesAnnh as [Bid [[Bidl Bidr] [Bidwl Bidwr]]].
      assert (Bw == Bid) as Bidw.
      assert (Bidwle := Bidwl Bw).
      assert (Bwe := eproj2 _ _ B_hasTimesAnnih).
      simpl in Bwe.
      destruct Bwe as [Bwl Bwr].
      assert (Bwre := Bwr Bid).
      unfold Bw in *.
      simpl in *.
      rewrite <- Bwre.
      tauto.

      intros x y z.
      destruct x as [[[xa pxa] [xb pxb]] | xw];
      destruct y as [[[ya pya] [yb pyb]] | yw]; 
      destruct z as [[[za pza] [zb pzb]] | zw];
      simpl; try constructor.

      (* case 2 y = w *)
      Focus 2.
      destruct (infA (za * xa));
      destruct (infB (zb * xb));
      simpl; try constructor;
      unfold r_eq; simpl; intuition.
      
      (* case 3 x = w *)
      Focus 2.
      destruct (infA (za * ya));
      destruct (infB (zb * yb));
      simpl; try constructor;
      unfold r_eq; simpl; intuition.

      (* case 1 x,y,z != w *)
      destruct (comp xa ya).
      
      Focus 2.
      (* xa < ya *)
      destruct (infA (za * xa)) as [zxa_w | zxa_w];
      destruct (infB (zb * xb)) as [zxb_w | zxb_w];
      destruct (infA (za * ya)) as [zya_w | zya_w];
      destruct (infB (zb * yb)) as [zyb_w | zyb_w];
      simpl; try constructor;
      unfold r_eq; simpl; intuition.

      red in l.
      assert (za * (xa + ya) == za * xa).
      rewrite l. intuition.
      assert (ld_zxya := A_is_left_distributive xa ya za).
      rewrite H in ld_zxya.
      rewrite zxa_w in ld_zxya.
      rewrite Aidw in ld_zxya.
      assert (zy_id := Aidl (za * ya)). simpl in zy_id.
      rewrite zy_id in ld_zxya.
      rewrite <- Aidw in ld_zxya.
      unfold Not in zya_w.
      rewrite <- ld_zxya in zya_w.
      intuition.
      assert (za * (xa + ya) == za * xa).

      red in l.
      rewrite l. intuition.
      assert (ld_zxya := A_is_left_distributive xa ya za).
      rewrite H in ld_zxya.
      rewrite zxa_w in ld_zxya.
      rewrite Aidw in ld_zxya.
      assert (zy_id := Aidl (za * ya)). simpl in zy_id.
      rewrite zy_id in ld_zxya.
      rewrite <- Aidw in ld_zxya.
      unfold Not in zya_w.
      rewrite <- ld_zxya in zya_w.
      intuition.
      
      assert (Bwsup := B_has_w_support _ _ _ pxb pyb pzb zxb_w).
      intuition.
      
      destruct (comp (za * xa) (za * ya)); simpl in *; intuition.
      assert (zx_zy_eq := equiv_eq _ _ l0 l1).
      rewrite zx_zy_eq.
      assert (zyzy := (A_idem (za * ya))); simpl in zyzy.
      intuition.
      
      assert (w_cond := B_is_w_condenced _ _ _ pxb pyb pzb zxb_w zyb_w).
      rewrite w_cond.
      assert (zyzy := B_idem (zb * yb)); simpl in zyzy; intuition.

      red in l.
      assert (ld_zxya := A_is_left_distributive xa ya za).
      rewrite l in ld_zxya.
      unfold Not in n0.
      assert False.
      apply n0.
      red.
      intuition.
      tauto.
      
      red in l.
      assert (ld_zxya := A_is_left_distributive xa ya za).
      rewrite l in ld_zxya.
      unfold Not in n0.
      assert False.
      apply n0.
      red.
      intuition.
      tauto.
      (* end of case xa < ya *)

      Focus 2.
      (* ya < xa *)
      destruct (infA (za * xa)) as [zxa_w | zxa_w];
      destruct (infB (zb * xb)) as [zxb_w | zxb_w];
      destruct (infA (za * ya)) as [zya_w | zya_w];
      destruct (infB (zb * yb)) as [zyb_w | zyb_w];
      simpl; try constructor;
      unfold r_eq; simpl; intuition.

      red in l.
      assert (za * (ya + xa) == za * ya).
      rewrite l. intuition.
      assert (ld_zxya := A_is_left_distributive ya xa za).
      rewrite H in ld_zxya.
      rewrite zya_w in ld_zxya.
      rewrite Aidw in ld_zxya.
      assert (zy_id := Aidl (za * xa)). simpl in zy_id.
      rewrite zy_id in ld_zxya.
      rewrite <- Aidw in ld_zxya.
      unfold Not in zxa_w.
      rewrite <- ld_zxya in zxa_w.
      intuition.

      red in l.
      assert (za * (ya + xa) == za * ya).
      rewrite l. intuition.
      assert (ld_zxya := A_is_left_distributive ya xa za).
      rewrite H in ld_zxya.
      rewrite zya_w in ld_zxya.
      rewrite Aidw in ld_zxya.
      assert (zy_id := Aidl (za * xa)). simpl in zy_id.
      rewrite zy_id in ld_zxya.
      rewrite <- Aidw in ld_zxya.
      unfold Not in zxa_w.
      rewrite <- ld_zxya in zxa_w.
      intuition.
      
      assert (Bwsup := B_has_w_support _ _ _ pyb pxb pzb zyb_w).
      intuition.
      
      destruct (comp (za * xa) (za * ya)); simpl in *; intuition.
      assert (zx_zy_eq := equiv_eq _ _ l0 l1).
      rewrite zx_zy_eq.
      assert (zyzy := (A_idem (za * ya))); simpl in zyzy.
      intuition.
      
      assert (w_cond := B_is_w_condenced _ _ _ pxb pyb pzb zxb_w zyb_w).
      rewrite w_cond.
      assert (zyzy := B_idem (zb * yb)); simpl in zyzy; intuition.

      red in l.
      assert (ld_zxya := A_is_left_distributive ya xa za).
      rewrite l in ld_zxya.
      unfold Not in n0.
      assert False.
      apply n0.
      red.
      intuition.
      tauto.
      
      red in l.
      assert (ld_zxya := A_is_left_distributive ya xa za).
      rewrite l in ld_zxya.
      unfold Not in n0.
      assert False.
      apply n0.
      red.
      intuition.
      tauto.
      (* end of case ya < xa *)
      
      assert (xy := equiv_eq _ _ l l0).
      clear l l0.
      red.
      destruct (infA (za * (xa + ya))) as [zxya_w | zxya_w]; simpl.
      rewrite xy in zxya_w.
      assert (yy := A_idem ya); simpl in yy.
      rewrite yy in zxya_w.
      destruct (infA (za * ya)); simpl in *; intuition.
      destruct (infA (za * xa)); simpl in *; rewrite ?xy in *; intuition.
      constructor.
      destruct (infB (zb * xb)); simpl.
      constructor.
      rewrite <- xy in zxya_w; intuition.
      destruct (infA (za * xa)); simpl in *; rewrite ?xy in *; intuition.
      assert (ff := n e); tauto.
      assert (ff := n zxya_w); tauto.
      
      destruct (infB (zb * (xb + yb))) as [zxyb_w | zxyb_w]; simpl.
      unfold Not in zxya_w.
      rewrite xy in zxya_w.
      assert (yy := A_idem ya); simpl in yy.
      rewrite yy in zxya_w.
      destruct (infA (za * xa)) as [zxa_w | zxa_w]; simpl.
      rewrite xy in zxa_w; tauto.
      clear zxya_w yy.
      destruct (infA (za * ya)) as [zya_w | zya_w]; simpl.
      rewrite <- xy in zya_w; assert (ff := zxa_w zya_w); tauto.
      
      destruct (infB (zb * xb)) as [zxb_w | zxb_w];
      destruct (infB (zb * yb)) as [zyb_w | zyb_w]; simpl.
      constructor.

      assert (ldb := B_is_left_distributive xb yb zb).
      rewrite ldb in zxyb_w.
      rewrite zxb_w in zxyb_w.
      rewrite Bidw in zxyb_w.
      assert (zy_id := Bidl (zb * yb)). simpl in zy_id.
      rewrite zy_id in zxyb_w.
      rewrite <- Bidw in zxyb_w.
      assert (ff := zyb_w zxyb_w); tauto.

      assert (ldb := B_is_left_distributive xb yb zb).
      rewrite ldb in zxyb_w.
      rewrite zyb_w in zxyb_w.
      rewrite Bidw in zxyb_w.
      assert (zy_id := Bidr (zb * xb)). simpl in zy_id.
      rewrite zy_id in zxyb_w.
      rewrite <- Bidw in zxyb_w.
      assert (ff := zxb_w zxyb_w); tauto.
      
      assert (ldb := B_is_left_distributive xb yb zb).
      rewrite ldb in zxyb_w.
      clear ldb.
      rewrite Bidw in zxyb_w.
      set (zy := zb * yb) in *.
      set (zx := zb * xb) in *.
      assert (zx + zx + zy == zx + zy) as zxy_le_zx.
      assert (xx := B_idem zx). simpl in xx.
      rewrite xx. intuition.
      assert (asc_xxy := assoc _ _ (isSemigroup (plusSemigroup B)) zx zx zy); simpl in asc_xxy.
      rewrite asc_xxy, zxyb_w in zxy_le_zx.
      assert (idr := Bidr zx). simpl in idr.
      rewrite zxy_le_zx in idr.
      destruct (comp (za * xa) (za * ya));
      unfold Not in zxb_w; rewrite Bidw, idr in zxb_w; intuition.
      
      destruct (infA (za * xa)) as [zxa_w | zxa_w];
      destruct (infA (za * ya)) as [zya_w | zya_w];
      simpl.
      unfold Not in zxya_w; rewrite xy in zxya_w.
      assert (yy := A_idem ya); simpl in yy; rewrite yy in zxya_w. tauto.
      rewrite xy in zxa_w.
      unfold Not in zya_w. assert (ff := zya_w zxa_w); intuition.
      rewrite <- xy in zya_w.
      unfold Not in zxa_w. assert (ff := zxa_w zya_w); intuition.
      
      destruct (infB (zb * xb)) as [zxb_w | zxb_w]; 
      destruct (infB (zb * yb)) as [zyb_w | zyb_w]; 
      simpl.
      
      assert (ldb := B_is_left_distributive xb yb zb).
      unfold Not in zxyb_w.
      rewrite ldb in zxyb_w.
      rewrite zxb_w, zyb_w in zxyb_w.
      assert (ww := B_idem Bw). simpl in ww.
      tauto.
      
      unfold r_eq; simpl. intuition.
      assert (lda := A_is_left_distributive xa ya za); simpl in lda; rewrite lda.
      rewrite xy.
      apply A_idem.
      assert (ldb := B_is_left_distributive xb yb zb); simpl in ldb; rewrite ldb.
      rewrite zxb_w, Bidw.
      apply Bidl.
      
      unfold r_eq; simpl. intuition.
      assert (lda := A_is_left_distributive xa ya za); simpl in lda; rewrite lda.
      rewrite xy.
      apply A_idem.
      assert (ldb := B_is_left_distributive xb yb zb); simpl in ldb; rewrite ldb.
      rewrite zyb_w, Bidw.
      apply Bidr.
      
      unfold r_eq; simpl.
      destruct (comp (za * xa) (za * ya)); intuition; simpl.
      apply A_is_left_distributive.
      apply B_is_left_distributive.
      unfold Not in n.
      rewrite xy in l,n.
      tauto.
      unfold Not in n.
      rewrite xy in l,n.
      tauto.
      unfold Not in n.
      rewrite xy in l,n.
      tauto.
      unfold Not in n.
      rewrite xy in l,n.
      tauto.
   Defined.
      
   Theorem isLeftDistributive_comp :
      IsLeftDistributive_comp A
      \/ IsLeftDistributive_comp B
      \/ (* B has w support - for a fixed c multiplication on 
            left either always gives w or never *)
      (Exists a b c : B, a != Bw /\ b != Bw /\ c != Bw /\ c * a == Bw /\ c * b != Bw)
      \/ (* B is left w-condenced *)
      (Exists a b c : B, a != Bw /\ b != Bw /\ c != Bw /\ c * a != Bw /\ c * b != Bw /\ c * a != c * b)
      -> IsLeftDistributive_comp absorbProdBisemigroup.
   Proof.
      intros X.
      destruct X as 
             [A_is_left_distributive_comp |
             [B_is_left_distributive_comp | 
             [B_has_w_support_comp |
              B_is_left_w_condenced]]].

      (* Aid = Aw - useful later *)
      destruct A_plusId_timesAnnh as [Aid [[Aidl Aidr] [Aidwl Aidwr]]].
      assert (Aw == Aid) as Aidw.
      assert (Aidwle := Aidwl Aw).
      assert (Awe := eproj2 _ _ A_hasTimesAnnih).
      simpl in Awe.
      destruct Awe as [Awl Awr].
      assert (Awre := Awr Aid).
      unfold Aw in *.
      simpl in *.
      rewrite <- Awre.
      tauto.

      (* Bid = Bw - useful later *)
      destruct B_plusId_timesAnnh as [Bid [[Bidl Bidr] [Bidwl Bidwr]]].
      assert (Bw == Bid) as Bidw.
      assert (Bidwle := Bidwl Bw).
      assert (Bwe := eproj2 _ _ B_hasTimesAnnih).
      simpl in Bwe.
      destruct Bwe as [Bwl Bwr].
      assert (Bwre := Bwr Bid).
      unfold Bw in *.
      simpl in *.
      rewrite <- Bwre.
      tauto.

      red.
      destruct A_is_left_distributive_comp as [xa [ya [za p]]].
      assert (Bnw := B_notsingleton Bw).
      destruct Bnw as [Bnw Bwnp].
      unfold Not in p.
      
      (* xa != w *)
      destruct (infA xa) as [x_w | x_w]; simpl.
      rewrite x_w in p.
      rewrite Aidw in p.
      assert (y_id := Aidl ya); simpl in y_id; rewrite y_id in p.
      assert (y_w := Aidwr za); simpl in y_w; rewrite y_w in p.
      assert (zy_id := Aidl (za * ya)); simpl in zy_id; rewrite zy_id in p.
      assert (za * ya == za * ya); [intuition | tauto].
      
      (* ya != w *)
      destruct (infA ya) as [y_w | y_w]; simpl.
      rewrite y_w in p.
      rewrite Aidw in p.
      assert (x_id := Aidr xa); simpl in x_id; rewrite x_id in p.
      assert (z_w := Aidwr za); simpl in z_w; rewrite z_w in p.
      assert (zx_id := Aidr (za * xa)); simpl in zx_id; rewrite zx_id in p.
      assert (za * xa == za * xa); [intuition | tauto].

      (* za != w *)
      destruct (infA za) as [z_w | z_w]; simpl.
      rewrite z_w in p.
      rewrite Aidw in p.
      assert (z1 := Aidwl (xa + ya)); simpl in z1; rewrite z1 in p.
      assert (z2 := Aidwl xa); simpl in z2; rewrite z2 in p.
      assert (z3 := Aidwl ya); simpl in z3; rewrite z3 in p.
      assert (z4 := Aidl Aid); simpl in z4; rewrite z4 in p.
      assert (Aid == Aid); [intuition | tauto].

      Focus 1.

      elimExists (inj1 _ True (and _ _ (sigma _ (fun c => c != Aw) xa x_w) (sigma _ (fun c => c != Bw) Bnw Bwnp))).
      elimExists (inj1 _ True (and _ _ (sigma _ (fun c => c != Aw) ya y_w) (sigma _ (fun c => c != Bw) Bnw Bwnp))).
      elimExists (inj1 _ True (and _ _ (sigma _ (fun c => c != Aw) za z_w) (sigma _ (fun c => c != Bw) Bnw Bwnp))).
      simpl.
      unfold Not.

      destruct (infA (za * xa)) as [zxa_w | zxa_w];
      destruct (infA (za * ya)) as [zya_w | zya_w];
      simpl.
      
      assert (idid := A_idem Aid); simpl in idid. 
      rewrite zxa_w, zya_w, Aidw, idid in p. clear idid.
      
      destruct (comp xa ya).
      assert (xy := equiv_eq _ _ l l0).
      rewrite <- xy in p.
      assert (xx := A_idem xa); simpl in xx; rewrite xx, zxa_w, Aidw in p. intuition.
      
      destruct (infA (za * xa)); simpl; intuition.
      red in l.
      rewrite l, e, Aidw in p; intuition.
      
      destruct (infA (za * ya)); simpl; intuition.
      red in l.
      assert (yxxy := A_comm xa ya); simpl in yxxy; rewrite yxxy in p.
      rewrite l, e, Aidw in p; intuition.


      rewrite zxa_w, Aidw in p.
      assert (zy_id := Aidl (za * ya)); simpl in zy_id; rewrite zy_id in p.
      
      destruct (comp xa ya).
      assert (xy := equiv_eq _ _ l l0).
      assert (yy := A_idem ya); simpl in yy.
      rewrite xy, yy in p. intuition.
      
      red in l.
      rewrite l in p.
      destruct (infA (za * xa)); intuition.
      
      destruct (infB (Bnw * Bnw)) as [bb_w | bb_w].
      
      destruct (comp xa ya).
      assert (xy := equiv_eq _ _ l l0); clear l l0.
      assert (xa + ya == xa) as xyxa.
      rewrite xy.
      apply (A_idem).
      unfold Not.
      rewrite xyxa in p.
      rewrite <- xy in p.
      assert (zxzx := A_idem (za * xa)); simpl in zxzx; rewrite zxzx in p.
      assert (za * xa == za * xa); [intuition | tauto].
      
      red in l.
      rewrite l in p.
      destruct (infA (za * xa)) as [zxa_w | zxa_w];
      destruct (infA (za * ya)) as [zya_w | zya_w];
      simpl.
      rewrite zxa_w, zya_w, Aidw in p. assert (idid := A_idem Aid); simpl in idid. 
      assert (Aid == Aid + Aid); [intuition | tauto].
      rewrite zxa_w, Aidw in p. assert (zy_id := Aidl (za * ya)); simpl in zy_id.
      rewrite zy_id in p.
      unfold Not.
      destruct (infB (Bnw * Bnw)) as [bb_w | bb_w]; intuition.
      simpl in H.
      clear H zy_id zya_w.
      unfold Not in n.

      assert (xa + ya == ya -> False).
      intro xyy. apply n. red. assert (yxxy := A_comm xa ya); simpl in yxxy; rewrite <- yxxy. tauto.
      apply H.
      rewrite  l.



*)
