{
open Yacc_spec
}

rule token = parse
    [' ' '\t' '\n']        { token lexbuf }
  | ['0'-'9']+ as lxm      { INT (int_of_string lxm) }
  | '('                    { LPAREN }
  | ')'                    { RPAREN }
  | '='                    { EQUAL }
  | '+'                    { PLUS }
  | '*'                    { TIMES }
  | ','                    { COMMA }
  | ':'                    { COLON }
  | '!'                    { BANG }
  | ';'                    { SEMICOLON }
  | '['                    { LBRACKET }
  | ']'                    { RBRACKET }
  | '?'                    { QUESTION }
  | "<-"                   { GETS }
  | "()"                   { UNIT }
  | "in"                   { IN }
  | "inl"                  { INL }
  | "inr"                  { INR }
  | "true"                 { TRUE }
  | "false"                { FALSE }
  | "let"                  { LET }
  | eof                    { EOF }
  | ['A'-'Z' 'a'-'z'] ['A'-'Z' 'a'-'z' '0'-'9' '_' '.' '-'] * as id
                           { ID id }
