open Datatypes
open DecSetoid
open Semigroup
open Union

(** val ver_union_op :
    coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier **)

let ver_union_op a b x y =
  match Obj.magic x with
    | Coq_inl a0 ->
        (match Obj.magic y with
           | Coq_inl b0 -> Obj.magic (Coq_inl (b.op a0 b0))
           | Coq_inr c -> y)
    | Coq_inr a0 ->
        (match Obj.magic y with
           | Coq_inl c -> x
           | Coq_inr b0 -> Obj.magic (Coq_inr (a.op a0 b0)))

(** val unionSwapSemigroup :
    coq_Semigroup -> coq_Semigroup -> coq_Semigroup **)

let unionSwapSemigroup a b =
  { setoid = (unionDecSetoid b.setoid a.setoid); op = (ver_union_op a b) }

(** val unionDsIso : coq_Semigroup -> coq_Semigroup -> coq_DsIso **)

let unionDsIso a b =
  { phi = (fun x ->
    match Obj.magic x with
      | Coq_inl a0 -> Obj.magic (Coq_inr a0)
      | Coq_inr a0 -> Obj.magic (Coq_inl a0)); phi' = (fun x ->
    match Obj.magic x with
      | Coq_inl a0 -> Obj.magic (Coq_inr a0)
      | Coq_inr a0 -> Obj.magic (Coq_inl a0)) }

(** val unionSmgIso : coq_Semigroup -> coq_Semigroup -> coq_SmgIso **)

let unionSmgIso a b =
  { phi = (fun x ->
    match Obj.magic x with
      | Coq_inl a0 -> Obj.magic (Coq_inr a0)
      | Coq_inr a0 -> Obj.magic (Coq_inl a0)); phi' = (fun x ->
    match Obj.magic x with
      | Coq_inl a0 -> Obj.magic (Coq_inr a0)
      | Coq_inr a0 -> Obj.magic (Coq_inl a0)) }

