open Datatypes
open DecSetoid
open IdArrow
open Transform

(** val isoPres_helper :
    coq_Transform -> coq_Transform -> coq_Transform -> coq_Transform ->
    coq_IdDsIso -> coq_IdDsIso -> coq_TfIso -> coq_TfIso -> coq_DsIso **)

let isoPres_helper a b c d ab cd ac bd =
  let { setoid = setoid0; fn = x; app = x0 } = a in
  let { choose = chooseA; equal = equalA } = setoid0 in
  let { setoid = setoid1; fn = x1; app = x2 } = b in
  let { choose = chooseB; equal = equalB } = setoid1 in
  let { setoid = setoid2; fn = x3; app = x4 } = c in
  let { choose = chooseC; equal = equalC } = setoid2 in
  let { setoid = setoid3; fn = x5; app = x6 } = d in
  let { choose = chooseD; equal = equalD } = setoid3 in
  { phi = ac.dsIso.phi; phi' = ac.dsIso.phi' }

(** val isoPres_helper_fn :
    coq_Transform -> coq_Transform -> coq_Transform -> coq_Transform ->
    coq_IdDsIso -> coq_IdDsIso -> coq_TfIso -> coq_TfIso -> coq_DsIso **)

let isoPres_helper_fn a b c d ab cd ac bd =
  let { setoid = setoid0; fn = x; app = x0 } = a in
  let { choose = chooseA; equal = equalA } = setoid0 in
  let { setoid = setoid1; fn = x1; app = x2 } = b in
  let { choose = chooseB; equal = equalB } = setoid1 in
  let { setoid = setoid2; fn = x3; app = x4 } = c in
  let { choose = chooseC; equal = equalC } = setoid2 in
  let { setoid = setoid3; fn = x5; app = x6 } = d in
  let { choose = chooseD; equal = equalD } = setoid3 in
  { phi = (fun x7 ->
  match Obj.magic x7 with
    | Coq_inl x8 -> Obj.magic (Coq_inl (ac.fnIso.phi x8))
    | Coq_inr x8 -> Obj.magic (Coq_inr (bd.fnIso.phi x8))); phi' = (fun x7 ->
  match Obj.magic x7 with
    | Coq_inl x8 -> Obj.magic (Coq_inl (ac.fnIso.phi' x8))
    | Coq_inr x8 -> Obj.magic (Coq_inr (bd.fnIso.phi' x8))) }

(** val isoPres :
    coq_Transform -> coq_Transform -> coq_Transform -> coq_Transform ->
    coq_IdDsIso -> coq_IdDsIso -> coq_IdTfIso -> coq_IdTfIso -> coq_TfIso **)

let isoPres a b c d ab cd ac bd =
  let { setoid = setoid0; fn = x; app = x0 } = a in
  let { choose = chooseA; equal = equalA } = setoid0 in
  let { setoid = setoid1; fn = x1; app = x2 } = b in
  let { choose = chooseB; equal = equalB } = setoid1 in
  let { setoid = setoid2; fn = x3; app = x4 } = c in
  let { choose = chooseC; equal = equalC } = setoid2 in
  let { setoid = setoid3; fn = x5; app = x6 } = d in
  let { choose = chooseD; equal = equalD } = setoid3 in
  { dsIso =
  (isoPres_helper { setoid = { choose = chooseA; equal = equalA }; fn = x;
    app = x0 } { setoid = { choose = chooseB; equal = equalB }; fn = x1;
    app = x2 } { setoid = { choose = chooseC; equal = equalC }; fn = x3;
    app = x4 } { setoid = { choose = chooseD; equal = equalD }; fn = x5;
    app = x6 } ab cd ac bd); fnIso =
  (isoPres_helper_fn { setoid = { choose = chooseA; equal = equalA }; fn = x;
    app = x0 } { setoid = { choose = chooseB; equal = equalB }; fn = x1;
    app = x2 } { setoid = { choose = chooseC; equal = equalC }; fn = x3;
    app = x4 } { setoid = { choose = chooseD; equal = equalD }; fn = x5;
    app = x6 } ab cd ac bd) }

(** val idPres :
    coq_Transform -> coq_Transform -> coq_Transform -> coq_Transform ->
    coq_IdDsIso -> coq_IdDsIso -> coq_IdTfIso -> coq_IdTfIso -> coq_IdTfIso **)

let idPres a b c d ab cd ac bd =
  isoPres a b c d ab cd ac bd

