open Datatypes
open DecSetoid
open Specif
open Transform
open TransformProperties
open Union

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val union_app :
    coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier ->
    carrier) -> (carrier -> carrier -> carrier) -> carrier -> carrier ->
    carrier **)

let union_app d f g app_f app_g f0 x =
  match Obj.magic f0 with
    | Coq_inl f1 -> app_f f1 x
    | Coq_inr g0 -> app_g g0 x

(** val unionTransform_DsEq :
    coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier ->
    carrier) -> (carrier -> carrier -> carrier) -> coq_Transform **)

let unionTransform_DsEq d f g app_f app_g =
  { setoid = d; fn = (unionDecSetoid f g); app =
    (union_app d f g app_f app_g) }

(** val cancelative_comp :
    coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier ->
    carrier) -> (carrier -> carrier -> carrier) -> (coq_Cancelative_comp,
    coq_Cancelative_comp) sum -> coq_Cancelative_comp **)

let cancelative_comp d f g app_f app_g = function
  | Coq_inl c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f0, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (
      (Obj.magic (Coq_inl f0)), __)))))
  | Coq_inr c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f0, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (
      (Obj.magic (Coq_inr f0)), __)))))

(** val condensed_comp :
    coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier ->
    carrier) -> (carrier -> carrier -> carrier) -> (coq_Condensed_comp,
    coq_Condensed_comp) sum -> coq_Condensed_comp **)

let condensed_comp d f g app_f app_g = function
  | Coq_inl c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f0, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (
      (Obj.magic (Coq_inl f0)), __)))))
  | Coq_inr c ->
      let Coq_existT (x0, s) = c in
      let Coq_existT (y, s0) = s in
      let Coq_existT (f0, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (
      (Obj.magic (Coq_inr f0)), __)))))

(** val identity_comp :
    coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier ->
    carrier) -> (carrier -> carrier -> carrier) -> (coq_Identity_comp,
    coq_Identity_comp) sum -> coq_Identity_comp **)

let identity_comp d f g app_f app_g = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (f0, _) = s in
      Coq_existT (x0, (Coq_existT ((Obj.magic (Coq_inl f0)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (f0, _) = s in
      Coq_existT (x0, (Coq_existT ((Obj.magic (Coq_inr f0)), __)))

(** val unionTransform :
    coq_Transform -> coq_Transform -> coq_DsIso -> coq_Transform **)

let unionTransform a b f =
  let { setoid = setoidA; fn = fnA; app = appA } = a in
  let { setoid = setoidB; fn = fnB; app = appB } = b in
  unionTransform_DsEq { setoid = setoidA; fn = fnA; app = appA }.setoid fnA
    fnB appA (fun l x -> f.phi' (appB l (f.phi x)))

