open Datatypes
open DecSetoid
open DecSetoidProperties
open Semigroup
open SemigroupProperties
open Specif
open Union

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val ver_union_op :
    coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier **)

let ver_union_op a b x y =
  match Obj.magic x with
    | Coq_inl a0 ->
        (match Obj.magic y with
           | Coq_inl b0 -> Obj.magic (Coq_inl (a.op a0 b0))
           | Coq_inr c -> x)
    | Coq_inr a0 ->
        (match Obj.magic y with
           | Coq_inl c -> y
           | Coq_inr b0 -> Obj.magic (Coq_inr (b.op a0 b0)))

(** val unionSemigroup : coq_Semigroup -> coq_Semigroup -> coq_Semigroup **)

let unionSemigroup a b =
  { setoid = (unionDecSetoid a.setoid b.setoid); op = (ver_union_op a b) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsIdempotent_comp,
    coq_IsIdempotent_comp) sum -> coq_IsIdempotent_comp **)

let isIdempotent_comp a b = function
  | Coq_inl i ->
      let Coq_existT (a0, _) = i in Coq_existT ((Obj.magic (Coq_inl a0)), __)
  | Coq_inr i ->
      let Coq_existT (b0, _) = i in Coq_existT ((Obj.magic (Coq_inr b0)), __)

(** val isSelective_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSelective_comp,
    coq_IsSelective_comp) sum -> coq_IsSelective_comp **)

let isSelective_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), __)))

(** val isCommutative_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsCommutative_comp,
    coq_IsCommutative_comp) sum -> coq_IsCommutative_comp **)

let isCommutative_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), __)))
  | Coq_inr i ->
      let Coq_existT (x0, s) = i in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inr x0)), (Coq_existT
      ((Obj.magic (Coq_inr y)), __)))

(** val hasIdentity :
    coq_Semigroup -> coq_Semigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasIdentity a b = function
  | Coq_existT (b0, _) -> Coq_existT ((Obj.magic (Coq_inr b0)), __)

(** val hasIdentity_comp :
    coq_Semigroup -> coq_Semigroup -> coq_HasIdentity_comp ->
    coq_HasIdentity_comp **)

let hasIdentity_comp a b eb i =
  match Obj.magic i with
    | Coq_inl x -> Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), __)
    | Coq_inr x ->
        let Coq_existT (y, _) = eb x in
        Coq_existT ((Obj.magic (Coq_inr y)), __)

(** val hasAnnihilator :
    coq_Semigroup -> coq_Semigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasAnnihilator a b = function
  | Coq_existT (na, _) -> Coq_existT ((Obj.magic (Coq_inl na)), __)

(** val hasAnnihilator_comp :
    coq_Semigroup -> coq_Semigroup -> coq_HasAnnihilator_comp ->
    coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a b na w =
  match Obj.magic w with
    | Coq_inl x ->
        let Coq_existT (y, _) = na x in
        Coq_existT ((Obj.magic (Coq_inl y)), __)
    | Coq_inr x -> Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), __)

(** val isLeft_comp : coq_Semigroup -> coq_Semigroup -> coq_IsLeft_comp **)

let isLeft_comp a b =
  Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))

(** val isRight_comp : coq_Semigroup -> coq_Semigroup -> coq_IsRight_comp **)

let isRight_comp a b =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr b.setoid.choose)), __)))

(** val leftCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> coq_LeftCondensed_comp **)

let leftCondensed_comp a b =
  Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val rightCondensed_comp :
    coq_Semigroup -> coq_Semigroup -> coq_RightCondensed_comp **)

let rightCondensed_comp a b =
  Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val leftCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> ((coq_LeftCancelative_comp,
    coq_AntiLeft_comp) sum, coq_IsSingleton_comp) sum ->
    coq_LeftCancelative_comp **)

let leftCancelative_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl l ->
             let Coq_existT (x0, s0) = l in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
             ((Obj.magic (Coq_inl y)), (Coq_existT (
             (Obj.magic (Coq_inl z)), __)))))
         | Coq_inr a0 ->
             let Coq_existT (x0, s0) = a0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (Coq_inl y)), (Coq_existT
             ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl x0)), __))))))
  | Coq_inr sg ->
      let Coq_existT (b0, _) = sg b.setoid.choose in
      Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
      ((Obj.magic (Coq_inr b0)), (Coq_existT
      ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_Semigroup -> ((coq_RightCancelative_comp,
    coq_AntiRight_comp) sum, coq_IsSingleton_comp) sum ->
    coq_RightCancelative_comp **)

let rightCancelative_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl r ->
             let Coq_existT (x0, s0) = r in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, _) = s1 in
             Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
             ((Obj.magic (Coq_inl y)), (Coq_existT (
             (Obj.magic (Coq_inl z)), __)))))
         | Coq_inr a0 ->
             let Coq_existT (x0, s0) = a0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
             ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl y)), __))))))
  | Coq_inr sg ->
      let Coq_existT (b0, _) = sg b.setoid.choose in
      Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
      ((Obj.magic (Coq_inr b0)), (Coq_existT
      ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val antiRight_comp :
    coq_Semigroup -> coq_Semigroup -> coq_AntiRight_comp **)

let antiRight_comp a b =
  Coq_existT ((Obj.magic (Coq_inr b.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))

(** val antiLeft_comp :
    coq_Semigroup -> coq_Semigroup -> coq_AntiLeft_comp **)

let antiLeft_comp a b =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr b.setoid.choose)), __)))

(** val treeGlb_comp :
    coq_Semigroup -> coq_Semigroup -> (coq_IsSelective_comp,
    coq_TreeGlb_comp) sum -> (carrier, (carrier, (carrier, __) sigT) sigT)
    sigT **)

let treeGlb_comp a b = function
  | Coq_inl i ->
      let Coq_existT (x1, s) = i in
      let Coq_existT (y1, _) = s in
      Coq_existT ((Obj.magic (Coq_inl x1)), (Coq_existT
      ((Obj.magic (Coq_inl y1)), (Coq_existT
      ((Obj.magic (Coq_inr b.setoid.choose)), __)))))
  | Coq_inr tb ->
      let Coq_existT (x2, s) = tb __ __ in
      let Coq_existT (y2, s0) = s in
      let Coq_existT (z2, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inr x2)), (Coq_existT
      ((Obj.magic (Coq_inr y2)), (Coq_existT ((Obj.magic (Coq_inr z2)),
      __)))))

