open DecSetoid
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_Transform = { setoid : coq_DecSetoid; fn : 
                       coq_DecSetoid; app : (carrier -> carrier -> carrier) }

(** val coq_Transform_rect :
    (coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier -> carrier) -> __
    -> 'a1) -> coq_Transform -> 'a1 **)

let coq_Transform_rect f t =
  let { setoid = x; fn = x0; app = x1 } = t in f x x0 x1 __

(** val coq_Transform_rec :
    (coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier -> carrier) -> __
    -> 'a1) -> coq_Transform -> 'a1 **)

let coq_Transform_rec f t =
  let { setoid = x; fn = x0; app = x1 } = t in f x x0 x1 __

(** val setoid : coq_Transform -> coq_DecSetoid **)

let setoid x = x.setoid

(** val fn : coq_Transform -> coq_DecSetoid **)

let fn x = x.fn

(** val app : coq_Transform -> carrier -> carrier -> carrier **)

let app x = x.app

(** val coq_IsTfIso_rect :
    coq_Transform -> coq_Transform -> coq_DsIso -> coq_DsIso -> (__ -> __ ->
    'a1) -> 'a1 **)

let coq_IsTfIso_rect t t' dsIso0 fnIso0 f =
  f __ __

(** val coq_IsTfIso_rec :
    coq_Transform -> coq_Transform -> coq_DsIso -> coq_DsIso -> (__ -> __ ->
    'a1) -> 'a1 **)

let coq_IsTfIso_rec t t' dsIso0 fnIso0 f =
  f __ __

type coq_TfIso = { dsIso : coq_DsIso; fnIso : coq_DsIso }

(** val coq_TfIso_rect :
    coq_Transform -> coq_Transform -> (coq_DsIso -> coq_DsIso -> __ -> 'a1)
    -> coq_TfIso -> 'a1 **)

let coq_TfIso_rect t t' f t0 =
  let { dsIso = x; fnIso = x0 } = t0 in f x x0 __

(** val coq_TfIso_rec :
    coq_Transform -> coq_Transform -> (coq_DsIso -> coq_DsIso -> __ -> 'a1)
    -> coq_TfIso -> 'a1 **)

let coq_TfIso_rec t t' f t0 =
  let { dsIso = x; fnIso = x0 } = t0 in f x x0 __

(** val dsIso : coq_Transform -> coq_Transform -> coq_TfIso -> coq_DsIso **)

let dsIso _ _ x = x.dsIso

(** val fnIso : coq_Transform -> coq_Transform -> coq_TfIso -> coq_DsIso **)

let fnIso _ _ x = x.fnIso

(** val coq_TfIso_refl : coq_Transform -> coq_TfIso **)

let coq_TfIso_refl t =
  { dsIso = { phi = (fun x -> x); phi' = (fun x -> x) }; fnIso = { phi =
    (fun x -> x); phi' = (fun x -> x) } }

(** val coq_TfIso_sym :
    coq_Transform -> coq_Transform -> coq_TfIso -> coq_TfIso **)

let coq_TfIso_sym t t' i =
  { dsIso =
    (let dsIso0 = i.dsIso in { phi = dsIso0.phi'; phi' = dsIso0.phi });
    fnIso =
    (let dsIso0 = i.fnIso in { phi = dsIso0.phi'; phi' = dsIso0.phi }) }

(** val coq_TfIso_trans :
    coq_Transform -> coq_Transform -> coq_Transform -> coq_TfIso -> coq_TfIso
    -> coq_TfIso **)

let coq_TfIso_trans t t' t'' i i' =
  { dsIso = (coq_DsIso_trans t.setoid t'.setoid t''.setoid i.dsIso i'.dsIso);
    fnIso = (coq_DsIso_trans t.fn t'.fn t''.fn i.fnIso i'.fnIso) }

(** val liftTfIso :
    coq_DecSetoid -> coq_Transform -> coq_DsIso -> (coq_Transform, coq_TfIso
    * __) sigT **)

let liftTfIso a b iso =
  Coq_existT ({ setoid = a; fn = b.fn; app = (fun f x ->
    iso.phi' (b.app f (iso.phi x))) }, ({ dsIso = { phi = iso.phi; phi' =
    iso.phi' }; fnIso = { phi = (fun x -> x); phi' = (fun x -> x) } } , __))

