open BigTuples
open Datatypes
open EqNat

type __ = Obj.t

type coq_DS =
  | Coq_dAddConstant of coq_DS
  | Coq_dBool
  | Coq_dNat
  | Coq_dProduct of coq_DS * coq_DS
  | Coq_dRange of nat
  | Coq_dUnion of coq_DS * coq_DS
  | Coq_dUnit
  | Coq_dFSets of coq_DS
  | Coq_dFMinSets of coq_PO
  | Coq_dSeq of coq_DS
  | Coq_dSimpleSeq of coq_DS
  | Coq_dMultiSets of coq_DS
and coq_SG =
  | Coq_sBoolAnd
  | Coq_sBoolOr
  | Coq_sNatMax
  | Coq_sNatMin
  | Coq_sNatPlus
  | Coq_sLex of coq_SG * coq_SG
  | Coq_sProduct of coq_SG * coq_SG
  | Coq_sRangeMax of nat
  | Coq_sRangeMin of nat
  | Coq_sRangePlus of nat
  | Coq_sTopUnion of coq_SG * coq_SG
  | Coq_sUnion of coq_SG * coq_SG
  | Coq_sUnionSwap of coq_SG * coq_SG
  | Coq_sUnit
  | Coq_sFSetsIntersect of coq_DS
  | Coq_sFSetsUnion of coq_DS
  | Coq_sFSetsOp of coq_SG
  | Coq_sFMinSetsUnion of coq_PO
  | Coq_sFMinSetsOp of coq_OS
  | Coq_sLeft of coq_DS
  | Coq_sRight of coq_DS
  | Coq_sSelLex of coq_SG * coq_SG
  | Coq_sSeq of coq_DS
  | Coq_sSimpleSeq of coq_DS
  | Coq_sPrefix of coq_DS
  | Coq_sPostfix of coq_DS
  | Coq_sRevOp of coq_SG
  | Coq_sMultiSetsUnion of coq_DS
  | Coq_sMultiSetsIntersect of coq_DS
and coq_PO =
  | Coq_pDual of coq_PO
  | Coq_pLeftNaturalOrder of coq_SG
  | Coq_pRightNaturalOrder of coq_SG
  | Coq_pLex of coq_PO * coq_PO
  | Coq_pNatLe
  | Coq_pAnnTop of coq_SG
and coq_OS =
  | Coq_oDual of coq_OS
  | Coq_oLeftNaturalOrder of coq_SG
  | Coq_oRightNaturalOrder of coq_SG
  | Coq_oLex of coq_OS * coq_OS
  | Coq_oBsLeftNaturalOrder of coq_BS
  | Coq_oSimpleSeq of coq_DS
and coq_BS =
  | Coq_bUnit
  | Coq_bBoolOrAnd
  | Coq_bNatMaxPlus
  | Coq_bNatMinPlus
  | Coq_bNatMaxMin
  | Coq_bNatIMaxPlus
  | Coq_bNatIMinPlus
  | Coq_bNatIMaxMin
  | Coq_bRangeMaxPlus of nat
  | Coq_bRangeMinPlus of nat
  | Coq_bRangeMaxMin of nat
  | Coq_bSwap of coq_BS
  | Coq_bFMinSets of coq_OS
  | Coq_bFMinSetsOpUnion of coq_OS
  | Coq_bFSets of coq_DS
  | Coq_bFSetsOp of coq_SG
  | Coq_bLex of coq_BS * coq_BS
  | Coq_bProduct of coq_BS * coq_BS
  | Coq_bLeft of coq_SG
  | Coq_bAddZero of coq_BS
  | Coq_bAddOne of coq_BS
  | Coq_bSelLex of coq_BS * coq_BS
  | Coq_bRevTimes of coq_BS
  | Coq_bPrefixSeq of coq_DS
  | Coq_bPostfixSeq of coq_DS
  | Coq_bMultiSets of coq_DS
and coq_TF =
  | Coq_tId of coq_DS
  | Coq_tReplace of coq_DS
  | Coq_tProduct of coq_TF * coq_TF
  | Coq_tUnion of coq_TF * coq_TF
  | Coq_tCayley of coq_SG
and coq_ST =
  | Coq_stLeft of coq_SG
  | Coq_stRight of coq_SG
  | Coq_stLex of coq_ST * coq_ST
  | Coq_stSelLex of coq_ST * coq_ST
  | Coq_stUnion of coq_ST * coq_ST
  | Coq_stCayley of coq_BS

val coq_DS_rect :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_DS -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> coq_DS -> 'a1

val coq_DS_rec :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_DS -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> coq_DS -> 'a1

val coq_SG_rect :
  'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1)
  -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (nat -> 'a1) -> (nat -> 'a1)
  -> (nat -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG ->
  'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) ->
  'a1 -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> 'a1) ->
  (coq_PO -> 'a1) -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) ->
  (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS ->
  'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_SG -> 'a1

val coq_SG_rec :
  'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1)
  -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (nat -> 'a1) -> (nat -> 'a1)
  -> (nat -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG ->
  'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) ->
  'a1 -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> 'a1) ->
  (coq_PO -> 'a1) -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) ->
  (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS ->
  'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_SG -> 'a1

val coq_PO_rect :
  (coq_PO -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO ->
  'a1 -> coq_PO -> 'a1 -> 'a1) -> 'a1 -> (coq_SG -> 'a1) -> coq_PO -> 'a1

val coq_PO_rec :
  (coq_PO -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO ->
  'a1 -> coq_PO -> 'a1 -> 'a1) -> 'a1 -> (coq_SG -> 'a1) -> coq_PO -> 'a1

val coq_OS_rect :
  (coq_OS -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_OS ->
  'a1 -> coq_OS -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> (coq_DS -> 'a1) ->
  coq_OS -> 'a1

val coq_OS_rec :
  (coq_OS -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_OS ->
  'a1 -> coq_OS -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> (coq_DS -> 'a1) ->
  coq_OS -> 'a1

val coq_BS_rect :
  'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (nat -> 'a1) ->
  (nat -> 'a1) -> (nat -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_OS -> 'a1)
  -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_BS -> 'a1
  -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) ->
  (coq_SG -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
  (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_BS -> 'a1

val coq_BS_rec :
  'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (nat -> 'a1) ->
  (nat -> 'a1) -> (nat -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_OS -> 'a1)
  -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_BS -> 'a1
  -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) ->
  (coq_SG -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
  (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_BS -> 'a1

val coq_TF_rect :
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 ->
  'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 -> 'a1) -> (coq_SG -> 'a1) ->
  coq_TF -> 'a1

val coq_TF_rec :
  (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 ->
  'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 -> 'a1) -> (coq_SG -> 'a1) ->
  coq_TF -> 'a1

val coq_ST_rect :
  (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 ->
  'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 -> 'a1) -> (coq_ST -> 'a1 -> coq_ST
  -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> coq_ST -> 'a1

val coq_ST_rec :
  (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 ->
  'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 -> 'a1) -> (coq_ST -> 'a1 -> coq_ST
  -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> coq_ST -> 'a1

val coq_Syntax_ind : __ -> ret_type

val coq_ST_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_ST -> 'a7

val coq_TF_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_TF -> 'a6

val coq_BS_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_BS -> 'a5

val coq_OS_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_OS -> 'a4

val coq_PO_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_PO -> 'a3

val coq_SG_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_SG -> 'a2

val coq_DS_rect2 :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> coq_DS -> 'a1

val coq_Syntax_rect :
  (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1 ->
  'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1 ->
  (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 -> 'a1)
  -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 -> 'a2 ->
  'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
  coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) ->
  (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
  -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2 -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_PO ->
  'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1
  -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
  'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS
  -> 'a1 -> 'a2) -> (coq_PO -> 'a3 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_PO -> 'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 ->
  (coq_SG -> 'a2 -> 'a3) -> (coq_OS -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4)
  -> (coq_SG -> 'a2 -> 'a4) -> (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) ->
  (coq_BS -> 'a5 -> 'a4) -> (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 ->
  'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat ->
  'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4
  -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS ->
  'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) ->
  (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5)
  -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) ->
  (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5)
  -> (coq_DS -> 'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 ->
  coq_TF -> 'a6 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG
  -> 'a2 -> 'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) ->
  (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7
  -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 ->
  'a7) -> ret_type

type coq_Lang =
  | Coq_dsInc of coq_DS
  | Coq_sgInc of coq_SG
  | Coq_poInc of coq_PO
  | Coq_osInc of coq_OS
  | Coq_bsInc of coq_BS
  | Coq_tfInc of coq_TF
  | Coq_stInc of coq_ST

val coq_Lang_rect :
  (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1) ->
  (coq_BS -> 'a1) -> (coq_TF -> 'a1) -> (coq_ST -> 'a1) -> coq_Lang -> 'a1

val coq_Lang_rec :
  (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1) ->
  (coq_BS -> 'a1) -> (coq_TF -> 'a1) -> (coq_ST -> 'a1) -> coq_Lang -> 'a1

val coq_OS_PO : coq_OS -> coq_PO

val coq_OS_SG : coq_OS -> coq_SG

val coq_SG_DS : coq_SG -> coq_DS

val coq_PO_DS : coq_PO -> coq_DS

val coq_BS_SG_plus : coq_BS -> coq_SG

val coq_BS_SG_times : coq_BS -> coq_SG

val coq_ST_TF : coq_ST -> coq_TF

val coq_ST_SG : coq_ST -> coq_SG

val coq_TF_DS : coq_TF -> coq_DS

val fn_TF_DS : coq_TF -> coq_DS

val eq_DS : coq_DS -> coq_DS -> bool

val eq_SG : coq_SG -> coq_SG -> bool

val eq_PO : coq_PO -> coq_PO -> bool

val eq_OS : coq_OS -> coq_OS -> bool

val eq_BS : coq_BS -> coq_BS -> bool

val eq_TF : coq_TF -> coq_TF -> bool

val eq_ST : coq_ST -> coq_ST -> bool

