open BigTuples
open Datatypes
open EqNat

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_DS =
  | Coq_dAddConstant of coq_DS
  | Coq_dBool
  | Coq_dNat
  | Coq_dProduct of coq_DS * coq_DS
  | Coq_dRange of nat
  | Coq_dUnion of coq_DS * coq_DS
  | Coq_dUnit
  | Coq_dFSets of coq_DS
  | Coq_dFMinSets of coq_PO
  | Coq_dSeq of coq_DS
  | Coq_dSimpleSeq of coq_DS
  | Coq_dMultiSets of coq_DS
and coq_SG =
  | Coq_sBoolAnd
  | Coq_sBoolOr
  | Coq_sNatMax
  | Coq_sNatMin
  | Coq_sNatPlus
  | Coq_sLex of coq_SG * coq_SG
  | Coq_sProduct of coq_SG * coq_SG
  | Coq_sRangeMax of nat
  | Coq_sRangeMin of nat
  | Coq_sRangePlus of nat
  | Coq_sTopUnion of coq_SG * coq_SG
  | Coq_sUnion of coq_SG * coq_SG
  | Coq_sUnionSwap of coq_SG * coq_SG
  | Coq_sUnit
  | Coq_sFSetsIntersect of coq_DS
  | Coq_sFSetsUnion of coq_DS
  | Coq_sFSetsOp of coq_SG
  | Coq_sFMinSetsUnion of coq_PO
  | Coq_sFMinSetsOp of coq_OS
  | Coq_sLeft of coq_DS
  | Coq_sRight of coq_DS
  | Coq_sSelLex of coq_SG * coq_SG
  | Coq_sSeq of coq_DS
  | Coq_sSimpleSeq of coq_DS
  | Coq_sPrefix of coq_DS
  | Coq_sPostfix of coq_DS
  | Coq_sRevOp of coq_SG
  | Coq_sMultiSetsUnion of coq_DS
  | Coq_sMultiSetsIntersect of coq_DS
and coq_PO =
  | Coq_pDual of coq_PO
  | Coq_pLeftNaturalOrder of coq_SG
  | Coq_pRightNaturalOrder of coq_SG
  | Coq_pLex of coq_PO * coq_PO
  | Coq_pNatLe
  | Coq_pAnnTop of coq_SG
and coq_OS =
  | Coq_oDual of coq_OS
  | Coq_oLeftNaturalOrder of coq_SG
  | Coq_oRightNaturalOrder of coq_SG
  | Coq_oLex of coq_OS * coq_OS
  | Coq_oBsLeftNaturalOrder of coq_BS
  | Coq_oSimpleSeq of coq_DS
and coq_BS =
  | Coq_bUnit
  | Coq_bBoolOrAnd
  | Coq_bNatMaxPlus
  | Coq_bNatMinPlus
  | Coq_bNatMaxMin
  | Coq_bNatIMaxPlus
  | Coq_bNatIMinPlus
  | Coq_bNatIMaxMin
  | Coq_bRangeMaxPlus of nat
  | Coq_bRangeMinPlus of nat
  | Coq_bRangeMaxMin of nat
  | Coq_bSwap of coq_BS
  | Coq_bFMinSets of coq_OS
  | Coq_bFMinSetsOpUnion of coq_OS
  | Coq_bFSets of coq_DS
  | Coq_bFSetsOp of coq_SG
  | Coq_bLex of coq_BS * coq_BS
  | Coq_bProduct of coq_BS * coq_BS
  | Coq_bLeft of coq_SG
  | Coq_bAddZero of coq_BS
  | Coq_bAddOne of coq_BS
  | Coq_bSelLex of coq_BS * coq_BS
  | Coq_bRevTimes of coq_BS
  | Coq_bPrefixSeq of coq_DS
  | Coq_bPostfixSeq of coq_DS
  | Coq_bMultiSets of coq_DS
and coq_TF =
  | Coq_tId of coq_DS
  | Coq_tReplace of coq_DS
  | Coq_tProduct of coq_TF * coq_TF
  | Coq_tUnion of coq_TF * coq_TF
  | Coq_tCayley of coq_SG
and coq_ST =
  | Coq_stLeft of coq_SG
  | Coq_stRight of coq_SG
  | Coq_stLex of coq_ST * coq_ST
  | Coq_stSelLex of coq_ST * coq_ST
  | Coq_stUnion of coq_ST * coq_ST
  | Coq_stCayley of coq_BS

(** val coq_DS_rect :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_DS -> 'a1 -> 'a1) ->
    (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> coq_DS -> 'a1 **)

let rec coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 = function
  | Coq_dAddConstant d0 ->
      f d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dBool -> f0
  | Coq_dNat -> f1
  | Coq_dProduct (d0, d1) ->
      f2 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0) d1
        (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d1)
  | Coq_dRange n -> f3 n
  | Coq_dUnion (d0, d1) ->
      f4 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0) d1
        (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d1)
  | Coq_dUnit -> f5
  | Coq_dFSets d0 ->
      f6 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dFMinSets p -> f7 p
  | Coq_dSeq d0 -> f8 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dSimpleSeq d0 ->
      f9 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dMultiSets d0 ->
      f10 d0 (coq_DS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)

(** val coq_DS_rec :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_DS -> 'a1 -> 'a1) ->
    (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> coq_DS -> 'a1 **)

let rec coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 = function
  | Coq_dAddConstant d0 ->
      f d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dBool -> f0
  | Coq_dNat -> f1
  | Coq_dProduct (d0, d1) ->
      f2 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0) d1
        (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d1)
  | Coq_dRange n -> f3 n
  | Coq_dUnion (d0, d1) ->
      f4 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0) d1
        (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d1)
  | Coq_dUnit -> f5
  | Coq_dFSets d0 ->
      f6 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dFMinSets p -> f7 p
  | Coq_dSeq d0 -> f8 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dSimpleSeq d0 ->
      f9 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)
  | Coq_dMultiSets d0 ->
      f10 d0 (coq_DS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 d0)

(** val coq_SG_rect :
    'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (coq_SG -> 'a1 -> coq_SG -> 'a1 ->
    'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (nat -> 'a1) -> (nat
    -> 'a1) -> (nat -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) ->
    (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG -> 'a1 -> coq_SG ->
    'a1 -> 'a1) -> 'a1 -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG ->
    'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) ->
    (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_DS ->
    'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG
    -> 'a1 -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_SG -> 'a1 **)

let rec coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 = function
  | Coq_sBoolAnd -> f
  | Coq_sBoolOr -> f0
  | Coq_sNatMax -> f1
  | Coq_sNatMin -> f2
  | Coq_sNatPlus -> f3
  | Coq_sLex (s0, s1) ->
      f4 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sProduct (s0, s1) ->
      f5 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sRangeMax n -> f6 n
  | Coq_sRangeMin n -> f7 n
  | Coq_sRangePlus n -> f8 n
  | Coq_sTopUnion (s0, s1) ->
      f9 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnion (s0, s1) ->
      f10 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnionSwap (s0, s1) ->
      f11 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnit -> f12
  | Coq_sFSetsIntersect d -> f13 d
  | Coq_sFSetsUnion d -> f14 d
  | Coq_sFSetsOp s0 ->
      f15 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0)
  | Coq_sFMinSetsUnion p -> f16 p
  | Coq_sFMinSetsOp o -> f17 o
  | Coq_sLeft d -> f18 d
  | Coq_sRight d -> f19 d
  | Coq_sSelLex (s0, s1) ->
      f20 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sSeq d -> f21 d
  | Coq_sSimpleSeq d -> f22 d
  | Coq_sPrefix d -> f23 d
  | Coq_sPostfix d -> f24 d
  | Coq_sRevOp s0 ->
      f25 s0
        (coq_SG_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0)
  | Coq_sMultiSetsUnion d -> f26 d
  | Coq_sMultiSetsIntersect d -> f27 d

(** val coq_SG_rec :
    'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (coq_SG -> 'a1 -> coq_SG -> 'a1 ->
    'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (nat -> 'a1) -> (nat
    -> 'a1) -> (nat -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) ->
    (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_SG -> 'a1 -> coq_SG ->
    'a1 -> 'a1) -> 'a1 -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG ->
    'a1 -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) ->
    (coq_DS -> 'a1) -> (coq_SG -> 'a1 -> coq_SG -> 'a1 -> 'a1) -> (coq_DS ->
    'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG
    -> 'a1 -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_SG -> 'a1 **)

let rec coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 = function
  | Coq_sBoolAnd -> f
  | Coq_sBoolOr -> f0
  | Coq_sNatMax -> f1
  | Coq_sNatMin -> f2
  | Coq_sNatPlus -> f3
  | Coq_sLex (s0, s1) ->
      f4 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sProduct (s0, s1) ->
      f5 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sRangeMax n -> f6 n
  | Coq_sRangeMin n -> f7 n
  | Coq_sRangePlus n -> f8 n
  | Coq_sTopUnion (s0, s1) ->
      f9 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnion (s0, s1) ->
      f10 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnionSwap (s0, s1) ->
      f11 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sUnit -> f12
  | Coq_sFSetsIntersect d -> f13 d
  | Coq_sFSetsUnion d -> f14 d
  | Coq_sFSetsOp s0 ->
      f15 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0)
  | Coq_sFMinSetsUnion p -> f16 p
  | Coq_sFMinSetsOp o -> f17 o
  | Coq_sLeft d -> f18 d
  | Coq_sRight d -> f19 d
  | Coq_sSelLex (s0, s1) ->
      f20 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0) s1
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s1)
  | Coq_sSeq d -> f21 d
  | Coq_sSimpleSeq d -> f22 d
  | Coq_sPrefix d -> f23 d
  | Coq_sPostfix d -> f24 d
  | Coq_sRevOp s0 ->
      f25 s0
        (coq_SG_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 s0)
  | Coq_sMultiSetsUnion d -> f26 d
  | Coq_sMultiSetsIntersect d -> f27 d

(** val coq_PO_rect :
    (coq_PO -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO
    -> 'a1 -> coq_PO -> 'a1 -> 'a1) -> 'a1 -> (coq_SG -> 'a1) -> coq_PO ->
    'a1 **)

let rec coq_PO_rect f f0 f1 f2 f3 f4 = function
  | Coq_pDual p0 -> f p0 (coq_PO_rect f f0 f1 f2 f3 f4 p0)
  | Coq_pLeftNaturalOrder s -> f0 s
  | Coq_pRightNaturalOrder s -> f1 s
  | Coq_pLex (p0, p1) ->
      f2 p0 (coq_PO_rect f f0 f1 f2 f3 f4 p0) p1
        (coq_PO_rect f f0 f1 f2 f3 f4 p1)
  | Coq_pNatLe -> f3
  | Coq_pAnnTop s -> f4 s

(** val coq_PO_rec :
    (coq_PO -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO
    -> 'a1 -> coq_PO -> 'a1 -> 'a1) -> 'a1 -> (coq_SG -> 'a1) -> coq_PO ->
    'a1 **)

let rec coq_PO_rec f f0 f1 f2 f3 f4 = function
  | Coq_pDual p0 -> f p0 (coq_PO_rec f f0 f1 f2 f3 f4 p0)
  | Coq_pLeftNaturalOrder s -> f0 s
  | Coq_pRightNaturalOrder s -> f1 s
  | Coq_pLex (p0, p1) ->
      f2 p0 (coq_PO_rec f f0 f1 f2 f3 f4 p0) p1
        (coq_PO_rec f f0 f1 f2 f3 f4 p1)
  | Coq_pNatLe -> f3
  | Coq_pAnnTop s -> f4 s

(** val coq_OS_rect :
    (coq_OS -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_OS
    -> 'a1 -> coq_OS -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> (coq_DS -> 'a1) ->
    coq_OS -> 'a1 **)

let rec coq_OS_rect f f0 f1 f2 f3 f4 = function
  | Coq_oDual o0 -> f o0 (coq_OS_rect f f0 f1 f2 f3 f4 o0)
  | Coq_oLeftNaturalOrder s -> f0 s
  | Coq_oRightNaturalOrder s -> f1 s
  | Coq_oLex (o0, o1) ->
      f2 o0 (coq_OS_rect f f0 f1 f2 f3 f4 o0) o1
        (coq_OS_rect f f0 f1 f2 f3 f4 o1)
  | Coq_oBsLeftNaturalOrder b -> f3 b
  | Coq_oSimpleSeq d -> f4 d

(** val coq_OS_rec :
    (coq_OS -> 'a1 -> 'a1) -> (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_OS
    -> 'a1 -> coq_OS -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> (coq_DS -> 'a1) ->
    coq_OS -> 'a1 **)

let rec coq_OS_rec f f0 f1 f2 f3 f4 = function
  | Coq_oDual o0 -> f o0 (coq_OS_rec f f0 f1 f2 f3 f4 o0)
  | Coq_oLeftNaturalOrder s -> f0 s
  | Coq_oRightNaturalOrder s -> f1 s
  | Coq_oLex (o0, o1) ->
      f2 o0 (coq_OS_rec f f0 f1 f2 f3 f4 o0) o1
        (coq_OS_rec f f0 f1 f2 f3 f4 o1)
  | Coq_oBsLeftNaturalOrder b -> f3 b
  | Coq_oSimpleSeq d -> f4 d

(** val coq_BS_rect :
    'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (nat -> 'a1) ->
    (nat -> 'a1) -> (nat -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_OS -> 'a1)
    -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_BS ->
    'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1)
    -> (coq_SG -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
    (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
    (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_BS -> 'a1 **)

let rec coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 = function
  | Coq_bUnit -> f
  | Coq_bBoolOrAnd -> f0
  | Coq_bNatMaxPlus -> f1
  | Coq_bNatMinPlus -> f2
  | Coq_bNatMaxMin -> f3
  | Coq_bNatIMaxPlus -> f4
  | Coq_bNatIMinPlus -> f5
  | Coq_bNatIMaxMin -> f6
  | Coq_bRangeMaxPlus n -> f7 n
  | Coq_bRangeMinPlus n -> f8 n
  | Coq_bRangeMaxMin n -> f9 n
  | Coq_bSwap b0 ->
      f10 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bFMinSets o -> f11 o
  | Coq_bFMinSetsOpUnion o -> f12 o
  | Coq_bFSets d -> f13 d
  | Coq_bFSetsOp s -> f14 s
  | Coq_bLex (b0, b1) ->
      f15 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bProduct (b0, b1) ->
      f16 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bLeft s -> f17 s
  | Coq_bAddZero b0 ->
      f18 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bAddOne b0 ->
      f19 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bSelLex (b0, b1) ->
      f20 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bRevTimes b0 ->
      f21 b0
        (coq_BS_rect f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bPrefixSeq d -> f22 d
  | Coq_bPostfixSeq d -> f23 d
  | Coq_bMultiSets d -> f24 d

(** val coq_BS_rec :
    'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> (nat -> 'a1) ->
    (nat -> 'a1) -> (nat -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_OS -> 'a1)
    -> (coq_OS -> 'a1) -> (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_BS ->
    'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1)
    -> (coq_SG -> 'a1) -> (coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
    (coq_BS -> 'a1 -> coq_BS -> 'a1 -> 'a1) -> (coq_BS -> 'a1 -> 'a1) ->
    (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> coq_BS -> 'a1 **)

let rec coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 = function
  | Coq_bUnit -> f
  | Coq_bBoolOrAnd -> f0
  | Coq_bNatMaxPlus -> f1
  | Coq_bNatMinPlus -> f2
  | Coq_bNatMaxMin -> f3
  | Coq_bNatIMaxPlus -> f4
  | Coq_bNatIMinPlus -> f5
  | Coq_bNatIMaxMin -> f6
  | Coq_bRangeMaxPlus n -> f7 n
  | Coq_bRangeMinPlus n -> f8 n
  | Coq_bRangeMaxMin n -> f9 n
  | Coq_bSwap b0 ->
      f10 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bFMinSets o -> f11 o
  | Coq_bFMinSetsOpUnion o -> f12 o
  | Coq_bFSets d -> f13 d
  | Coq_bFSetsOp s -> f14 s
  | Coq_bLex (b0, b1) ->
      f15 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bProduct (b0, b1) ->
      f16 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bLeft s -> f17 s
  | Coq_bAddZero b0 ->
      f18 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bAddOne b0 ->
      f19 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bSelLex (b0, b1) ->
      f20 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0) b1
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b1)
  | Coq_bRevTimes b0 ->
      f21 b0
        (coq_BS_rec f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15
          f16 f17 f18 f19 f20 f21 f22 f23 f24 b0)
  | Coq_bPrefixSeq d -> f22 d
  | Coq_bPostfixSeq d -> f23 d
  | Coq_bMultiSets d -> f24 d

(** val coq_TF_rect :
    (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 ->
    'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 -> 'a1) -> (coq_SG -> 'a1) ->
    coq_TF -> 'a1 **)

let rec coq_TF_rect f f0 f1 f2 f3 = function
  | Coq_tId d -> f d
  | Coq_tReplace d -> f0 d
  | Coq_tProduct (t0, t1) ->
      f1 t0 (coq_TF_rect f f0 f1 f2 f3 t0) t1 (coq_TF_rect f f0 f1 f2 f3 t1)
  | Coq_tUnion (t0, t1) ->
      f2 t0 (coq_TF_rect f f0 f1 f2 f3 t0) t1 (coq_TF_rect f f0 f1 f2 f3 t1)
  | Coq_tCayley s -> f3 s

(** val coq_TF_rec :
    (coq_DS -> 'a1) -> (coq_DS -> 'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 ->
    'a1) -> (coq_TF -> 'a1 -> coq_TF -> 'a1 -> 'a1) -> (coq_SG -> 'a1) ->
    coq_TF -> 'a1 **)

let rec coq_TF_rec f f0 f1 f2 f3 = function
  | Coq_tId d -> f d
  | Coq_tReplace d -> f0 d
  | Coq_tProduct (t0, t1) ->
      f1 t0 (coq_TF_rec f f0 f1 f2 f3 t0) t1 (coq_TF_rec f f0 f1 f2 f3 t1)
  | Coq_tUnion (t0, t1) ->
      f2 t0 (coq_TF_rec f f0 f1 f2 f3 t0) t1 (coq_TF_rec f f0 f1 f2 f3 t1)
  | Coq_tCayley s -> f3 s

(** val coq_ST_rect :
    (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 ->
    'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 -> 'a1) -> (coq_ST -> 'a1 ->
    coq_ST -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> coq_ST -> 'a1 **)

let rec coq_ST_rect f f0 f1 f2 f3 f4 = function
  | Coq_stLeft s0 -> f s0
  | Coq_stRight s0 -> f0 s0
  | Coq_stLex (s0, s1) ->
      f1 s0 (coq_ST_rect f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rect f f0 f1 f2 f3 f4 s1)
  | Coq_stSelLex (s0, s1) ->
      f2 s0 (coq_ST_rect f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rect f f0 f1 f2 f3 f4 s1)
  | Coq_stUnion (s0, s1) ->
      f3 s0 (coq_ST_rect f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rect f f0 f1 f2 f3 f4 s1)
  | Coq_stCayley b -> f4 b

(** val coq_ST_rec :
    (coq_SG -> 'a1) -> (coq_SG -> 'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 ->
    'a1) -> (coq_ST -> 'a1 -> coq_ST -> 'a1 -> 'a1) -> (coq_ST -> 'a1 ->
    coq_ST -> 'a1 -> 'a1) -> (coq_BS -> 'a1) -> coq_ST -> 'a1 **)

let rec coq_ST_rec f f0 f1 f2 f3 f4 = function
  | Coq_stLeft s0 -> f s0
  | Coq_stRight s0 -> f0 s0
  | Coq_stLex (s0, s1) ->
      f1 s0 (coq_ST_rec f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rec f f0 f1 f2 f3 f4 s1)
  | Coq_stSelLex (s0, s1) ->
      f2 s0 (coq_ST_rec f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rec f f0 f1 f2 f3 f4 s1)
  | Coq_stUnion (s0, s1) ->
      f3 s0 (coq_ST_rec f f0 f1 f2 f3 f4 s0) s1
        (coq_ST_rec f f0 f1 f2 f3 f4 s1)
  | Coq_stCayley b -> f4 b

(** val coq_Syntax_ind : __ -> ret_type **)

let coq_Syntax_ind _ =
  pair7_90 (Obj.magic __) (Obj.magic __) (Obj.magic __) 
    (Obj.magic __) (Obj.magic __) (Obj.magic __) (Obj.magic __) __ __ __ __
    __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __
    __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __
    __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __ __
    __ __ __ __ __ __ __ __ __ __ __ __ __ __

(** val coq_ST_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_ST -> 'a7 **)

let coq_ST_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 s =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s1, s2) -> f16 s1 (f90 s1) s2 (f90 s2)
    | Coq_sProduct (s1, s2) -> f17 s1 (f90 s1) s2 (f90 s2)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s1, s2) -> f21 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnion (s1, s2) -> f22 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnionSwap (s1, s2) -> f23 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s1 -> f27 s1 (f90 s1)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s1, s2) -> f32 s1 (f90 s1) s2 (f90 s2)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s1 -> f37 s1 (f90 s1)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s0 -> f41 s0 (f90 s0)
    | Coq_pRightNaturalOrder s0 -> f42 s0 (f90 s0)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s0 -> f45 s0 (f90 s0)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s0 -> f47 s0 (f90 s0)
    | Coq_oRightNaturalOrder s0 -> f48 s0 (f90 s0)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s0 -> f67 s0 (f90 s0)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s0 -> f70 s0 (f90 s0)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s0 -> f82 s0 (f90 s0)
  and f95 = function
    | Coq_stLeft s1 -> f83 s1 (f90 s1)
    | Coq_stRight s1 -> f84 s1 (f90 s1)
    | Coq_stLex (s1, s2) -> f85 s1 (f95 s1) s2 (f95 s2)
    | Coq_stSelLex (s1, s2) -> f86 s1 (f95 s1) s2 (f95 s2)
    | Coq_stUnion (s1, s2) -> f87 s1 (f95 s1) s2 (f95 s2)
    | Coq_stCayley b -> f88 b (f93 b)
  in f95 s

(** val coq_TF_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_TF -> 'a6 **)

let coq_TF_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 t =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s0, s1) -> f16 s0 (f90 s0) s1 (f90 s1)
    | Coq_sProduct (s0, s1) -> f17 s0 (f90 s0) s1 (f90 s1)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s0, s1) -> f21 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnion (s0, s1) -> f22 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnionSwap (s0, s1) -> f23 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s0 -> f27 s0 (f90 s0)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s0, s1) -> f32 s0 (f90 s0) s1 (f90 s1)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s0 -> f37 s0 (f90 s0)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s -> f41 s (f90 s)
    | Coq_pRightNaturalOrder s -> f42 s (f90 s)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s -> f45 s (f90 s)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s -> f47 s (f90 s)
    | Coq_oRightNaturalOrder s -> f48 s (f90 s)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s -> f67 s (f90 s)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s -> f70 s (f90 s)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t1, t2) -> f80 t1 (f94 t1) t2 (f94 t2)
    | Coq_tUnion (t1, t2) -> f81 t1 (f94 t1) t2 (f94 t2)
    | Coq_tCayley s -> f82 s (f90 s)
  and f95 = function
    | Coq_stLeft s0 -> f83 s0 (f90 s0)
    | Coq_stRight s0 -> f84 s0 (f90 s0)
    | Coq_stLex (s0, s1) -> f85 s0 (f95 s0) s1 (f95 s1)
    | Coq_stSelLex (s0, s1) -> f86 s0 (f95 s0) s1 (f95 s1)
    | Coq_stUnion (s0, s1) -> f87 s0 (f95 s0) s1 (f95 s1)
    | Coq_stCayley b -> f88 b (f93 b)
  in f94 t

(** val coq_BS_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_BS -> 'a5 **)

let coq_BS_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 b =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s0, s1) -> f16 s0 (f90 s0) s1 (f90 s1)
    | Coq_sProduct (s0, s1) -> f17 s0 (f90 s0) s1 (f90 s1)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s0, s1) -> f21 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnion (s0, s1) -> f22 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnionSwap (s0, s1) -> f23 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s0 -> f27 s0 (f90 s0)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s0, s1) -> f32 s0 (f90 s0) s1 (f90 s1)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s0 -> f37 s0 (f90 s0)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s -> f41 s (f90 s)
    | Coq_pRightNaturalOrder s -> f42 s (f90 s)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s -> f45 s (f90 s)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s -> f47 s (f90 s)
    | Coq_oRightNaturalOrder s -> f48 s (f90 s)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b0 -> f50 b0 (f93 b0)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b1 -> f63 b1 (f93 b1)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s -> f67 s (f90 s)
    | Coq_bLex (b1, b2) -> f68 b1 (f93 b1) b2 (f93 b2)
    | Coq_bProduct (b1, b2) -> f69 b1 (f93 b1) b2 (f93 b2)
    | Coq_bLeft s -> f70 s (f90 s)
    | Coq_bAddZero b1 -> f71 b1 (f93 b1)
    | Coq_bAddOne b1 -> f72 b1 (f93 b1)
    | Coq_bSelLex (b1, b2) -> f73 b1 (f93 b1) b2 (f93 b2)
    | Coq_bRevTimes b1 -> f74 b1 (f93 b1)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s -> f82 s (f90 s)
  and f95 = function
    | Coq_stLeft s0 -> f83 s0 (f90 s0)
    | Coq_stRight s0 -> f84 s0 (f90 s0)
    | Coq_stLex (s0, s1) -> f85 s0 (f95 s0) s1 (f95 s1)
    | Coq_stSelLex (s0, s1) -> f86 s0 (f95 s0) s1 (f95 s1)
    | Coq_stUnion (s0, s1) -> f87 s0 (f95 s0) s1 (f95 s1)
    | Coq_stCayley b0 -> f88 b0 (f93 b0)
  in f93 b

(** val coq_OS_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_OS -> 'a4 **)

let coq_OS_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 o =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s0, s1) -> f16 s0 (f90 s0) s1 (f90 s1)
    | Coq_sProduct (s0, s1) -> f17 s0 (f90 s0) s1 (f90 s1)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s0, s1) -> f21 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnion (s0, s1) -> f22 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnionSwap (s0, s1) -> f23 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s0 -> f27 s0 (f90 s0)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o0 -> f29 o0 (f92 o0)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s0, s1) -> f32 s0 (f90 s0) s1 (f90 s1)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s0 -> f37 s0 (f90 s0)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s -> f41 s (f90 s)
    | Coq_pRightNaturalOrder s -> f42 s (f90 s)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s -> f45 s (f90 s)
  and f92 = function
    | Coq_oDual o1 -> f46 o1 (f92 o1)
    | Coq_oLeftNaturalOrder s -> f47 s (f90 s)
    | Coq_oRightNaturalOrder s -> f48 s (f90 s)
    | Coq_oLex (o1, o2) -> f49 o1 (f92 o1) o2 (f92 o2)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o0 -> f64 o0 (f92 o0)
    | Coq_bFMinSetsOpUnion o0 -> f65 o0 (f92 o0)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s -> f67 s (f90 s)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s -> f70 s (f90 s)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s -> f82 s (f90 s)
  and f95 = function
    | Coq_stLeft s0 -> f83 s0 (f90 s0)
    | Coq_stRight s0 -> f84 s0 (f90 s0)
    | Coq_stLex (s0, s1) -> f85 s0 (f95 s0) s1 (f95 s1)
    | Coq_stSelLex (s0, s1) -> f86 s0 (f95 s0) s1 (f95 s1)
    | Coq_stUnion (s0, s1) -> f87 s0 (f95 s0) s1 (f95 s1)
    | Coq_stCayley b -> f88 b (f93 b)
  in f92 o

(** val coq_PO_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_PO -> 'a3 **)

let coq_PO_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 p =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p0 -> f7 p0 (f91 p0)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s0, s1) -> f16 s0 (f90 s0) s1 (f90 s1)
    | Coq_sProduct (s0, s1) -> f17 s0 (f90 s0) s1 (f90 s1)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s0, s1) -> f21 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnion (s0, s1) -> f22 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnionSwap (s0, s1) -> f23 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s0 -> f27 s0 (f90 s0)
    | Coq_sFMinSetsUnion p0 -> f28 p0 (f91 p0)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s0, s1) -> f32 s0 (f90 s0) s1 (f90 s1)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s0 -> f37 s0 (f90 s0)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p1 -> f40 p1 (f91 p1)
    | Coq_pLeftNaturalOrder s -> f41 s (f90 s)
    | Coq_pRightNaturalOrder s -> f42 s (f90 s)
    | Coq_pLex (p1, p2) -> f43 p1 (f91 p1) p2 (f91 p2)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s -> f45 s (f90 s)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s -> f47 s (f90 s)
    | Coq_oRightNaturalOrder s -> f48 s (f90 s)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s -> f67 s (f90 s)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s -> f70 s (f90 s)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s -> f82 s (f90 s)
  and f95 = function
    | Coq_stLeft s0 -> f83 s0 (f90 s0)
    | Coq_stRight s0 -> f84 s0 (f90 s0)
    | Coq_stLex (s0, s1) -> f85 s0 (f95 s0) s1 (f95 s1)
    | Coq_stSelLex (s0, s1) -> f86 s0 (f95 s0) s1 (f95 s1)
    | Coq_stUnion (s0, s1) -> f87 s0 (f95 s0) s1 (f95 s1)
    | Coq_stCayley b -> f88 b (f93 b)
  in f91 p

(** val coq_SG_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_SG -> 'a2 **)

let coq_SG_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 s =
  let rec f89 = function
    | Coq_dAddConstant d0 -> f d0 (f89 d0)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d0, d1) -> f2 d0 (f89 d0) d1 (f89 d1)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d0, d1) -> f4 d0 (f89 d0) d1 (f89 d1)
    | Coq_dUnit -> f5
    | Coq_dFSets d0 -> f6 d0 (f89 d0)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d0 -> f8 d0 (f89 d0)
    | Coq_dSimpleSeq d0 -> f9 d0 (f89 d0)
    | Coq_dMultiSets d0 -> f10 d0 (f89 d0)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s1, s2) -> f16 s1 (f90 s1) s2 (f90 s2)
    | Coq_sProduct (s1, s2) -> f17 s1 (f90 s1) s2 (f90 s2)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s1, s2) -> f21 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnion (s1, s2) -> f22 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnionSwap (s1, s2) -> f23 s1 (f90 s1) s2 (f90 s2)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d -> f25 d (f89 d)
    | Coq_sFSetsUnion d -> f26 d (f89 d)
    | Coq_sFSetsOp s1 -> f27 s1 (f90 s1)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d -> f30 d (f89 d)
    | Coq_sRight d -> f31 d (f89 d)
    | Coq_sSelLex (s1, s2) -> f32 s1 (f90 s1) s2 (f90 s2)
    | Coq_sSeq d -> f33 d (f89 d)
    | Coq_sSimpleSeq d -> f34 d (f89 d)
    | Coq_sPrefix d -> f35 d (f89 d)
    | Coq_sPostfix d -> f36 d (f89 d)
    | Coq_sRevOp s1 -> f37 s1 (f90 s1)
    | Coq_sMultiSetsUnion d -> f38 d (f89 d)
    | Coq_sMultiSetsIntersect d -> f39 d (f89 d)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s0 -> f41 s0 (f90 s0)
    | Coq_pRightNaturalOrder s0 -> f42 s0 (f90 s0)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s0 -> f45 s0 (f90 s0)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s0 -> f47 s0 (f90 s0)
    | Coq_oRightNaturalOrder s0 -> f48 s0 (f90 s0)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d -> f51 d (f89 d)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d -> f66 d (f89 d)
    | Coq_bFSetsOp s0 -> f67 s0 (f90 s0)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s0 -> f70 s0 (f90 s0)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d -> f75 d (f89 d)
    | Coq_bPostfixSeq d -> f76 d (f89 d)
    | Coq_bMultiSets d -> f77 d (f89 d)
  and f94 = function
    | Coq_tId d -> f78 d (f89 d)
    | Coq_tReplace d -> f79 d (f89 d)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s0 -> f82 s0 (f90 s0)
  and f95 = function
    | Coq_stLeft s1 -> f83 s1 (f90 s1)
    | Coq_stRight s1 -> f84 s1 (f90 s1)
    | Coq_stLex (s1, s2) -> f85 s1 (f95 s1) s2 (f95 s2)
    | Coq_stSelLex (s1, s2) -> f86 s1 (f95 s1) s2 (f95 s2)
    | Coq_stUnion (s1, s2) -> f87 s1 (f95 s1) s2 (f95 s2)
    | Coq_stCayley b -> f88 b (f93 b)
  in f90 s

(** val coq_DS_rect2 :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    coq_DS -> 'a1 **)

let coq_DS_rect2 f f0 f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12 f13 f14 f15 f16 f17 f18 f19 f20 f21 f22 f23 f24 f25 f26 f27 f28 f29 f30 f31 f32 f33 f34 f35 f36 f37 f38 f39 f40 f41 f42 f43 f44 f45 f46 f47 f48 f49 f50 f51 f52 f53 f54 f55 f56 f57 f58 f59 f60 f61 f62 f63 f64 f65 f66 f67 f68 f69 f70 f71 f72 f73 f74 f75 f76 f77 f78 f79 f80 f81 f82 f83 f84 f85 f86 f87 f88 d =
  let rec f89 = function
    | Coq_dAddConstant d1 -> f d1 (f89 d1)
    | Coq_dBool -> f0
    | Coq_dNat -> f1
    | Coq_dProduct (d1, d2) -> f2 d1 (f89 d1) d2 (f89 d2)
    | Coq_dRange n -> f3 n
    | Coq_dUnion (d1, d2) -> f4 d1 (f89 d1) d2 (f89 d2)
    | Coq_dUnit -> f5
    | Coq_dFSets d1 -> f6 d1 (f89 d1)
    | Coq_dFMinSets p -> f7 p (f91 p)
    | Coq_dSeq d1 -> f8 d1 (f89 d1)
    | Coq_dSimpleSeq d1 -> f9 d1 (f89 d1)
    | Coq_dMultiSets d1 -> f10 d1 (f89 d1)
  and f90 = function
    | Coq_sBoolAnd -> f11
    | Coq_sBoolOr -> f12
    | Coq_sNatMax -> f13
    | Coq_sNatMin -> f14
    | Coq_sNatPlus -> f15
    | Coq_sLex (s0, s1) -> f16 s0 (f90 s0) s1 (f90 s1)
    | Coq_sProduct (s0, s1) -> f17 s0 (f90 s0) s1 (f90 s1)
    | Coq_sRangeMax n -> f18 n
    | Coq_sRangeMin n -> f19 n
    | Coq_sRangePlus n -> f20 n
    | Coq_sTopUnion (s0, s1) -> f21 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnion (s0, s1) -> f22 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnionSwap (s0, s1) -> f23 s0 (f90 s0) s1 (f90 s1)
    | Coq_sUnit -> f24
    | Coq_sFSetsIntersect d0 -> f25 d0 (f89 d0)
    | Coq_sFSetsUnion d0 -> f26 d0 (f89 d0)
    | Coq_sFSetsOp s0 -> f27 s0 (f90 s0)
    | Coq_sFMinSetsUnion p -> f28 p (f91 p)
    | Coq_sFMinSetsOp o -> f29 o (f92 o)
    | Coq_sLeft d0 -> f30 d0 (f89 d0)
    | Coq_sRight d0 -> f31 d0 (f89 d0)
    | Coq_sSelLex (s0, s1) -> f32 s0 (f90 s0) s1 (f90 s1)
    | Coq_sSeq d0 -> f33 d0 (f89 d0)
    | Coq_sSimpleSeq d0 -> f34 d0 (f89 d0)
    | Coq_sPrefix d0 -> f35 d0 (f89 d0)
    | Coq_sPostfix d0 -> f36 d0 (f89 d0)
    | Coq_sRevOp s0 -> f37 s0 (f90 s0)
    | Coq_sMultiSetsUnion d0 -> f38 d0 (f89 d0)
    | Coq_sMultiSetsIntersect d0 -> f39 d0 (f89 d0)
  and f91 = function
    | Coq_pDual p0 -> f40 p0 (f91 p0)
    | Coq_pLeftNaturalOrder s -> f41 s (f90 s)
    | Coq_pRightNaturalOrder s -> f42 s (f90 s)
    | Coq_pLex (p0, p1) -> f43 p0 (f91 p0) p1 (f91 p1)
    | Coq_pNatLe -> f44
    | Coq_pAnnTop s -> f45 s (f90 s)
  and f92 = function
    | Coq_oDual o0 -> f46 o0 (f92 o0)
    | Coq_oLeftNaturalOrder s -> f47 s (f90 s)
    | Coq_oRightNaturalOrder s -> f48 s (f90 s)
    | Coq_oLex (o0, o1) -> f49 o0 (f92 o0) o1 (f92 o1)
    | Coq_oBsLeftNaturalOrder b -> f50 b (f93 b)
    | Coq_oSimpleSeq d0 -> f51 d0 (f89 d0)
  and f93 = function
    | Coq_bUnit -> f52
    | Coq_bBoolOrAnd -> f53
    | Coq_bNatMaxPlus -> f54
    | Coq_bNatMinPlus -> f55
    | Coq_bNatMaxMin -> f56
    | Coq_bNatIMaxPlus -> f57
    | Coq_bNatIMinPlus -> f58
    | Coq_bNatIMaxMin -> f59
    | Coq_bRangeMaxPlus n -> f60 n
    | Coq_bRangeMinPlus n -> f61 n
    | Coq_bRangeMaxMin n -> f62 n
    | Coq_bSwap b0 -> f63 b0 (f93 b0)
    | Coq_bFMinSets o -> f64 o (f92 o)
    | Coq_bFMinSetsOpUnion o -> f65 o (f92 o)
    | Coq_bFSets d0 -> f66 d0 (f89 d0)
    | Coq_bFSetsOp s -> f67 s (f90 s)
    | Coq_bLex (b0, b1) -> f68 b0 (f93 b0) b1 (f93 b1)
    | Coq_bProduct (b0, b1) -> f69 b0 (f93 b0) b1 (f93 b1)
    | Coq_bLeft s -> f70 s (f90 s)
    | Coq_bAddZero b0 -> f71 b0 (f93 b0)
    | Coq_bAddOne b0 -> f72 b0 (f93 b0)
    | Coq_bSelLex (b0, b1) -> f73 b0 (f93 b0) b1 (f93 b1)
    | Coq_bRevTimes b0 -> f74 b0 (f93 b0)
    | Coq_bPrefixSeq d0 -> f75 d0 (f89 d0)
    | Coq_bPostfixSeq d0 -> f76 d0 (f89 d0)
    | Coq_bMultiSets d0 -> f77 d0 (f89 d0)
  and f94 = function
    | Coq_tId d0 -> f78 d0 (f89 d0)
    | Coq_tReplace d0 -> f79 d0 (f89 d0)
    | Coq_tProduct (t0, t1) -> f80 t0 (f94 t0) t1 (f94 t1)
    | Coq_tUnion (t0, t1) -> f81 t0 (f94 t0) t1 (f94 t1)
    | Coq_tCayley s -> f82 s (f90 s)
  and f95 = function
    | Coq_stLeft s0 -> f83 s0 (f90 s0)
    | Coq_stRight s0 -> f84 s0 (f90 s0)
    | Coq_stLex (s0, s1) -> f85 s0 (f95 s0) s1 (f95 s1)
    | Coq_stSelLex (s0, s1) -> f86 s0 (f95 s0) s1 (f95 s1)
    | Coq_stUnion (s0, s1) -> f87 s0 (f95 s0) s1 (f95 s1)
    | Coq_stCayley b -> f88 b (f93 b)
  in f89 d

(** val coq_Syntax_rect :
    (coq_DS -> 'a1 -> 'a1) -> 'a1 -> 'a1 -> (coq_DS -> 'a1 -> coq_DS -> 'a1
    -> 'a1) -> (nat -> 'a1) -> (coq_DS -> 'a1 -> coq_DS -> 'a1 -> 'a1) -> 'a1
    -> (coq_DS -> 'a1 -> 'a1) -> (coq_PO -> 'a3 -> 'a1) -> (coq_DS -> 'a1 ->
    'a1) -> (coq_DS -> 'a1 -> 'a1) -> (coq_DS -> 'a1 -> 'a1) -> 'a2 -> 'a2 ->
    'a2 -> 'a2 -> 'a2 -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG
    -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (nat -> 'a2) -> (nat -> 'a2) -> (nat
    -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 ->
    coq_SG -> 'a2 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2 -> 'a2) -> 'a2
    -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 ->
    'a2) -> (coq_PO -> 'a3 -> 'a2) -> (coq_OS -> 'a4 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> coq_SG -> 'a2
    -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_DS ->
    'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_SG -> 'a2 -> 'a2) ->
    (coq_DS -> 'a1 -> 'a2) -> (coq_DS -> 'a1 -> 'a2) -> (coq_PO -> 'a3 ->
    'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_SG -> 'a2 -> 'a3) -> (coq_PO ->
    'a3 -> coq_PO -> 'a3 -> 'a3) -> 'a3 -> (coq_SG -> 'a2 -> 'a3) -> (coq_OS
    -> 'a4 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) -> (coq_SG -> 'a2 -> 'a4) ->
    (coq_OS -> 'a4 -> coq_OS -> 'a4 -> 'a4) -> (coq_BS -> 'a5 -> 'a4) ->
    (coq_DS -> 'a1 -> 'a4) -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5 -> 'a5
    -> 'a5 -> (nat -> 'a5) -> (nat -> 'a5) -> (nat -> 'a5) -> (coq_BS -> 'a5
    -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_OS -> 'a4 -> 'a5) -> (coq_DS ->
    'a1 -> 'a5) -> (coq_SG -> 'a2 -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5
    -> 'a5) -> (coq_BS -> 'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_SG -> 'a2 ->
    'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_BS ->
    'a5 -> coq_BS -> 'a5 -> 'a5) -> (coq_BS -> 'a5 -> 'a5) -> (coq_DS -> 'a1
    -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS -> 'a1 -> 'a5) -> (coq_DS ->
    'a1 -> 'a6) -> (coq_DS -> 'a1 -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6
    -> 'a6) -> (coq_TF -> 'a6 -> coq_TF -> 'a6 -> 'a6) -> (coq_SG -> 'a2 ->
    'a6) -> (coq_SG -> 'a2 -> 'a7) -> (coq_SG -> 'a2 -> 'a7) -> (coq_ST ->
    'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7)
    -> (coq_ST -> 'a7 -> coq_ST -> 'a7 -> 'a7) -> (coq_BS -> 'a5 -> 'a7) ->
    ret_type **)

let coq_Syntax_rect x x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 x16 x17 x18 x19 x20 x21 x22 x23 x24 x25 x26 x27 x28 x29 x30 x31 x32 x33 x34 x35 x36 x37 x38 x39 x40 x41 x42 x43 x44 x45 x46 x47 x48 x49 x50 x51 x52 x53 x54 x55 x56 x57 x58 x59 x60 x61 x62 x63 x64 x65 x66 x67 x68 x69 x70 x71 x72 x73 x74 x75 x76 x77 x78 x79 x80 x81 x82 x83 x84 x85 x86 x87 x88 =
  pair7_90
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_DS_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_SG_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_PO_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_OS_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_BS_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_TF_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179)
    (fun x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102 x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116 x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130 x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144 x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158 x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172 x173 x174 x175 x176 x177 x178 x179 ->
    coq_ST_rect2 x89 x90 x91 x92 x93 x94 x95 x96 x97 x98 x99 x100 x101 x102
      x103 x104 x105 x106 x107 x108 x109 x110 x111 x112 x113 x114 x115 x116
      x117 x118 x119 x120 x121 x122 x123 x124 x125 x126 x127 x128 x129 x130
      x131 x132 x133 x134 x135 x136 x137 x138 x139 x140 x141 x142 x143 x144
      x145 x146 x147 x148 x149 x150 x151 x152 x153 x154 x155 x156 x157 x158
      x159 x160 x161 x162 x163 x164 x165 x166 x167 x168 x169 x170 x171 x172
      x173 x174 x175 x176 x177 x178 x179) x x0 x1 x2 x3 x4 x5 x6 x7 x8 x9 x10
    x11 x12 x13 x14 x15 x16 x17 x18 x19 x20 x21 x22 x23 x24 x25 x26 x27 x28
    x29 x30 x31 x32 x33 x34 x35 x36 x37 x38 x39 x40 x41 x42 x43 x44 x45 x46
    x47 x48 x49 x50 x51 x52 x53 x54 x55 x56 x57 x58 x59 x60 x61 x62 x63 x64
    x65 x66 x67 x68 x69 x70 x71 x72 x73 x74 x75 x76 x77 x78 x79 x80 x81 x82
    x83 x84 x85 x86 x87 x88

type coq_Lang =
  | Coq_dsInc of coq_DS
  | Coq_sgInc of coq_SG
  | Coq_poInc of coq_PO
  | Coq_osInc of coq_OS
  | Coq_bsInc of coq_BS
  | Coq_tfInc of coq_TF
  | Coq_stInc of coq_ST

(** val coq_Lang_rect :
    (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1)
    -> (coq_BS -> 'a1) -> (coq_TF -> 'a1) -> (coq_ST -> 'a1) -> coq_Lang ->
    'a1 **)

let coq_Lang_rect f f0 f1 f2 f3 f4 f5 = function
  | Coq_dsInc x -> f x
  | Coq_sgInc x -> f0 x
  | Coq_poInc x -> f1 x
  | Coq_osInc x -> f2 x
  | Coq_bsInc x -> f3 x
  | Coq_tfInc x -> f4 x
  | Coq_stInc x -> f5 x

(** val coq_Lang_rec :
    (coq_DS -> 'a1) -> (coq_SG -> 'a1) -> (coq_PO -> 'a1) -> (coq_OS -> 'a1)
    -> (coq_BS -> 'a1) -> (coq_TF -> 'a1) -> (coq_ST -> 'a1) -> coq_Lang ->
    'a1 **)

let coq_Lang_rec f f0 f1 f2 f3 f4 f5 = function
  | Coq_dsInc x -> f x
  | Coq_sgInc x -> f0 x
  | Coq_poInc x -> f1 x
  | Coq_osInc x -> f2 x
  | Coq_bsInc x -> f3 x
  | Coq_tfInc x -> f4 x
  | Coq_stInc x -> f5 x

(** val coq_OS_PO : coq_OS -> coq_PO **)

let rec coq_OS_PO = function
  | Coq_oDual x0 -> Coq_pDual (coq_OS_PO x0)
  | Coq_oLeftNaturalOrder x0 -> Coq_pLeftNaturalOrder x0
  | Coq_oRightNaturalOrder x0 -> Coq_pRightNaturalOrder x0
  | Coq_oLex (x0, y) -> Coq_pLex ((coq_OS_PO x0), (coq_OS_PO y))
  | Coq_oBsLeftNaturalOrder x0 -> Coq_pLeftNaturalOrder (coq_BS_SG_plus x0)
  | Coq_oSimpleSeq x0 -> Coq_pAnnTop (Coq_sSimpleSeq x0)

(** val coq_OS_SG : coq_OS -> coq_SG **)

and coq_OS_SG = function
  | Coq_oDual x0 -> coq_OS_SG x0
  | Coq_oLeftNaturalOrder x0 -> x0
  | Coq_oRightNaturalOrder x0 -> x0
  | Coq_oLex (x0, y) -> Coq_sProduct ((coq_OS_SG x0), (coq_OS_SG y))
  | Coq_oBsLeftNaturalOrder x0 -> coq_BS_SG_times x0
  | Coq_oSimpleSeq x0 -> Coq_sSimpleSeq x0

(** val coq_SG_DS : coq_SG -> coq_DS **)

and coq_SG_DS = function
  | Coq_sBoolAnd -> Coq_dBool
  | Coq_sBoolOr -> Coq_dBool
  | Coq_sLex (x0, y) -> Coq_dProduct ((coq_SG_DS x0), (coq_SG_DS y))
  | Coq_sProduct (x0, y) -> Coq_dProduct ((coq_SG_DS x0), (coq_SG_DS y))
  | Coq_sRangeMax n -> Coq_dRange n
  | Coq_sRangeMin n -> Coq_dRange n
  | Coq_sRangePlus n -> Coq_dRange n
  | Coq_sTopUnion (x0, y) -> Coq_dUnion ((Coq_dUnion (
      (coq_SG_DS x0), (coq_SG_DS y))), Coq_dUnit)
  | Coq_sUnion (x0, y) -> Coq_dUnion ((coq_SG_DS x0), (coq_SG_DS y))
  | Coq_sUnionSwap (x0, y) -> Coq_dUnion ((coq_SG_DS y), (coq_SG_DS x0))
  | Coq_sUnit -> Coq_dUnit
  | Coq_sFSetsIntersect x0 -> Coq_dFSets x0
  | Coq_sFSetsUnion x0 -> Coq_dFSets x0
  | Coq_sFSetsOp x0 -> Coq_dFSets (coq_SG_DS x0)
  | Coq_sFMinSetsUnion x0 -> Coq_dFMinSets x0
  | Coq_sFMinSetsOp x0 -> Coq_dFMinSets (coq_OS_PO x0)
  | Coq_sLeft x0 -> x0
  | Coq_sRight x0 -> x0
  | Coq_sSelLex (x0, y) -> Coq_dProduct ((coq_SG_DS x0), (coq_SG_DS y))
  | Coq_sSeq x0 -> Coq_dSeq x0
  | Coq_sSimpleSeq x0 -> Coq_dSimpleSeq x0
  | Coq_sPrefix x0 -> Coq_dSeq x0
  | Coq_sPostfix x0 -> Coq_dSeq x0
  | Coq_sRevOp x0 -> coq_SG_DS x0
  | Coq_sMultiSetsUnion x0 -> Coq_dMultiSets x0
  | Coq_sMultiSetsIntersect x0 -> Coq_dMultiSets x0
  | _ -> Coq_dNat

(** val coq_PO_DS : coq_PO -> coq_DS **)

and coq_PO_DS = function
  | Coq_pDual x0 -> coq_PO_DS x0
  | Coq_pLeftNaturalOrder x0 -> coq_SG_DS x0
  | Coq_pRightNaturalOrder x0 -> coq_SG_DS x0
  | Coq_pLex (x0, y) -> Coq_dProduct ((coq_PO_DS x0), (coq_PO_DS y))
  | Coq_pNatLe -> Coq_dNat
  | Coq_pAnnTop x0 -> coq_SG_DS x0

(** val coq_BS_SG_plus : coq_BS -> coq_SG **)

and coq_BS_SG_plus = function
  | Coq_bUnit -> Coq_sUnit
  | Coq_bBoolOrAnd -> Coq_sBoolOr
  | Coq_bNatMaxPlus -> Coq_sNatMax
  | Coq_bNatMinPlus -> Coq_sNatMin
  | Coq_bNatMaxMin -> Coq_sNatMax
  | Coq_bNatIMinPlus -> Coq_sUnionSwap (Coq_sNatMin, Coq_sUnit)
  | Coq_bRangeMaxPlus n -> Coq_sRangeMax n
  | Coq_bRangeMinPlus n -> Coq_sRangeMin n
  | Coq_bRangeMaxMin n -> Coq_sRangeMax n
  | Coq_bSwap x0 -> coq_BS_SG_times x0
  | Coq_bFMinSets x0 -> Coq_sFMinSetsUnion (coq_OS_PO x0)
  | Coq_bFMinSetsOpUnion x0 -> Coq_sFMinSetsOp x0
  | Coq_bFSets x0 -> Coq_sFSetsUnion x0
  | Coq_bFSetsOp x0 -> Coq_sFSetsUnion (coq_SG_DS x0)
  | Coq_bLex (x0, y) -> Coq_sLex ((coq_BS_SG_plus x0), (coq_BS_SG_plus y))
  | Coq_bProduct (x0, y) -> Coq_sProduct ((coq_BS_SG_plus x0),
      (coq_BS_SG_plus y))
  | Coq_bLeft x0 -> x0
  | Coq_bAddZero x0 -> Coq_sUnion ((coq_BS_SG_plus x0), Coq_sUnit)
  | Coq_bAddOne x0 -> Coq_sUnion (Coq_sUnit, (coq_BS_SG_plus x0))
  | Coq_bSelLex (x0, y) -> Coq_sSelLex ((coq_BS_SG_plus x0),
      (coq_BS_SG_plus y))
  | Coq_bRevTimes x0 -> coq_BS_SG_plus x0
  | Coq_bPrefixSeq x0 -> Coq_sPrefix x0
  | Coq_bPostfixSeq x0 -> Coq_sPostfix x0
  | Coq_bMultiSets x0 -> Coq_sMultiSetsIntersect x0
  | _ -> Coq_sUnion (Coq_sUnit, Coq_sNatMax)

(** val coq_BS_SG_times : coq_BS -> coq_SG **)

and coq_BS_SG_times = function
  | Coq_bUnit -> Coq_sUnit
  | Coq_bBoolOrAnd -> Coq_sBoolAnd
  | Coq_bNatMaxPlus -> Coq_sNatPlus
  | Coq_bNatMinPlus -> Coq_sNatPlus
  | Coq_bNatMaxMin -> Coq_sNatMin
  | Coq_bNatIMaxMin -> Coq_sUnionSwap (Coq_sNatMin, Coq_sUnit)
  | Coq_bRangeMaxPlus n -> Coq_sRangePlus n
  | Coq_bRangeMinPlus n -> Coq_sRangePlus n
  | Coq_bRangeMaxMin n -> Coq_sRangeMin n
  | Coq_bSwap x0 -> coq_BS_SG_plus x0
  | Coq_bFMinSets x0 -> Coq_sFMinSetsOp x0
  | Coq_bFMinSetsOpUnion x0 -> Coq_sFMinSetsUnion (coq_OS_PO x0)
  | Coq_bFSets x0 -> Coq_sFSetsIntersect x0
  | Coq_bFSetsOp x0 -> Coq_sFSetsOp x0
  | Coq_bLex (x0, y) -> Coq_sProduct ((coq_BS_SG_times x0),
      (coq_BS_SG_times y))
  | Coq_bProduct (x0, y) -> Coq_sProduct ((coq_BS_SG_times x0),
      (coq_BS_SG_times y))
  | Coq_bLeft x0 -> Coq_sLeft (coq_SG_DS x0)
  | Coq_bAddZero x0 -> Coq_sUnionSwap (Coq_sUnit, (coq_BS_SG_times x0))
  | Coq_bAddOne x0 -> Coq_sUnionSwap ((coq_BS_SG_times x0), Coq_sUnit)
  | Coq_bSelLex (x0, y) -> Coq_sProduct ((coq_BS_SG_times x0),
      (coq_BS_SG_times y))
  | Coq_bRevTimes x0 -> Coq_sRevOp (coq_BS_SG_times x0)
  | Coq_bPrefixSeq x0 -> Coq_sSeq x0
  | Coq_bPostfixSeq x0 -> Coq_sSeq x0
  | Coq_bMultiSets x0 -> Coq_sMultiSetsUnion x0
  | _ -> Coq_sUnion (Coq_sUnit, Coq_sNatPlus)

(** val coq_ST_TF : coq_ST -> coq_TF **)

let rec coq_ST_TF = function
  | Coq_stLeft x0 -> Coq_tReplace (coq_SG_DS x0)
  | Coq_stRight x0 -> Coq_tId (coq_SG_DS x0)
  | Coq_stLex (x0, y) -> Coq_tProduct ((coq_ST_TF x0), (coq_ST_TF y))
  | Coq_stSelLex (x0, y) -> Coq_tProduct ((coq_ST_TF x0), (coq_ST_TF y))
  | Coq_stUnion (x0, y) -> Coq_tUnion ((coq_ST_TF x0), (coq_ST_TF y))
  | Coq_stCayley x0 -> Coq_tCayley (coq_BS_SG_times x0)

(** val coq_ST_SG : coq_ST -> coq_SG **)

let rec coq_ST_SG = function
  | Coq_stLeft x0 -> x0
  | Coq_stRight x0 -> x0
  | Coq_stLex (x0, y) -> Coq_sLex ((coq_ST_SG x0), (coq_ST_SG y))
  | Coq_stSelLex (x0, y) -> Coq_sSelLex ((coq_ST_SG x0), (coq_ST_SG y))
  | Coq_stUnion (x0, y) -> coq_ST_SG x0
  | Coq_stCayley x0 -> coq_BS_SG_plus x0

(** val coq_TF_DS : coq_TF -> coq_DS **)

let rec coq_TF_DS = function
  | Coq_tId x0 -> x0
  | Coq_tReplace x0 -> x0
  | Coq_tProduct (x0, y) -> Coq_dProduct ((coq_TF_DS x0), (coq_TF_DS y))
  | Coq_tUnion (x0, y) -> coq_TF_DS x0
  | Coq_tCayley x0 -> coq_SG_DS x0

(** val fn_TF_DS : coq_TF -> coq_DS **)

let rec fn_TF_DS = function
  | Coq_tId x0 -> Coq_dUnit
  | Coq_tReplace x0 -> x0
  | Coq_tProduct (x0, y) -> Coq_dProduct ((fn_TF_DS x0), (fn_TF_DS y))
  | Coq_tUnion (x0, y) -> Coq_dUnion ((fn_TF_DS x0), (fn_TF_DS y))
  | Coq_tCayley x0 -> coq_SG_DS x0

(** val eq_DS : coq_DS -> coq_DS -> bool **)

let rec eq_DS x y =
  match x with
    | Coq_dAddConstant x1 ->
        (match y with
           | Coq_dAddConstant y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_dBool -> (match y with
                      | Coq_dBool -> true
                      | _ -> false)
    | Coq_dNat -> (match y with
                     | Coq_dNat -> true
                     | _ -> false)
    | Coq_dProduct (x1, x2) ->
        (match y with
           | Coq_dProduct (y1, y2) ->
               if eq_DS x1 y1 then eq_DS x2 y2 else false
           | _ -> false)
    | Coq_dRange n1 ->
        (match y with
           | Coq_dRange n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_dUnion (x1, x2) ->
        (match y with
           | Coq_dUnion (y1, y2) ->
               if eq_DS x1 y1 then eq_DS x2 y2 else false
           | _ -> false)
    | Coq_dUnit -> (match y with
                      | Coq_dUnit -> true
                      | _ -> false)
    | Coq_dFSets x1 ->
        (match y with
           | Coq_dFSets y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_dFMinSets x1 ->
        (match y with
           | Coq_dFMinSets y1 -> eq_PO x1 y1
           | _ -> false)
    | Coq_dSeq x1 ->
        (match y with
           | Coq_dSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_dSimpleSeq x1 ->
        (match y with
           | Coq_dSimpleSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_dMultiSets x1 ->
        (match y with
           | Coq_dMultiSets y1 -> eq_DS x1 y1
           | _ -> false)

(** val eq_SG : coq_SG -> coq_SG -> bool **)

and eq_SG x y =
  match x with
    | Coq_sBoolAnd -> (match y with
                         | Coq_sBoolAnd -> true
                         | _ -> false)
    | Coq_sBoolOr -> (match y with
                        | Coq_sBoolOr -> true
                        | _ -> false)
    | Coq_sNatMax -> (match y with
                        | Coq_sNatMax -> true
                        | _ -> false)
    | Coq_sNatMin -> (match y with
                        | Coq_sNatMin -> true
                        | _ -> false)
    | Coq_sNatPlus -> (match y with
                         | Coq_sNatPlus -> true
                         | _ -> false)
    | Coq_sLex (x1, x2) ->
        (match y with
           | Coq_sLex (y1, y2) -> if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sProduct (x1, x2) ->
        (match y with
           | Coq_sProduct (y1, y2) ->
               if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sRangeMax n1 ->
        (match y with
           | Coq_sRangeMax n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_sRangeMin n1 ->
        (match y with
           | Coq_sRangeMin n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_sRangePlus n1 ->
        (match y with
           | Coq_sRangePlus n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_sTopUnion (x1, x2) ->
        (match y with
           | Coq_sTopUnion (y1, y2) ->
               if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sUnion (x1, x2) ->
        (match y with
           | Coq_sUnion (y1, y2) ->
               if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sUnionSwap (x1, x2) ->
        (match y with
           | Coq_sUnionSwap (y1, y2) ->
               if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sUnit -> (match y with
                      | Coq_sUnit -> true
                      | _ -> false)
    | Coq_sFSetsIntersect x1 ->
        (match y with
           | Coq_sFSetsIntersect y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sFSetsUnion x1 ->
        (match y with
           | Coq_sFSetsUnion y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sFSetsOp x1 ->
        (match y with
           | Coq_sFSetsOp y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_sFMinSetsUnion x1 ->
        (match y with
           | Coq_sFMinSetsUnion y1 -> eq_PO x1 y1
           | _ -> false)
    | Coq_sFMinSetsOp x1 ->
        (match y with
           | Coq_sFMinSetsOp y1 -> eq_OS x1 y1
           | _ -> false)
    | Coq_sLeft x1 ->
        (match y with
           | Coq_sLeft y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sRight x1 ->
        (match y with
           | Coq_sRight y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sSelLex (x1, x2) ->
        (match y with
           | Coq_sSelLex (y1, y2) ->
               if eq_SG x1 y1 then eq_SG x2 y2 else false
           | _ -> false)
    | Coq_sSeq x1 ->
        (match y with
           | Coq_sSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sSimpleSeq x1 ->
        (match y with
           | Coq_sSimpleSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sPrefix x1 ->
        (match y with
           | Coq_sPrefix y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sPostfix x1 ->
        (match y with
           | Coq_sPostfix y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sRevOp x1 ->
        (match y with
           | Coq_sRevOp y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_sMultiSetsUnion x1 ->
        (match y with
           | Coq_sMultiSetsUnion y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_sMultiSetsIntersect x1 ->
        (match y with
           | Coq_sMultiSetsIntersect y1 -> eq_DS x1 y1
           | _ -> false)

(** val eq_PO : coq_PO -> coq_PO -> bool **)

and eq_PO x y =
  match x with
    | Coq_pDual x1 ->
        (match y with
           | Coq_pDual y1 -> eq_PO x1 y1
           | _ -> false)
    | Coq_pLeftNaturalOrder x1 ->
        (match y with
           | Coq_pLeftNaturalOrder y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_pRightNaturalOrder x1 ->
        (match y with
           | Coq_pRightNaturalOrder y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_pLex (x1, x2) ->
        (match y with
           | Coq_pLex (y1, y2) -> if eq_PO x1 y1 then eq_PO x2 y2 else false
           | _ -> false)
    | Coq_pNatLe -> (match y with
                       | Coq_pNatLe -> true
                       | _ -> false)
    | Coq_pAnnTop x1 ->
        (match y with
           | Coq_pAnnTop y1 -> eq_SG x1 y1
           | _ -> false)

(** val eq_OS : coq_OS -> coq_OS -> bool **)

and eq_OS x y =
  match x with
    | Coq_oDual x1 ->
        (match y with
           | Coq_oDual y1 -> eq_OS x1 y1
           | _ -> false)
    | Coq_oLeftNaturalOrder x1 ->
        (match y with
           | Coq_oLeftNaturalOrder y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_oRightNaturalOrder x1 ->
        (match y with
           | Coq_oRightNaturalOrder y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_oLex (x1, x2) ->
        (match y with
           | Coq_oLex (y1, y2) -> if eq_OS x1 y1 then eq_OS x2 y2 else false
           | _ -> false)
    | Coq_oBsLeftNaturalOrder x1 ->
        (match y with
           | Coq_oBsLeftNaturalOrder y1 -> eq_BS x1 y1
           | _ -> false)
    | Coq_oSimpleSeq x1 ->
        (match y with
           | Coq_oSimpleSeq y1 -> eq_DS x1 y1
           | _ -> false)

(** val eq_BS : coq_BS -> coq_BS -> bool **)

and eq_BS x y =
  match x with
    | Coq_bUnit -> (match y with
                      | Coq_bUnit -> true
                      | _ -> false)
    | Coq_bBoolOrAnd ->
        (match y with
           | Coq_bBoolOrAnd -> true
           | _ -> false)
    | Coq_bNatMaxPlus ->
        (match y with
           | Coq_bNatMaxPlus -> true
           | _ -> false)
    | Coq_bNatMinPlus ->
        (match y with
           | Coq_bNatMinPlus -> true
           | _ -> false)
    | Coq_bNatMaxMin ->
        (match y with
           | Coq_bNatMaxMin -> true
           | _ -> false)
    | Coq_bNatIMaxPlus ->
        (match y with
           | Coq_bNatIMaxPlus -> true
           | _ -> false)
    | Coq_bNatIMinPlus ->
        (match y with
           | Coq_bNatIMinPlus -> true
           | _ -> false)
    | Coq_bNatIMaxMin ->
        (match y with
           | Coq_bNatIMaxMin -> true
           | _ -> false)
    | Coq_bRangeMaxPlus n1 ->
        (match y with
           | Coq_bRangeMaxPlus n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_bRangeMinPlus n1 ->
        (match y with
           | Coq_bRangeMinPlus n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_bRangeMaxMin n1 ->
        (match y with
           | Coq_bRangeMaxMin n2 -> beq_nat n1 n2
           | _ -> false)
    | Coq_bSwap x1 ->
        (match y with
           | Coq_bSwap y1 -> eq_BS x1 y1
           | _ -> false)
    | Coq_bFMinSets x1 ->
        (match y with
           | Coq_bFMinSets y1 -> eq_OS x1 y1
           | _ -> false)
    | Coq_bFMinSetsOpUnion x1 ->
        (match y with
           | Coq_bFMinSetsOpUnion y1 -> eq_OS x1 y1
           | _ -> false)
    | Coq_bFSets x1 ->
        (match y with
           | Coq_bFSets y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_bFSetsOp x1 ->
        (match y with
           | Coq_bFSetsOp y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_bLex (x1, x2) ->
        (match y with
           | Coq_bLex (y1, y2) -> if eq_BS x1 y1 then eq_BS x2 y2 else false
           | _ -> false)
    | Coq_bProduct (x1, x2) ->
        (match y with
           | Coq_bProduct (y1, y2) ->
               if eq_BS x1 y1 then eq_BS x2 y2 else false
           | _ -> false)
    | Coq_bLeft x1 ->
        (match y with
           | Coq_bLeft y1 -> eq_SG x1 y1
           | _ -> false)
    | Coq_bAddZero x1 ->
        (match y with
           | Coq_bAddZero y1 -> eq_BS x1 y1
           | _ -> false)
    | Coq_bAddOne x1 ->
        (match y with
           | Coq_bAddOne y1 -> eq_BS x1 y1
           | _ -> false)
    | Coq_bSelLex (x1, x2) ->
        (match y with
           | Coq_bSelLex (y1, y2) ->
               if eq_BS x1 y1 then eq_BS x2 y2 else false
           | _ -> false)
    | Coq_bRevTimes x1 ->
        (match y with
           | Coq_bRevTimes y1 -> eq_BS x1 y1
           | _ -> false)
    | Coq_bPrefixSeq x1 ->
        (match y with
           | Coq_bPrefixSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_bPostfixSeq x1 ->
        (match y with
           | Coq_bPostfixSeq y1 -> eq_DS x1 y1
           | _ -> false)
    | Coq_bMultiSets x1 ->
        (match y with
           | Coq_bMultiSets y1 -> eq_DS x1 y1
           | _ -> false)

(** val eq_TF : coq_TF -> coq_TF -> bool **)

let rec eq_TF x y =
  match x with
    | Coq_tId x1 -> (match y with
                       | Coq_tId x2 -> eq_DS x1 x2
                       | _ -> false)
    | Coq_tReplace x1 ->
        (match y with
           | Coq_tReplace x2 -> eq_DS x1 x2
           | _ -> false)
    | Coq_tProduct (x1, y1) ->
        (match y with
           | Coq_tProduct (x2, y2) ->
               if eq_TF x1 x2 then eq_TF y1 y2 else false
           | _ -> false)
    | Coq_tUnion (x1, y1) ->
        (match y with
           | Coq_tUnion (x2, y2) ->
               if eq_TF x1 x2 then eq_TF y1 y2 else false
           | _ -> false)
    | Coq_tCayley x1 ->
        (match y with
           | Coq_tCayley x2 -> eq_SG x1 x2
           | _ -> false)

(** val eq_ST : coq_ST -> coq_ST -> bool **)

let rec eq_ST x y =
  match x with
    | Coq_stLeft x1 ->
        (match y with
           | Coq_stLeft x2 -> eq_SG x1 x2
           | _ -> false)
    | Coq_stRight x1 ->
        (match y with
           | Coq_stRight x2 -> eq_SG x1 x2
           | _ -> false)
    | Coq_stLex (x1, y1) ->
        (match y with
           | Coq_stLex (x2, y2) -> if eq_ST x1 x2 then eq_ST y1 y2 else false
           | _ -> false)
    | Coq_stSelLex (x1, y1) ->
        (match y with
           | Coq_stSelLex (x2, y2) ->
               if eq_ST x1 x2 then eq_ST y1 y2 else false
           | _ -> false)
    | Coq_stUnion (x1, y1) ->
        (match y with
           | Coq_stUnion (x2, y2) ->
               if eq_ST x1 x2 then eq_ST y1 y2 else false
           | _ -> false)
    | Coq_stCayley x1 ->
        (match y with
           | Coq_stCayley x2 -> eq_BS x1 x2
           | _ -> false)

