open DecSetoid
open DecSetoidProperties
open List0
open Semigroup
open SemigroupProperties
open Seq
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val seqSemigroup : coq_DecSetoid -> coq_Semigroup **)

let seqSemigroup a =
  { setoid = (seqDecSetoid a); op = (Obj.magic (fun x x0 -> app x x0)) }

(** val seqnatSmgIso : coq_DecSetoid -> coq_IsSingleton -> coq_SmgIso **)

let seqnatSmgIso a sg =
  seqnatDsIso a sg

(** val isIdempotent_comp : coq_DecSetoid -> coq_IsIdempotent_comp **)

let isIdempotent_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), __)

(** val isSelective_comp : coq_DecSetoid -> coq_IsSelective_comp **)

let isSelective_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT
    ((Obj.magic (a.choose :: [])), __)))

(** val isCommutative_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsCommutative_comp **)

let isCommutative_comp a sg =
  let Coq_existT (b, _) = sg a.choose in
  Coq_existT ((Obj.magic (b :: [])), (Coq_existT
  ((Obj.magic (a.choose :: [])), __)))

(** val hasIdentity : coq_DecSetoid -> coq_HasIdentity **)

let hasIdentity a =
  Coq_existT ((Obj.magic []), __)

(** val hasAnnihilator_comp : coq_DecSetoid -> coq_HasAnnihilator_comp **)

let hasAnnihilator_comp a x =
  Coq_existT ((Obj.magic (a.choose :: [])), __)

(** val isLeft_comp : coq_DecSetoid -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    __)))

(** val isRight_comp : coq_DecSetoid -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), __)))

(** val leftCondensed_comp : coq_DecSetoid -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT
    ((Obj.magic (a.choose :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val rightCondensed_comp : coq_DecSetoid -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT
    ((Obj.magic (a.choose :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

