open Compare_dec
open Datatypes
open DecSetoid
open DecSetoidProperties
open List0
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val seq_eq : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let rec seq_eq a x y =
  match x with
    | [] -> (match y with
               | [] -> true
               | c :: l -> false)
    | a0 :: x' ->
        (match y with
           | [] -> false
           | b :: y' -> if negb (a.equal a0 b) then false else seq_eq a x' y')

(** val seqDecSetoid : coq_DecSetoid -> coq_DecSetoid **)

let seqDecSetoid a =
  { choose = (Obj.magic []); equal = (Obj.magic (seq_eq a)) }

(** val copy_seq : coq_DecSetoid -> carrier -> nat -> carrier **)

let rec copy_seq a x = function
  | O -> Obj.magic []
  | S n' -> Obj.magic (x :: (Obj.magic (fun x0 x1 -> copy_seq a x0 x1) x n'))

(** val seqnatDsIso : coq_DecSetoid -> coq_IsSingleton -> coq_DsIso **)

let seqnatDsIso a sg =
  { phi = (Obj.magic (fun x -> length x)); phi' =
    (Obj.magic (copy_seq a (projT1 sg))) }

(** val isSingleton_comp : coq_DecSetoid -> coq_IsSingleton_comp **)

let isSingleton_comp a c =
  match Obj.magic c with
    | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
    | x :: xs -> Coq_existT ((Obj.magic []), __)

(** val twoElements_comp : coq_DecSetoid -> coq_TwoElements_comp **)

let twoElements_comp a a0 b =
  match Obj.magic a0 with
    | [] ->
        (match Obj.magic b with
           | [] -> Coq_existT ((Obj.magic []), __)
           | y :: l ->
               (match l with
                  | [] -> Coq_existT ((Obj.magic (y :: (y :: []))), __)
                  | y1 :: ys -> Coq_existT ((Obj.magic (y :: [])), __)))
    | x :: l ->
        (match l with
           | [] ->
               (match Obj.magic b with
                  | [] -> Coq_existT ((Obj.magic (x :: (x :: []))), __)
                  | y :: l0 -> Coq_existT ((Obj.magic []), __))
           | x1 :: xs ->
               (match Obj.magic b with
                  | [] -> Coq_existT ((Obj.magic (x :: [])), __)
                  | y :: l0 -> Coq_existT ((Obj.magic []), __)))

(** val finite_comp : coq_DecSetoid -> coq_Finite_comp **)

let finite_comp a l =
  let Coq_existT (x, _) =
    let rec f = function
      | [] -> Coq_existT ([], __)
      | a0 :: l1 ->
          let Coq_existT (x, _) = f l1 in
          (match le_gt_dec (length x) (length (Obj.magic a0)) with
             | Coq_left -> Coq_existT ((a.choose :: (Obj.magic a0)), __)
             | Coq_right -> Coq_existT (x, __))
    in f l
  in
  Coq_existT ((Obj.magic x), __)

