open DecSetoid
open IdArrow
open Semigroup
open SemigroupPropRecord
open SemigroupTransform
open Specif
open Transform
open TransformPropRecord

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val glueSTf_DsEq :
    coq_Semigroup -> coq_Transform -> coq_SemigroupTransform **)

let glueSTf_DsEq a b =
  { SemigroupTransform.setoid = b.setoid; op = a.Semigroup.op;
    SemigroupTransform.fn = b.fn; SemigroupTransform.app = b.app }

(** val glueSTf_DsEq_IdSmgIso :
    coq_Semigroup -> coq_Transform -> coq_IdSmgIso **)

let glueSTf_DsEq_IdSmgIso a b =
  let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
  let { setoid = setoid1; fn = fn0; app = app0 } = b in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val glueSTf_DsEq_IdTfIso :
    coq_Semigroup -> coq_Transform -> coq_IdTfIso **)

let glueSTf_DsEq_IdTfIso a b =
  let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
  let { setoid = setoid1; fn = fn0; app = app0 } = b in
  { dsIso = { phi = (fun x -> x); phi' = (fun x -> x) }; fnIso = { phi =
  (fun x -> x); phi' = (fun x -> x) } }

(** val glueSTf :
    coq_Semigroup -> coq_Transform -> coq_DsIso -> coq_SemigroupTransform **)

let glueSTf a b' iso =
  let Coq_existT (b, p) = liftTfIso a.Semigroup.setoid b' iso in
  let iso' , _ = p in glueSTf_DsEq a b

(** val glueSTfSmg_DsEq : coq_Semigroup -> coq_Transform -> coq_SmgIso **)

let glueSTfSmg_DsEq a b =
  let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
  let { setoid = setoid1; fn = fn0; app = app0 } = b in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val glueSTfSmgIso :
    coq_Semigroup -> coq_Transform -> coq_DsIso -> coq_SmgIso **)

let glueSTfSmgIso a b e =
  let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
  let { choose = choose0; equal = equal0 } = setoid0 in
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val glueSTfTf_DsEq : coq_Semigroup -> coq_Transform -> coq_TfIso **)

let glueSTfTf_DsEq a b =
  let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
  let { setoid = setoid1; fn = fn0; app = app0 } = b in
  { dsIso = { phi = (fun x -> x); phi' = (fun x -> x) }; fnIso = { phi =
  (fun x -> x); phi' = (fun x -> x) } }

(** val glueSTfTf :
    coq_Semigroup -> coq_Transform -> coq_DsIso -> coq_TfIso **)

let glueSTfTf a b iso =
  let Coq_existT (b', p) = liftTfIso a.Semigroup.setoid b iso in
  let iso' , _ = p in
  coq_TfIso_trans b b' (transformST (glueSTf_DsEq a b'))
    (coq_TfIso_sym b' b iso') (glueSTfTf_DsEq a b')

(** val projSTfTfIso :
    coq_Semigroup -> coq_Transform -> coq_DsIso -> tfProp -> tfProp **)

let projSTfTfIso a b iso h =
  tfPropIso b (transformST (glueSTf a b iso)) (glueSTfTf a b iso) h

(** val projSTfSmgIso :
    coq_Semigroup -> coq_Transform -> coq_DsIso -> sgProp -> sgProp **)

let projSTfSmgIso a b iso h =
  sgPropIso a (semigroupST (glueSTf a b iso))
    (let { Semigroup.setoid = setoid0; Semigroup.op = op0 } = a in
    let { choose = choose0; equal = equal0 } = setoid0 in
    { phi = (fun x -> x); phi' = (fun x -> x) }) h

(** val liftSTfIso :
    coq_DecSetoid -> coq_SemigroupTransform -> coq_DsIso ->
    (coq_SemigroupTransform, coq_STfIso * __) sigT **)

let liftSTfIso a b iso =
  Coq_existT ({ SemigroupTransform.setoid = a; op = (fun x y ->
    iso.phi' (b.op (iso.phi x) (iso.phi y))); SemigroupTransform.fn =
    b.SemigroupTransform.fn; SemigroupTransform.app = (fun f x ->
    iso.phi' (b.SemigroupTransform.app f (iso.phi x))) },
    ({ SemigroupTransform.dsIso = { phi = iso.phi; phi' = iso.phi' };
    SemigroupTransform.fnIso = { phi = (fun x -> x); phi' = (fun x -> x) } }
    , __))

