open DecSetoid
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_Semigroup = { setoid : coq_DecSetoid;
                       op : (carrier -> carrier -> carrier) }

(** val coq_Semigroup_rect :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> __ -> 'a1) ->
    coq_Semigroup -> 'a1 **)

let coq_Semigroup_rect f s =
  let { setoid = x; op = x0 } = s in f x x0 __ __

(** val coq_Semigroup_rec :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> __ -> __ -> 'a1) ->
    coq_Semigroup -> 'a1 **)

let coq_Semigroup_rec f s =
  let { setoid = x; op = x0 } = s in f x x0 __ __

(** val setoid : coq_Semigroup -> coq_DecSetoid **)

let setoid x = x.setoid

(** val op : coq_Semigroup -> carrier -> carrier -> carrier **)

let op x = x.op

(** val coq_IsSmgIso_rect :
    coq_Semigroup -> coq_Semigroup -> coq_DsIso -> (__ -> __ -> 'a1) -> 'a1 **)

let coq_IsSmgIso_rect s s' dsIso0 f =
  f __ __

(** val coq_IsSmgIso_rec :
    coq_Semigroup -> coq_Semigroup -> coq_DsIso -> (__ -> __ -> 'a1) -> 'a1 **)

let coq_IsSmgIso_rec s s' dsIso0 f =
  f __ __

type coq_SmgIso =
  coq_DsIso
  (* singleton inductive, whose constructor was Build_SmgIso *)

(** val coq_SmgIso_rect :
    coq_Semigroup -> coq_Semigroup -> (coq_DsIso -> __ -> 'a1) -> coq_SmgIso
    -> 'a1 **)

let coq_SmgIso_rect s s' f s0 =
  f s0 __

(** val coq_SmgIso_rec :
    coq_Semigroup -> coq_Semigroup -> (coq_DsIso -> __ -> 'a1) -> coq_SmgIso
    -> 'a1 **)

let coq_SmgIso_rec s s' f s0 =
  f s0 __

(** val dsIso : coq_Semigroup -> coq_Semigroup -> coq_SmgIso -> coq_DsIso **)

let dsIso s s' s0 =
  s0

(** val coq_SmgIso_refl : coq_Semigroup -> coq_SmgIso **)

let coq_SmgIso_refl s =
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val coq_SmgIso_sym :
    coq_Semigroup -> coq_Semigroup -> coq_SmgIso -> coq_SmgIso **)

let coq_SmgIso_sym s s' i =
  { phi = i.phi'; phi' = i.phi }

(** val coq_SmgIso_trans :
    coq_Semigroup -> coq_Semigroup -> coq_Semigroup -> coq_SmgIso ->
    coq_SmgIso -> coq_SmgIso **)

let coq_SmgIso_trans s s' s'' i i' =
  coq_DsIso_trans s.setoid s'.setoid s''.setoid i i'

(** val liftSmgIso :
    coq_DecSetoid -> coq_Semigroup -> coq_DsIso -> (coq_Semigroup, coq_SmgIso
    * __) sigT **)

let liftSmgIso a b iso =
  Coq_existT ({ setoid = a; op = (fun x y ->
    iso.phi' (b.op (iso.phi x) (iso.phi y))) }, ({ phi = iso.phi; phi' =
    iso.phi' } , __))

