open Datatypes
open DecSetoid
open Logic0
open Product2
open SelLex
open SemigroupProperties
open SemigroupTransform
open SemigroupTransformGlue
open SemigroupTransformProperties
open Specif
open TransformProperties

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val selLexSemigroupTransform :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    coq_SemigroupTransform **)

let selLexSemigroupTransform a b =
  glueSTf_DsEq (selLexSemigroup (semigroupST a) (semigroupST b))
    (prodTransform (transformST a) (transformST b))

(** val distributive_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    ((coq_Distributive_comp, coq_Distributive_comp) sum, coq_Cancelative_comp
    * coq_Condensed_comp) sum -> coq_Distributive_comp **)

let distributive_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl d ->
             let Coq_existT (a0, s0) = d in
             let Coq_existT (b0, s1) = s0 in
             let Coq_existT (f, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (f , b.fn.choose)), __)))))
         | Coq_inr d ->
             let Coq_existT (x0, s0) = d in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (g, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y)), (Coq_existT
             ((Obj.magic (a.fn.choose , g)), __))))))
  | Coq_inr p ->
      let c , x0 = p in
      let Coq_existT (a0, s) = c in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (f, _) = s0 in
      let Coq_existT (x1, s1) = x0 in
      let Coq_existT (y, s2) = s1 in
      let Coq_existT (g, _) = s2 in
      (match lex_case (semigroupST a) a0 b0 with
         | Coq_inleft s3 ->
             (match s3 with
                | Coq_left -> Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
                    ((Obj.magic (b0 , y)), (Coq_existT (
                    (Obj.magic (f , g)), __)))))
                | Coq_right ->
                    let Coq_existT (w, _) =
                      copy_var
                        (b.setoid.equal (b.app g x1)
                          (b.op (b.app g x1) (b.app g y)))
                    in
                    if w
                    then Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                           ((Obj.magic (b0 , x1)), (Coq_existT
                           ((Obj.magic (f , g)), __)))))
                    else Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
                           ((Obj.magic (b0 , y)), (Coq_existT
                           ((Obj.magic (f , g)), __))))))
         | Coq_inright ->
             let Coq_existT (w, _) =
               copy_var
                 (b.setoid.equal (b.app g x1)
                   (b.op (b.app g x1) (b.app g y)))
             in
             if w
             then Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
                    ((Obj.magic (b0 , y)), (Coq_existT (
                    (Obj.magic (f , g)), __)))))
             else Coq_existT ((Obj.magic (a0 , y)), (Coq_existT
                    ((Obj.magic (b0 , x1)), (Coq_existT (
                    (Obj.magic (f , g)), __))))))

(** val inflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    (coq_Inflationary_comp, coq_StrictInflationary_comp *
    coq_Inflationary_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let inflationary_comp a b = function
  | Coq_inl ia ->
      let Coq_existT (x0, s) = ia __ __ in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f , b.fn.choose)), __)))
  | Coq_inr p ->
      let sia , ib = p in
      let Coq_existT (a0, s) = sia __ __ in
      let Coq_existT (g, _) = s in
      let Coq_existT (x0, s0) = ib __ __ in
      let Coq_existT (f, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (g , f)), __)))

(** val deflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    (coq_Deflationary_comp, coq_StrictDeflationary_comp *
    coq_Deflationary_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let deflationary_comp a b = function
  | Coq_inl ia ->
      let Coq_existT (x0, s) = ia __ __ in
      let Coq_existT (f, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (f , b.fn.choose)), __)))
  | Coq_inr p ->
      let sia , ib = p in
      let Coq_existT (a0, s) = sia __ __ in
      let Coq_existT (g, _) = s in
      let Coq_existT (x0, s0) = ib __ __ in
      let Coq_existT (f, _) = s0 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (g , f)), __)))

(** val strictInflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    (coq_StrictInflationary_comp * (coq_Inflationary_comp,
    coq_StrictInflationary_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let strictInflationary_comp a b = function
  | sia , s ->
      (match s with
         | Coq_inl ia ->
             let Coq_existT (b0, s0) = ia __ __ in
             let Coq_existT (k, _) = s0 in
             Coq_existT ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (k , b.fn.choose)), __)))
         | Coq_inr sib ->
             let Coq_existT (a0, s0) = sia __ __ in
             let Coq_existT (g, _) = s0 in
             let Coq_existT (b0, s1) = sib __ __ in
             let Coq_existT (k, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b0)), (Coq_existT
             ((Obj.magic (g , k)), __))))

(** val strictDeflationary_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform ->
    (coq_StrictDeflationary_comp * (coq_Deflationary_comp,
    coq_StrictDeflationary_comp) sum) -> (carrier, (carrier, __) sigT) sigT **)

let strictDeflationary_comp a b = function
  | sia , s ->
      (match s with
         | Coq_inl ia ->
             let Coq_existT (b0, s0) = ia __ __ in
             let Coq_existT (k, _) = s0 in
             Coq_existT ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (k , b.fn.choose)), __)))
         | Coq_inr sib ->
             let Coq_existT (a0, s0) = sia __ __ in
             let Coq_existT (g, _) = s0 in
             let Coq_existT (b0, s1) = sib __ __ in
             let Coq_existT (k, _) = s1 in
             Coq_existT ((Obj.magic (a0 , b0)), (Coq_existT
             ((Obj.magic (g , k)), __))))

(** val hasId_back_a :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    coq_HasIdentity **)

let hasId_back_a a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (ida, __)

(** val hasId_back_b :
    coq_SemigroupTransform -> coq_SemigroupTransform -> coq_HasIdentity ->
    coq_HasIdentity **)

let hasId_back_b a b = function
  | Coq_existT (x0, x1) ->
      let ida , idb = Obj.magic x0 in Coq_existT (idb, __)

(** val strict_comp :
    coq_SemigroupTransform -> coq_SemigroupTransform -> (coq_Strict_comp,
    coq_Strict_comp) sum -> coq_Strict_comp **)

let strict_comp a b x hasId =
  match x with
    | Coq_inl sta ->
        let Coq_existT (f, _) =
          sta
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (ida, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (f , b.fn.choose)), __)
    | Coq_inr stb ->
        let Coq_existT (f, _) =
          stb
            (let Coq_existT (x0, x1) = hasId in
            let ida , idb = Obj.magic x0 in Coq_existT (idb, __))
        in
        let Coq_existT (x0, x1) = hasId in
        let ida , idb = Obj.magic x0 in
        Coq_existT ((Obj.magic (a.fn.choose , f)), __)

