open Datatypes
open DecSetoid
open DecSetoidProperties
open Logic0
open Product
open Semigroup
open SemigroupProperties
open Specif

type coq_LexComp =
  | Coq_equiv
  | Coq_less
  | Coq_more
  | Coq_none

val coq_LexComp_rect : 'a1 -> 'a1 -> 'a1 -> 'a1 -> coq_LexComp -> 'a1

val coq_LexComp_rec : 'a1 -> 'a1 -> 'a1 -> 'a1 -> coq_LexComp -> 'a1

val lexComp : coq_Semigroup -> carrier -> carrier -> coq_LexComp

val lexOp : coq_Semigroup -> coq_Semigroup -> carrier -> carrier -> carrier

val swapComp : coq_LexComp -> coq_LexComp

val lex_case : coq_Semigroup -> carrier -> carrier -> sumbool sumor

val selLexSemigroup : coq_Semigroup -> coq_Semigroup -> coq_Semigroup

val isIdempotent_comp :
  coq_Semigroup -> coq_Semigroup -> coq_IsIdempotent_comp ->
  coq_IsIdempotent_comp

val isSelective_comp :
  coq_Semigroup -> coq_Semigroup -> coq_IsSelective_comp ->
  coq_IsSelective_comp

val isCommutative_comp :
  coq_Semigroup -> coq_Semigroup -> coq_IsCommutative_comp ->
  coq_IsCommutative_comp

val hasIdentity :
  coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity * coq_HasIdentity) ->
  coq_HasIdentity

val hasIdentity_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_HasIdentity_comp,
  coq_HasIdentity_comp) sum -> coq_HasIdentity_comp

val hasAnnihilator :
  coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator * coq_HasAnnihilator)
  -> coq_HasAnnihilator

val hasAnnihilator_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_HasAnnihilator_comp,
  coq_HasAnnihilator_comp) sum -> coq_HasAnnihilator_comp

val isLeft_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp, coq_IsLeft_comp)
  sum -> coq_IsLeft_comp

val isRight_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp, coq_IsRight_comp)
  sum -> coq_IsRight_comp

val leftCondensed_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
  coq_LeftCondensed_comp) sum -> coq_LeftCondensed_comp

val rightCondensed_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
  coq_RightCondensed_comp) sum -> coq_RightCondensed_comp

val leftCancelative_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp * (coq_IsSingleton,
  coq_IsSingleton_comp) sum, coq_LeftCancelative_comp) sum ->
  coq_LeftCancelative_comp

val rightCancelative_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp * (coq_IsSingleton,
  coq_IsSingleton_comp) sum, coq_RightCancelative_comp) sum ->
  coq_RightCancelative_comp

val antiRight_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp,
  coq_AntiRight_comp) sum -> coq_AntiRight_comp

val antiLeft_comp :
  coq_Semigroup -> coq_Semigroup -> (coq_IsSingleton_comp, coq_AntiLeft_comp)
  sum -> coq_AntiLeft_comp

