open Compare_dec
open Datatypes
open DecSetoid
open DecSetoidProperties
open EqNat
open Peano
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val eq_range : nat -> nat -> nat -> bool **)

let eq_range n x y =
  if leb n x then if leb n y then true else beq_nat x y else beq_nat x y

(** val rangeDecSetoid : nat -> coq_DecSetoid **)

let rangeDecSetoid n =
  { choose = (Obj.magic O); equal = (Obj.magic (eq_range n)) }

(** val reverseRangeDsIso : nat -> coq_DsIso **)

let reverseRangeDsIso n =
  { phi = (fun x -> Obj.magic (minus n (Obj.magic x))); phi' = (fun x ->
    Obj.magic (minus n (Obj.magic x))) }

(** val range0DsIso : coq_DsIso **)

let range0DsIso =
  { phi = (fun x -> Obj.magic ()); phi' = (fun x -> Obj.magic O) }

(** val range1DsIso : coq_DsIso **)

let range1DsIso =
  { phi = (fun x ->
    Obj.magic (negb ((rangeDecSetoid (S O)).equal x (Obj.magic O)))); phi' =
    (fun x -> if Obj.magic x then Obj.magic (S O) else Obj.magic O) }

(** val isSingleton_comp : nat -> coq_IsSingleton_comp **)

let isSingleton_comp n c =
  match Obj.magic c with
    | O -> Coq_existT ((Obj.magic (S O)), __)
    | S x -> Coq_existT ((Obj.magic O), __)

(** val twoElements_comp : nat -> coq_TwoElements_comp **)

let twoElements_comp n a b =
  match Obj.magic a with
    | O ->
        (match Obj.magic b with
           | O -> Coq_existT ((Obj.magic (S O)), __)
           | S n0 ->
               (match n0 with
                  | O -> Coq_existT ((Obj.magic (S (S O))), __)
                  | S y -> Coq_existT ((Obj.magic (S O)), __)))
    | S n0 ->
        (match n0 with
           | O ->
               (match Obj.magic b with
                  | O -> Coq_existT ((Obj.magic (S (S O))), __)
                  | S n1 -> Coq_existT ((Obj.magic O), __))
           | S x ->
               (match Obj.magic b with
                  | O -> Coq_existT ((Obj.magic (S O)), __)
                  | S n1 -> Coq_existT ((Obj.magic O), __)))

(** val seq : nat -> nat list **)

let rec seq = function
  | O -> O :: []
  | S n0 -> (S n0) :: (seq n0)

(** val finite : nat -> coq_Finite **)

let finite n =
  Coq_existT ((Obj.magic (seq n)), __)

