open Datatypes
open DecSetoid
open DecSetoidProperties
open List0
open Logic0
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val eq_prod :
    coq_DecSetoid -> coq_DecSetoid -> (carrier * carrier) -> (carrier *
    carrier) -> bool **)

let eq_prod a b x y =
  let x1 , x2 = x in
  let y1 , y2 = y in if a.equal x1 y1 then b.equal x2 y2 else false

(** val prodDecSetoid : coq_DecSetoid -> coq_DecSetoid -> coq_DecSetoid **)

let prodDecSetoid a b =
  { choose = (Obj.magic (a.choose , b.choose)); equal =
    (Obj.magic (eq_prod a b)) }

(** val singA_DsIso :
    coq_DecSetoid -> coq_DecSetoid -> coq_IsSingleton -> coq_DsIso **)

let singA_DsIso a b = function
  | Coq_existT (a0, _) -> { phi = (fun x0 ->
      let x1 , x2 = Obj.magic x0 in x2); phi' = (fun x0 ->
      Obj.magic (a0 , x0)) }

(** val singB_DsIso :
    coq_DecSetoid -> coq_DecSetoid -> coq_IsSingleton -> coq_DsIso **)

let singB_DsIso a b = function
  | Coq_existT (b0, _) -> { phi = (fun x0 ->
      let x1 , x2 = Obj.magic x0 in x1); phi' = (fun x0 ->
      Obj.magic (x0 , b0)) }

(** val isSingleton :
    coq_DecSetoid -> coq_DecSetoid -> (coq_IsSingleton * coq_IsSingleton) ->
    coq_IsSingleton **)

let isSingleton a b = function
  | i , x0 ->
      let Coq_existT (a0, _) = i in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val isSingleton_comp :
    coq_DecSetoid -> coq_DecSetoid -> (coq_IsSingleton_comp,
    coq_IsSingleton_comp) sum -> coq_IsSingleton_comp **)

let isSingleton_comp a b x c =
  match x with
    | Coq_inl sa ->
        let x1 , x2 = Obj.magic c in
        let Coq_existT (y, _) = sa x1 in
        Coq_existT ((Obj.magic (y , x2)), __)
    | Coq_inr sb ->
        let x1 , x2 = Obj.magic c in
        let Coq_existT (y, _) = sb x2 in
        Coq_existT ((Obj.magic (x1 , y)), __)

(** val twoElements :
    coq_DecSetoid -> coq_DecSetoid -> (coq_IsSingleton * coq_TwoElements,
    coq_IsSingleton * coq_TwoElements) sum -> coq_TwoElements **)

let twoElements a b = function
  | Coq_inl p ->
      let i , x0 = p in
      let Coq_existT (a0, _) = i in
      let Coq_existT (b1, s) = x0 in
      let Coq_existT (b2, _) = s in
      Coq_existT ((Obj.magic (a0 , b1)), (Coq_existT (
      (Obj.magic (a0 , b2)), __)))
  | Coq_inr p ->
      let i , x0 = p in
      let Coq_existT (b0, _) = i in
      let Coq_existT (a1, s) = x0 in
      let Coq_existT (a2, _) = s in
      Coq_existT ((Obj.magic (a1 , b0)), (Coq_existT (
      (Obj.magic (a2 , b0)), __)))

(** val twoElements_comp :
    coq_DecSetoid -> coq_DecSetoid -> ((coq_IsSingleton_comp,
    coq_TwoElements_comp) sum * (coq_IsSingleton_comp, coq_TwoElements_comp)
    sum) -> coq_TwoElements_comp **)

let twoElements_comp a b x a0 b0 =
  let s , x0 = x in
  (match s with
     | Coq_inl sa ->
         (match x0 with
            | Coq_inl sb ->
                let x1 , x2 = Obj.magic a0 in
                let y1 , y2 = Obj.magic b0 in
                let Coq_existT (w, _) = copy_var (a.equal x1 y1) in
                if w
                then let Coq_existT (w0, _) = copy_var (b.equal x2 y2) in
                     if w0
                     then Coq_existT ((Obj.magic (a.choose , b.choose)), __)
                     else let Coq_existT (c, _) = sa x1 in
                          Coq_existT ((Obj.magic (c , x2)), __)
                else let Coq_existT (w0, _) = copy_var (b.equal x2 y2) in
                     let Coq_existT (c, _) = sb x2 in
                     Coq_existT ((Obj.magic (x1 , c)), __)
            | Coq_inr ta ->
                let x1 , x2 = Obj.magic a0 in
                let y1 , y2 = Obj.magic b0 in
                let Coq_existT (w, _) = copy_var (a.equal x1 y1) in
                if w
                then let Coq_existT (c, _) = sa x1 in
                     Coq_existT ((Obj.magic (c , b.choose)), __)
                else let Coq_existT (c, _) = ta x1 y1 in
                     Coq_existT ((Obj.magic (c , b.choose)), __))
     | Coq_inr tb ->
         (match x0 with
            | Coq_inl sb ->
                let x1 , x2 = Obj.magic a0 in
                let y1 , y2 = Obj.magic b0 in
                let Coq_existT (w, _) = copy_var (b.equal x2 y2) in
                if w
                then let Coq_existT (c, _) = sb x2 in
                     Coq_existT ((Obj.magic (a.choose , c)), __)
                else let Coq_existT (c, _) = tb x2 y2 in
                     Coq_existT ((Obj.magic (a.choose , c)), __)
            | Coq_inr ta ->
                let x1 , x2 = Obj.magic a0 in
                let y1 , y2 = Obj.magic b0 in
                let Coq_existT (w, _) = copy_var (a.equal x1 y1) in
                if w
                then let Coq_existT (w0, _) = copy_var (b.equal x2 y2) in
                     if w0
                     then Coq_existT ((Obj.magic (a.choose , b.choose)), __)
                     else let Coq_existT (c, _) = tb x2 y2 in
                          Coq_existT ((Obj.magic (a.choose , c)), __)
                else let Coq_existT (w0, _) = copy_var (b.equal x2 y2) in
                     let Coq_existT (c, _) = ta x1 y1 in
                     Coq_existT ((Obj.magic (c , b.choose)), __)))

(** val finite :
    coq_DecSetoid -> coq_DecSetoid -> (coq_Finite * coq_Finite) -> coq_Finite **)

let finite a b = function
  | f , x0 ->
      let Coq_existT (la, _) = f in
      let Coq_existT (lb, _) = x0 in
      Coq_existT ((Obj.magic (list_prod la lb)), __)

(** val finite_comp :
    coq_DecSetoid -> coq_DecSetoid -> (coq_Finite_comp, coq_Finite_comp) sum
    -> coq_Finite_comp **)

let finite_comp a b x l =
  match x with
    | Coq_inl fa ->
        let Coq_existT (w, _) = copy_var (split (Obj.magic l)) in
        let l0 , l1 = w in
        let Coq_existT (x0, _) = fa l0 in
        Coq_existT ((Obj.magic (x0 , b.choose)), __)
    | Coq_inr fb ->
        let Coq_existT (w, _) = copy_var (split (Obj.magic l)) in
        let l0 , l1 = w in
        let Coq_existT (x0, _) = fb l1 in
        Coq_existT ((Obj.magic (a.choose , x0)), __)

