open Datatypes
open List0
open Syntax

type __ = Obj.t

type ocamlTypes =
  | Ocm_unit
  | Ocm_int
  | Ocm_bool
  | Ocm_sum of ocamlTypes * ocamlTypes
  | Ocm_prod of ocamlTypes * ocamlTypes
  | Ocm_list of ocamlTypes

val ocamlTypes_rect :
  'a1 -> 'a1 -> 'a1 -> (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) ->
  (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) -> (ocamlTypes -> 'a1 ->
  'a1) -> ocamlTypes -> 'a1

val ocamlTypes_rec :
  'a1 -> 'a1 -> 'a1 -> (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) ->
  (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) -> (ocamlTypes -> 'a1 ->
  'a1) -> ocamlTypes -> 'a1

type ocmType = __

val otDS : coq_DS -> ocamlTypes

val otSG : coq_SG -> ocamlTypes

val otPO : coq_PO -> ocamlTypes

val otOS : coq_OS -> ocamlTypes

val otBS : coq_BS -> ocamlTypes

val otTF : coq_TF -> ocamlTypes

val otST : coq_ST -> ocamlTypes

val otLang : coq_Lang -> ocamlTypes

type ('t, ' t') splitMono = { mono : ('t -> ' t'); mono_inv : (' t' -> 't) }

val splitMono_rect :
  (('a1 -> 'a2) -> ('a2 -> 'a1) -> __ -> 'a3) -> ('a1, 'a2) splitMono -> 'a3

val splitMono_rec :
  (('a1 -> 'a2) -> ('a2 -> 'a1) -> __ -> 'a3) -> ('a1, 'a2) splitMono -> 'a3

val mono : ('a1, 'a2) splitMono -> 'a1 -> 'a2

val mono_inv : ('a1, 'a2) splitMono -> 'a2 -> 'a1

type ast =
  | Ast_unit
  | Ast_bool of bool
  | Ast_int of nat
  | Ast_inl of ast
  | Ast_inr of ast
  | Ast_prod of ast * ast
  | Ast_list of ast list

val ast_rect :
  'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ast -> 'a1 -> 'a1) -> (ast -> 'a1
  -> 'a1) -> (ast -> 'a1 -> ast -> 'a1 -> 'a1) -> (ast list -> 'a1) -> ast ->
  'a1

val ast_rec :
  'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ast -> 'a1 -> 'a1) -> (ast -> 'a1
  -> 'a1) -> (ast -> 'a1 -> ast -> 'a1 -> 'a1) -> (ast list -> 'a1) -> ast ->
  'a1

type wfAst =
  | WfAst_unit
  | WfAst_bool of bool
  | WfAst_int of nat
  | WfAst_inl of ocamlTypes * ocamlTypes * wfAst
  | WfAst_inr of ocamlTypes * ocamlTypes * wfAst
  | WfAst_prod of ocamlTypes * ocamlTypes * wfAst * wfAst
  | WfAst_list of ocamlTypes * wfAst list

val wfAst_rect :
  'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst
  -> 'a1 -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> 'a1) ->
  (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> wfAst -> 'a1 -> 'a1) ->
  (ocamlTypes -> wfAst list -> 'a1) -> ocamlTypes -> wfAst -> 'a1

val wfAst_rec :
  'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst
  -> 'a1 -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> 'a1) ->
  (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> wfAst -> 'a1 -> 'a1) ->
  (ocamlTypes -> wfAst list -> 'a1) -> ocamlTypes -> wfAst -> 'a1

val ast_forget : ocamlTypes -> wfAst -> ast

val ast_typecheck : ocamlTypes -> ast -> bool

type notWT =
  | NotWT of ast * ocamlTypes

val notWT_rect : (ast -> ocamlTypes -> 'a1) -> notWT -> 'a1

val notWT_rec : (ast -> ocamlTypes -> 'a1) -> notWT -> 'a1

val ast_wfAst : ocamlTypes -> ast -> (wfAst, notWT) sum

val toAst : ocamlTypes -> ocmType -> wfAst

val fromAst : ocamlTypes -> wfAst -> ocmType

val ast_to_ocmType : ocamlTypes -> ast -> (ocmType, notWT) sum

val ocmType_to_ast : ocamlTypes -> ocmType -> ast

val astSplitMono : ocamlTypes -> (ocmType, wfAst) splitMono

