open Datatypes
open List0
open Syntax

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type ocamlTypes =
  | Ocm_unit
  | Ocm_int
  | Ocm_bool
  | Ocm_sum of ocamlTypes * ocamlTypes
  | Ocm_prod of ocamlTypes * ocamlTypes
  | Ocm_list of ocamlTypes

(** val ocamlTypes_rect :
    'a1 -> 'a1 -> 'a1 -> (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) ->
    (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) -> (ocamlTypes -> 'a1 ->
    'a1) -> ocamlTypes -> 'a1 **)

let rec ocamlTypes_rect f f0 f1 f2 f3 f4 = function
  | Ocm_unit -> f
  | Ocm_int -> f0
  | Ocm_bool -> f1
  | Ocm_sum (o0, o1) ->
      f2 o0 (ocamlTypes_rect f f0 f1 f2 f3 f4 o0) o1
        (ocamlTypes_rect f f0 f1 f2 f3 f4 o1)
  | Ocm_prod (o0, o1) ->
      f3 o0 (ocamlTypes_rect f f0 f1 f2 f3 f4 o0) o1
        (ocamlTypes_rect f f0 f1 f2 f3 f4 o1)
  | Ocm_list o0 -> f4 o0 (ocamlTypes_rect f f0 f1 f2 f3 f4 o0)

(** val ocamlTypes_rec :
    'a1 -> 'a1 -> 'a1 -> (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) ->
    (ocamlTypes -> 'a1 -> ocamlTypes -> 'a1 -> 'a1) -> (ocamlTypes -> 'a1 ->
    'a1) -> ocamlTypes -> 'a1 **)

let rec ocamlTypes_rec f f0 f1 f2 f3 f4 = function
  | Ocm_unit -> f
  | Ocm_int -> f0
  | Ocm_bool -> f1
  | Ocm_sum (o0, o1) ->
      f2 o0 (ocamlTypes_rec f f0 f1 f2 f3 f4 o0) o1
        (ocamlTypes_rec f f0 f1 f2 f3 f4 o1)
  | Ocm_prod (o0, o1) ->
      f3 o0 (ocamlTypes_rec f f0 f1 f2 f3 f4 o0) o1
        (ocamlTypes_rec f f0 f1 f2 f3 f4 o1)
  | Ocm_list o0 -> f4 o0 (ocamlTypes_rec f f0 f1 f2 f3 f4 o0)

type ocmType = __

(** val otDS : coq_DS -> ocamlTypes **)

let rec otDS = function
  | Coq_dAddConstant x -> Ocm_sum ((otDS x), Ocm_unit)
  | Coq_dBool -> Ocm_bool
  | Coq_dProduct (x, y) -> Ocm_prod ((otDS x), (otDS y))
  | Coq_dUnion (x, y) -> Ocm_sum ((otDS x), (otDS y))
  | Coq_dUnit -> Ocm_unit
  | Coq_dFSets x -> Ocm_list (otDS x)
  | Coq_dFMinSets x -> Ocm_list (otPO x)
  | Coq_dSeq x -> Ocm_list (otDS x)
  | Coq_dSimpleSeq x -> Ocm_list (otDS x)
  | Coq_dMultiSets x -> Ocm_list (otDS x)
  | _ -> Ocm_int

(** val otSG : coq_SG -> ocamlTypes **)

and otSG = function
  | Coq_sBoolAnd -> Ocm_bool
  | Coq_sBoolOr -> Ocm_bool
  | Coq_sLex (x, y) -> Ocm_prod ((otSG x), (otSG y))
  | Coq_sProduct (x, y) -> Ocm_prod ((otSG x), (otSG y))
  | Coq_sTopUnion (x, y) -> Ocm_sum ((Ocm_sum ((otSG x), 
      (otSG y))), Ocm_unit)
  | Coq_sUnion (x, y) -> Ocm_sum ((otSG x), (otSG y))
  | Coq_sUnionSwap (x, y) -> Ocm_sum ((otSG y), (otSG x))
  | Coq_sUnit -> Ocm_unit
  | Coq_sFSetsIntersect x -> Ocm_list (otDS x)
  | Coq_sFSetsUnion x -> Ocm_list (otDS x)
  | Coq_sFSetsOp x -> Ocm_list (otSG x)
  | Coq_sFMinSetsUnion x -> Ocm_list (otPO x)
  | Coq_sFMinSetsOp x -> Ocm_list (otOS x)
  | Coq_sLeft x -> otDS x
  | Coq_sRight x -> otDS x
  | Coq_sSelLex (x, y) -> Ocm_prod ((otSG x), (otSG y))
  | Coq_sSeq x -> Ocm_list (otDS x)
  | Coq_sSimpleSeq x -> Ocm_list (otDS x)
  | Coq_sPrefix x -> Ocm_list (otDS x)
  | Coq_sPostfix x -> Ocm_list (otDS x)
  | Coq_sRevOp x -> otSG x
  | Coq_sMultiSetsUnion x -> Ocm_list (otDS x)
  | Coq_sMultiSetsIntersect x -> Ocm_list (otDS x)
  | _ -> Ocm_int

(** val otPO : coq_PO -> ocamlTypes **)

and otPO = function
  | Coq_pDual x -> otPO x
  | Coq_pLeftNaturalOrder x -> otSG x
  | Coq_pRightNaturalOrder x -> otSG x
  | Coq_pLex (x, y) -> Ocm_prod ((otPO x), (otPO y))
  | Coq_pNatLe -> Ocm_int
  | Coq_pAnnTop x -> otSG x

(** val otOS : coq_OS -> ocamlTypes **)

and otOS = function
  | Coq_oDual x -> otOS x
  | Coq_oLeftNaturalOrder x -> otSG x
  | Coq_oRightNaturalOrder x -> otSG x
  | Coq_oLex (x, y) -> Ocm_prod ((otOS x), (otOS y))
  | Coq_oBsLeftNaturalOrder x -> otBS x
  | Coq_oSimpleSeq x -> Ocm_list (otDS x)

(** val otBS : coq_BS -> ocamlTypes **)

and otBS = function
  | Coq_bUnit -> Ocm_unit
  | Coq_bBoolOrAnd -> Ocm_bool
  | Coq_bNatIMaxPlus -> Ocm_sum (Ocm_unit, Ocm_int)
  | Coq_bNatIMinPlus -> Ocm_sum (Ocm_unit, Ocm_int)
  | Coq_bNatIMaxMin -> Ocm_sum (Ocm_unit, Ocm_int)
  | Coq_bSwap x -> otBS x
  | Coq_bFMinSets x -> Ocm_list (otOS x)
  | Coq_bFMinSetsOpUnion x -> Ocm_list (otOS x)
  | Coq_bFSets x -> Ocm_list (otDS x)
  | Coq_bFSetsOp x -> Ocm_list (otSG x)
  | Coq_bLex (x, y) -> Ocm_prod ((otBS x), (otBS y))
  | Coq_bProduct (x, y) -> Ocm_prod ((otBS x), (otBS y))
  | Coq_bLeft x -> otSG x
  | Coq_bAddZero x -> Ocm_sum ((otBS x), Ocm_unit)
  | Coq_bAddOne x -> Ocm_sum (Ocm_unit, (otBS x))
  | Coq_bSelLex (x, y) -> Ocm_prod ((otBS x), (otBS y))
  | Coq_bRevTimes x -> otBS x
  | Coq_bPrefixSeq x -> Ocm_list (otDS x)
  | Coq_bPostfixSeq x -> Ocm_list (otDS x)
  | Coq_bMultiSets x -> Ocm_list (otDS x)
  | _ -> Ocm_int

(** val otTF : coq_TF -> ocamlTypes **)

let rec otTF = function
  | Coq_tId x0 -> otDS x0
  | Coq_tReplace x0 -> otDS x0
  | Coq_tProduct (x0, y) -> Ocm_prod ((otTF x0), (otTF y))
  | Coq_tUnion (x0, y) -> otTF x0
  | Coq_tCayley x0 -> otSG x0

(** val otST : coq_ST -> ocamlTypes **)

let rec otST = function
  | Coq_stLeft x0 -> otSG x0
  | Coq_stRight x0 -> otSG x0
  | Coq_stLex (x0, y) -> Ocm_prod ((otST x0), (otST y))
  | Coq_stSelLex (x0, y) -> Ocm_prod ((otST x0), (otST y))
  | Coq_stUnion (x0, y) -> otST x0
  | Coq_stCayley x0 -> otBS x0

(** val otLang : coq_Lang -> ocamlTypes **)

let otLang = function
  | Coq_dsInc x0 -> otDS x0
  | Coq_sgInc x0 -> otSG x0
  | Coq_poInc x0 -> otPO x0
  | Coq_osInc x0 -> otOS x0
  | Coq_bsInc x0 -> otBS x0
  | Coq_tfInc x0 -> otTF x0
  | Coq_stInc x0 -> otST x0

type ('t, ' t') splitMono = { mono : ('t -> ' t'); mono_inv : (' t' -> 't) }

(** val splitMono_rect :
    (('a1 -> 'a2) -> ('a2 -> 'a1) -> __ -> 'a3) -> ('a1, 'a2) splitMono ->
    'a3 **)

let splitMono_rect f s =
  let { mono = x; mono_inv = x0 } = s in f x x0 __

(** val splitMono_rec :
    (('a1 -> 'a2) -> ('a2 -> 'a1) -> __ -> 'a3) -> ('a1, 'a2) splitMono ->
    'a3 **)

let splitMono_rec f s =
  let { mono = x; mono_inv = x0 } = s in f x x0 __

(** val mono : ('a1, 'a2) splitMono -> 'a1 -> 'a2 **)

let mono x = x.mono

(** val mono_inv : ('a1, 'a2) splitMono -> 'a2 -> 'a1 **)

let mono_inv x = x.mono_inv

type ast =
  | Ast_unit
  | Ast_bool of bool
  | Ast_int of nat
  | Ast_inl of ast
  | Ast_inr of ast
  | Ast_prod of ast * ast
  | Ast_list of ast list

(** val ast_rect :
    'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ast -> 'a1 -> 'a1) -> (ast ->
    'a1 -> 'a1) -> (ast -> 'a1 -> ast -> 'a1 -> 'a1) -> (ast list -> 'a1) ->
    ast -> 'a1 **)

let rec ast_rect f f0 f1 f2 f3 f4 f5 = function
  | Ast_unit -> f
  | Ast_bool b -> f0 b
  | Ast_int n -> f1 n
  | Ast_inl a0 -> f2 a0 (ast_rect f f0 f1 f2 f3 f4 f5 a0)
  | Ast_inr a0 -> f3 a0 (ast_rect f f0 f1 f2 f3 f4 f5 a0)
  | Ast_prod (a0, a1) ->
      f4 a0 (ast_rect f f0 f1 f2 f3 f4 f5 a0) a1
        (ast_rect f f0 f1 f2 f3 f4 f5 a1)
  | Ast_list l -> f5 l

(** val ast_rec :
    'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ast -> 'a1 -> 'a1) -> (ast ->
    'a1 -> 'a1) -> (ast -> 'a1 -> ast -> 'a1 -> 'a1) -> (ast list -> 'a1) ->
    ast -> 'a1 **)

let rec ast_rec f f0 f1 f2 f3 f4 f5 = function
  | Ast_unit -> f
  | Ast_bool b -> f0 b
  | Ast_int n -> f1 n
  | Ast_inl a0 -> f2 a0 (ast_rec f f0 f1 f2 f3 f4 f5 a0)
  | Ast_inr a0 -> f3 a0 (ast_rec f f0 f1 f2 f3 f4 f5 a0)
  | Ast_prod (a0, a1) ->
      f4 a0 (ast_rec f f0 f1 f2 f3 f4 f5 a0) a1
        (ast_rec f f0 f1 f2 f3 f4 f5 a1)
  | Ast_list l -> f5 l

type wfAst =
  | WfAst_unit
  | WfAst_bool of bool
  | WfAst_int of nat
  | WfAst_inl of ocamlTypes * ocamlTypes * wfAst
  | WfAst_inr of ocamlTypes * ocamlTypes * wfAst
  | WfAst_prod of ocamlTypes * ocamlTypes * wfAst * wfAst
  | WfAst_list of ocamlTypes * wfAst list

(** val wfAst_rect :
    'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ocamlTypes -> ocamlTypes ->
    wfAst -> 'a1 -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> 'a1)
    -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> wfAst -> 'a1 -> 'a1) ->
    (ocamlTypes -> wfAst list -> 'a1) -> ocamlTypes -> wfAst -> 'a1 **)

let rec wfAst_rect f f0 f1 f2 f3 f4 f5 o = function
  | WfAst_unit -> f
  | WfAst_bool b -> f0 b
  | WfAst_int n -> f1 n
  | WfAst_inl (t1, t2, w0) ->
      f2 t1 t2 w0 (wfAst_rect f f0 f1 f2 f3 f4 f5 t1 w0)
  | WfAst_inr (t1, t2, w0) ->
      f3 t1 t2 w0 (wfAst_rect f f0 f1 f2 f3 f4 f5 t2 w0)
  | WfAst_prod (t1, t2, w0, w1) ->
      f4 t1 t2 w0 (wfAst_rect f f0 f1 f2 f3 f4 f5 t1 w0) w1
        (wfAst_rect f f0 f1 f2 f3 f4 f5 t2 w1)
  | WfAst_list (t, l) -> f5 t l

(** val wfAst_rec :
    'a1 -> (bool -> 'a1) -> (nat -> 'a1) -> (ocamlTypes -> ocamlTypes ->
    wfAst -> 'a1 -> 'a1) -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> 'a1)
    -> (ocamlTypes -> ocamlTypes -> wfAst -> 'a1 -> wfAst -> 'a1 -> 'a1) ->
    (ocamlTypes -> wfAst list -> 'a1) -> ocamlTypes -> wfAst -> 'a1 **)

let rec wfAst_rec f f0 f1 f2 f3 f4 f5 o = function
  | WfAst_unit -> f
  | WfAst_bool b -> f0 b
  | WfAst_int n -> f1 n
  | WfAst_inl (t1, t2, w0) ->
      f2 t1 t2 w0 (wfAst_rec f f0 f1 f2 f3 f4 f5 t1 w0)
  | WfAst_inr (t1, t2, w0) ->
      f3 t1 t2 w0 (wfAst_rec f f0 f1 f2 f3 f4 f5 t2 w0)
  | WfAst_prod (t1, t2, w0, w1) ->
      f4 t1 t2 w0 (wfAst_rec f f0 f1 f2 f3 f4 f5 t1 w0) w1
        (wfAst_rec f f0 f1 f2 f3 f4 f5 t2 w1)
  | WfAst_list (t, l) -> f5 t l

(** val ast_forget : ocamlTypes -> wfAst -> ast **)

let rec ast_forget t = function
  | WfAst_unit -> Ast_unit
  | WfAst_bool b -> Ast_bool b
  | WfAst_int n -> Ast_int n
  | WfAst_inl (t1, t2, x0) -> Ast_inl (ast_forget t1 x0)
  | WfAst_inr (t1, t2, x0) -> Ast_inr (ast_forget t2 x0)
  | WfAst_prod (t1, t2, x0, y) -> Ast_prod ((ast_forget t1 x0),
      (ast_forget t2 y))
  | WfAst_list (t0, l) -> Ast_list (map (ast_forget t0) l)

(** val ast_typecheck : ocamlTypes -> ast -> bool **)

let rec ast_typecheck t x =
  match t with
    | Ocm_unit -> (match x with
                     | Ast_unit -> true
                     | _ -> false)
    | Ocm_int -> (match x with
                    | Ast_int n -> true
                    | _ -> false)
    | Ocm_bool -> (match x with
                     | Ast_bool b -> true
                     | _ -> false)
    | Ocm_sum (t1, t2) ->
        (match x with
           | Ast_inl x0 -> ast_typecheck t1 x0
           | Ast_inr x0 -> ast_typecheck t2 x0
           | _ -> false)
    | Ocm_prod (t1, t2) ->
        (match x with
           | Ast_prod (x0, y) ->
               if ast_typecheck t1 x0 then ast_typecheck t2 x0 else false
           | _ -> false)
    | Ocm_list t1 ->
        (match x with
           | Ast_list l -> forallb (ast_typecheck t) l
           | _ -> false)

type notWT =
  | NotWT of ast * ocamlTypes

(** val notWT_rect : (ast -> ocamlTypes -> 'a1) -> notWT -> 'a1 **)

let notWT_rect f = function
  | NotWT (x, x0) -> f x x0

(** val notWT_rec : (ast -> ocamlTypes -> 'a1) -> notWT -> 'a1 **)

let notWT_rec f = function
  | NotWT (x, x0) -> f x x0

(** val ast_wfAst : ocamlTypes -> ast -> (wfAst, notWT) sum **)

let rec ast_wfAst t x =
  match t with
    | Ocm_unit ->
        (match x with
           | Ast_unit -> Coq_inl WfAst_unit
           | _ -> Coq_inr (NotWT (x, Ocm_unit)))
    | Ocm_int ->
        (match x with
           | Ast_int i -> Coq_inl (WfAst_int i)
           | _ -> Coq_inr (NotWT (x, Ocm_int)))
    | Ocm_bool ->
        (match x with
           | Ast_bool b -> Coq_inl (WfAst_bool b)
           | _ -> Coq_inr (NotWT (x, Ocm_bool)))
    | Ocm_sum (t1, t2) ->
        (match x with
           | Ast_inl x0 ->
               (match ast_wfAst t1 x0 with
                  | Coq_inl x1 -> Coq_inl (WfAst_inl (t1, t2, x1))
                  | Coq_inr e -> Coq_inr e)
           | Ast_inr x0 ->
               (match ast_wfAst t2 x0 with
                  | Coq_inl x1 -> Coq_inl (WfAst_inr (t1, t2, x1))
                  | Coq_inr e -> Coq_inr e)
           | _ -> Coq_inr (NotWT (x, (Ocm_sum (t1, t2)))))
    | Ocm_prod (t1, t2) ->
        (match x with
           | Ast_prod (x0, y) ->
               (match ast_wfAst t1 x0 with
                  | Coq_inl x1 ->
                      (match ast_wfAst t2 y with
                         | Coq_inl y0 -> Coq_inl (WfAst_prod (t1, t2, x1,
                             y0))
                         | Coq_inr t0 -> Coq_inr t0)
                  | Coq_inr t0 -> Coq_inr t0)
           | _ -> Coq_inr (NotWT (x, (Ocm_prod (t1, t2)))))
    | Ocm_list t1 ->
        (match x with
           | Ast_list l ->
               (match fold_right (fun x0 l0 ->
                        match l0 with
                          | Coq_inl l1 ->
                              (match ast_wfAst t1 x0 with
                                 | Coq_inl x1 -> Coq_inl (x1 ::
                                     (Obj.magic l1))
                                 | Coq_inr e -> Coq_inr e)
                          | Coq_inr e -> Coq_inr e) (Coq_inl []) l with
                  | Coq_inl l0 -> Coq_inl (WfAst_list (t1, l0))
                  | Coq_inr e -> Coq_inr e)
           | _ -> Coq_inr (NotWT (x, (Ocm_list t1))))

(** val toAst : ocamlTypes -> ocmType -> wfAst **)

let rec toAst t x =
  match t with
    | Ocm_unit -> let () = Obj.magic x in WfAst_unit
    | Ocm_int -> WfAst_int (Obj.magic x)
    | Ocm_bool -> WfAst_bool (Obj.magic x)
    | Ocm_sum (t1, t2) ->
        (match Obj.magic x with
           | Coq_inl x0 -> WfAst_inl (t1, t2, (toAst t1 x0))
           | Coq_inr x0 -> WfAst_inr (t1, t2, (toAst t2 x0)))
    | Ocm_prod (t1, t2) ->
        let x0 , y = Obj.magic x in
        WfAst_prod (t1, t2, (toAst t1 x0), (toAst t2 y))
    | Ocm_list t0 -> WfAst_list (t0, (map (toAst t0) (Obj.magic x)))

(** val fromAst : ocamlTypes -> wfAst -> ocmType **)

let rec fromAst t = function
  | WfAst_unit -> Obj.magic ()
  | WfAst_bool b -> Obj.magic b
  | WfAst_int n -> Obj.magic n
  | WfAst_inl (t1, t2, x0) -> Obj.magic (Coq_inl (fromAst t1 x0))
  | WfAst_inr (t1, t2, x0) -> Obj.magic (Coq_inr (fromAst t2 x0))
  | WfAst_prod (t1, t2, x1, x2) ->
      Obj.magic ((fromAst t1 x1) , (fromAst t2 x2))
  | WfAst_list (t0, l) -> Obj.magic (map (fromAst t0) l)

(** val ast_to_ocmType : ocamlTypes -> ast -> (ocmType, notWT) sum **)

let ast_to_ocmType t x =
  match ast_wfAst t x with
    | Coq_inl x0 -> Coq_inl (fromAst t x0)
    | Coq_inr e -> Coq_inr e

(** val ocmType_to_ast : ocamlTypes -> ocmType -> ast **)

let ocmType_to_ast t x =
  ast_forget t (toAst t x)

(** val astSplitMono : ocamlTypes -> (ocmType, wfAst) splitMono **)

let astSplitMono t =
  { mono = (toAst t); mono_inv = (fromAst t) }

