open Compare_dec
open Datatypes
open DecSetoid
open DecSetoidProperties
open List0
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val count : coq_DecSetoid -> carrier -> carrier list -> nat **)

let rec count a a0 = function
  | [] -> O
  | b :: x' -> if a.equal a0 b then S (count a a0 x') else count a a0 x'

(** val same : coq_DecSetoid -> carrier -> nat -> carrier list **)

let rec same a a0 = function
  | O -> []
  | S n' -> a0 :: (same a a0 n')

(** val multisubset :
    coq_DecSetoid -> carrier list -> carrier list -> bool **)

let multisubset a x y =
  forallb (fun a0 -> leb (count a a0 x) (count a a0 y)) x

(** val multieq : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let multieq a x y =
  if multisubset a x y then multisubset a y x else false

(** val multisetDecSetoid : coq_DecSetoid -> coq_DecSetoid **)

let multisetDecSetoid a =
  { choose = (Obj.magic []); equal = (Obj.magic (multieq a)) }

(** val sg_multiset_nat_dsIso :
    coq_DecSetoid -> coq_IsSingleton -> coq_DsIso **)

let sg_multiset_nat_dsIso a = function
  | Coq_existT (a0, _) -> { phi = (Obj.magic (count a a0)); phi' =
      (Obj.magic (same a a0)) }

(** val isSingleton_comp : coq_DecSetoid -> coq_IsSingleton_comp **)

let isSingleton_comp a c =
  match Obj.magic c with
    | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
    | a0 :: c0 -> Coq_existT ((Obj.magic []), __)

(** val twoElements_comp : coq_DecSetoid -> coq_TwoElements_comp **)

let twoElements_comp a a0 b =
  match Obj.magic a0 with
    | [] ->
        (match Obj.magic b with
           | [] -> Coq_existT ((Obj.magic []), __)
           | b0 :: l ->
               (match l with
                  | [] -> Coq_existT ((Obj.magic (b0 :: (b0 :: []))), __)
                  | b' :: y -> Coq_existT ((Obj.magic (b0 :: [])), __)))
    | a1 :: l ->
        (match l with
           | [] ->
               (match Obj.magic b with
                  | [] -> Coq_existT ((Obj.magic (a1 :: (a1 :: []))), __)
                  | b0 :: l0 -> Coq_existT ((Obj.magic []), __))
           | a' :: x ->
               (match Obj.magic b with
                  | [] -> Coq_existT ((Obj.magic (a1 :: [])), __)
                  | b0 :: l0 -> Coq_existT ((Obj.magic []), __)))

