open Datatypes
open Specif

(** val list_rect :
    'a2 -> ('a1 -> 'a1 list -> 'a2 -> 'a2) -> 'a1 list -> 'a2 **)

let rec list_rect f f0 = function
  | [] -> f
  | a :: l0 -> f0 a l0 (list_rect f f0 l0)

(** val list_rec :
    'a2 -> ('a1 -> 'a1 list -> 'a2 -> 'a2) -> 'a1 list -> 'a2 **)

let rec list_rec f f0 = function
  | [] -> f
  | a :: l0 -> f0 a l0 (list_rec f f0 l0)

(** val head : 'a1 list -> 'a1 option **)

let head = function
  | [] -> error
  | x :: l0 -> value x

(** val hd : 'a1 -> 'a1 list -> 'a1 **)

let hd default = function
  | [] -> default
  | x :: l0 -> x

(** val tail : 'a1 list -> 'a1 list **)

let tail = function
  | [] -> []
  | a :: m -> m

(** val length : 'a1 list -> nat **)

let rec length = function
  | [] -> O
  | a :: m -> S (length m)

(** val app : 'a1 list -> 'a1 list -> 'a1 list **)

let rec app l m =
  match l with
    | [] -> m
    | a :: l1 -> a :: (app l1 m)

(** val destruct_list : 'a1 list -> ('a1, 'a1 list) sigT sumor **)

let rec destruct_list = function
  | [] -> Coq_inright
  | a :: l0 -> Coq_inleft (Coq_existT (a, l0))

(** val coq_In_dec :
    ('a1 -> 'a1 -> sumbool) -> 'a1 -> 'a1 list -> sumbool **)

let rec coq_In_dec h a = function
  | [] -> Coq_right
  | a0 :: l0 ->
      (match h a0 a with
         | Coq_left -> Coq_left
         | Coq_right -> coq_In_dec h a l0)

(** val nth : nat -> 'a1 list -> 'a1 -> 'a1 **)

let rec nth n l default =
  match n with
    | O -> (match l with
              | [] -> default
              | x :: l' -> x)
    | S m -> (match l with
                | [] -> default
                | x :: t -> nth m t default)

(** val nth_ok : nat -> 'a1 list -> 'a1 -> bool **)

let rec nth_ok n l default =
  match n with
    | O -> (match l with
              | [] -> false
              | x :: l' -> true)
    | S m -> (match l with
                | [] -> false
                | x :: t -> nth_ok m t default)

(** val nth_in_or_default : nat -> 'a1 list -> 'a1 -> sumbool **)

let rec nth_in_or_default n l d =
  match l with
    | [] -> Coq_right
    | a :: l0 ->
        (match n with
           | O -> Coq_left
           | S n1 -> nth_in_or_default n1 l0 d)

(** val nth_error : 'a1 list -> nat -> 'a1 coq_Exc **)

let rec nth_error l = function
  | O -> (match l with
            | [] -> error
            | x :: l0 -> value x)
  | S n0 -> (match l with
               | [] -> error
               | a :: l0 -> nth_error l0 n0)

(** val nth_default : 'a1 -> 'a1 list -> nat -> 'a1 **)

let nth_default default l n =
  match nth_error l n with
    | Some x -> x
    | None -> default

(** val remove : ('a1 -> 'a1 -> sumbool) -> 'a1 -> 'a1 list -> 'a1 list **)

let rec remove eq_dec x = function
  | [] -> []
  | y :: tl ->
      (match eq_dec x y with
         | Coq_left -> remove eq_dec x tl
         | Coq_right -> y :: (remove eq_dec x tl))

(** val last : 'a1 list -> 'a1 -> 'a1 **)

let rec last l d =
  match l with
    | [] -> d
    | a :: l0 -> (match l0 with
                    | [] -> a
                    | a0 :: l1 -> last l0 d)

(** val removelast : 'a1 list -> 'a1 list **)

let rec removelast = function
  | [] -> []
  | a :: l0 ->
      (match l0 with
         | [] -> []
         | a0 :: l1 -> a :: (removelast l0))

(** val exists_last : 'a1 list -> ('a1 list, 'a1) sigT **)

let rec exists_last = function
  | [] -> assert false (* absurd case *)
  | a :: l0 ->
      (match l0 with
         | [] -> Coq_existT ([], a)
         | a0 :: l1 ->
             let Coq_existT (l', s) = exists_last l0 in
             Coq_existT ((a :: l'), s))

(** val count_occ : ('a1 -> 'a1 -> sumbool) -> 'a1 list -> 'a1 -> nat **)

let rec count_occ eqA_dec l x =
  match l with
    | [] -> O
    | y :: tl ->
        (match eqA_dec y x with
           | Coq_left -> S (count_occ eqA_dec tl x)
           | Coq_right -> count_occ eqA_dec tl x)

(** val rev : 'a1 list -> 'a1 list **)

let rec rev = function
  | [] -> []
  | x :: l' -> app (rev l') (x :: [])

(** val rev_append : 'a1 list -> 'a1 list -> 'a1 list **)

let rec rev_append l l' =
  match l with
    | [] -> l'
    | a :: l0 -> rev_append l0 (a :: l')

(** val rev' : 'a1 list -> 'a1 list **)

let rev' l =
  rev_append l []

(** val list_eq_dec :
    ('a1 -> 'a1 -> sumbool) -> 'a1 list -> 'a1 list -> sumbool **)

let rec list_eq_dec eqA_dec l l' =
  match l with
    | [] -> (match l' with
               | [] -> Coq_left
               | y :: l'0 -> Coq_right)
    | a :: l0 ->
        (match l' with
           | [] -> Coq_right
           | y :: l'0 ->
               (match eqA_dec a y with
                  | Coq_left -> list_eq_dec eqA_dec l0 l'0
                  | Coq_right -> Coq_right))

(** val map : ('a1 -> 'a2) -> 'a1 list -> 'a2 list **)

let rec map f = function
  | [] -> []
  | a :: t -> (f a) :: (map f t)

(** val flat_map : ('a1 -> 'a2 list) -> 'a1 list -> 'a2 list **)

let rec flat_map f = function
  | [] -> []
  | x :: t -> app (f x) (flat_map f t)

(** val fold_left : ('a1 -> 'a2 -> 'a1) -> 'a2 list -> 'a1 -> 'a1 **)

let rec fold_left f l a0 =
  match l with
    | [] -> a0
    | b :: t -> fold_left f t (f a0 b)

(** val fold_right : ('a2 -> 'a1 -> 'a1) -> 'a1 -> 'a2 list -> 'a1 **)

let rec fold_right f a0 = function
  | [] -> a0
  | b :: t -> f b (fold_right f a0 t)

(** val list_power : 'a1 list -> 'a2 list -> ('a1 * 'a2) list list **)

let rec list_power l l' =
  match l with
    | [] -> [] :: []
    | x :: t ->
        flat_map (fun f -> map (fun y -> (x , y) :: f) l') (list_power t l')

(** val existsb : ('a1 -> bool) -> 'a1 list -> bool **)

let rec existsb f = function
  | [] -> false
  | a :: l0 -> if f a then true else existsb f l0

(** val forallb : ('a1 -> bool) -> 'a1 list -> bool **)

let rec forallb f = function
  | [] -> true
  | a :: l0 -> if f a then forallb f l0 else false

(** val filter : ('a1 -> bool) -> 'a1 list -> 'a1 list **)

let rec filter f = function
  | [] -> []
  | x :: l0 -> if f x then x :: (filter f l0) else filter f l0

(** val find : ('a1 -> bool) -> 'a1 list -> 'a1 option **)

let rec find f = function
  | [] -> None
  | x :: tl -> if f x then Some x else find f tl

(** val partition : ('a1 -> bool) -> 'a1 list -> 'a1 list * 'a1 list **)

let rec partition f = function
  | [] -> [] , []
  | x :: tl ->
      let g , d = partition f tl in
      if f x then (x :: g) , d else g , (x :: d)

(** val split : ('a1 * 'a2) list -> 'a1 list * 'a2 list **)

let rec split = function
  | [] -> [] , []
  | p :: tl -> let x , y = p in let g , d = split tl in (x :: g) , (y :: d)

(** val combine : 'a1 list -> 'a2 list -> ('a1 * 'a2) list **)

let rec combine l l' =
  match l with
    | [] -> []
    | x :: tl ->
        (match l' with
           | [] -> []
           | y :: tl' -> (x , y) :: (combine tl tl'))

(** val list_prod : 'a1 list -> 'a2 list -> ('a1 * 'a2) list **)

let rec list_prod l l' =
  match l with
    | [] -> []
    | x :: t -> app (map (fun y -> x , y) l') (list_prod t l')

(** val firstn : nat -> 'a1 list -> 'a1 list **)

let rec firstn n l =
  match n with
    | O -> []
    | S n0 -> (match l with
                 | [] -> []
                 | a :: l0 -> a :: (firstn n0 l0))

(** val skipn : nat -> 'a1 list -> 'a1 list **)

let rec skipn n l =
  match n with
    | O -> l
    | S n0 -> (match l with
                 | [] -> []
                 | a :: l0 -> skipn n0 l0)

(** val seq : nat -> nat -> nat list **)

let rec seq start = function
  | O -> []
  | S len0 -> start :: (seq (S start) len0)

