open Datatypes
open DecSetoid
open DecSetoidProperties
open Lex0
open Logic0
open OrderSemigroup
open OrderSemigroupGlue
open OrderSemigroupProperties
open PreorderProperties
open Product0
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val lexOrderSemigroup :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_OrderSemigroup **)

let lexOrderSemigroup a b =
  glueOSmg (prodSemigroup (semigroupOS a) (semigroupOS b))
    (lexPreorder (preorderOS a) (preorderOS b))

(** val singA_OSmgIso :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IsSingleton ->
    coq_OSmgIso **)

let singA_OSmgIso a b = function
  | Coq_existT (a0, _) -> { phi = (fun x -> let x0 , x2 = Obj.magic x in x2);
      phi' = (fun x -> Obj.magic (a0 , x)) }

(** val singB_OSmgIso :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IsSingleton ->
    coq_OSmgIso **)

let singB_OSmgIso a b = function
  | Coq_existT (b0, _) -> { phi = (fun x -> let x1 , x0 = Obj.magic x in x1);
      phi' = (fun x -> Obj.magic (x , b0)) }

(** val leftMonotonic_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_LeftMonotonic_comp,
    coq_LeftMonotonic_comp) sum, coq_LeftEquivCancelative_comp *
    coq_LeftEquivCondensed_comp) sum -> coq_LeftMonotonic_comp **)

let leftMonotonic_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl l ->
             let Coq_existT (x1, s0) = l in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z1 , b.setoid.choose)), __)))))
         | Coq_inr l ->
             let Coq_existT (x2, s0) = l in
             let Coq_existT (y2, s1) = s0 in
             let Coq_existT (z2, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z2)), __))))))
  | Coq_inr p ->
      let l , x0 = p in
      let Coq_existT (x1, s) = l in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = x0 in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      let Coq_existT (w, _) = copy_var (a.le x1 y1) in
      if w
      then let Coq_existT (w0, _) = copy_var (b.le (b.op x2 y2) (b.op x2 z2))
           in
           if w0
           then Coq_existT ((Obj.magic (z1 , x2)), (Coq_existT
                  ((Obj.magic (x1 , z2)), (Coq_existT (
                  (Obj.magic (y1 , y2)), __)))))
           else Coq_existT ((Obj.magic (z1 , x2)), (Coq_existT
                  ((Obj.magic (x1 , y2)), (Coq_existT (
                  (Obj.magic (y1 , z2)), __)))))
      else let Coq_existT (w0, _) = copy_var (b.le (b.op x2 y2) (b.op x2 z2))
           in
           if w0
           then Coq_existT ((Obj.magic (z1 , x2)), (Coq_existT
                  ((Obj.magic (y1 , z2)), (Coq_existT (
                  (Obj.magic (x1 , y2)), __)))))
           else Coq_existT ((Obj.magic (z1 , x2)), (Coq_existT
                  ((Obj.magic (y1 , y2)), (Coq_existT (
                  (Obj.magic (x1 , z2)), __)))))

(** val rightMonotonic_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_RightMonotonic_comp,
    coq_RightMonotonic_comp) sum, coq_RightEquivCancelative_comp *
    coq_RightEquivCondensed_comp) sum -> coq_RightMonotonic_comp **)

let rightMonotonic_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl r ->
             let Coq_existT (x1, s0) = r in
             let Coq_existT (y1, s1) = s0 in
             let Coq_existT (z1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (z1 , b.setoid.choose)), __)))))
         | Coq_inr r ->
             let Coq_existT (x2, s0) = r in
             let Coq_existT (y2, s1) = s0 in
             let Coq_existT (z2, _) = s1 in
             Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , y2)), (Coq_existT
             ((Obj.magic (a.setoid.choose , z2)), __))))))
  | Coq_inr p ->
      let r , x0 = p in
      let Coq_existT (x1, s) = r in
      let Coq_existT (y1, s0) = s in
      let Coq_existT (z1, _) = s0 in
      let Coq_existT (x2, s1) = x0 in
      let Coq_existT (y2, s2) = s1 in
      let Coq_existT (z2, _) = s2 in
      let Coq_existT (w, _) = copy_var (a.le x1 y1) in
      if w
      then let Coq_existT (w0, _) = copy_var (b.le (b.op y2 x2) (b.op z2 x2))
           in
           if w0
           then Coq_existT ((Obj.magic (x1 , z2)), (Coq_existT
                  ((Obj.magic (y1 , y2)), (Coq_existT (
                  (Obj.magic (z1 , x2)), __)))))
           else Coq_existT ((Obj.magic (x1 , y2)), (Coq_existT
                  ((Obj.magic (y1 , z2)), (Coq_existT (
                  (Obj.magic (z1 , x2)), __)))))
      else let Coq_existT (w0, _) = copy_var (b.le (b.op y2 x2) (b.op z2 x2))
           in
           if w0
           then Coq_existT ((Obj.magic (y1 , z2)), (Coq_existT
                  ((Obj.magic (x1 , y2)), (Coq_existT (
                  (Obj.magic (z1 , x2)), __)))))
           else Coq_existT ((Obj.magic (y1 , y2)), (Coq_existT
                  ((Obj.magic (x1 , z2)), (Coq_existT (
                  (Obj.magic (z1 , x2)), __)))))

(** val hasIdentity_back_a :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasIdentity ->
    coq_HasIdentity **)

let hasIdentity_back_a a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (a0, __)

(** val hasIdentity_back_b :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasIdentity ->
    coq_HasIdentity **)

let hasIdentity_back_b a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (b0, __)

(** val hasAnnihilator_back_a :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasAnnihilator_back_a a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (a0, __)

(** val hasAnnihilator_back_b :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasAnnihilator ->
    coq_HasAnnihilator **)

let hasAnnihilator_back_b a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (b0, __)

(** val hasTop_back_a :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasTop -> coq_HasTop **)

let hasTop_back_a a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (a0, __)

(** val hasTop_back_b :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasTop -> coq_HasTop **)

let hasTop_back_b a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (b0, __)

(** val hasBottom_back_a :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasBottom ->
    coq_HasBottom **)

let hasBottom_back_a a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (a0, __)

(** val hasBottom_back_b :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_HasBottom ->
    coq_HasBottom **)

let hasBottom_back_b a b = function
  | Coq_existT (x0, x1) -> let a0 , b0 = Obj.magic x0 in Coq_existT (b0, __)

(** val leftOpNonDecreasing_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftOpIncreasing_comp *
    (coq_LeftOpNonDecreasing_comp, coq_LeftOpNonDecreasing_comp) sum) ->
    coq_LeftOpNonDecreasing_comp **)

let leftOpNonDecreasing_comp a b = function
  | l , x0 ->
      let Coq_existT (a0, s) = l in
      let Coq_existT (b0, _) = s in
      (match x0 with
         | Coq_inl l0 ->
             let Coq_existT (x1, s0) = l0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr l0 ->
             let Coq_existT (x1, s0) = l0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
             ((Obj.magic (b0 , y)), __))))

(** val rightOpNonDecreasing_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightOpIncreasing_comp *
    (coq_RightOpNonDecreasing_comp, coq_RightOpNonDecreasing_comp) sum) ->
    coq_RightOpNonDecreasing_comp **)

let rightOpNonDecreasing_comp a b = function
  | r , x0 ->
      let Coq_existT (a0, s) = r in
      let Coq_existT (b0, _) = s in
      (match x0 with
         | Coq_inl r0 ->
             let Coq_existT (x1, s0) = r0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (y , b.setoid.choose)), __)))
         | Coq_inr r0 ->
             let Coq_existT (x1, s0) = r0 in
             let Coq_existT (y, _) = s0 in
             Coq_existT ((Obj.magic (a0 , x1)), (Coq_existT
             ((Obj.magic (b0 , y)), __))))

(** val rightChoiceIncrease_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_RightChoiceIncrease_comp, coq_RightChoiceIncrease_comp) sum ->
    (carrier, (carrier, __) sigT) sigT **)

let rightChoiceIncrease_comp a b = function
  | Coq_inl rci ->
      let Coq_existT (x0, s) = rci __ in
      let Coq_existT (y, _) = s in
      let b0 = b.setoid.choose in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), __)))
  | Coq_inr rci ->
      let Coq_existT (x0, s) = rci __ in
      let Coq_existT (y, _) = s in
      let a0 = a.setoid.choose in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), __)))

(** val leftChoiceIncrease_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftChoiceIncrease_comp,
    coq_LeftChoiceIncrease_comp) sum -> (carrier, (carrier, __) sigT) sigT **)

let leftChoiceIncrease_comp a b = function
  | Coq_inl rci ->
      let Coq_existT (x0, s) = rci __ in
      let Coq_existT (y, _) = s in
      let b0 = b.setoid.choose in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), __)))
  | Coq_inr rci ->
      let Coq_existT (x0, s) = rci __ in
      let Coq_existT (y, _) = s in
      let a0 = a.setoid.choose in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), __)))

(** val sond_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    coq_SelectiveOpNonDecreasing_comp -> (carrier, (carrier, __) sigT) sigT **)

let sond_CE_1 a b sond =
  let Coq_existT (x, s) = sond __ __ in
  let Coq_existT (y, _) = s in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)), __)))

(** val sond_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    coq_SelectiveOpNonDecreasing_comp -> (carrier, (carrier, __) sigT) sigT **)

let sond_CE_2 a b sond =
  let Coq_existT (x, s) = sond __ __ in
  let Coq_existT (y, _) = s in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)), __)))

(** val sond_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightChoiceIncrease_comp
    -> coq_RightOpNonDecreasing_comp -> (carrier, (carrier, __) sigT) sigT **)

let sond_CE_3 a b rci = function
  | Coq_existT (x2, s) ->
      let Coq_existT (y2, _) = s in
      let Coq_existT (x1, s0) = rci __ in
      let Coq_existT (y1, _) = s0 in
      Coq_existT ((Obj.magic (x1 , y2)), (Coq_existT (
      (Obj.magic (y1 , x2)), __)))

(** val sond_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftChoiceIncrease_comp
    -> coq_LeftOpNonDecreasing_comp -> (carrier, (carrier, __) sigT) sigT **)

let sond_CE_4 a b lci = function
  | Coq_existT (x2, s) ->
      let Coq_existT (y2, _) = s in
      let Coq_existT (x1, s0) = lci __ in
      let Coq_existT (y1, _) = s0 in
      Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT (
      (Obj.magic (y1 , y2)), __)))

(** val selectiveOpNonDecreasing_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    ((coq_SelectiveOpNonDecreasing_comp, coq_SelectiveOpNonDecreasing_comp)
    sum, __ * (coq_RightChoiceIncrease_comp * coq_RightOpNonDecreasing_comp,
    coq_LeftChoiceIncrease_comp * coq_LeftOpNonDecreasing_comp) sum) sum ->
    (carrier, (carrier, __) sigT) sigT **)

let selectiveOpNonDecreasing_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, _) = s0 in
             let b0 = b.setoid.choose in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), __)))
         | Coq_inr p2 ->
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, _) = s0 in
             let a0 = a.setoid.choose in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), __))))
  | Coq_inr p ->
      let _ , s = p in
      (match s with
         | Coq_inl p0 ->
             let p5 , p6 = p0 in
             let Coq_existT (x2, s0) = p6 in
             let Coq_existT (y2, _) = s0 in
             let Coq_existT (x1, s1) = p5 __ in
             let Coq_existT (y1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , y2)), (Coq_existT
             ((Obj.magic (y1 , x2)), __)))
         | Coq_inr p0 ->
             let p7 , p8 = p0 in
             let Coq_existT (x2, s0) = p8 in
             let Coq_existT (y2, _) = s0 in
             let Coq_existT (x1, s1) = p7 __ in
             let Coq_existT (y1, _) = s1 in
             Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT
             ((Obj.magic (y1 , y2)), __))))

(** val leftOpIncreasing_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_LeftOpNonDecreasing_comp, coq_LeftOpIncreasing_comp *
    coq_LeftOpIncreasing_comp) sum -> coq_LeftOpIncreasing_comp **)

let leftOpIncreasing_comp a b = function
  | Coq_inl l ->
      let Coq_existT (a3, s) = l in
      let Coq_existT (a4, _) = s in
      Coq_existT ((Obj.magic (a3 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (a4 , b.setoid.choose)), __)))
  | Coq_inr p ->
      let l , x0 = p in
      let Coq_existT (a1, s) = l in
      let Coq_existT (a2, _) = s in
      let Coq_existT (b1, s0) = x0 in
      let Coq_existT (b2, _) = s0 in
      Coq_existT ((Obj.magic (a1 , b1)), (Coq_existT (
      (Obj.magic (a2 , b2)), __)))

(** val rightOpIncreasing_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_RightOpNonDecreasing_comp, coq_RightOpIncreasing_comp *
    coq_RightOpIncreasing_comp) sum -> coq_RightOpIncreasing_comp **)

let rightOpIncreasing_comp a b = function
  | Coq_inl r ->
      let Coq_existT (a3, s) = r in
      let Coq_existT (a4, _) = s in
      Coq_existT ((Obj.magic (a3 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (a4 , b.setoid.choose)), __)))
  | Coq_inr p ->
      let r , x0 = p in
      let Coq_existT (a1, s) = r in
      let Coq_existT (a2, _) = s in
      let Coq_existT (b1, s0) = x0 in
      let Coq_existT (b2, _) = s0 in
      Coq_existT ((Obj.magic (a1 , b1)), (Coq_existT (
      (Obj.magic (a2 , b2)), __)))

(** val leftEquivCancelative_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_LeftEquivCancelative_comp, coq_LeftEquivCancelative_comp) sum ->
    coq_LeftEquivCancelative_comp **)

let leftEquivCancelative_comp a b = function
  | Coq_inl l ->
      let Coq_existT (a0, s) = l in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (c , b.setoid.choose)), __)))))
  | Coq_inr l ->
      let Coq_existT (a0, s) = l in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , c)), __)))))

(** val rightEquivCancelative_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_RightEquivCancelative_comp, coq_RightEquivCancelative_comp) sum ->
    coq_RightEquivCancelative_comp **)

let rightEquivCancelative_comp a b = function
  | Coq_inl r ->
      let Coq_existT (a0, s) = r in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (c , b.setoid.choose)), __)))))
  | Coq_inr r ->
      let Coq_existT (a0, s) = r in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , c)), __)))))

(** val leftEquivCondensed_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftEquivCondensed_comp,
    coq_LeftEquivCondensed_comp) sum -> coq_LeftEquivCondensed_comp **)

let leftEquivCondensed_comp a b = function
  | Coq_inl l ->
      let Coq_existT (a0, s) = l in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (w, _) = copy_var (a.le (a.op a0 b0) (a.op a0 c)) in
      if w
      then Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (c , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), __)))))
      else Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (c , b.setoid.choose)), __)))))
  | Coq_inr l ->
      let Coq_existT (a0, s) = l in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (w, _) = copy_var (b.le (b.op a0 b0) (b.op a0 c)) in
      if w
      then Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , c)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b0)), __)))))
      else Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , c)), __)))))

(** val rightEquivCondensed_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (coq_RightEquivCondensed_comp, coq_RightEquivCondensed_comp) sum ->
    coq_RightEquivCondensed_comp **)

let rightEquivCondensed_comp a b = function
  | Coq_inl r ->
      let Coq_existT (a0, s) = r in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (w, _) = copy_var (a.le (a.op a0 b0) (a.op a0 c)) in
      if w
      then Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (c , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), __)))))
      else Coq_existT ((Obj.magic (a0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (b0 , b.setoid.choose)), (Coq_existT
             ((Obj.magic (c , b.setoid.choose)), __)))))
  | Coq_inr r ->
      let Coq_existT (a0, s) = r in
      let Coq_existT (b0, s0) = s in
      let Coq_existT (c, _) = s0 in
      let Coq_existT (w, _) = copy_var (b.le (b.op a0 b0) (b.op a0 c)) in
      if w
      then Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , c)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b0)), __)))))
      else Coq_existT ((Obj.magic (a.setoid.choose , a0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , b0)), (Coq_existT
             ((Obj.magic (a.setoid.choose , c)), __)))))

(** val sel_back :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (__, coq_IsLeft_comp) sum ->
    (__, coq_IsRight_comp) sum -> (__, coq_IsSelective_comp) sum ->
    (coq_IsSingleton, coq_IsSingleton_comp) sum -> (__, coq_IsLeft_comp) sum
    -> (__, coq_IsRight_comp) sum -> (__, coq_IsSelective_comp) sum ->
    (coq_IsSingleton, coq_IsSingleton_comp) sum -> (((__, __) sum, __ *
    coq_IsSingleton) sum, coq_IsSingleton * __) sum **)

let sel_back a b x x0 x1 x2 x3 x4 x5 x6 =
  match x with
    | Coq_inl _ ->
        (match x0 with
           | Coq_inl _ ->
               (match x1 with
                  | Coq_inl _ ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x4 with
                                       | Coq_inl _ -> Coq_inl (Coq_inl
                                           (Coq_inr __))
                                       | Coq_inr i4 ->
                                           (match x5 with
                                              | Coq_inl _ ->
                                                  (
                                                  match x6 with
                                                    | 
                                                  Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                                    | 
                                                  Coq_inr i6 -> Coq_inr (i2 ,
                                                  __))
                                              | Coq_inr i5 ->
                                                  (
                                                  match x6 with
                                                    | 
                                                  Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                                    | 
                                                  Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *)))))
                         | Coq_inr i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x4 with
                                       | Coq_inl _ -> Coq_inl (Coq_inl
                                           (Coq_inr __))
                                       | Coq_inr i4 ->
                                           (match x5 with
                                              | Coq_inl _ ->
                                                  (
                                                  match x6 with
                                                    | 
                                                  Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                                    | 
                                                  Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inr
                                                  i2))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))
                                              | Coq_inr i5 ->
                                                  (
                                                  match x6 with
                                                    | 
                                                  Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                                    | 
                                                  Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))))))
                  | Coq_inr i1 ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x4 with
                                       | Coq_inl _ -> Coq_inl (Coq_inl
                                           (Coq_inr __))
                                       | Coq_inr i4 ->
                                           (match x5 with
                                              | Coq_inl _ -> Coq_inr (i2 ,
                                                  __)
                                              | Coq_inr i5 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inl i1)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))))
                         | Coq_inr i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x4 with
                                       | Coq_inl _ -> Coq_inl (Coq_inl
                                           (Coq_inr __))
                                       | Coq_inr i4 ->
                                           (match x5 with
                                              | Coq_inl _ ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inl i1)) , (Coq_inr
                                                  i2))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *)
                                              | Coq_inr i5 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inr i4)) ,
                                                  (Coq_inl i1)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))))))
           | Coq_inr i0 ->
               (match x1 with
                  | Coq_inl _ ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 -> Coq_inr (i2 ,
                                                  __))
                                       | Coq_inr i5 ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inl i0)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))))
                         | Coq_inr i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inl i0)) ,
                                                  (Coq_inr i6)) , (Coq_inr
                                                  i2))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))
                                       | Coq_inr i5 ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inr
                                                  i3) , (Coq_inl i0)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *)))))
                  | Coq_inr i1 ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x5 with
                                       | Coq_inl _ -> Coq_inr (i2 , __)
                                       | Coq_inr i5 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inr
                                               i3) , (Coq_inl i0)) , (Coq_inl
                                               i1)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)))
                         | Coq_inr i2 ->
                             (match x3 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inl __))
                                | Coq_inr i3 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inr
                                               i3) , (Coq_inl i0)) , (Coq_inl
                                               i1)) , (Coq_inr i2))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)
                                       | Coq_inr i5 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inr
                                               i3) , (Coq_inl i0)) , (Coq_inl
                                               i1)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *))))))
    | Coq_inr i ->
        (match x0 with
           | Coq_inl _ ->
               (match x1 with
                  | Coq_inl _ ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x4 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inr __))
                                | Coq_inr i4 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 -> Coq_inr (i2 ,
                                                  __))
                                       | Coq_inr i5 ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inl
                                                  i) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))))
                         | Coq_inr i2 ->
                             (match x4 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inr __))
                                | Coq_inr i4 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inl
                                                  i) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inr
                                                  i2))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *))
                                       | Coq_inr i5 ->
                                           (match x6 with
                                              | Coq_inl i6 -> Coq_inl
                                                  (Coq_inr (__ , i6))
                                              | Coq_inr i6 ->
                                                  let Coq_existT (
                                                  x7, s) =
                                                  isSelective_comp
                                                  (semigroupOS a)
                                                  (semigroupOS b) ((((Coq_inl
                                                  i) , (Coq_inr i4)) ,
                                                  (Coq_inr i6)) , (Coq_inl
                                                  i5))
                                                  in
                                                  let Coq_existT (y, _) = s
                                                  in
                                                  assert false
                                                  (* absurd case *)))))
                  | Coq_inr i1 ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x4 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inr __))
                                | Coq_inr i4 ->
                                    (match x5 with
                                       | Coq_inl _ -> Coq_inr (i2 , __)
                                       | Coq_inr i5 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inr i4)) , (Coq_inl
                                               i1)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)))
                         | Coq_inr i2 ->
                             (match x4 with
                                | Coq_inl _ -> Coq_inl (Coq_inl (Coq_inr __))
                                | Coq_inr i4 ->
                                    (match x5 with
                                       | Coq_inl _ ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inr i4)) , (Coq_inl
                                               i1)) , (Coq_inr i2))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)
                                       | Coq_inr i5 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inr i4)) , (Coq_inl
                                               i1)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)))))
           | Coq_inr i0 ->
               (match x1 with
                  | Coq_inl _ ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x5 with
                                | Coq_inl _ ->
                                    (match x6 with
                                       | Coq_inl i6 -> Coq_inl (Coq_inr (__ ,
                                           i6))
                                       | Coq_inr i6 -> Coq_inr (i2 , __))
                                | Coq_inr i5 ->
                                    (match x6 with
                                       | Coq_inl i6 -> Coq_inl (Coq_inr (__ ,
                                           i6))
                                       | Coq_inr i6 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inl i0)) , (Coq_inr
                                               i6)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *)))
                         | Coq_inr i2 ->
                             (match x5 with
                                | Coq_inl _ ->
                                    (match x6 with
                                       | Coq_inl i6 -> Coq_inl (Coq_inr (__ ,
                                           i6))
                                       | Coq_inr i6 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inl i0)) , (Coq_inr
                                               i6)) , (Coq_inr i2))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *))
                                | Coq_inr i5 ->
                                    (match x6 with
                                       | Coq_inl i6 -> Coq_inl (Coq_inr (__ ,
                                           i6))
                                       | Coq_inr i6 ->
                                           let Coq_existT (
                                             x7, s) =
                                             isSelective_comp 
                                               (semigroupOS a)
                                               (semigroupOS b) ((((Coq_inl i)
                                               , (Coq_inl i0)) , (Coq_inr
                                               i6)) , (Coq_inl i5))
                                           in
                                           let Coq_existT (y, _) = s in
                                           assert false (* absurd case *))))
                  | Coq_inr i1 ->
                      (match x2 with
                         | Coq_inl i2 ->
                             (match x5 with
                                | Coq_inl _ -> Coq_inr (i2 , __)
                                | Coq_inr i5 ->
                                    let Coq_existT (
                                      x7, s) =
                                      isSelective_comp 
                                        (semigroupOS a) 
                                        (semigroupOS b) ((((Coq_inl i) ,
                                        (Coq_inl i0)) , (Coq_inl i1)) ,
                                        (Coq_inl i5))
                                    in
                                    let Coq_existT (y, _) = s in
                                    assert false (* absurd case *))
                         | Coq_inr i2 ->
                             (match x5 with
                                | Coq_inl _ ->
                                    let Coq_existT (
                                      x7, s) =
                                      isSelective_comp 
                                        (semigroupOS a) 
                                        (semigroupOS b) ((((Coq_inl i) ,
                                        (Coq_inl i0)) , (Coq_inl i1)) ,
                                        (Coq_inr i2))
                                    in
                                    let Coq_existT (y, _) = s in
                                    assert false (* absurd case *)
                                | Coq_inr i5 ->
                                    let Coq_existT (
                                      x7, s) =
                                      isSelective_comp 
                                        (semigroupOS a) 
                                        (semigroupOS b) ((((Coq_inl i) ,
                                        (Coq_inl i0)) , (Coq_inl i1)) ,
                                        (Coq_inl i5))
                                    in
                                    let Coq_existT (y, _) = s in
                                    assert false (* absurd case *)))))

(** val iaus_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IncompArrowUniqueSrc_comp
    -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let iaus_CE_1 a b iaus =
  let b0 = b.setoid.choose in
  let Coq_existT (x1, s) = iaus __ __ __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, _) = s0 in
  Coq_existT ((Obj.magic (x1 , b0)), (Coq_existT ((Obj.magic (y1 , b0)),
  (Coq_existT ((Obj.magic (z1 , b0)), __)))))

(** val iaus_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IncompArrowUniqueSrc_comp
    -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let iaus_CE_2 a b iaus =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = iaus __ __ __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), __)))))

(** val incompArrowUniqueSrc_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (((((((((coq_IncompArrowUniqueSrc_comp, coq_IncompArrowUniqueSrc_comp)
    sum, coq_IsLeft_comp * __) sum, coq_IsRight_comp * __) sum,
    coq_IsSelective_comp * __) sum, coq_IsSingleton_comp * coq_IsSingleton)
    sum, coq_IsLeft_comp * __) sum, coq_IsRight_comp * __) sum,
    coq_IsSelective_comp * __) sum, coq_IsSingleton_comp * coq_IsSingleton)
    sum -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let incompArrowUniqueSrc_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl s2 ->
                           (match s2 with
                              | Coq_inl s3 ->
                                  (match s3 with
                                     | Coq_inl s4 ->
                                         (match s4 with
                                            | Coq_inl s5 ->
                                                (match s5 with
                                                   | 
                                                 Coq_inl s6 ->
                                                  (match s6 with
                                                    | 
                                                  Coq_inl iausa ->
                                                  let b0 = b.setoid.choose in
                                                  let Coq_existT (
                                                  x1, s7) = 
                                                  iausa __ __ __ __
                                                  in
                                                  let Coq_existT (
                                                  y1, s8) = s7
                                                  in
                                                  let Coq_existT (z1, _) = s8
                                                  in
                                                  Coq_existT
                                                  (
                                                  (Obj.magic (x1 , b0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (y1 , b0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (z1 , b0)),
                                                  __)))))
                                                    | 
                                                  Coq_inr iausb ->
                                                  let a0 = a.setoid.choose in
                                                  let Coq_existT (
                                                  x0, s7) = 
                                                  iausb __ __ __ __
                                                  in
                                                  let Coq_existT (y, s8) = s7
                                                  in
                                                  let Coq_existT (z, _) = s8
                                                  in
                                                  Coq_existT
                                                  (
                                                  (Obj.magic (a0 , x0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (a0 , y)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (a0 , z)),
                                                  __))))))
                                                   | 
                                                 Coq_inr p ->
                                                  let p0 , _ = p in
                                                  let Coq_existT (
                                                  x0, s6) = p0
                                                  in
                                                  let Coq_existT (y, _) = s6
                                                  in
                                                  assert false
                                                  (* absurd case *))
                                            | Coq_inr p ->
                                                let p0 , _ = p in
                                                let Coq_existT (x0, s5) = p0
                                                in
                                                let Coq_existT (y, _) = s5 in
                                                assert false
                                                (* absurd case *))
                                     | Coq_inr p ->
                                         let p0 , _ = p in
                                         let Coq_existT (x0, s4) = p0 in
                                         let Coq_existT (y, _) = s4 in
                                         assert false (* absurd case *))
                              | Coq_inr p ->
                                  let p0 , q = p in
                                  let Coq_existT (x0, _) = q in
                                  let Coq_existT (y, _) = p0 x0 in
                                  assert false (* absurd case *))
                       | Coq_inr p ->
                           let p0 , _ = p in
                           let Coq_existT (x0, s2) = p0 in
                           let Coq_existT (y, _) = s2 in
                           assert false (* absurd case *))
                | Coq_inr p ->
                    let p0 , _ = p in
                    let Coq_existT (x0, s1) = p0 in
                    let Coq_existT (y, _) = s1 in
                    assert false (* absurd case *))
         | Coq_inr p ->
             let p0 , _ = p in
             let Coq_existT (x0, s0) = p0 in
             let Coq_existT (y, _) = s0 in assert false (* absurd case *))
  | Coq_inr p ->
      let p0 , q = p in
      let Coq_existT (x0, _) = q in
      let Coq_existT (y, _) = p0 x0 in assert false (* absurd case *)

(** val iaf_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IncompArrowFactor_comp ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let iaf_CE_1 a b iaf =
  let Coq_existT (x, s) = iaf __ __ __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), __)))))

(** val iaf_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_IncompArrowFactor_comp ->
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let iaf_CE_2 a b iaf =
  let Coq_existT (x, s) = iaf __ __ __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), __)))))

(** val incompArrowFactor_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    (((((((((coq_IncompArrowFactor_comp, coq_IncompArrowFactor_comp) sum,
    coq_IsLeft_comp * __) sum, coq_IsRight_comp * __) sum,
    coq_IsSelective_comp * __) sum, coq_IsSingleton_comp * coq_IsSingleton)
    sum, coq_IsLeft_comp * __) sum, coq_IsRight_comp * __) sum,
    coq_IsSelective_comp * __) sum, coq_IsSingleton_comp * coq_IsSingleton)
    sum -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let incompArrowFactor_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl s2 ->
                           (match s2 with
                              | Coq_inl s3 ->
                                  (match s3 with
                                     | Coq_inl s4 ->
                                         (match s4 with
                                            | Coq_inl s5 ->
                                                (match s5 with
                                                   | 
                                                 Coq_inl s6 ->
                                                  (match s6 with
                                                    | 
                                                  Coq_inl iafa ->
                                                  let Coq_existT (
                                                  x0, s7) = 
                                                  iafa __ __ __ __
                                                  in
                                                  let Coq_existT (y, s8) = s7
                                                  in
                                                  let Coq_existT (z, _) = s8
                                                  in
                                                  let b0 = b.setoid.choose in
                                                  Coq_existT
                                                  (
                                                  (Obj.magic (x0 , b0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (y , b0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (z , b0)),
                                                  __)))))
                                                    | 
                                                  Coq_inr iafb ->
                                                  let Coq_existT (
                                                  x0, s7) = 
                                                  iafb __ __ __ __
                                                  in
                                                  let Coq_existT (y, s8) = s7
                                                  in
                                                  let Coq_existT (z, _) = s8
                                                  in
                                                  let a0 = a.setoid.choose in
                                                  Coq_existT
                                                  (
                                                  (Obj.magic (a0 , x0)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (a0 , y)),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (a0 , z)),
                                                  __))))))
                                                   | 
                                                 Coq_inr p ->
                                                  let p0 , _ = p in
                                                  let Coq_existT (
                                                  x0, s6) = p0
                                                  in
                                                  let Coq_existT (y, _) = s6
                                                  in
                                                  assert false
                                                  (* absurd case *))
                                            | Coq_inr p ->
                                                let p0 , _ = p in
                                                let Coq_existT (x0, s5) = p0
                                                in
                                                let Coq_existT (y, _) = s5 in
                                                assert false
                                                (* absurd case *))
                                     | Coq_inr p ->
                                         let p0 , _ = p in
                                         let Coq_existT (x0, s4) = p0 in
                                         let Coq_existT (y, _) = s4 in
                                         assert false (* absurd case *))
                              | Coq_inr p ->
                                  let p0 , q = p in
                                  let Coq_existT (x0, _) = q in
                                  let Coq_existT (y, _) = p0 x0 in
                                  assert false (* absurd case *))
                       | Coq_inr p ->
                           let p0 , _ = p in
                           let Coq_existT (x0, s2) = p0 in
                           let Coq_existT (y, _) = s2 in
                           assert false (* absurd case *))
                | Coq_inr p ->
                    let p0 , _ = p in
                    let Coq_existT (x0, s1) = p0 in
                    let Coq_existT (y, _) = s1 in
                    assert false (* absurd case *))
         | Coq_inr p ->
             let p0 , _ = p in
             let Coq_existT (x0, s0) = p0 in
             let Coq_existT (y, _) = s0 in assert false (* absurd case *))
  | Coq_inr p ->
      let p0 , q = p in
      let Coq_existT (x0, _) = q in
      let Coq_existT (y, _) = p0 x0 in assert false (* absurd case *)

(** val rightTotal_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightTotal_comp,
    coq_RightTotal_comp) sum -> coq_RightTotal_comp **)

let rightTotal_comp a b = function
  | Coq_inl r ->
      let Coq_existT (z, s) = r in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      let b0 = b.setoid.choose in
      Coq_existT ((Obj.magic (z , b0)), (Coq_existT (
      (Obj.magic (x0 , b0)), (Coq_existT ((Obj.magic (y , b0)), __)))))
  | Coq_inr r ->
      let Coq_existT (z, s) = r in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      let a0 = a.setoid.choose in
      Coq_existT ((Obj.magic (a0 , z)), (Coq_existT (
      (Obj.magic (a0 , x0)), (Coq_existT ((Obj.magic (a0 , y)), __)))))

(** val leftTotal_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftTotal_comp,
    coq_LeftTotal_comp) sum -> coq_LeftTotal_comp **)

let leftTotal_comp a b = function
  | Coq_inl l ->
      let Coq_existT (z, s) = l in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      let b0 = b.setoid.choose in
      Coq_existT ((Obj.magic (z , b0)), (Coq_existT (
      (Obj.magic (x0 , b0)), (Coq_existT ((Obj.magic (y , b0)), __)))))
  | Coq_inr l ->
      let Coq_existT (z, s) = l in
      let Coq_existT (x0, s0) = s in
      let Coq_existT (y, _) = s0 in
      let a0 = a.setoid.choose in
      Coq_existT ((Obj.magic (a0 , z)), (Coq_existT (
      (Obj.magic (a0 , x0)), (Coq_existT ((Obj.magic (a0 , y)), __)))))

(** val rmcc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultChoiseComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmcc_CE_1 a b rmcc =
  let Coq_existT (x, s) = rmcc __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rmcc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultChoiseComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmcc_CE_2 a b rmcc =
  let Coq_existT (x, s) = rmcc __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rmcc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtSwapEquiv_comp ->
    coq_RightMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rmcc_CE_3 a b lse mc =
  let Coq_existT (x1, s) = lse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = mc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rmcc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultSplitComp_comp
    -> coq_RightEquivCondensed_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rmcc_CE_4 a b rmsc rec0 =
  let Coq_existT (x1, s) = rmsc __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rec0 in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, _) = s3 in
  let Coq_existT (w, _) = copy_var (b.le (b.op y2 x2) (b.op z2 x2)) in
  if w
  then Coq_existT ((Obj.magic (x1 , z2)), (Coq_existT (
         (Obj.magic (y1 , y2)), (Coq_existT
         ((Obj.magic (z1 , b.setoid.choose)), (Coq_existT
         ((Obj.magic (w1 , x2)), __)))))))
  else Coq_existT ((Obj.magic (x1 , y2)), (Coq_existT (
         (Obj.magic (y1 , z2)), (Coq_existT
         ((Obj.magic (z1 , b.setoid.choose)), (Coq_existT
         ((Obj.magic (w1 , x2)), __)))))))

(** val rmcc_CE_5 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtLeSwapEquiv_comp
    -> coq_RightLtMultComp_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rmcc_CE_5 a b llse lmc =
  let Coq_existT (x1, s) = llse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = lmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rmcc_CE_6 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeSwapEquiv_comp ->
    coq_RightMultPresLtLe_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rmcc_CE_6 a b lse mpll =
  let Coq_existT (x1, s) = lse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = mpll __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rightMultChoiseComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    ((coq_RightMultChoiseComp_comp, coq_RightMultChoiseComp_comp) sum, __ *
    (((coq_RightLtSwapEquiv_comp * coq_RightMultComp_comp,
    coq_RightMultSplitComp_comp * coq_RightEquivCondensed_comp) sum,
    coq_RightLtLeSwapEquiv_comp * coq_RightLtMultComp_comp) sum,
    coq_RightLeSwapEquiv_comp * coq_RightMultPresLtLe_comp) sum) sum ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rightMultChoiseComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl rmcca ->
             let Coq_existT (x0, s0) = rmcca __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let b0 = b.setoid.choose in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr rmccb ->
             let Coq_existT (x0, s0) = rmccb __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let a0 = a.setoid.choose in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p ->
      let _ , x0 = p in
      (match x0 with
         | Coq_inl s ->
             (match s with
                | Coq_inl s0 ->
                    (match s0 with
                       | Coq_inl u -> let u1 , u2 = u in rmcc_CE_3 a b u1 u2
                       | Coq_inr u -> let u1 , u2 = u in rmcc_CE_4 a b u1 u2)
                | Coq_inr u -> let u1 , u2 = u in rmcc_CE_5 a b u1 u2)
         | Coq_inr u -> let u1 , u2 = u in rmcc_CE_6 a b u1 u2)

(** val lmcc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultChoiseComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmcc_CE_1 a b rmcc =
  let Coq_existT (x, s) = rmcc __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val lmcc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultChoiseComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmcc_CE_2 a b rmcc =
  let Coq_existT (x, s) = rmcc __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val lmcc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtSwapEquiv_comp ->
    coq_LeftMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmcc_CE_3 a b lse mc =
  let Coq_existT (x1, s) = lse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = mc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val lmcc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultSplitComp_comp ->
    coq_LeftEquivCondensed_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let lmcc_CE_4 a b rmsc rec0 =
  let Coq_existT (x1, s) = rmsc __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rec0 in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, _) = s3 in
  let Coq_existT (w, _) = copy_var (b.le (b.op x2 y2) (b.op x2 z2)) in
  if w
  then Coq_existT ((Obj.magic (x1 , z2)), (Coq_existT (
         (Obj.magic (y1 , y2)), (Coq_existT
         ((Obj.magic (z1 , b.setoid.choose)), (Coq_existT
         ((Obj.magic (w1 , x2)), __)))))))
  else Coq_existT ((Obj.magic (x1 , y2)), (Coq_existT (
         (Obj.magic (y1 , z2)), (Coq_existT
         ((Obj.magic (z1 , b.setoid.choose)), (Coq_existT
         ((Obj.magic (w1 , x2)), __)))))))

(** val lmcc_CE_5 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtLeSwapEquiv_comp ->
    coq_LeftLtMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmcc_CE_5 a b llse lmc =
  let Coq_existT (x1, s) = llse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = lmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val lmcc_CE_6 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeSwapEquiv_comp ->
    coq_LeftMultPresLtLe_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmcc_CE_6 a b lse mpll =
  let Coq_existT (x1, s) = lse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = mpll __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val leftMultChoiseComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    ((coq_LeftMultChoiseComp_comp, coq_LeftMultChoiseComp_comp) sum, __ *
    (((coq_LeftLtSwapEquiv_comp * coq_LeftMultComp_comp,
    coq_LeftMultSplitComp_comp * coq_LeftEquivCondensed_comp) sum,
    coq_LeftLtLeSwapEquiv_comp * coq_LeftLtMultComp_comp) sum,
    coq_LeftLeSwapEquiv_comp * coq_LeftMultPresLtLe_comp) sum) sum ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let leftMultChoiseComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl rmcca ->
             let Coq_existT (x0, s0) = rmcca __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let b0 = b.setoid.choose in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr rmccb ->
             let Coq_existT (x0, s0) = rmccb __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let a0 = a.setoid.choose in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p ->
      let _ , x0 = p in
      (match x0 with
         | Coq_inl s ->
             (match s with
                | Coq_inl s0 ->
                    (match s0 with
                       | Coq_inl u -> let u1 , u2 = u in lmcc_CE_3 a b u1 u2
                       | Coq_inr u -> let u1 , u2 = u in lmcc_CE_4 a b u1 u2)
                | Coq_inr u -> let u1 , u2 = u in lmcc_CE_5 a b u1 u2)
         | Coq_inr u -> let u1 , u2 = u in lmcc_CE_6 a b u1 u2)

(** val rlse_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlse_CE_1 a b rlsea =
  let Coq_existT (x, s) = rlsea __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rlse_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlse_CE_2 a b rlsea =
  let Coq_existT (x, s) = rlsea __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rlse_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtLeSwapEquiv_comp
    -> coq_RightStrictEquiv_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rlse_CE_3 a b rllsea rseb =
  let Coq_existT (x1, s) = rllsea __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rseb __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rightLtSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_RightLtSwapEquiv_comp,
    coq_RightLtSwapEquiv_comp) sum, coq_RightLtLeSwapEquiv_comp *
    coq_RightStrictEquiv_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightLtSwapEquiv_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let b0 = b.setoid.choose in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let a0 = a.setoid.choose in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p4 , p5 = p in rlse_CE_3 a b p4 p5

(** val rightMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightMultComp_comp,
    coq_RightMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightMultComp_comp a b = function
  | Coq_inl rmca ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rmca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rmcb ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rmcb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val rmsc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultSplitComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmsc_CE_1 a b rmsc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rmsc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rmsc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultSplitComp_comp
    -> (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmsc_CE_2 a b rmsc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rmsc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rmsc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtSwapEquiv_comp ->
    coq_RightMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rmsc_CE_3 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rmsc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtLeSwapEquiv_comp
    -> coq_RightLeMultComp_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rmsc_CE_4 a b rllse rlmc =
  let Coq_existT (x1, s) = rllse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rlmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rmsc_CE_5 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeSwapEquiv_comp ->
    coq_RightLtLeMulpCoh_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rmsc_CE_5 a b rlse rllse =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rllse __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rightMultSplitComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    ((((coq_RightMultSplitComp_comp, coq_RightMultSplitComp_comp) sum,
    coq_RightLtSwapEquiv_comp * coq_RightMultComp_comp) sum,
    coq_RightLtLeSwapEquiv_comp * coq_RightLeMultComp_comp) sum,
    coq_RightLeSwapEquiv_comp * coq_RightLtLeMulpCoh_comp) sum -> (carrier,
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rightMultSplitComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl p1 ->
                           let b0 = b.setoid.choose in
                           let Coq_existT (x0, s2) = p1 __ __ in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, s4) = s3 in
                           let Coq_existT (w, _) = s4 in
                           Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                           ((Obj.magic (y , b0)), (Coq_existT
                           ((Obj.magic (z , b0)), (Coq_existT
                           ((Obj.magic (w , b0)), __)))))))
                       | Coq_inr p2 ->
                           let a0 = a.setoid.choose in
                           let Coq_existT (x0, s2) = p2 __ __ in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, s4) = s3 in
                           let Coq_existT (w, _) = s4 in
                           Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                           ((Obj.magic (a0 , y)), (Coq_existT
                           ((Obj.magic (a0 , z)), (Coq_existT
                           ((Obj.magic (a0 , w)), __))))))))
                | Coq_inr p -> let p3 , p4 = p in rmsc_CE_3 a b p3 p4)
         | Coq_inr p -> let p5 , p6 = p in rmsc_CE_4 a b p5 p6)
  | Coq_inr p -> let p7 , p8 = p in rmsc_CE_5 a b p7 p8

(** val rightLtLeSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightLtLeSwapEquiv_comp,
    coq_RightLtLeSwapEquiv_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightLtLeSwapEquiv_comp a b = function
  | Coq_inl rllse ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rllse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rllse ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rllse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val rlmc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlmc_CE_1 a b rlmc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlmc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rlmc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlmc_CE_2 a b rlmc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlmc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rlmc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightStrictEquiv_comp ->
    coq_RightMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rlmc_CE_3 a b rse rmc =
  let Coq_existT (x1, s) = rse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rlmc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeMultComp_comp ->
    coq_RightEquivCondensed_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rlmc_CE_4 a b rlmc = function
  | Coq_existT (w, s) ->
      let Coq_existT (x, s0) = s in
      let Coq_existT (y, _) = s0 in
      let Coq_existT (w0, _) = copy_var (b.le (b.op x w) (b.op y w)) in
      if w0
      then let Coq_existT (x1, s1) = rlmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , y)), (Coq_existT
           ((Obj.magic (y1 , x)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))
      else let Coq_existT (x1, s1) = rlmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , x)), (Coq_existT
           ((Obj.magic (y1 , y)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))

(** val rightLtMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (((coq_RightLtMultComp_comp,
    coq_RightLtMultComp_comp) sum, coq_RightStrictEquiv_comp *
    coq_RightMultComp_comp) sum, coq_RightLeMultComp_comp *
    coq_RightEquivCondensed_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightLtMultComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl p1 ->
                    let b0 = b.setoid.choose in
                    let Coq_existT (x0, s1) = p1 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                    ((Obj.magic (y , b0)), (Coq_existT (
                    (Obj.magic (z , b0)), (Coq_existT (
                    (Obj.magic (w , b0)), __)))))))
                | Coq_inr p2 ->
                    let a0 = a.setoid.choose in
                    let Coq_existT (x0, s1) = p2 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , y)), (Coq_existT (
                    (Obj.magic (a0 , z)), (Coq_existT (
                    (Obj.magic (a0 , w)), __))))))))
         | Coq_inr p -> let p3 , p4 = p in rlmc_CE_3 a b p3 p4)
  | Coq_inr p -> let p5 , p6 = p in rlmc_CE_4 a b p5 p6

(** val rlese_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlese_CE_1 a b rlese =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlese __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rlese_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlese_CE_2 a b rlese =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlese __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rlese_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtLeSwapEquiv_comp
    -> coq_RightLeMultComp_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rlese_CE_3 a b rllse rlmc =
  let Coq_existT (x1, s) = rllse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rlmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rlese_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtSwapEquiv_comp ->
    coq_RightMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rlese_CE_4 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rightLeSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (((coq_RightLeSwapEquiv_comp,
    coq_RightLeSwapEquiv_comp) sum, coq_RightLtLeSwapEquiv_comp *
    coq_RightLeMultComp_comp) sum, coq_RightLtSwapEquiv_comp *
    coq_RightMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightLeSwapEquiv_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl p1 ->
                    let b0 = b.setoid.choose in
                    let Coq_existT (x0, s1) = p1 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                    ((Obj.magic (y , b0)), (Coq_existT (
                    (Obj.magic (z , b0)), (Coq_existT (
                    (Obj.magic (w , b0)), __)))))))
                | Coq_inr p2 ->
                    let a0 = a.setoid.choose in
                    let Coq_existT (x0, s1) = p2 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , y)), (Coq_existT (
                    (Obj.magic (a0 , z)), (Coq_existT (
                    (Obj.magic (a0 , w)), __))))))))
         | Coq_inr p -> let p3 , p4 = p in rlese_CE_3 a b p3 p4)
  | Coq_inr p -> let p5 , p6 = p in rlese_CE_4 a b p5 p6

(** val rmpll_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultPresLtLe_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmpll_CE_1 a b rmpll =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rmpll __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rmpll_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightMultPresLtLe_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rmpll_CE_2 a b rmpll =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rmpll __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rmpll_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLtLeMulpCoh_comp ->
    coq_RightEquivCondensed_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rmpll_CE_3 a b rllmc = function
  | Coq_existT (w, s) ->
      let Coq_existT (x, s0) = s in
      let Coq_existT (y, _) = s0 in
      let Coq_existT (w0, _) = copy_var (b.le (b.op x w) (b.op y w)) in
      if w0
      then let Coq_existT (x1, s1) = rllmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , y)), (Coq_existT
           ((Obj.magic (y1 , x)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))
      else let Coq_existT (x1, s1) = rllmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , x)), (Coq_existT
           ((Obj.magic (y1 , y)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))

(** val rightMultPresLtLe_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_RightMultPresLtLe_comp,
    coq_RightMultPresLtLe_comp) sum, coq_RightLtLeMulpCoh_comp *
    coq_RightEquivCondensed_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightMultPresLtLe_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let b0 = b.setoid.choose in
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let a0 = a.setoid.choose in
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p3 , p4 = p in rmpll_CE_3 a b p3 p4

(** val rightStrictEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightStrictEquiv_comp,
    coq_RightStrictEquiv_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightStrictEquiv_comp a b = function
  | Coq_inl rse ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rse ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val rlemc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlemc_CE_1 a b rlemc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlemc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val rlemc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightLeMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let rlemc_CE_2 a b rlemc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlemc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val rlemc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_RightStrictEquiv_comp ->
    coq_RightMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let rlemc_CE_3 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val rightLeMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_RightLeMultComp_comp,
    coq_RightLeMultComp_comp) sum, coq_RightStrictEquiv_comp *
    coq_RightMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightLeMultComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let b0 = b.setoid.choose in
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let a0 = a.setoid.choose in
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p3 , p4 = p in rlemc_CE_3 a b p3 p4

(** val rightLtLeMulpCoh_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_RightLtLeMulpCoh_comp,
    coq_RightLtLeMulpCoh_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let rightLtLeMulpCoh_comp a b = function
  | Coq_inl rllmc ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rllmc __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rllmc ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rllmc __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val llse_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llse_CE_1 a b rlsea =
  let Coq_existT (x, s) = rlsea __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let b0 = b.setoid.choose in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val llse_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llse_CE_2 a b rlsea =
  let Coq_existT (x, s) = rlsea __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  let a0 = a.setoid.choose in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val llse_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtLeSwapEquiv_comp ->
    coq_LeftStrictEquiv_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let llse_CE_3 a b rllsea rseb =
  let Coq_existT (x1, s) = rllsea __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rseb __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val leftLtSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_LeftLtSwapEquiv_comp,
    coq_LeftLtSwapEquiv_comp) sum, coq_LeftLtLeSwapEquiv_comp *
    coq_LeftStrictEquiv_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let leftLtSwapEquiv_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let b0 = b.setoid.choose in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             let a0 = a.setoid.choose in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p4 , p5 = p in llse_CE_3 a b p4 p5

(** val leftMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftMultComp_comp,
    coq_LeftMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let leftMultComp_comp a b = function
  | Coq_inl rmca ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rmca __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rmcb ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rmcb __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val lmsc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultSplitComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmsc_CE_1 a b rmsc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rmsc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val lmsc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultSplitComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmsc_CE_2 a b rmsc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rmsc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val lmsc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtSwapEquiv_comp ->
    coq_LeftMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmsc_CE_3 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val lmsc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtLeSwapEquiv_comp ->
    coq_LeftLeMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmsc_CE_4 a b rllse rlmc =
  let Coq_existT (x1, s) = rllse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rlmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val lmsc_CE_5 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeSwapEquiv_comp ->
    coq_LeftLtLeMulpCoh_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let lmsc_CE_5 a b rlse rllse =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rllse __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val leftMultSplitComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup ->
    ((((coq_LeftMultSplitComp_comp, coq_LeftMultSplitComp_comp) sum,
    coq_LeftLtSwapEquiv_comp * coq_LeftMultComp_comp) sum,
    coq_LeftLtLeSwapEquiv_comp * coq_LeftLeMultComp_comp) sum,
    coq_LeftLeSwapEquiv_comp * coq_LeftLtLeMulpCoh_comp) sum -> (carrier,
    (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let leftMultSplitComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl s1 ->
                    (match s1 with
                       | Coq_inl p1 ->
                           let b0 = b.setoid.choose in
                           let Coq_existT (x0, s2) = p1 __ __ in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, s4) = s3 in
                           let Coq_existT (w, _) = s4 in
                           Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                           ((Obj.magic (y , b0)), (Coq_existT
                           ((Obj.magic (z , b0)), (Coq_existT
                           ((Obj.magic (w , b0)), __)))))))
                       | Coq_inr p2 ->
                           let a0 = a.setoid.choose in
                           let Coq_existT (x0, s2) = p2 __ __ in
                           let Coq_existT (y, s3) = s2 in
                           let Coq_existT (z, s4) = s3 in
                           let Coq_existT (w, _) = s4 in
                           Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                           ((Obj.magic (a0 , y)), (Coq_existT
                           ((Obj.magic (a0 , z)), (Coq_existT
                           ((Obj.magic (a0 , w)), __))))))))
                | Coq_inr p -> let p3 , p4 = p in lmsc_CE_3 a b p3 p4)
         | Coq_inr p -> let p5 , p6 = p in lmsc_CE_4 a b p5 p6)
  | Coq_inr p -> let p7 , p8 = p in lmsc_CE_5 a b p7 p8

(** val leftLtLeSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftLtLeSwapEquiv_comp,
    coq_LeftLtLeSwapEquiv_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let leftLtLeSwapEquiv_comp a b = function
  | Coq_inl rllse ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rllse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rllse ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rllse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val llmc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llmc_CE_1 a b rlmc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlmc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val llmc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llmc_CE_2 a b rlmc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlmc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val llmc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftStrictEquiv_comp ->
    coq_LeftMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let llmc_CE_3 a b rse rmc =
  let Coq_existT (x1, s) = rse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val llmc_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeMultComp_comp ->
    coq_LeftEquivCondensed_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let llmc_CE_4 a b rlmc = function
  | Coq_existT (w, s) ->
      let Coq_existT (x, s0) = s in
      let Coq_existT (y, _) = s0 in
      let Coq_existT (w0, _) = copy_var (b.le (b.op w x) (b.op w y)) in
      if w0
      then let Coq_existT (x1, s1) = rlmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , y)), (Coq_existT
           ((Obj.magic (y1 , x)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))
      else let Coq_existT (x1, s1) = rlmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , x)), (Coq_existT
           ((Obj.magic (y1 , y)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))

(** val leftLtMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (((coq_LeftLtMultComp_comp,
    coq_LeftLtMultComp_comp) sum, coq_LeftStrictEquiv_comp *
    coq_LeftMultComp_comp) sum, coq_LeftLeMultComp_comp *
    coq_LeftEquivCondensed_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let leftLtMultComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl p1 ->
                    let b0 = b.setoid.choose in
                    let Coq_existT (x0, s1) = p1 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                    ((Obj.magic (y , b0)), (Coq_existT (
                    (Obj.magic (z , b0)), (Coq_existT (
                    (Obj.magic (w , b0)), __)))))))
                | Coq_inr p2 ->
                    let a0 = a.setoid.choose in
                    let Coq_existT (x0, s1) = p2 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , y)), (Coq_existT (
                    (Obj.magic (a0 , z)), (Coq_existT (
                    (Obj.magic (a0 , w)), __))))))))
         | Coq_inr p -> let p3 , p4 = p in llmc_CE_3 a b p3 p4)
  | Coq_inr p -> let p5 , p6 = p in llmc_CE_4 a b p5 p6

(** val llese_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llese_CE_1 a b rlese =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlese __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val llese_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeSwapEquiv_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llese_CE_2 a b rlese =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlese __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val llese_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtLeSwapEquiv_comp ->
    coq_LeftLeMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let llese_CE_3 a b rllse rlmc =
  let Coq_existT (x1, s) = rllse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rlmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val llese_CE_4 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtSwapEquiv_comp ->
    coq_LeftMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let llese_CE_4 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val leftLeSwapEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (((coq_LeftLeSwapEquiv_comp,
    coq_LeftLeSwapEquiv_comp) sum, coq_LeftLtLeSwapEquiv_comp *
    coq_LeftLeMultComp_comp) sum, coq_LeftLtSwapEquiv_comp *
    coq_LeftMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let leftLeSwapEquiv_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl s0 ->
             (match s0 with
                | Coq_inl p1 ->
                    let b0 = b.setoid.choose in
                    let Coq_existT (x0, s1) = p1 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
                    ((Obj.magic (y , b0)), (Coq_existT (
                    (Obj.magic (z , b0)), (Coq_existT (
                    (Obj.magic (w , b0)), __)))))))
                | Coq_inr p2 ->
                    let a0 = a.setoid.choose in
                    let Coq_existT (x0, s1) = p2 __ __ in
                    let Coq_existT (y, s2) = s1 in
                    let Coq_existT (z, s3) = s2 in
                    let Coq_existT (w, _) = s3 in
                    Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
                    ((Obj.magic (a0 , y)), (Coq_existT (
                    (Obj.magic (a0 , z)), (Coq_existT (
                    (Obj.magic (a0 , w)), __))))))))
         | Coq_inr p -> let p3 , p4 = p in llese_CE_3 a b p3 p4)
  | Coq_inr p -> let p5 , p6 = p in llese_CE_4 a b p5 p6

(** val lmpll_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultPresLtLe_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmpll_CE_1 a b rmpll =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rmpll __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val lmpll_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftMultPresLtLe_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let lmpll_CE_2 a b rmpll =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rmpll __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val lmpll_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLtLeMulpCoh_comp ->
    coq_LeftEquivCondensed_comp -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let lmpll_CE_3 a b rllmc = function
  | Coq_existT (w, s) ->
      let Coq_existT (x, s0) = s in
      let Coq_existT (y, _) = s0 in
      let Coq_existT (w0, _) = copy_var (b.le (b.op w x) (b.op w y)) in
      if w0
      then let Coq_existT (x1, s1) = rllmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , y)), (Coq_existT
           ((Obj.magic (y1 , x)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))
      else let Coq_existT (x1, s1) = rllmc __ __ in
           let Coq_existT (y1, s2) = s1 in
           let Coq_existT (z1, s3) = s2 in
           let Coq_existT (w1, _) = s3 in
           Coq_existT ((Obj.magic (x1 , x)), (Coq_existT
           ((Obj.magic (y1 , y)), (Coq_existT ((Obj.magic (z1 , w)),
           (Coq_existT ((Obj.magic (w1 , w)), __)))))))

(** val leftMultPresLtLe_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_LeftMultPresLtLe_comp,
    coq_LeftMultPresLtLe_comp) sum, coq_LeftLtLeMulpCoh_comp *
    coq_LeftEquivCondensed_comp) sum -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let leftMultPresLtLe_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let b0 = b.setoid.choose in
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let a0 = a.setoid.choose in
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p3 , p4 = p in lmpll_CE_3 a b p3 p4

(** val leftStrictEquiv_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftStrictEquiv_comp,
    coq_LeftStrictEquiv_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let leftStrictEquiv_comp a b = function
  | Coq_inl rse ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rse ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rse __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

(** val llemc_CE_1 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llemc_CE_1 a b rlemc =
  let b0 = b.setoid.choose in
  let Coq_existT (x, s) = rlemc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (x , b0)), (Coq_existT ((Obj.magic (y , b0)),
  (Coq_existT ((Obj.magic (z , b0)), (Coq_existT ((Obj.magic (w , b0)),
  __)))))))

(** val llemc_CE_2 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftLeMultComp_comp ->
    (carrier, (carrier, (carrier, (carrier, __) sigT) sigT) sigT) sigT **)

let llemc_CE_2 a b rlemc =
  let a0 = a.setoid.choose in
  let Coq_existT (x, s) = rlemc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, s1) = s0 in
  let Coq_existT (w, _) = s1 in
  Coq_existT ((Obj.magic (a0 , x)), (Coq_existT ((Obj.magic (a0 , y)),
  (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT ((Obj.magic (a0 , w)),
  __)))))))

(** val llemc_CE_3 :
    coq_OrderSemigroup -> coq_OrderSemigroup -> coq_LeftStrictEquiv_comp ->
    coq_LeftMultComp_comp -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let llemc_CE_3 a b rlse rmc =
  let Coq_existT (x1, s) = rlse __ __ in
  let Coq_existT (y1, s0) = s in
  let Coq_existT (z1, s1) = s0 in
  let Coq_existT (w1, _) = s1 in
  let Coq_existT (x2, s2) = rmc __ __ in
  let Coq_existT (y2, s3) = s2 in
  let Coq_existT (z2, s4) = s3 in
  let Coq_existT (w2, _) = s4 in
  Coq_existT ((Obj.magic (x1 , x2)), (Coq_existT ((Obj.magic (y1 , y2)),
  (Coq_existT ((Obj.magic (z1 , z2)), (Coq_existT (
  (Obj.magic (w1 , w2)), __)))))))

(** val leftLeMultComp_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> ((coq_LeftLeMultComp_comp,
    coq_LeftLeMultComp_comp) sum, coq_LeftStrictEquiv_comp *
    coq_LeftMultComp_comp) sum -> (carrier, (carrier, (carrier, (carrier, __)
    sigT) sigT) sigT) sigT **)

let leftLeMultComp_comp a b = function
  | Coq_inl s ->
      (match s with
         | Coq_inl p1 ->
             let b0 = b.setoid.choose in
             let Coq_existT (x0, s0) = p1 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT
             ((Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)),
             (Coq_existT ((Obj.magic (w , b0)), __)))))))
         | Coq_inr p2 ->
             let a0 = a.setoid.choose in
             let Coq_existT (x0, s0) = p2 __ __ in
             let Coq_existT (y, s1) = s0 in
             let Coq_existT (z, s2) = s1 in
             let Coq_existT (w, _) = s2 in
             Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT
             ((Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)),
             (Coq_existT ((Obj.magic (a0 , w)), __))))))))
  | Coq_inr p -> let p3 , p4 = p in llemc_CE_3 a b p3 p4

(** val leftLtLeMulpCoh_comp :
    coq_OrderSemigroup -> coq_OrderSemigroup -> (coq_LeftLtLeMulpCoh_comp,
    coq_LeftLtLeMulpCoh_comp) sum -> (carrier, (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT) sigT **)

let leftLtLeMulpCoh_comp a b = function
  | Coq_inl rllmc ->
      let b0 = b.setoid.choose in
      let Coq_existT (x0, s) = rllmc __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (x0 , b0)), (Coq_existT (
      (Obj.magic (y , b0)), (Coq_existT ((Obj.magic (z , b0)), (Coq_existT
      ((Obj.magic (w , b0)), __)))))))
  | Coq_inr rllmc ->
      let a0 = a.setoid.choose in
      let Coq_existT (x0, s) = rllmc __ __ in
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, s1) = s0 in
      let Coq_existT (w, _) = s1 in
      Coq_existT ((Obj.magic (a0 , x0)), (Coq_existT (
      (Obj.magic (a0 , y)), (Coq_existT ((Obj.magic (a0 , z)), (Coq_existT
      ((Obj.magic (a0 , w)), __)))))))

