open Datatypes
open DecSetoid
open Preorder
open PreorderProperties
open Product
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val lex_setoid : coq_Preorder -> coq_Preorder -> coq_DecSetoid **)

let lex_setoid a b =
  prodDecSetoid a.setoid b.setoid

(** val lex_le :
    coq_Preorder -> coq_Preorder -> carrier -> carrier -> bool **)

let lex_le a b x y =
  let x1 , x2 = Obj.magic x in
  let y1 , y2 = Obj.magic y in
  if a.le x1 y1
  then if negb (a.le y1 x1) then true else b.le x2 y2
  else false

(** val lexPreorder : coq_Preorder -> coq_Preorder -> coq_Preorder **)

let lexPreorder a b =
  { setoid = (prodDecSetoid a.setoid b.setoid); le = (lex_le a b) }

(** val hasTop :
    coq_Preorder -> coq_Preorder -> (coq_HasTop * coq_HasTop) -> coq_HasTop **)

let hasTop a b = function
  | h , x0 ->
      let Coq_existT (a0, _) = h in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val hasTop_comp :
    coq_Preorder -> coq_Preorder -> (coq_HasTop_comp, coq_HasTop_comp) sum ->
    coq_HasTop_comp **)

let hasTop_comp a b x t =
  match x with
    | Coq_inl ta ->
        let x1 , x2 = Obj.magic t in
        let Coq_existT (y, _) = ta x1 in
        Coq_existT ((Obj.magic (y , x2)), __)
    | Coq_inr tb ->
        let x1 , x2 = Obj.magic t in
        let Coq_existT (y, _) = tb x2 in
        Coq_existT ((Obj.magic (x1 , y)), __)

(** val hasBottom :
    coq_Preorder -> coq_Preorder -> (coq_HasBottom * coq_HasBottom) ->
    coq_HasBottom **)

let hasBottom a b = function
  | h , x0 ->
      let Coq_existT (a0, _) = h in
      let Coq_existT (b0, _) = x0 in Coq_existT ((Obj.magic (a0 , b0)), __)

(** val hasBottom_comp :
    coq_Preorder -> coq_Preorder -> (coq_HasBottom_comp, coq_HasBottom_comp)
    sum -> coq_HasBottom_comp **)

let hasBottom_comp a b x t =
  match x with
    | Coq_inl ta ->
        let x1 , x2 = Obj.magic t in
        let Coq_existT (y, _) = ta x1 in
        Coq_existT ((Obj.magic (y , x2)), __)
    | Coq_inr tb ->
        let x1 , x2 = Obj.magic t in
        let Coq_existT (y, _) = tb x2 in
        Coq_existT ((Obj.magic (x1 , y)), __)

(** val total_comp :
    coq_Preorder -> coq_Preorder -> (coq_Total_comp, coq_Total_comp) sum ->
    coq_Total_comp **)

let total_comp a b = function
  | Coq_inl t ->
      let Coq_existT (x0, s) = t in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y , b.setoid.choose)), __)))
  | Coq_inr t ->
      let Coq_existT (x0, s) = t in
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x0)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y)), __)))

(** val antisym_comp :
    coq_Preorder -> coq_Preorder -> (coq_Antisym_comp, coq_Antisym_comp) sum
    -> coq_Antisym_comp **)

let antisym_comp a b = function
  | Coq_inl a0 ->
      let Coq_existT (x1, s) = a0 in
      let Coq_existT (y1, _) = s in
      Coq_existT ((Obj.magic (x1 , b.setoid.choose)), (Coq_existT
      ((Obj.magic (y1 , b.setoid.choose)), __)))
  | Coq_inr a0 ->
      let Coq_existT (x2, s) = a0 in
      let Coq_existT (y2, _) = s in
      Coq_existT ((Obj.magic (a.setoid.choose , x2)), (Coq_existT
      ((Obj.magic (a.setoid.choose , y2)), __)))

