open DecSetoid
open DecSetoidProperties
open LeftNaturalOrder
open Logic0
open OrderSemigroup
open OrderSemigroupGlue
open OrderSemigroupProperties
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val leftNaturalOrder : coq_Semigroup -> coq_OrderSemigroup **)

let leftNaturalOrder s =
  glueOSmg s (leftNaturalOrder s)

(** val rightOpNonDecreasing_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> coq_RightOpNonDecreasing_comp **)

let rightOpNonDecreasing_comp s s0 =
  let Coq_existT (x, _) = s0 s.setoid.choose in
  let Coq_existT (w, _) =
    copy_var (s.setoid.equal (s.op x s.setoid.choose) s.setoid.choose)
  in
  if w
  then Coq_existT (x, (Coq_existT (s.setoid.choose, __)))
  else Coq_existT (s.setoid.choose, (Coq_existT (x, __)))

(** val leftOpNonDecreasing_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> coq_LeftOpNonDecreasing_comp **)

let leftOpNonDecreasing_comp s s0 =
  let Coq_existT (x, _) = s0 s.setoid.choose in
  let Coq_existT (w, _) =
    copy_var (s.setoid.equal (s.op x s.setoid.choose) s.setoid.choose)
  in
  if w
  then Coq_existT (x, (Coq_existT (s.setoid.choose, __)))
  else Coq_existT (s.setoid.choose, (Coq_existT (x, __)))

(** val selectiveOpNonDecreasing_comp :
    coq_Semigroup -> coq_IsSelective_comp -> (carrier, (carrier, __) sigT)
    sigT **)

let selectiveOpNonDecreasing_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, _) = s0 in Coq_existT (a, (Coq_existT (b, __)))

(** val leftOpIncreasing_comp :
    coq_Semigroup -> coq_LeftOpIncreasing_comp **)

let leftOpIncreasing_comp s =
  Coq_existT (s.setoid.choose, (Coq_existT (s.setoid.choose, __)))

(** val rightOpIncreasing_comp :
    coq_Semigroup -> coq_RightOpIncreasing_comp **)

let rightOpIncreasing_comp s =
  Coq_existT (s.setoid.choose, (Coq_existT (s.setoid.choose, __)))

(** val leftEquivCancelative_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> coq_LeftEquivCancelative_comp **)

let leftEquivCancelative_comp s sng =
  let Coq_existT (b, _) = sng s.setoid.choose in
  let Coq_existT (w, _) =
    copy_var (s.setoid.equal b (s.op s.setoid.choose b))
  in
  if w
  then Coq_existT (s.setoid.choose, (Coq_existT ((s.op s.setoid.choose b),
         (Coq_existT ((s.op s.setoid.choose b), __)))))
  else Coq_existT (b, (Coq_existT ((s.op s.setoid.choose b), (Coq_existT
         ((s.op s.setoid.choose b), __)))))

(** val rightEquivCancelative_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> coq_RightEquivCancelative_comp **)

let rightEquivCancelative_comp s sng =
  let Coq_existT (b, _) = sng s.setoid.choose in
  let Coq_existT (w, _) =
    copy_var (s.setoid.equal b (s.op s.setoid.choose b))
  in
  if w
  then Coq_existT (s.setoid.choose, (Coq_existT ((s.op s.setoid.choose b),
         (Coq_existT ((s.op s.setoid.choose b), __)))))
  else Coq_existT (b, (Coq_existT ((s.op s.setoid.choose b), (Coq_existT
         ((s.op s.setoid.choose b), __)))))

(** val leftEquivCondensed_comp :
    coq_Semigroup -> coq_LeftCondensed_comp -> coq_LeftEquivCondensed_comp **)

let leftEquivCondensed_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, s1) = s0 in
      let Coq_existT (c, _) = s1 in
      Coq_existT (a, (Coq_existT (b, (Coq_existT (c, __)))))

(** val rightEquivCondensed_comp :
    coq_Semigroup -> coq_RightCondensed_comp -> coq_RightEquivCondensed_comp **)

let rightEquivCondensed_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, s1) = s0 in
      let Coq_existT (c, _) = s1 in
      Coq_existT (a, (Coq_existT (b, (Coq_existT (c, __)))))

(** val rightChoiceIncrease_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, __) sigT)
    sigT **)

let rightChoiceIncrease_comp s sg =
  let a = s.setoid.choose in
  let Coq_existT (b, _) = sg a in
  let Coq_existT (w, _) = copy_var (s.setoid.equal (s.op a b) a) in
  if w
  then Coq_existT (b, (Coq_existT ((s.op a b), __)))
  else Coq_existT (a, (Coq_existT ((s.op a b), __)))

(** val leftChoiceIncrease_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, __) sigT)
    sigT **)

let leftChoiceIncrease_comp s sg =
  let a = s.setoid.choose in
  let Coq_existT (b, _) = sg a in
  let Coq_existT (w, _) = copy_var (s.setoid.equal (s.op a b) a) in
  if w
  then Coq_existT ((s.op a b), (Coq_existT (b, __)))
  else Coq_existT ((s.op a b), (Coq_existT (a, __)))

(** val rightTotal_comp :
    coq_Semigroup -> coq_TreeGlb_comp -> coq_RightTotal_comp **)

let rightTotal_comp s x =
  let Coq_existT (x0, s0) = x __ __ in
  let Coq_existT (y, s1) = s0 in
  let Coq_existT (z, _) = s1 in
  Coq_existT (z, (Coq_existT (x0, (Coq_existT (y, __)))))

(** val leftTotal_comp :
    coq_Semigroup -> coq_TreeGlb_comp -> coq_LeftTotal_comp **)

let leftTotal_comp s x =
  let Coq_existT (x0, s0) = x __ __ in
  let Coq_existT (y, s1) = s0 in
  let Coq_existT (z, _) = s1 in
  Coq_existT (z, (Coq_existT (x0, (Coq_existT (y, __)))))

(** val rightLtSwapEquiv_comp :
    coq_Semigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightLtSwapEquiv_comp s = function
  | Coq_existT (x0, s0) ->
      let Coq_existT (y, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (y, (Coq_existT (x0,
      __)))))))

(** val rightMultComp_comp :
    coq_Semigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightMultComp_comp s = function
  | Coq_existT (x0, s0) ->
      let Coq_existT (y, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (x0, (Coq_existT (y,
      __)))))))

(** val rightLtLeSwapEquiv_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightLtLeSwapEquiv_comp s sg =
  let Coq_existT (x, s0) =
    let x = s.setoid.choose in
    let Coq_existT (y, _) = sg x in
    let Coq_existT (w, _) = copy_var (s.setoid.equal (s.op x y) x) in
    if w
    then Coq_existT (x, (Coq_existT (y, __)))
    else Coq_existT ((s.op x y), (Coq_existT (x, __)))
  in
  let Coq_existT (y, _) = s0 in
  Coq_existT (x, (Coq_existT (y, (Coq_existT (y, (Coq_existT (x, __)))))))

(** val rightMultPresLtLe_comp :
    coq_Semigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightMultPresLtLe_comp s = function
  | Coq_existT (x0, s0) ->
      let Coq_existT (y, _) = s0 in
      Coq_existT (x0, (Coq_existT (y, (Coq_existT (y, (Coq_existT (x0,
      __)))))))

(** val rightStrictEquiv_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT) sigT **)

let rightStrictEquiv_comp s sg =
  let Coq_existT (x, s0) =
    let x = s.setoid.choose in
    let Coq_existT (y, _) = sg x in
    let Coq_existT (w, _) = copy_var (s.setoid.equal (s.op x y) x) in
    if w
    then Coq_existT (x, (Coq_existT (y, __)))
    else Coq_existT ((s.op x y), (Coq_existT (x, __)))
  in
  let Coq_existT (y, _) = s0 in
  Coq_existT (y, (Coq_existT (x, (Coq_existT (x, (Coq_existT (y, __)))))))

