open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open DecSetoidProperties
open FSetOp
open FSetsUnion
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val fsetOpBisemigroup : coq_Semigroup -> coq_Bisemigroup **)

let fsetOpBisemigroup a =
  glueBSmg (fsetsUnionSemigroup a.setoid) (fsetOpSemigroup a)

(** val singl :
    coq_Semigroup -> coq_IsSingleton -> carrier -> (__, (carrier, __) sigT)
    sum **)

let singl a x x0 =
  let Coq_existT (a0, _) = x in
  (match Obj.magic x0 with
     | [] -> Coq_inl __
     | x1 :: xs -> Coq_inr (Coq_existT (a0, __)))

(** val hasTimesId_back :
    coq_Semigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasTimesId_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | [] -> assert false (* absurd case *)
         | ida :: m -> Coq_existT (ida, __))

(** val isRightStrictStable_comp :
    coq_Semigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightStrictStable_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val isLeftStrictStable_comp :
    coq_Semigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftStrictStable_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val isRightCompEqCancel_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isRightCompEqCancel_comp a sg =
  let Coq_existT (b, _) = sg a.setoid.choose in
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
  ((Obj.magic (b :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val isLeftCompEqCancel_comp :
    coq_Semigroup -> coq_IsSingleton_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isLeftCompEqCancel_comp a sg =
  let Coq_existT (b, _) = sg a.setoid.choose in
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
  ((Obj.magic (b :: [])), (Coq_existT ((Obj.magic []), __)))))

(** val isRightCompCancel_comp :
    coq_Semigroup -> coq_RightCondensed_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isRightCompCancel_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (b :: [])), (Coq_existT (
      (Obj.magic (c :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val isLeftCompCancel_comp :
    coq_Semigroup -> coq_LeftCondensed_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isLeftCompCancel_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (b :: [])), (Coq_existT (
      (Obj.magic (c :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val leftDiscrete_comp :
    coq_Semigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let leftDiscrete_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (a.setoid.choose :: [])),
    __)))))

(** val rightDiscrete_comp :
    coq_Semigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let rightDiscrete_comp a =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (a.setoid.choose :: [])),
    __)))))

(** val leftComparable_comp :
    coq_Semigroup -> coq_LeftCondensed_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let leftComparable_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (b :: [])), (Coq_existT (
      (Obj.magic (c :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val rightComparable_comp :
    coq_Semigroup -> coq_RightCondensed_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let rightComparable_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT ((Obj.magic (b :: [])), (Coq_existT (
      (Obj.magic (c :: [])), (Coq_existT ((Obj.magic (a0 :: [])), __)))))

(** val leftIncreasing_comp :
    coq_Semigroup -> coq_IsRight_comp -> (carrier, (carrier, __) sigT) sigT **)

let leftIncreasing_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (y :: [])), (Coq_existT (
      (Obj.magic (x0 :: [])), __)))

(** val rightIncreasing_comp :
    coq_Semigroup -> coq_IsLeft_comp -> (carrier, (carrier, __) sigT) sigT **)

let rightIncreasing_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (x0 :: [])), (Coq_existT (
      (Obj.magic (y :: [])), __)))

(** val leftStrictIncreasing_comp :
    coq_Semigroup -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val rightStrictIncreasing_comp :
    coq_Semigroup -> (carrier, (carrier, __) sigT) sigT **)

let rightStrictIncreasing_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_Semigroup -> coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a hasId =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic (a.setoid.choose :: [])), __)))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_Semigroup -> coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a hasId =
  Coq_existT ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic (a.setoid.choose :: [])), (Coq_existT
    ((Obj.magic (a.setoid.choose :: [])), __)))))

