open DecSetoid
open DecSetoidProperties
open FSets
open Semigroup
open SemigroupProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val fsetsIntersectionSemigroup : coq_DecSetoid -> coq_Semigroup **)

let fsetsIntersectionSemigroup a =
  { setoid = (fsetDecSetoid a); op = (Obj.magic (intersect a)) }

(** val isSelective_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_IsSelective_comp **)

let isSelective_comp a sa =
  let Coq_existT (b, _) = sa a.choose in
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT
  ((Obj.magic (b :: [])), __)))

(** val hasIdentity : coq_DecSetoid -> coq_Finite -> coq_HasIdentity **)

let hasIdentity a = function
  | Coq_existT (l, _) -> Coq_existT ((Obj.magic l), __)

(** val hasIdentity_comp :
    coq_DecSetoid -> coq_Finite_comp -> coq_HasIdentity_comp **)

let hasIdentity_comp a fl x =
  let Coq_existT (y, _) = Obj.magic fl x in
  Coq_existT ((Obj.magic (y :: [])), __)

(** val hasAnnihilator : coq_DecSetoid -> coq_HasAnnihilator **)

let hasAnnihilator a =
  Coq_existT ((Obj.magic []), __)

(** val isLeft_comp : coq_DecSetoid -> coq_IsLeft_comp **)

let isLeft_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), __)))

(** val isRight_comp : coq_DecSetoid -> coq_IsRight_comp **)

let isRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])),
    __)))

(** val leftCondensed_comp : coq_DecSetoid -> coq_LeftCondensed_comp **)

let leftCondensed_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])), __)))))

(** val rightCondensed_comp : coq_DecSetoid -> coq_RightCondensed_comp **)

let rightCondensed_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), (Coq_existT ((Obj.magic (a.choose :: [])), __)))))

(** val leftCancelative_comp : coq_DecSetoid -> coq_LeftCancelative_comp **)

let leftCancelative_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val rightCancelative_comp :
    coq_DecSetoid -> coq_RightCancelative_comp **)

let rightCancelative_comp a =
  Coq_existT ((Obj.magic (a.choose :: [])), (Coq_existT (
    (Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val antiRight_comp : coq_DecSetoid -> coq_AntiRight_comp **)

let antiRight_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiLeft_comp : coq_DecSetoid -> coq_AntiLeft_comp **)

let antiLeft_comp a =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

