open Datatypes
open DecSetoid
open DecSetoidProperties
open List0
open Logic0
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val mem : coq_DecSetoid -> carrier -> carrier list -> bool **)

let mem a x l =
  existsb (fun y -> a.equal x y) l

(** val subset : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let subset a x y =
  forallb (fun a0 -> mem a a0 y) x

(** val eq_fset : coq_DecSetoid -> carrier list -> carrier list -> bool **)

let eq_fset a x y =
  if subset a x y then subset a y x else false

(** val nodub : coq_DecSetoid -> carrier list -> carrier list **)

let rec nodub a = function
  | [] -> []
  | a0 :: x' -> if mem a a0 x' then nodub a x' else a0 :: (nodub a x')

(** val union :
    coq_DecSetoid -> carrier list -> carrier list -> carrier list **)

let union a x y =
  nodub a (app x y)

(** val intersect :
    coq_DecSetoid -> carrier list -> carrier list -> carrier list **)

let intersect a x y =
  filter (fun a0 -> mem a a0 y) x

(** val subt :
    coq_DecSetoid -> carrier list -> carrier list -> carrier list **)

let subt a x y =
  filter (fun a0 -> negb (mem a a0 y)) x

(** val existsb_mem_elim :
    coq_DecSetoid -> (carrier -> bool) -> carrier list -> (carrier, __) sigT **)

let rec existsb_mem_elim a f = function
  | [] -> assert false (* absurd case *)
  | a0 :: l ->
      let Coq_existT (w, _) = copy_var (f a0) in
      if w
      then Coq_existT (a0, __)
      else let Coq_existT (x, _) = existsb_mem_elim a f l in
           Coq_existT (x, __)

(** val fsetDecSetoid : coq_DecSetoid -> coq_DecSetoid **)

let fsetDecSetoid a =
  { choose = (Obj.magic []); equal = (Obj.magic (eq_fset a)) }

(** val isSingleton_comp : coq_DecSetoid -> coq_IsSingleton_comp **)

let isSingleton_comp a c =
  match Obj.magic c with
    | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
    | a0 :: c0 -> Coq_existT ((Obj.magic []), __)

(** val twoElements : coq_DecSetoid -> coq_IsSingleton -> coq_TwoElements **)

let twoElements a = function
  | Coq_existT (c, _) -> Coq_existT ((Obj.magic (c :: [])), (Coq_existT
      ((Obj.magic []), __)))

(** val twoElements_comp :
    coq_DecSetoid -> coq_IsSingleton_comp -> coq_TwoElements_comp **)

let twoElements_comp a h a0 b =
  match Obj.magic a0 with
    | [] ->
        (match Obj.magic b with
           | [] -> Coq_existT ((Obj.magic (a.choose :: [])), __)
           | b0 :: y ->
               let Coq_existT (c, _) = h b0 in
               Coq_existT ((Obj.magic (c :: [])), __))
    | a1 :: x ->
        (match Obj.magic b with
           | [] ->
               let Coq_existT (c, _) = h a1 in
               Coq_existT ((Obj.magic (c :: [])), __)
           | b0 :: y -> Coq_existT ((Obj.magic []), __))

(** val powerset : 'a1 list -> 'a1 list list **)

let rec powerset = function
  | [] -> [] :: []
  | a :: x' -> app (map (fun x0 -> a :: x0) (powerset x')) (powerset x')

(** val mem_map_elim :
    coq_DecSetoid -> coq_DecSetoid -> (carrier -> carrier) -> carrier ->
    carrier list -> (carrier, __) sigT **)

let rec mem_map_elim a b f x = function
  | [] -> assert false (* absurd case *)
  | a1 :: l ->
      let Coq_existT (w, _) = copy_var (a.equal x (f a1)) in
      if w
      then Coq_existT (a1, __)
      else let Coq_existT (y, _) = mem_map_elim a b f x l in
           Coq_existT (y, __)

(** val finite : coq_DecSetoid -> coq_Finite -> coq_Finite **)

let finite a = function
  | Coq_existT (l, _) -> Coq_existT ((Obj.magic (powerset l)), __)

(** val flat : coq_DecSetoid -> carrier list -> carrier **)

let flat a l =
  fold_right (fun x y -> Obj.magic (union a (Obj.magic x) (Obj.magic y)))
    (Obj.magic []) l

(** val finite_comp : coq_DecSetoid -> coq_Finite_comp -> coq_Finite_comp **)

let finite_comp a fn l =
  let Coq_existT (x, _) = Obj.magic fn (flat a l) in
  Coq_existT ((Obj.magic (x :: (Obj.magic (flat a l)))), __)

