open Datatypes
open DecSetoid
open DecSetoidProperties
open FSets
open List0
open Logic0
open Semigroup
open SemigroupProperties
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val fset_op : coq_Semigroup -> carrier -> carrier -> carrier **)

let fset_op s x y =
  Obj.magic
    (map (fun w -> let w1 , w2 = w in s.op w1 w2)
      (list_prod (Obj.magic x) (Obj.magic y)))

(** val fset_op_elim :
    coq_Semigroup -> carrier -> carrier -> carrier -> (carrier, (carrier, __)
    sigT) sigT **)

let fset_op_elim s a x y =
  let rec f = function
    | [] -> assert false (* absurd case *)
    | a0 :: l0 ->
        let Coq_existT (w, _) =
          copy_var
            (mem s.setoid a (map (fun x0 -> s.op a0 x0) (Obj.magic y)))
        in
        if w
        then let Coq_existT (c, _) =
               mem_map_elim s.setoid s.setoid (fun x0 -> 
                 s.op a0 x0) a (Obj.magic y)
             in
             Coq_existT (a0, (Coq_existT (c, __)))
        else let Coq_existT (b, s0) = f l0 in
             let Coq_existT (c, _) = s0 in
             Coq_existT (b, (Coq_existT (c, __)))
  in f (Obj.magic x)

(** val fsetOpSemigroup : coq_Semigroup -> coq_Semigroup **)

let fsetOpSemigroup s =
  { setoid = (fsetDecSetoid s.setoid); op = (fset_op s) }

(** val isIdempotent_comp :
    coq_Semigroup -> coq_IsSelective_comp -> coq_IsIdempotent_comp **)

let isIdempotent_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, _) = s0 in
      Coq_existT ((Obj.magic (a :: (b :: []))), __)

(** val isSelective_comp :
    coq_Semigroup -> ((coq_IsLeft_comp * coq_IsRight_comp) *
    (coq_TwoElements_comp, coq_IsIdempotent_comp) sum) ->
    coq_IsSelective_comp **)

let isSelective_comp s = function
  | p , x0 ->
      let i , x1 = p in
      let Coq_existT (a, s0) = i in
      let Coq_existT (b, _) = s0 in
      let Coq_existT (c, s1) = x1 in
      let Coq_existT (d, _) = s1 in
      (match x0 with
         | Coq_inl te ->
             let Coq_existT (w, _) = copy_var (s.setoid.equal (s.op a b) a)
             in
             if w
             then assert false (* absurd case *)
             else let Coq_existT (w0, _) =
                    copy_var (s.setoid.equal (s.op a b) b)
                  in
                  if w0
                  then let Coq_existT (w1, _) =
                         copy_var (s.setoid.equal (s.op c d) c)
                       in
                       if w1
                       then let Coq_existT (w2, _) =
                              copy_var (s.setoid.equal (s.op c c) c)
                            in
                            if w2
                            then let Coq_existT (w3, _) =
                                   copy_var (s.setoid.equal (s.op d d) d)
                                 in
                                 if w3
                                 then let Coq_existT (
                                        w4, _) =
                                        copy_var
                                          (s.setoid.equal (s.op a a) a)
                                      in
                                      if w4
                                      then let Coq_existT (
                                             w5, _) =
                                             copy_var
                                               (s.setoid.equal (s.op b b) b)
                                           in
                                           if w5
                                           then let Coq_existT (
                                                  w6, _) =
                                                  copy_var
                                                  (s.setoid.equal a b)
                                                in
                                                if w6
                                                then 
                                                  assert false
                                                  (* absurd case *)
                                                else 
                                                  let Coq_existT (
                                                  w7, _) =
                                                  copy_var
                                                  (s.setoid.equal a d)
                                                  in
                                                  if w7
                                                  then 
                                                  let Coq_existT (
                                                  w8, _) =
                                                  copy_var
                                                  (s.setoid.equal b c)
                                                  in
                                                  if w8
                                                  then 
                                                  let Coq_existT (
                                                  x2, _) = 
                                                  te a b
                                                  in
                                                  let Coq_existT (
                                                  w9, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op x2 b) x2)
                                                  in
                                                  if w9
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (a :: (x2 ::
                                                  []))), (Coq_existT
                                                  ((Obj.magic (b :: [])),
                                                  __)))
                                                  else 
                                                  let Coq_existT (
                                                  w10, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op x2 b) b)
                                                  in
                                                  if w10
                                                  then 
                                                  let Coq_existT (
                                                  w11, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op x2 a) x2)
                                                  in
                                                  if w11
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (x2 :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (a :: (b ::
                                                  []))), __)))
                                                  else 
                                                  let Coq_existT (
                                                  w12, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op x2 a) a)
                                                  in
                                                  if w12
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (b :: (x2 ::
                                                  []))), (Coq_existT
                                                  ((Obj.magic (a :: [])),
                                                  __)))
                                                  else 
                                                  Coq_existT
                                                  ((Obj.magic (x2 :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (a :: [])),
                                                  __)))
                                                  else 
                                                  Coq_existT
                                                  ((Obj.magic (x2 :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (b :: [])),
                                                  __)))
                                                  else 
                                                  let Coq_existT (
                                                  w9, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op c b) c)
                                                  in
                                                  if w9
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (a :: (c ::
                                                  []))), (Coq_existT
                                                  ((Obj.magic (a :: (b ::
                                                  []))), __)))
                                                  else 
                                                  let Coq_existT (
                                                  w10, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op c b) b)
                                                  in
                                                  if w10
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (a :: (c ::
                                                  []))), (Coq_existT
                                                  ((Obj.magic (a :: (b ::
                                                  []))), __)))
                                                  else 
                                                  Coq_existT
                                                  ((Obj.magic (c :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (b :: [])),
                                                  __)))
                                                  else 
                                                  let Coq_existT (
                                                  w8, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op a d) a)
                                                  in
                                                  if w8
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (a :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (b :: (d ::
                                                  []))), __)))
                                                  else 
                                                  let Coq_existT (
                                                  w9, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op a d) d)
                                                  in
                                                  if w9
                                                  then 
                                                  Coq_existT
                                                  ((Obj.magic (a :: (c ::
                                                  []))), (Coq_existT
                                                  ((Obj.magic (d :: [])),
                                                  __)))
                                                  else 
                                                  Coq_existT
                                                  ((Obj.magic (a :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (d :: [])),
                                                  __)))
                                           else let Coq_existT (
                                                  w6, _) =
                                                  copy_var
                                                  (s.setoid.equal 
                                                  (s.op b b) b)
                                                in
                                                if w6
                                                then 
                                                  assert false
                                                  (* absurd case *)
                                                else 
                                                  Coq_existT
                                                  ((Obj.magic (b :: [])),
                                                  (Coq_existT
                                                  ((Obj.magic (b :: [])),
                                                  __)))
                                      else let Coq_existT (
                                             w5, _) =
                                             copy_var
                                               (s.setoid.equal (s.op a a) a)
                                           in
                                           if w5
                                           then assert false
                                                  (* absurd case *)
                                           else Coq_existT
                                                  (
                                                  (Obj.magic (a :: [])),
                                                  (Coq_existT
                                                  (
                                                  (Obj.magic (a :: [])),
                                                  __)))
                                 else let Coq_existT (
                                        w4, _) =
                                        copy_var
                                          (s.setoid.equal (s.op d d) d)
                                      in
                                      if w4
                                      then assert false (* absurd case *)
                                      else Coq_existT (
                                             (Obj.magic (d :: [])),
                                             (Coq_existT
                                             ((Obj.magic (d :: [])), __)))
                            else let Coq_existT (w3, _) =
                                   copy_var (s.setoid.equal (s.op c c) c)
                                 in
                                 if w3
                                 then assert false (* absurd case *)
                                 else Coq_existT ((Obj.magic (c :: [])),
                                        (Coq_existT (
                                        (Obj.magic (c :: [])), __)))
                       else let Coq_existT (w2, _) =
                              copy_var (s.setoid.equal (s.op c d) d)
                            in
                            if w2
                            then assert false (* absurd case *)
                            else Coq_existT ((Obj.magic (c :: [])),
                                   (Coq_existT ((Obj.magic (d :: [])), __)))
                  else Coq_existT ((Obj.magic (a :: [])), (Coq_existT
                         ((Obj.magic (b :: [])), __)))
         | Coq_inr i0 ->
             let Coq_existT (x2, _) = i0 in
             Coq_existT ((Obj.magic (x2 :: [])), (Coq_existT
             ((Obj.magic (x2 :: [])), __))))

(** val isCommutative_comp :
    coq_Semigroup -> coq_IsCommutative_comp -> coq_IsCommutative_comp **)

let isCommutative_comp s = function
  | Coq_existT (a, s0) ->
      let Coq_existT (b, _) = s0 in
      Coq_existT ((Obj.magic (a :: [])), (Coq_existT (
      (Obj.magic (b :: [])), __)))

(** val hasIdentity : coq_Semigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasIdentity s = function
  | Coq_existT (a, _) -> Coq_existT ((Obj.magic (a :: [])), __)

(** val hasIdentity_comp :
    coq_Semigroup -> coq_HasIdentity_comp -> coq_HasIdentity_comp **)

let hasIdentity_comp s id i =
  match Obj.magic i with
    | [] -> Coq_existT ((Obj.magic (s.setoid.choose :: [])), __)
    | x :: xs ->
        let Coq_existT (c, _) = id x in
        Coq_existT ((Obj.magic (c :: [])), __)

(** val hasAnnihilator : coq_Semigroup -> coq_HasAnnihilator **)

let hasAnnihilator s =
  Coq_existT ((Obj.magic []), __)

(** val isLeft_comp : coq_Semigroup -> coq_IsLeft_comp **)

let isLeft_comp s =
  Coq_existT ((Obj.magic (s.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), __)))

(** val isRight_comp : coq_Semigroup -> coq_IsRight_comp **)

let isRight_comp s =
  Coq_existT ((Obj.magic []), (Coq_existT
    ((Obj.magic (s.setoid.choose :: [])), __)))

(** val leftCondensed_comp : coq_Semigroup -> coq_LeftCondensed_comp **)

let leftCondensed_comp s =
  Coq_existT ((Obj.magic (s.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (s.setoid.choose :: [])),
    __)))))

(** val rightCondensed_comp : coq_Semigroup -> coq_RightCondensed_comp **)

let rightCondensed_comp s =
  Coq_existT ((Obj.magic (s.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic (s.setoid.choose :: [])),
    __)))))

(** val leftCancelative_comp : coq_Semigroup -> coq_LeftCancelative_comp **)

let leftCancelative_comp s =
  Coq_existT ((Obj.magic (s.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val rightCancelative_comp :
    coq_Semigroup -> coq_RightCancelative_comp **)

let rightCancelative_comp s =
  Coq_existT ((Obj.magic (s.setoid.choose :: [])), (Coq_existT
    ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))))

(** val antiRight_comp : coq_Semigroup -> coq_AntiRight_comp **)

let antiRight_comp s =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

(** val antiLeft_comp : coq_Semigroup -> coq_AntiLeft_comp **)

let antiLeft_comp s =
  Coq_existT ((Obj.magic []), (Coq_existT ((Obj.magic []), __)))

