open DecSetoid
open Preorder
open PreorderProperties
open Specif

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val ge : coq_Preorder -> carrier -> carrier -> bool **)

let ge p x y =
  p.le y x

(** val dualPreorder : coq_Preorder -> coq_Preorder **)

let dualPreorder p =
  { setoid = p.setoid; le = (ge p) }

(** val hasTop : coq_Preorder -> coq_HasBottom -> coq_HasTop **)

let hasTop p = function
  | Coq_existT (b, _) -> Coq_existT (b, __)

(** val hasTop_comp :
    coq_Preorder -> coq_HasBottom_comp -> coq_HasTop_comp **)

let hasTop_comp p h x =
  let Coq_existT (a, _) = h x in Coq_existT (a, __)

(** val hasBottom : coq_Preorder -> coq_HasTop -> coq_HasBottom **)

let hasBottom p = function
  | Coq_existT (t, _) -> Coq_existT (t, __)

(** val hasBottom_comp :
    coq_Preorder -> coq_HasTop_comp -> coq_HasBottom_comp **)

let hasBottom_comp p h x =
  let Coq_existT (a, _) = h x in Coq_existT (a, __)

(** val total_comp : coq_Preorder -> coq_Total_comp -> coq_Total_comp **)

let total_comp p = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

(** val antisym_comp :
    coq_Preorder -> coq_Antisym_comp -> coq_Antisym_comp **)

let antisym_comp p = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (x0, (Coq_existT (y, __)))

