open DecSetoid
open DecSetoidProperties
open List0
open Specif

type dsProp = { isSingleton : coq_IsSingleton option;
                isSingleton_comp : coq_IsSingleton_comp option;
                twoElements : coq_TwoElements option;
                twoElements_comp : coq_TwoElements_comp option;
                finite : coq_Finite option;
                finite_comp : coq_Finite_comp option }

val dsProp_rect :
  coq_DecSetoid -> (coq_IsSingleton option -> coq_IsSingleton_comp option ->
  coq_TwoElements option -> coq_TwoElements_comp option -> coq_Finite option
  -> coq_Finite_comp option -> 'a1) -> dsProp -> 'a1

val dsProp_rec :
  coq_DecSetoid -> (coq_IsSingleton option -> coq_IsSingleton_comp option ->
  coq_TwoElements option -> coq_TwoElements_comp option -> coq_Finite option
  -> coq_Finite_comp option -> 'a1) -> dsProp -> 'a1

val isSingleton : coq_DecSetoid -> dsProp -> coq_IsSingleton option

val isSingleton_comp : coq_DecSetoid -> dsProp -> coq_IsSingleton_comp option

val twoElements : coq_DecSetoid -> dsProp -> coq_TwoElements option

val twoElements_comp : coq_DecSetoid -> dsProp -> coq_TwoElements_comp option

val finite : coq_DecSetoid -> dsProp -> coq_Finite option

val finite_comp : coq_DecSetoid -> dsProp -> coq_Finite_comp option

val dsPropIso :
  coq_DecSetoid -> coq_DecSetoid -> coq_DsIso -> dsProp -> dsProp

