open DecSetoid
open Semigroup
open SemigroupProperties
open Specif
open Transform
open TransformProperties

let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val cayley_app : coq_Semigroup -> carrier -> carrier -> carrier **)

let cayley_app a f x =
  a.op f x

(** val cayleyMapTransform : coq_Semigroup -> coq_Transform **)

let cayleyMapTransform a =
  { setoid = a.Semigroup.setoid; fn = a.Semigroup.setoid; app =
    (cayley_app a) }

(** val cancelative_comp :
    coq_Semigroup -> coq_LeftCancelative_comp -> coq_Cancelative_comp **)

let cancelative_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (a0, (Coq_existT (b, (Coq_existT (c, __)))))

(** val condensed_comp :
    coq_Semigroup -> coq_LeftCondensed_comp -> coq_Condensed_comp **)

let condensed_comp a = function
  | Coq_existT (a0, s) ->
      let Coq_existT (b, s0) = s in
      let Coq_existT (c, _) = s0 in
      Coq_existT (b, (Coq_existT (c, (Coq_existT (a0, __)))))

(** val identity_comp :
    coq_Semigroup -> coq_IsRight_comp -> coq_Identity_comp **)

let identity_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in Coq_existT (y, (Coq_existT (x0, __)))

