open DecSetoid
open Semigroup
open Specif

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

type coq_Bisemigroup = { setoid : coq_DecSetoid;
                         plus : (carrier -> carrier -> carrier);
                         times : (carrier -> carrier -> carrier) }

(** val coq_Bisemigroup_rect :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> (carrier -> carrier
    -> carrier) -> __ -> __ -> __ -> __ -> 'a1) -> coq_Bisemigroup -> 'a1 **)

let coq_Bisemigroup_rect f b =
  let { setoid = x; plus = x0; times = x1 } = b in f x x0 x1 __ __ __ __

(** val coq_Bisemigroup_rec :
    (coq_DecSetoid -> (carrier -> carrier -> carrier) -> (carrier -> carrier
    -> carrier) -> __ -> __ -> __ -> __ -> 'a1) -> coq_Bisemigroup -> 'a1 **)

let coq_Bisemigroup_rec f b =
  let { setoid = x; plus = x0; times = x1 } = b in f x x0 x1 __ __ __ __

(** val setoid : coq_Bisemigroup -> coq_DecSetoid **)

let setoid x = x.setoid

(** val plus : coq_Bisemigroup -> carrier -> carrier -> carrier **)

let plus x = x.plus

(** val times : coq_Bisemigroup -> carrier -> carrier -> carrier **)

let times x = x.times

(** val plusSmg : coq_Bisemigroup -> coq_Semigroup **)

let plusSmg bS =
  { Semigroup.setoid = bS.setoid; op = bS.plus }

(** val timesSmg : coq_Bisemigroup -> coq_Semigroup **)

let timesSmg bS =
  { Semigroup.setoid = bS.setoid; op = bS.times }

(** val coq_IsBSmgIso_rect :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_DsIso -> (__ -> __ -> __ -> __
    -> 'a1) -> 'a1 **)

let coq_IsBSmgIso_rect b b' dsIso0 f =
  f __ __ __ __

(** val coq_IsBSmgIso_rec :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_DsIso -> (__ -> __ -> __ -> __
    -> 'a1) -> 'a1 **)

let coq_IsBSmgIso_rec b b' dsIso0 f =
  f __ __ __ __

type coq_BSmgIso =
  coq_DsIso
  (* singleton inductive, whose constructor was Build_BSmgIso *)

(** val coq_BSmgIso_rect :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_DsIso -> __ -> 'a1) ->
    coq_BSmgIso -> 'a1 **)

let coq_BSmgIso_rect b b' f b0 =
  f b0 __

(** val coq_BSmgIso_rec :
    coq_Bisemigroup -> coq_Bisemigroup -> (coq_DsIso -> __ -> 'a1) ->
    coq_BSmgIso -> 'a1 **)

let coq_BSmgIso_rec b b' f b0 =
  f b0 __

(** val dsIso :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_BSmgIso -> coq_DsIso **)

let dsIso b b' b0 =
  b0

(** val plusSmgBSmgIso :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_BSmgIso -> coq_SmgIso **)

let plusSmgBSmgIso b b' iso =
  iso

(** val timesSmgBSmgIso :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_BSmgIso -> coq_SmgIso **)

let timesSmgBSmgIso b b' iso =
  iso

(** val coq_BSmgIso_refl : coq_Bisemigroup -> coq_BSmgIso **)

let coq_BSmgIso_refl b =
  { phi = (fun x -> x); phi' = (fun x -> x) }

(** val coq_BSmgIso_sym :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_BSmgIso -> coq_BSmgIso **)

let coq_BSmgIso_sym b b' i =
  { phi = i.phi'; phi' = i.phi }

(** val coq_BSmgIso_trans :
    coq_Bisemigroup -> coq_Bisemigroup -> coq_Bisemigroup -> coq_BSmgIso ->
    coq_BSmgIso -> coq_BSmgIso **)

let coq_BSmgIso_trans b b' b'' i i' =
  coq_DsIso_trans b.setoid b'.setoid b''.setoid i i'

(** val liftBSmgIso :
    coq_DecSetoid -> coq_Bisemigroup -> coq_DsIso -> (coq_Bisemigroup,
    coq_BSmgIso * __) sigT **)

let liftBSmgIso a b iso =
  Coq_existT ({ setoid = a; plus = (fun x y ->
    iso.phi' (b.plus (iso.phi x) (iso.phi y))); times = (fun x y ->
    iso.phi' (b.times (iso.phi x) (iso.phi y))) }, ({ phi = iso.phi; phi' =
    iso.phi' } , __))

