open AstDS
open DecSetoid
open OcamlTypes
open Specif
open Transform

(** val app_T :
    coq_Transform -> (carrier, 'a1) splitMono -> (carrier, 'a2) splitMono ->
    carrier -> carrier -> carrier **)

let app_T s smono fnsmono a b =
  (Obj.magic smono).mono
    (s.app ((Obj.magic fnsmono).mono_inv a) ((Obj.magic smono).mono_inv b))

(** val buildIsoTf :
    coq_Transform -> (carrier, 'a1) splitMono -> (carrier, 'a2) splitMono ->
    coq_Transform **)

let buildIsoTf s smono fnsmono =
  { setoid = (buildIsoDs s.setoid smono); fn = (buildIsoDs s.fn fnsmono);
    app = (fun x x0 -> app_T s smono fnsmono x x0) }

(** val buildIsoTf_Iso :
    coq_Transform -> (carrier, 'a1) splitMono -> (carrier, 'a2) splitMono ->
    coq_TfIso **)

let buildIsoTf_Iso s smono fnsmono =
  { dsIso = { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }; fnIso = { phi = (fun x ->
    (Obj.magic fnsmono).mono x); phi' = (fun x ->
    (Obj.magic fnsmono).mono_inv x) } }

(** val astTF :
    coq_Transform -> ocamlTypes -> ocamlTypes -> (coq_Transform, coq_TfIso)
    sigT **)

let astTF x t fnt =
  let h = astSplitMono t in
  let h' = astSplitMono fnt in
  Coq_existT ((buildIsoTf x h h'), (buildIsoTf_Iso x h h'))

