open AstDS
open DecSetoid
open OcamlTypes
open SemigroupTransform
open Specif

(** val op_T :
    coq_SemigroupTransform -> (carrier, 'a1) splitMono -> carrier -> carrier
    -> carrier **)

let op_T s smono a b =
  (Obj.magic smono).mono
    (s.op ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b))

(** val app_T :
    coq_SemigroupTransform -> (carrier, 'a1) splitMono -> (carrier, 'a2)
    splitMono -> carrier -> carrier -> carrier **)

let app_T s smono fnsmono a b =
  (Obj.magic smono).mono
    (s.app ((Obj.magic fnsmono).mono_inv a) ((Obj.magic smono).mono_inv b))

(** val buildIsoSTf :
    coq_SemigroupTransform -> (carrier, 'a1) splitMono -> (carrier, 'a2)
    splitMono -> coq_SemigroupTransform **)

let buildIsoSTf s smono fnsmono =
  { setoid = (buildIsoDs s.setoid smono); op = (fun x x0 ->
    op_T s smono x x0); fn = (buildIsoDs s.fn fnsmono); app = (fun x x0 ->
    app_T s smono fnsmono x x0) }

(** val buildIsoSTf_Iso :
    coq_SemigroupTransform -> (carrier, 'a1) splitMono -> (carrier, 'a2)
    splitMono -> coq_STfIso **)

let buildIsoSTf_Iso s smono fnsmono =
  { dsIso = { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }; fnIso = { phi = (fun x ->
    (Obj.magic fnsmono).mono x); phi' = (fun x ->
    (Obj.magic fnsmono).mono_inv x) } }

(** val astST :
    coq_SemigroupTransform -> ocamlTypes -> ocamlTypes ->
    (coq_SemigroupTransform, coq_STfIso) sigT **)

let astST x t fnt =
  let h = astSplitMono t in
  let h' = astSplitMono fnt in
  Coq_existT ((buildIsoSTf x h h'), (buildIsoSTf_Iso x h h'))

