open AstDS
open DecSetoid
open OcamlTypes
open Semigroup
open Specif

(** val op_T :
    coq_Semigroup -> (carrier, 'a1) splitMono -> carrier -> carrier ->
    carrier **)

let op_T s smono a b =
  (Obj.magic smono).mono
    (s.op ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b))

(** val buildIsoSmg :
    coq_Semigroup -> (carrier, 'a1) splitMono -> coq_Semigroup **)

let buildIsoSmg s smono =
  { setoid = (buildIsoDs s.setoid smono); op = (fun x x0 ->
    op_T s smono x x0) }

(** val buildIsoSmg_Iso :
    coq_Semigroup -> (carrier, 'a1) splitMono -> coq_SmgIso **)

let buildIsoSmg_Iso s smono =
  { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }

(** val astSG :
    coq_Semigroup -> ocamlTypes -> (coq_Semigroup, coq_SmgIso) sigT **)

let astSG x t =
  let h = astSplitMono t in
  Coq_existT ((buildIsoSmg x h), { phi = (fun x0 -> 
  (Obj.magic h).mono x0); phi' = (fun x0 -> (Obj.magic h).mono_inv x0) })

