open AstDS
open DecSetoid
open OcamlTypes
open OrderSemigroup
open Specif

(** val le_T :
    coq_OrderSemigroup -> (carrier, 'a1) splitMono -> carrier -> carrier ->
    bool **)

let le_T o smono a b =
  o.le ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b)

(** val op_T :
    coq_OrderSemigroup -> (carrier, 'a1) splitMono -> carrier -> carrier ->
    carrier **)

let op_T o smono a b =
  (Obj.magic smono).mono
    (o.op ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b))

(** val buildIsoOSmg :
    coq_OrderSemigroup -> (carrier, 'a1) splitMono -> coq_OrderSemigroup **)

let buildIsoOSmg o smono =
  { setoid = (buildIsoDs o.setoid smono); le = (fun x x0 ->
    le_T o smono x x0); op = (fun x x0 -> op_T o smono x x0) }

(** val buildIsoOSmg_Iso :
    coq_OrderSemigroup -> (carrier, 'a1) splitMono -> coq_OSmgIso **)

let buildIsoOSmg_Iso o smono =
  { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }

(** val astOS :
    coq_OrderSemigroup -> ocamlTypes -> (coq_OrderSemigroup, coq_OSmgIso)
    sigT **)

let astOS x t =
  let h = astSplitMono t in
  Coq_existT ((buildIsoOSmg x h), { phi = (fun x0 -> 
  (Obj.magic h).mono x0); phi' = (fun x0 -> (Obj.magic h).mono_inv x0) })

