open DecSetoid
open OcamlTypes
open Specif

(** val eq_T :
    coq_DecSetoid -> (carrier, 'a1) splitMono -> 'a1 -> 'a1 -> bool **)

let eq_T d smono a b =
  d.equal (smono.mono_inv a) (smono.mono_inv b)

(** val buildIsoDs :
    coq_DecSetoid -> (carrier, 'a1) splitMono -> coq_DecSetoid **)

let buildIsoDs d smono =
  { choose = ((Obj.magic smono).mono d.choose); equal = (fun x x0 ->
    eq_T d (Obj.magic smono) x x0) }

(** val buildIsoDs_Iso :
    coq_DecSetoid -> (carrier, 'a1) splitMono -> coq_DsIso **)

let buildIsoDs_Iso d smono =
  { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }

(** val astDS :
    coq_DecSetoid -> ocamlTypes -> (coq_DecSetoid, coq_DsIso) sigT **)

let astDS x t =
  let h = astSplitMono t in
  Coq_existT ((buildIsoDs x h), { phi = (fun x0 -> 
  (Obj.magic h).mono x0); phi' = (fun x0 -> (Obj.magic h).mono_inv x0) })

