open AstDS
open Bisemigroup
open DecSetoid
open OcamlTypes
open Semigroup
open Specif

(** val plus_T :
    coq_Bisemigroup -> (carrier, 'a1) splitMono -> carrier -> carrier ->
    carrier **)

let plus_T b smono a b0 =
  (Obj.magic smono).mono
    (b.plus ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b0))

(** val times_T :
    coq_Bisemigroup -> (carrier, 'a1) splitMono -> carrier -> carrier ->
    carrier **)

let times_T b smono a b0 =
  (Obj.magic smono).mono
    (b.times ((Obj.magic smono).mono_inv a) ((Obj.magic smono).mono_inv b0))

(** val buildIsoBSmg :
    coq_Bisemigroup -> (carrier, 'a1) splitMono -> coq_Bisemigroup **)

let buildIsoBSmg b smono =
  { Bisemigroup.setoid = (buildIsoDs (plusSmg b).setoid smono); plus =
    (fun x x0 -> plus_T b smono x x0); times = (fun x x0 ->
    times_T b smono x x0) }

(** val buildIsoBSmg_Iso :
    coq_Bisemigroup -> (carrier, 'a1) splitMono -> coq_BSmgIso **)

let buildIsoBSmg_Iso b smono =
  { phi = (fun x -> (Obj.magic smono).mono x); phi' = (fun x ->
    (Obj.magic smono).mono_inv x) }

(** val astBS :
    coq_Bisemigroup -> ocamlTypes -> (coq_Bisemigroup, coq_BSmgIso) sigT **)

let astBS x t =
  let h = astSplitMono t in
  Coq_existT ((buildIsoBSmg x h), { phi = (fun x0 -> 
  (Obj.magic h).mono x0); phi' = (fun x0 -> (Obj.magic h).mono_inv x0) })

