open BinPos
open Bool
open Datatypes
open Peano
open Specif

type ascii =
  | Ascii of bool * bool * bool * bool * bool * bool * bool * bool

val ascii_rect :
  (bool -> bool -> bool -> bool -> bool -> bool -> bool -> bool -> 'a1) ->
  ascii -> 'a1

val ascii_rec :
  (bool -> bool -> bool -> bool -> bool -> bool -> bool -> bool -> 'a1) ->
  ascii -> 'a1

val zero : ascii

val one : ascii

val app1 : (bool -> bool) -> ascii -> ascii

val app2 : (bool -> bool -> bool) -> ascii -> ascii -> ascii

val shift : bool -> ascii -> ascii

val ascii_dec : ascii -> ascii -> sumbool

val ascii_of_pos_aux : ascii -> ascii -> positive -> nat -> ascii

val ascii_of_pos : positive -> ascii

val ascii_of_nat : nat -> ascii

val nat_of_ascii : ascii -> nat

val coq_Space : ascii

val coq_DoubleQuote : ascii

val coq_Beep : ascii

