open Bisemigroup
open BisemigroupGlue
open BisemigroupProperties
open Datatypes
open DecSetoid
open SemigroupProperties
open Specif
open Union0
open UnionSwap
open Unit0

type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val addZeroBisemigroup : coq_Bisemigroup -> coq_Bisemigroup **)

let addZeroBisemigroup a =
  glueBSmg (unionSemigroup (plusSmg a) unitSemigroup)
    (unionSwapSemigroup unitSemigroup (timesSmg a))

(** val zero : coq_Bisemigroup -> carrier **)

let zero a =
  Obj.magic (Coq_inr ())

(** val isLeftDistributive_comp :
    coq_Bisemigroup -> coq_IsLeftDistributive_comp ->
    coq_IsLeftDistributive_comp **)

let isLeftDistributive_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val isRightDistributive_comp :
    coq_Bisemigroup -> coq_IsRightDistributive_comp ->
    coq_IsRightDistributive_comp **)

let isRightDistributive_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, s0) = s in
      let Coq_existT (z, _) = s0 in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val hasPlusAnn_back :
    coq_Bisemigroup -> coq_HasAnnihilator -> coq_HasAnnihilator **)

let hasPlusAnn_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | Coq_inl an -> Coq_existT (an, __)
         | Coq_inr c -> let () = c in assert false (* absurd case *))

(** val hasTimesId_back :
    coq_Bisemigroup -> coq_HasIdentity -> coq_HasIdentity **)

let hasTimesId_back a = function
  | Coq_existT (x0, x1) ->
      (match Obj.magic x0 with
         | Coq_inl an -> Coq_existT (an, __)
         | Coq_inr c -> let () = c in assert false (* absurd case *))

(** val isRightStrictStable_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isRightStrictStable_comp a =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT ((Obj.magic (Coq_inr ())), __)))))

(** val isLeftStrictStable_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let isLeftStrictStable_comp a =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT ((Obj.magic (Coq_inr ())), __)))))

(** val isRightCompEqCancel_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isRightCompEqCancel_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inr ())),
      __)))))

(** val isLeftCompEqCancel_comp :
    coq_Bisemigroup -> coq_IsSelective_comp -> (carrier, (carrier, (carrier,
    __) sigT) sigT) sigT **)

let isLeftCompEqCancel_comp a = function
  | Coq_existT (x0, s) ->
      let Coq_existT (y, _) = s in
      Coq_existT ((Obj.magic (Coq_inl x0)), (Coq_existT
      ((Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inr ())),
      __)))))

(** val isLeftCompCancel_comp :
    coq_Bisemigroup -> coq_IsLeftCompCancel_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let isLeftCompCancel_comp a lcc =
  let Coq_existT (x, s) = lcc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val isRightCompCancel_comp :
    coq_Bisemigroup -> coq_IsRightCompCancel_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let isRightCompCancel_comp a lcc =
  let Coq_existT (x, s) = lcc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val leftDiscrete_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let leftDiscrete_comp a =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val rightDiscrete_comp :
    coq_Bisemigroup -> (carrier, (carrier, (carrier, __) sigT) sigT) sigT **)

let rightDiscrete_comp a =
  Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
    ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inl a.setoid.choose)), __)))))

(** val leftComparable_comp :
    coq_Bisemigroup -> coq_LeftComparable_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let leftComparable_comp a lc =
  let Coq_existT (x, s) = lc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val rightComparable_comp :
    coq_Bisemigroup -> coq_RightComparable_comp -> (carrier, (carrier,
    (carrier, __) sigT) sigT) sigT **)

let rightComparable_comp a lc =
  let Coq_existT (x, s) = lc __ __ in
  let Coq_existT (y, s0) = s in
  let Coq_existT (z, _) = s0 in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), (Coq_existT ((Obj.magic (Coq_inl z)), __)))))

(** val leftIncreasing_comp :
    coq_Bisemigroup -> coq_LeftIncreasing_comp -> (carrier, (carrier, __)
    sigT) sigT **)

let leftIncreasing_comp a li =
  let Coq_existT (x, s) = li __ __ in
  let Coq_existT (y, _) = s in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), __)))

(** val rightIncreasing_comp :
    coq_Bisemigroup -> coq_RightIncreasing_comp -> (carrier, (carrier, __)
    sigT) sigT **)

let rightIncreasing_comp a li =
  let Coq_existT (x, s) = li __ __ in
  let Coq_existT (y, _) = s in
  Coq_existT ((Obj.magic (Coq_inl x)), (Coq_existT (
  (Obj.magic (Coq_inl y)), __)))

(** val leftStrictIncreasing_comp :
    coq_Bisemigroup -> (carrier, (carrier, __) sigT) sigT **)

let leftStrictIncreasing_comp a =
  Coq_existT ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))

(** val rightStrictIncreasing_comp :
    coq_Bisemigroup -> (carrier, (carrier, __) sigT) sigT **)

let rightStrictIncreasing_comp a =
  Coq_existT ((Obj.magic (Coq_inr ())), (Coq_existT
    ((Obj.magic (Coq_inr ())), __)))

(** val isRightTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_IsRightTimesMapToIdConstantPlus_comp **)

let isRightTimesMapToIdConstantPlus_comp a = function
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl id -> assert false (* absurd case *)
         | Coq_inr c ->
             let () = c in
             Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl a.setoid.choose)), __))))))

(** val isLeftTimesMapToIdConstantPlus_comp :
    coq_Bisemigroup -> coq_IsLeftTimesMapToIdConstantPlus_comp **)

let isLeftTimesMapToIdConstantPlus_comp a = function
  | Coq_existT (x, x0) ->
      (match Obj.magic x with
         | Coq_inl id -> assert false (* absurd case *)
         | Coq_inr c ->
             let () = c in
             Coq_existT ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl a.setoid.choose)), (Coq_existT
             ((Obj.magic (Coq_inl a.setoid.choose)), __))))))

